/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.organization.constant;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;

import java.util.Set;

/**
 * @author hongyan
 * @version 1.0
 * @title TXPermissionConst
 * @desc 重构的constant, 只用于方便查询.当有新权限增加时, rd需在这里增加枚举值
 * @date 2016年8月6日
 */
public enum TXPermissionConst {
    CAMPUS_SETTING(100, "校区设置"),
    ACCOUNT_SETTING(101, "账号设置"),
    FINANCE_MANAGEMENT(102, "资金管理"),
    RULE_SETTING(103, "设置规则"),
    SEE_ALL_CONSULT_RECORD(104, "查看机构所有咨询记录"),
    PERSONAL_CONSULT_MANAGEMENT(105, "处理分配给自己的咨询"),
    SEE_ALL_CLUES(106, "查看机构所有线索信息"),
    DELETE_CLUES(107, "删除线索"),
    DISTRIBUTE_CLUES(108, "分配线索"),
    EXPORT_CLUES(109, "导出线索"),
    ACTIVATE_INVALID_CLUES(110, "激活无效线索"),
    PERSONAL_CLUES_MANAGEMENT(111, "管理分配给自己的线索"),
    SEE_ALL_ORG_STUDENTS(112, "查看机构所有学员信息"),
    DELETE_STUDENTS(113, "删除学员"),
    EXPORT_STUDENTS(114, "导出学员"),
    PERSONAL_STUDENTS_MANAGEMENT(115, "管理分配给自己的学员"),
    ADD_NEW_CLASSES(116, "新增班级"),
    ADD_NEW_TEACHERS(117, "新增老师"),
    ADD_NEW_CLASSROOMS(118, "新增教室"),
    DISTRIBUTE_CLASSMANAGER(119, "分配班主任"),//SHOW_ENTER_CLASS_ARWANGEMENT
    SHOW_ENTER_CLASS_ARRANGEMENT(120, "是否显示排课入口"),
    IF_SIGNUP(121, "是否可签到"),
    IF_COLLECT_MONEY(122, "是否可收款"),
    ADD_MARKETING_ACTIVITY(123, "新增营销活动"),
    IF_CLASS_ARRANGE(124, "是否可以排课"),
    SHOW_ENTER_SIGNUP(125, "是否显示签到入口"),
//    SHOW_ENTER_FINANCE(126, "是否显示资金入口"),
//    SHOW_TEACHER_PARTLY_FUNCTION(127, "是否显示老师部分功能"),
    SHOW_ENTER_CLASS_SCHEDULE(128, "是否显示课表入口"),
    IF_MANAGE_CLASS_SCHEDULE(129, "是否可以管理课表"),
    DASHBOARD(130, "仪表盘"),
    PIC_OF_ENROLL_FUNNEL(131, "招生漏斗图"),
    REPORT_OF_CONSULT_SOURCE(132, "咨询来源分析报表"),
    WECHAT_FANS_TREND(133, "微信粉丝增减趋势"),
    TO_BE_DONE_TODAY(134, "今日待办"),
    MESSAGE(135, "消息"),
    NOTIFY(136, "通知"),
    COLLEAGUE_CONTACTS(137, "同事通讯录"),
    CLUES_MANAGEMENT(138, "线索管理"),
    ENROLL_FUNNEL(139, "招生漏斗"),
    REMIND_OF_WORK(140, "工作提醒"),
    CLASS_ARRANGEMENT(141, "排课"),
    CLASS_SCHEDULE(142, "课表"),
    APPRAISE(143, "评价"),
    CLASS_CAN_BE_ARRANGE_PIC(144, "可排课班级首图"),
    WECHAT_HOUSEKEEPER(145, "微信管家"),
    ZHUANJIESHAO(146, "转介绍"),
    QUANWANGBAOWEN(147, "全网爆文"),
    SAOYISAO(148, "扫一扫"),
    PHONE_400(149, "400电话"),
    GSXTUIGUANG(150, "跟谁学推广"),
    FUZESHOUTU(151, "我负责的班级首图"),
    TOUPIAO(152, "微信投票"),
    CHOUJIANG(153, "微信抽奖"),
    QUNFAXIAOXI(154, "群发消息"),
    QUNFADUANXIN(155, "群发短信"),
    WEIHUODONG(156, "微活动"),
    HUODONGBAOMING(157, "活动报名"),
    WEIGUANWANG(159, "微官网"),
    SHEBANRUKOU(160, "是否显示设班入口");

    private Long pCode;
    private String pName;

    TXPermissionConst(Integer pCode, String pName) {
        this.pCode = pCode.longValue();
        this.pName = pName;
    }

    public Long getpCode() {
        return pCode;
    }

    public void setpCode(Long pCode) {
        this.pCode = pCode;
    }

    public String getpName() {
        return pName;
    }

    public void setpName(String pName) {
        this.pName = pName;
    }

    /* ===================================以下保存特殊逻辑使用的常量集合==================================== */

    /**
     * @desc 重构的权限更改一对多map, 将只保存冗余的对应关系, 自身对应被剔除.对应关系被改为code.
     * @author hongyan
     * @date 2016年8月6日
     * @version 1.0
     */
    public static final Multimap<Long, Long> ONE_MULTY_CODE_MAP = ArrayListMultimap.create();

    static {
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.SHOW_ENTER_CLASS_ARRANGEMENT.getpCode(), TXPermissionConst.IF_CLASS_ARRANGE.getpCode());//124
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.SHOW_ENTER_CLASS_ARRANGEMENT.getpCode(), TXPermissionConst.SHOW_ENTER_CLASS_SCHEDULE.getpCode());//128
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.SHOW_ENTER_CLASS_ARRANGEMENT.getpCode(), TXPermissionConst.IF_MANAGE_CLASS_SCHEDULE.getpCode());//129

        ONE_MULTY_CODE_MAP.put(TXPermissionConst.IF_SIGNUP.getpCode(), TXPermissionConst.SHOW_ENTER_SIGNUP.getpCode());//125

        ONE_MULTY_CODE_MAP.put(TXPermissionConst.ADD_MARKETING_ACTIVITY.getpCode(), TXPermissionConst.QUNFAXIAOXI.getpCode());//154
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.ADD_MARKETING_ACTIVITY.getpCode(), TXPermissionConst.WECHAT_HOUSEKEEPER.getpCode());//145
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.ADD_MARKETING_ACTIVITY.getpCode(), TXPermissionConst.ZHUANJIESHAO.getpCode());//146
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.ADD_MARKETING_ACTIVITY.getpCode(), TXPermissionConst.QUANWANGBAOWEN.getpCode());//147
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.ADD_MARKETING_ACTIVITY.getpCode(), TXPermissionConst.GSXTUIGUANG.getpCode());//150
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.ADD_MARKETING_ACTIVITY.getpCode(), TXPermissionConst.TOUPIAO.getpCode());//152
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.ADD_MARKETING_ACTIVITY.getpCode(), TXPermissionConst.CHOUJIANG.getpCode());//153
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.ADD_MARKETING_ACTIVITY.getpCode(), TXPermissionConst.QUNFADUANXIN.getpCode());//155
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.ADD_MARKETING_ACTIVITY.getpCode(), TXPermissionConst.WEIHUODONG.getpCode());//156
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.ADD_MARKETING_ACTIVITY.getpCode(), TXPermissionConst.HUODONGBAOMING.getpCode());//157
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.ADD_MARKETING_ACTIVITY.getpCode(), TXPermissionConst.WEIGUANWANG.getpCode());//159
    }

    /**
     * @desc 权限保存控制表, 总校长在crm对员工进行权限控制时, set中有的code将被反映到数据库, 其他值使用默认权限 前端若增加了权限控制勾选项目,需要在这个set中增加对应权限码.
     * @author hongyan
     */
    public static final Set<Long> PERMISSION_SAVE_CONTROL_SET = Sets.newHashSet();

    static {
        PERMISSION_SAVE_CONTROL_SET.add(FINANCE_MANAGEMENT.getpCode());// 102
        PERMISSION_SAVE_CONTROL_SET.add(RULE_SETTING.getpCode());// 103

        PERMISSION_SAVE_CONTROL_SET.add(SEE_ALL_CONSULT_RECORD.getpCode());// 104
        PERMISSION_SAVE_CONTROL_SET.add(PERSONAL_CONSULT_MANAGEMENT.getpCode());// 105

        PERMISSION_SAVE_CONTROL_SET.add(SEE_ALL_CLUES.getpCode());// 106
        PERMISSION_SAVE_CONTROL_SET.add(DELETE_CLUES.getpCode());// 107
        PERMISSION_SAVE_CONTROL_SET.add(DISTRIBUTE_CLUES.getpCode());// 108
        PERMISSION_SAVE_CONTROL_SET.add(EXPORT_CLUES.getpCode());// 109
        PERMISSION_SAVE_CONTROL_SET.add(ACTIVATE_INVALID_CLUES.getpCode());// 110
        PERMISSION_SAVE_CONTROL_SET.add(PERSONAL_CLUES_MANAGEMENT.getpCode());// 111

        PERMISSION_SAVE_CONTROL_SET.add(SEE_ALL_ORG_STUDENTS.getpCode());// 112
        PERMISSION_SAVE_CONTROL_SET.add(DELETE_STUDENTS.getpCode());// 113
        PERMISSION_SAVE_CONTROL_SET.add(EXPORT_STUDENTS.getpCode());// 114
        PERMISSION_SAVE_CONTROL_SET.add(PERSONAL_STUDENTS_MANAGEMENT.getpCode());// 115

        PERMISSION_SAVE_CONTROL_SET.add(ADD_NEW_CLASSES.getpCode());// 116
        PERMISSION_SAVE_CONTROL_SET.add(ADD_NEW_TEACHERS.getpCode());// 117
        PERMISSION_SAVE_CONTROL_SET.add(ADD_NEW_CLASSROOMS.getpCode());// 118
        PERMISSION_SAVE_CONTROL_SET.add(DISTRIBUTE_CLASSMANAGER.getpCode());// 119
        PERMISSION_SAVE_CONTROL_SET.add(IF_SIGNUP.getpCode());// 121
        PERMISSION_SAVE_CONTROL_SET.add(SHOW_ENTER_CLASS_ARRANGEMENT.getpCode());// 120

        PERMISSION_SAVE_CONTROL_SET.add(IF_COLLECT_MONEY.getpCode());// 122

        PERMISSION_SAVE_CONTROL_SET.add(ADD_MARKETING_ACTIVITY.getpCode());// 123
        /* =============================上面是前端控制的code=================================== */
        /* =============================下面是一对多map增加的code=================================== */
//        PERMISSION_SAVE_CONTROL_SET.addAll(ONE_MULTY_CODE_MAP.values());
    }

    public static void main(String[] args) {
        System.out.println(PERMISSION_SAVE_CONTROL_SET);
    }
}
