/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.addressbook.dao.TXAddressBookDao;
import com.baijia.tianxiao.dal.addressbook.po.TXAddressBook;
import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.sal.organization.org.dto.addressbook.TXAddressBookDto;
import com.baijia.tianxiao.sal.organization.org.service.TXAddressBookService;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;
import com.baijia.tianxiao.util.mobile.EmojiUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TXAddressBookServiceImpl
implements TXAddressBookService {
    private static final Logger log = LoggerFactory.getLogger(TXAddressBookServiceImpl.class);
    @Autowired
    private TXAddressBookDao txAddressBookDao;
    @Autowired
    private OrgBranchsDao orgBranchsDao;

    @Override
    @Transactional(readOnly=true)
    public List<TXAddressBookDto> getOrgAddressBook(long orgId) {
        List addressBookList = this.txAddressBookDao.getAddressByOrgId(orgId);
        ArrayList<TXAddressBookDto> addressBookDtoList = new ArrayList<TXAddressBookDto>();
        for (TXAddressBook txAddressBook : addressBookList) {
            TXAddressBookDto txAddressBookDto = new TXAddressBookDto();
            txAddressBookDto.setUnit(txAddressBook.getUnit());
            txAddressBookDto.setProvince(txAddressBook.getProvince());
            txAddressBookDto.setName(txAddressBook.getName());
            txAddressBookDto.setLongitude(txAddressBook.getLongitude());
            txAddressBookDto.setLatitude(txAddressBook.getLatitude());
            txAddressBookDto.setDistrict(txAddressBook.getDistrict());
            txAddressBookDto.setDescription(txAddressBook.getDescription());
            txAddressBookDto.setId(txAddressBook.getId());
            txAddressBookDto.setCity(txAddressBook.getCity());
            addressBookDtoList.add(txAddressBookDto);
        }
        return addressBookDtoList;
    }

    @Override
    @Transactional(readOnly=true)
    public TXAddressBookDto getAddress(long id) {
        BussinessPreconditions.checkArgument((id > 0L ? 1 : 0) != 0, (Object)"\u5730\u5740id\u65e0\u6548");
        TXAddressBookDto txAddressBookDto = new TXAddressBookDto();
        TXAddressBook txAddressBook = (TXAddressBook)this.txAddressBookDao.getById((Serializable)Long.valueOf(id), new String[0]);
        BussinessPreconditions.checkArgument((txAddressBook != null ? 1 : 0) != 0, (Object)"\u5730\u5740\u4e0d\u5b58\u5728");
        if (txAddressBook != null) {
            txAddressBookDto.setCity(txAddressBook.getCity());
            txAddressBookDto.setDescription(txAddressBook.getDescription());
            txAddressBookDto.setDistrict(txAddressBook.getDistrict());
            txAddressBookDto.setLatitude(txAddressBook.getLatitude());
            txAddressBookDto.setLongitude(txAddressBook.getLongitude());
            txAddressBookDto.setName(txAddressBook.getName());
            txAddressBookDto.setProvince(txAddressBook.getProvince());
            txAddressBookDto.setUnit(txAddressBook.getUnit());
            txAddressBookDto.setId(id);
        }
        log.debug("txAddressBookDto={ }", (Object)txAddressBookDto);
        return txAddressBookDto;
    }

    @Override
    @Transactional
    public void updateAddressBook(TXAddressBookDto txAddressBookDto) {
        BussinessPreconditions.checkArgument((txAddressBookDto.getId() != null ? 1 : 0) != 0, (Object)"\u65e0\u6548\u7684\u5730\u5740id");
        BussinessPreconditions.checkArgument((!EmojiUtils.containsEmoji((String)txAddressBookDto.getUnit()) ? 1 : 0) != 0, (Object)"\u4e0d\u80fd\u542b\u6709Emoji\u5b57\u7b26");
        TXAddressBook txAddressBook = (TXAddressBook)this.txAddressBookDao.getById((Serializable)txAddressBookDto.getId(), new String[0]);
        log.debug("update txAddressBookDto={ },", (Object)txAddressBookDto);
        BussinessPreconditions.checkArgument((txAddressBook != null ? 1 : 0) != 0, (Object)"\u5730\u5740\u4e0d\u5b58\u5728");
        if (txAddressBook != null) {
            txAddressBook.setDistrict(txAddressBookDto.getDistrict());
            txAddressBook.setCity(txAddressBookDto.getCity());
            txAddressBook.setProvince(txAddressBookDto.getProvince());
            txAddressBook.setLatitude(txAddressBookDto.getLatitude());
            txAddressBook.setLongitude(txAddressBookDto.getLongitude());
            txAddressBook.setDescription(txAddressBookDto.getDescription());
            txAddressBook.setUnit(txAddressBookDto.getUnit());
            txAddressBook.setName(txAddressBookDto.getName());
            txAddressBook.setUpdateTime(new Date());
            log.debug("update txAddressBook={ },", (Object)txAddressBook);
            this.txAddressBookDao.update((Object)txAddressBook, new String[0]);
        }
    }

    @Override
    @Transactional
    public long newAddress(long orgId, TXAddressBookDto txAddressBookDto) {
        int num = this.txAddressBookDao.getAddressNum(orgId);
        BussinessPreconditions.checkArgument((num >= 0 && num < 100 ? 1 : 0) != 0, (Object)"\u6700\u591a\u53ea\u80fd\u5b58\u50a8100\u4e2a\u5730\u5740\uff0c\u8bf7\u5148\u5220\u9664\u4e00\u4e9b\u5730\u5740\u540e\u518d\u8bd5");
        TXAddressBook txAddressBook = new TXAddressBook();
        log.debug("update txAddressBookDto={ },", (Object)txAddressBookDto);
        BussinessPreconditions.checkArgument((!EmojiUtils.containsEmoji((String)txAddressBookDto.getUnit()) ? 1 : 0) != 0, (Object)"\u4e0d\u80fd\u542b\u6709Emoji\u5b57\u7b26");
        txAddressBook.setDistrict(txAddressBookDto.getDistrict());
        txAddressBook.setCity(txAddressBookDto.getCity());
        txAddressBook.setProvince(txAddressBookDto.getProvince());
        txAddressBook.setLatitude(txAddressBookDto.getLatitude());
        txAddressBook.setLongitude(txAddressBookDto.getLongitude());
        txAddressBook.setDescription(txAddressBookDto.getDescription());
        txAddressBook.setUnit(txAddressBookDto.getUnit());
        txAddressBook.setName(txAddressBookDto.getName());
        txAddressBook.setOrgId(Long.valueOf(orgId));
        txAddressBook.setUpdateTime(new Date());
        txAddressBook.setCreateTime(new Date());
        log.debug("new txAddressBook={ },", (Object)txAddressBook);
        this.txAddressBookDao.save((Object)txAddressBook, new String[0]);
        long id = txAddressBook.getId();
        return id;
    }

    @Override
    public void deleteAddress(long id) {
        this.txAddressBookDao.delById((Serializable)Long.valueOf(id));
    }

    @Override
    public void changLastUse(long addressId, long orgId) {
        TXAddressBook txAddressBookuse = this.txAddressBookDao.getLastUseAddress(orgId);
        if (txAddressBookuse != null) {
            txAddressBookuse.setLastUse(Integer.valueOf(0));
            this.txAddressBookDao.update((Object)txAddressBookuse, new String[0]);
        }
        TXAddressBook txAddressBook = (TXAddressBook)this.txAddressBookDao.getById((Serializable)Long.valueOf(addressId), new String[0]);
        txAddressBook.setLastUse(Integer.valueOf(1));
        this.txAddressBookDao.update((Object)txAddressBook, new String[0]);
    }
}

