/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.finance.service.impl;

import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpTo;
import com.baijia.tianxiao.sal.organization.finance.constant.FinancePayTypeCode;
import com.baijia.tianxiao.sal.organization.finance.dto.request.TxFinanceRecordRequest;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxFinanceRecordDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxTypeRecordDto;
import com.baijia.tianxiao.sal.organization.finance.service.TxFinanceRecordService;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TxFinanceRecordServiceImpl
implements TxFinanceRecordService {
    private static final Logger log = LoggerFactory.getLogger(TxFinanceRecordServiceImpl.class);
    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;

    @Override
    public List<TxFinanceRecordDto> financeByDay(Long orgId, TxFinanceRecordRequest recordRequest) {
        Date startDate = null;
        Date endDate = null;
        if (recordRequest.getDate() != null) {
            startDate = endDate = DateUtil.getDateByDay((int)recordRequest.getYear(), (int)recordRequest.getMonth(), (int)recordRequest.getDate());
        } else {
            startDate = DateUtil.getDateByYearMonth((int)recordRequest.getYear(), (int)recordRequest.getMonth());
            endDate = DateUtil.endDateByYearMonth((int)recordRequest.getYear(), (int)recordRequest.getMonth());
        }
        List list = this.txFinanceRecordDayDao.list(orgId, DateUtil.getStartOfDay((Date)startDate), DateUtil.getEndOfDay((Date)endDate), new String[0]);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.EMPTY_LIST;
        }
        return this.buildDto(list, startDate, endDate, 1);
    }

    private List<TxFinanceRecordDto> buildDto(List<TxFinanceRecordDay> list, Date startDate, Date endDate, int type) {
        ArrayList result = Lists.newArrayList();
        HashMap map = Maps.newHashMap();
        for (TxFinanceRecordDay txFinanceRecordDay : list) {
            TxTypeRecordDto typeRecordDto;
            String key = "";
            key = type == 1 ? DateUtil.getStrByDate((Date)txFinanceRecordDay.getMdate()) : DateUtil.getMonthStrByDate((Date)txFinanceRecordDay.getMdate());
            TxFinanceRecordDto dto = (TxFinanceRecordDto)((Object)map.get(key));
            if (dto == null) {
                dto = new TxFinanceRecordDto();
            }
            dto.setCreateTime(txFinanceRecordDay.getMdate());
            if (txFinanceRecordDay.getOpTo().intValue() == FinanceOpTo.INCOME.getCode().intValue()) {
                dto.setIncomeSum(dto.getIncomeSum() + txFinanceRecordDay.getOpPrice());
                dto.setIncomeNum(dto.getIncomeNum() + txFinanceRecordDay.getOpCount());
                if (type == 1) {
                    typeRecordDto = new TxTypeRecordDto();
                    typeRecordDto.setType(txFinanceRecordDay.getOpType());
                    typeRecordDto.setTypeStr(FinancePayTypeCode.getPayName(typeRecordDto.getType()));
                    typeRecordDto.setTypeSum(txFinanceRecordDay.getOpPrice());
                    typeRecordDto.setTypeNum(txFinanceRecordDay.getOpCount());
                    dto.getIncomeList().add(typeRecordDto);
                }
            } else {
                dto.setExpendSum(dto.getExpendSum() + txFinanceRecordDay.getOpPrice());
                dto.setExpendNum(dto.getExpendNum() + txFinanceRecordDay.getOpCount());
                if (type == 1) {
                    typeRecordDto = new TxTypeRecordDto();
                    typeRecordDto.setType(txFinanceRecordDay.getOpType());
                    typeRecordDto.setTypeStr(FinancePayTypeCode.getPayName(typeRecordDto.getType()));
                    typeRecordDto.setTypeSum(txFinanceRecordDay.getOpPrice());
                    typeRecordDto.setTypeNum(txFinanceRecordDay.getOpCount());
                    dto.getExpendList().add(typeRecordDto);
                }
            }
            dto.setIncomeSum(ArithUtil.round((double)dto.getIncomeSum(), (int)2));
            dto.setExpendSum(ArithUtil.round((double)dto.getExpendSum(), (int)2));
            dto.setAllBalance(ArithUtil.round((double)(dto.getIncomeSum() - dto.getExpendSum()), (int)2));
            map.put(key, dto);
        }
        result.addAll(map.values());
        Collections.sort(result, new Comparator<TxFinanceRecordDto>(){

            @Override
            public int compare(TxFinanceRecordDto o1, TxFinanceRecordDto o2) {
                return DateUtil.dateCompare((Date)o1.getCreateTime(), (Date)o2.getCreateTime());
            }
        });
        return result;
    }

    @Override
    public List<TxFinanceRecordDto> financeByMonth(Long orgId, TxFinanceRecordRequest recordRequest) {
        Date endDate;
        Date startDate = DateUtil.getDateByYear((int)recordRequest.getYear());
        List list = this.txFinanceRecordDayDao.list(orgId, startDate, endDate = DateUtil.endDateByYear((int)recordRequest.getYear()), new String[0]);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.EMPTY_LIST;
        }
        return this.buildDto(list, startDate, endDate, 2);
    }
}

