/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.finance.constant;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public enum FinanceOpType {
    OTHER(0, "\u6e20\u9053\u5206\u6210", 10, "\u5176\u4ed6", 0),
    ORDER(1, "\u652f\u4ed8\u8ba2\u5355", 1, "\u652f\u4ed8", 0),
    JIANGLI(2, "\u9080\u8bf7\u5956\u52b1", 2, "\u5956\u52b1", 0),
    TIXIAN(3, "\u7533\u8bf7\u63d0\u73b0", 3, "\u63d0\u73b0", 0),
    TIXIAN_CHENGGONG(4, "\u63d0\u73b0\u6210\u529f", 3, "\u63d0\u73b0", 0),
    TIXIAN_SHIBAI(5, "\u63d0\u73b0\u5931\u8d25", 4, "\u63d0\u73b0\u9000\u56de", 0),
    TIXIAN_SHOUXUFEI(6, "\u63d0\u73b0\u624b\u7eed\u8d39", 8, "\u624b\u7eed\u8d39", 0),
    RUZHU_JIANGLI(7, "\u8001\u5e08\u5165\u9a7b\u5e73\u53f0\u5956\u52b1", 2, "\u5956\u52b1", 0),
    HONGBAO_ZHIFU(8, "\u7ea2\u5305\u652f\u4ed8", 1, "\u652f\u4ed8", 0),
    SHOUDAN_JIANGLI(12, "\u9996\u5355\u5956\u52b1", 2, "\u5956\u52b1", 0),
    TUIGUANG_FEIYONG(20, "\u63a8\u5e7f\u8d39\u7528", 9, "\u63a8\u5e7f\u8d39\u7528", 0),
    KOUCHU_JIANGLI(21, "\u5956\u52b1\u6263\u9664", 2, "\u5956\u52b1", 0),
    TUIGUANG_CHONGZHI(22, "\u63a8\u5e7f\u5145\u503c", 7, "\u5145\u503c", 0),
    HUODONG_JIANGLI(24, "\u6392\u884c\u699c\u6d3b\u52a8\u5956\u52b1", 2, "\u5956\u52b1", 0),
    FANXIAN_JIANGLI(25, "\u9996\u5355\u8fd4\u73b0\u6d3b\u52a8\u5956\u52b1", 2, "\u5956\u52b1", 0),
    SHUANG12_BUTIE(26, "\u53cc\u5341\u4e8c\u6d3b\u52a8\u8865\u8d34", 2, "\u5956\u52b1", 0),
    YIYUAN_BUTIE(27, "\u4e00\u5143\u73ed\u8bfe\u8865\u8d34", 2, "\u5956\u52b1", 0),
    XINYI_ZENGYIN(40, "\u5fc3\u610f\u8d60\u996e", 1, "\u652f\u4ed8", 0),
    QIANQIAN_XUEFEI(60, "\u7b7e\u7b7e\u6536\u5b66\u8d39", 1, "\u652f\u4ed8", 0),
    KECHOU(61, "\u786e\u8ba4\u8bfe\u916c", 1, "\u652f\u4ed8", 0),
    CHONGZHI(62, "\u673a\u6784\u5145\u503c", 7, "\u5145\u503c", 1),
    BAOMING(63, "\u673a\u6784\u62a5\u540d", 1, "\u652f\u4ed8", 1),
    SETTLEMENT(64, "\u652f\u4ed8\u8ba2\u5355", 1, "\u652f\u4ed8", 1),
    FAKUAN(65, "\u8fdd\u89c4\u7f5a\u6b3e", 10, "\u5176\u4ed6", 0),
    SHOUXUFEI(68, "\u652f\u4ed8\u624b\u7eed\u8d39", 8, "\u624b\u7eed\u8d39", 0),
    TUIFEI_SHOUXUFEI(69, "\u63a8\u5e7f\u8d26\u6237\u9000\u8d39\u624b\u7eed\u8d39", 8, "\u624b\u7eed\u8d39", 0),
    FUWUFEI(70, "\u6280\u672f\u670d\u52a1\u8d39", 9, "\u63a8\u5e7f\u8d39\u7528", 0),
    TEXISHOUXUFEI(71, "\u8d34\u606f\u624b\u7eed\u8d39", 8, "\u624b\u7eed\u8d39", 0),
    DUANXIN_GOUMAI(73, "\u77ed\u4fe1\u8d2d\u4e70", 10, "\u5176\u4ed6", 0),
    JIAONA_YONGJIN(74, "\u7f34\u7eb3\u4f63\u91d1", 9, "\u63a8\u5e7f\u8d39\u7528", 0),
    PAY_ORDER(77, "\u652f\u4ed8\u8ba2\u5355", 1, "\u652f\u4ed8", 0),
    TUIGUANGFEI(78, "\u6e20\u9053\u63a8\u5e7f\u8d39", 9, "\u63a8\u5e7f\u8d39\u7528", 0),
    FENXIANG_FENCHENG(79, "\u5b66\u751f\u5206\u4eab\u5206\u6210", 9, "\u63a8\u5e7f\u8d39\u7528", 0),
    DRAWBACK(81, "\u9000\u6b3e", 5, "\u9000\u6b3e", 1),
    VIP_FENCHENG(82, "VIP\u5206\u6210", 10, "\u5176\u4ed6", 0),
    ZHIFU(101, "\u652f\u4ed8\u8ba2\u5355", 1, "\u652f\u4ed8", 0),
    JIAOYI_WANCHENG(102, "\u4ea4\u6613\u5b8c\u6210", 1, "\u652f\u4ed8", 0),
    BUFEN_TUIKUAN(103, "\u90e8\u5206\u9000\u6b3e", 5, "\u9000\u6b3e", 0),
    QUANBU_TUIKUAN(104, "\u5168\u989d\u9000\u6b3e", 5, "\u9000\u6b3e", 0),
    ZHUANZHANG_CHENGGONG(105, "\u8f6c\u8d26\u6210\u529f", 6, "\u8f6c\u8d26", 0);

    private Integer code;
    private String name;
    private Integer opType;
    private String opTypeName;
    private Integer producePoints;
    private static Map<Integer, FinanceOpType> map;
    private static Map<Integer, String> typeNameMap;
    private static Map<Integer, List<Integer>> opTypeMap;

    private FinanceOpType(int code, String name, Integer opType, String opTypeName, Integer producePoints) {
        this.code = code;
        this.name = name;
        this.opType = opType;
        this.opTypeName = opTypeName;
        this.producePoints = producePoints;
    }

    public static String getByCode(int code) {
        FinanceOpType o = map.get(code);
        if (o == null) {
            return "\u672a\u77e5" + code;
        }
        return o.getOpTypeName();
    }

    public static String getByOpType(int opType) {
        String o = typeNameMap.get(opType);
        if (o == null) {
            return "\u672a\u77e5" + opType;
        }
        return typeNameMap.get(o);
    }

    public static List<Integer> getByOpType(List<Integer> opType) {
        ArrayList result = Lists.newArrayList();
        for (Integer id : opType) {
            result.addAll((Collection)opTypeMap.get(id));
        }
        return result;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getOpType() {
        return this.opType;
    }

    public void setOpType(Integer opType) {
        this.opType = opType;
    }

    public String getOpTypeName() {
        return this.opTypeName;
    }

    public void setOpTypeName(String opTypeName) {
        this.opTypeName = opTypeName;
    }

    static {
        map = Maps.newHashMap();
        typeNameMap = Maps.newHashMap();
        opTypeMap = Maps.newHashMap();
        for (FinanceOpType opType : FinanceOpType.values()) {
            map.put(opType.code, opType);
        }
        for (FinanceOpType opType : FinanceOpType.values()) {
            typeNameMap.put(opType.getOpType(), opType.getOpTypeName());
        }
        for (FinanceOpType opType : FinanceOpType.values()) {
            List<Object> opTypeList = Lists.newArrayList();
            opTypeList = opTypeMap.get(opType.getOpType()) == null ? Lists.newArrayList() : opTypeMap.get(opType.getOpType());
            opTypeList.add(opType.getCode());
            opTypeMap.put(opType.getOpType(), opTypeList);
        }
    }
}

