
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.baijia.tianxiao.dal.callservice.dao.impl.TX400PhoneDaoImpl;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.sal.organization.org.dto.addressbook.TXAddressBookDto;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.collect.Sets;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.callservice.dao.TX400PhoneDao;
import com.baijia.tianxiao.dal.callservice.po.TX400Phone;
import com.baijia.tianxiao.dal.org.constant.AuditColumType;
import com.baijia.tianxiao.dal.org.constant.MIMEType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgBranchs;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfomationDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgTxtMsgService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.yunying.hag.service.HagService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @author zhangbing
 * @version 1.0
 * @title OrgInfoServiceImpl
 * @desc TODO
 * @date 2016年1月6日
 */
@Slf4j
@Service
public class OrgInfoServiceImpl implements OrgInfoService {

    @Autowired
    private OrgAccountDao orgAccountDao;

    @Autowired
    private OrgInfoDao orgInfoDao;

    @Autowired
    private OrgPhotoDao orgPhotoDao;

    @Autowired
    private OrgStorageDao orgStorageDao;

    @Autowired
    private OrgTxtMsgService orgTxtMsgService;
    @Autowired
    private TX400PhoneDao tx400PhoneDao;

    @Autowired
    private OrgBranchsDao orgBranchsDao;

    @Autowired(required = false)
    private HagService hagService;

    @Autowired
    private TXCascadeCredentialDao tXCascadeCredentialDao;

    @Autowired
    private TXCascadeAccountDao tXCascadeAccountDao;

    @Autowired
    private OrgSubAccountDao orgSubAccountDao;

    @Autowired
    private TXAccountDao txAccountDao;

    private static final String DEFAULT_ROLE_AVATAR = "https://imgs.genshuixue.com/21644918_xqjeiipb.png";
    private static final String DEFAULT_ORG_AVATAR = "http://www.genshuixue.com/asset/img/org/logo.jpg";
    // 优选老师业务特殊的几个机构id,对应number为:538794839, 538812759, 539470509, 874366019, 958159449
    private static final Set<Long> OPTIMAL_ORG_IDS = Sets.newHashSet(70638L, 70637L, 70643L, 45933L, 30017L);

    @Override
    public OrgInfoSimpleDto getOrgInfo(Long orgId) throws BussinessException, Exception {
        OrgInfoSimpleDto result = null;
        try {
            // 参数校验
            Preconditions.checkNotNull(orgId, "机构ID不能为空");
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
            Preconditions.checkNotNull(orgInfo, "非法请求");
            OrgAccount account = orgAccountDao.getAccountById(orgInfo.getOrgId());
            Preconditions.checkNotNull(account, "非法请求");
            result = this.copyFrom(orgInfo);
            result.setMobile(account.getMobile());
            OrgTxtMsg introduce =
                orgTxtMsgService.getOrgTxtByIdAndType(orgId.intValue(), AuditColumType.SUMMARY.getValue());
            result.setIntroduce(introduce == null ? "" : introduce.getValue());
            result.setOrgNumber(account.getNumber().longValue());
            result.setTeacherSignin(orgInfo.getTeacherSignin());

            // 获取机构地址
            List<OrgBranchs> branchsList = orgBranchsDao.listBranchsByOrgId(orgId.intValue());
            if (branchsList != null && branchsList.size() > 0) {
                OrgBranchs branchs = branchsList.get(0);
                String addressStr=branchs.getAddressDetail();
                StringBuilder sb = new StringBuilder();
                if(!GenericsUtils.isNullOrEmpty(addressStr)) {
                    TXAddressBookDto txAddressBookDto = JacksonUtil.str2Obj(addressStr, TXAddressBookDto.class);
                    sb.append(txAddressBookDto.getProvince()).append(txAddressBookDto.getCity()).append(txAddressBookDto.getDistrict()).append(txAddressBookDto.getName()).append(txAddressBookDto.getUnit());

                }else {
                    sb.append(branchs.getProvince()).append(branchs.getCounty());
                    sb.append(branchs.getDistrict()).append(branchs.getAddress());
                    sb.append(branchs.getBranchName());
                }
                result.setAddress(sb.toString());
            } else {
                result.setAddress("");
            }
            try {
                String mhost = PropertiesReader.getValue("wxm", "m.server");
                result.setMurl(mhost + "/i/" + result.getOrgNumber());
                // 新增地址链接 by hlj
                String lhost = PropertiesReader.getValue("wxm", "m.server");
                result.setLocationUrl(lhost + "/branch/" + result.getOrgNumber());
            } catch (Exception e) {
                log.warn("[OrgInfo] Exception", e.getMessage());
            }
        } catch (BussinessException e) {
            log.error("[OrgInfo] BussinessException", e);
            throw e;
        } catch (Exception e) {
            log.error("[OrgInfo] Exception", e);
            throw e;
        }
        return result;
    }

    @Override
    public OrgInfoSimpleDto getMOrgInfo(Long orgId){
        OrgInfoSimpleDto result = null;
        try {
            Preconditions.checkNotNull(orgId, "机构ID不能为空");
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
            Preconditions.checkNotNull(orgInfo, "非法请求");
            OrgAccount account = orgAccountDao.getAccountById(orgInfo.getOrgId());
            Preconditions.checkNotNull(account, "非法请求");
            result = this.copyFrom(orgInfo);
            result.setMobile(account.getMobile());
            result.setOrgNumber(account.getNumber().longValue());
            result.setTeacherSignin(orgInfo.getTeacherSignin());

            OrgTxtMsg introduce =
                    orgTxtMsgService.getOrgTxtByIdAndType(orgId.intValue(), AuditColumType.SUMMARY.getValue());
            result.setIntroduce(introduce == null ? "" : introduce.getValue());

        } catch (BussinessException e) {
            log.error("[OrgInfo] BussinessException", e);
            throw e;
        } catch (Exception e) {
            log.error("[OrgInfo] Exception", e);
            throw e;
        }
        return result;
    }

    /**
     * 结果封装
     *
     * @return
     */
    private OrgInfoSimpleDto copyFrom(OrgInfo orgInfo) {
        OrgInfoSimpleDto result = new OrgInfoSimpleDto();
        result.setShortName(orgInfo.getShortName());
        TX400Phone tx400Phone = tx400PhoneDao.getByOrgId(orgInfo.getOrgId());
        if (tx400Phone != null) {
            result.setTelephone(tx400Phone.getPhone400());
        }else if(TX400PhoneDaoImpl.NO_400_ORGMAP.containsKey(orgInfo.getOrgId())) {
            result.setTelephone(TX400PhoneDaoImpl.NO_400_ORGMAP.get(orgInfo.getOrgId()));
        }else{
            result.setTelephone(BizConf._400_PHONE_PREFIX);
            result.setExtension(orgInfo.getExtension());
        }
        result.setLogo(this.getLogo(orgInfo.getOrgId()));
        result.setOrgId(orgInfo.getOrgId());
        result.setMarkingStatus(orgInfo.getMarketingStatus());
        result.setName(orgInfo.getName());
        result.setContacts(orgInfo.getContacts());
        return result;
    }

    /**
     * 获取机构LOGO地址
     *
     * @param orgId
     * @return
     */
    @Override
    public String getLogo(int orgId) {
        String logo = OrgImgType.ORG_LOGO.getDefaultUrl();
        try {
            List<OrgPhoto> photos = orgPhotoDao.getByOrgIdAndCategory(orgId, OrgImgType.ORG_LOGO.getValue());
            if (photos != null && !photos.isEmpty()) {
                OrgPhoto photo = photos.get(0);
                Integer storageId = photo.getOrgStorageId();
                if (storageId != null) {
                    OrgStorage storage = this.orgStorageDao.getById(storageId.longValue());
                    if (storage != null) {
                        logo = this.constructUrl(storage);
                    }
                }
            }
        } catch (Exception e) {
            log.error("get org logo failed, e:{}", e);
        }
        return logo;
    }

    /**
     * 获取机构logo地址
     *
     * @param storage
     * @return
     */
    public String constructUrl(OrgStorage storage) {
        String imgServer = PropertiesReader.getValue("upload", "img.server");
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = ((MIMEType.values())[storage.getMimeType() - 1]).getExtension();
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    @Override
    public boolean updateTeacherSigninStatus(Long orgId, Integer signinStatus) {
        return orgInfoDao.updateTeacherSigninByOrgId(orgId, signinStatus);
    }

    @Override
    public Integer findSigninStatus(Integer orgId) {
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, "teacherSignin");
        return orgInfo.getTeacherSignin();
    }

    @Override
    public Map<Integer, OrgInfo> getOrgInfoMap(List<Integer> orgIds) {
        Map<Integer, OrgInfo> data = Maps.newHashMap();
        List<OrgInfo> orgInfos = orgInfoDao.getOrgInfos(orgIds);
        if (CollectionUtils.isNotEmpty(orgInfos)) {
            for (OrgInfo orgInfo : orgInfos) {
                data.put(orgInfo.getOrgId(), orgInfo);
            }
        }
        return data;
    }

    @Override
    public OrgInfo getOrgInfoByOrgId(Integer orgId) {
        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId);
        return orgInfo;

    }

    @Override
    public OrgInfomationDto getOrgInfoForRefresh(Integer orgId, Integer cascadeId, String imgServerLink,
        String homepageLink) {
        try {
            Preconditions.checkNotNull(orgId, "机构orgId不能为空");
            OrgAccount orgAcc = orgAccountDao.getById(orgId);
            Preconditions.checkNotNull(orgAcc, "该orgId:" + orgId + "找不到对应的orgAccount!");
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId);
            Preconditions.checkNotNull(orgInfo, "该orgId:" + orgId + "找不到对应的orgInfo!");
            OrgTxtMsg orgTxtMsg = orgTxtMsgService.getOrgTxtByIdAndType(orgId, AuditColumType.PHONE.getValue());
            OrgInfomationDto result = new OrgInfomationDto();
            result.setOrgId(orgId);
            result.setOrgNumber(orgAcc.getNumber());
            result.setShortName(orgInfo.getShortName());
            result.setOrgName(orgInfo.getName());
            result.setMobile(orgAcc.getMobile());
            result.setHotLine(null == orgTxtMsg ? null : orgTxtMsg.getValue());
            result.setOrgAvatar(getAvatarLink(orgAcc, imgServerLink));
            result.setHomePage(homepageLink.replace("number", orgAcc.getNumber().toString()));
            result.setDataAccountType(// FIXME hag 有问题的话,这儿会报错
                null != TxAccountPermissionServiceImpl.trailOrgAccount
                    && orgAcc.getNumber().equals(TxAccountPermissionServiceImpl.trailOrgAccount.getNumber()) ? 1 : 0);
            result.setHasTianxiaoRole(BooleanUtils.toInteger(hagService.hasPermission(orgAcc.getNumber(),
                BizConf.DEFAULT_TYPE, BizConf.HAG_RESOURSE_ORG_TIANXIAO_NUMBER)));
            result.setAuditStatus(orgInfo.getAuditStatus());

            String initOrgName = "";
            String orgSlogan = "";
            String orgLogo = "";
            Integer infoFillStatus = 0;
            Integer hasMasterRole = 0;
            Integer accountStatus = 0;

            TXCascadeCredential txc = null;

            log.info("getOrgInfoForRefresh: ==== 7");
            if (null != cascadeId) {
                TXCascadeAccount tca = tXCascadeAccountDao.getById(cascadeId);
                Preconditions.checkNotNull(tca, "该cascadeId:" + cascadeId + "找不到对应的TXCascadeAccount!");
                txc = tXCascadeCredentialDao.getById(tca.getCredentialId());
                Preconditions.checkNotNull(txc, "该cascadeId:" + cascadeId + "找不到对应的TXCascadeCredential!");
                result.setCascadeId(cascadeId);
                result.setCascadeRoleType(tca.getAccountType());
                result.setCascadeAvatar(StringUtils.isEmpty(txc.getAvatar()) ? DEFAULT_ROLE_AVATAR : txc.getAvatar());
                result.setNickName(txc.getName());
            } else {
                result.setNickName(orgInfo.getContacts()); // ?TODO
            }

            log.info("getOrgInfoForRefresh: ==== 9");
            OrgSubAccount orgSubAccount = orgSubAccountDao.getByOrgId(orgId);
            Integer orgId_ = orgId;
            if (orgSubAccount != null) {
                if (orgSubAccount.getPid().intValue() != 0) {
                    orgId_ = orgSubAccount.getPid();
                } else if (cascadeId == null) {
                    hasMasterRole = 1;
                }
            }

            log.info("getOrgInfoForRefresh: ==== 10");

            TXAccount txAccount = this.txAccountDao.getByOrgId(orgId_, TXAccountStatus.VALID.getCode());
            if (txAccount != null) {
                initOrgName = txAccount.getInitOrgName();
                initOrgName = GenericsUtils.isNullOrEmpty(initOrgName) ? orgInfo.getName() : initOrgName;
                orgSlogan = txAccount.getOrgSlogan();
                orgLogo = txAccount.getOrgLogo();
                Integer infoFillStatus_ = txAccount.getInfoFillStatus();
                if (infoFillStatus_.intValue() != 0) {
                    infoFillStatus = 1;
                }
            }

            initOrgName = GenericsUtils.isNullOrEmpty(initOrgName) ? orgInfo.getShortName() : initOrgName;

            result.setOrgLogo(orgLogo);
            result.setInitOrgName(initOrgName);
            result.setOrgSlogan(orgSlogan);
            result.setInfoFillStatus(infoFillStatus);
            result.setHasMasterRole(hasMasterRole);
            result.setAccountStatus(accountStatus);

            log.info("getOrgInfoForRefresh:{}", result);
            return result;
        } catch (NullPointerException npe) {
            log.error(" error is :{} ", npe);
            throw new BussinessException(CommonErrorCode.NOT_FOUND, npe.getMessage());
        }
    }

    private String getAvatarLink(OrgAccount orgAcc, String imgServerLink) {
        List<OrgPhoto> orgPhotoList = orgPhotoDao.getByOrgIdAndCategory(orgAcc.getId(), 1);
        if (CollectionUtils.isNotEmpty(orgPhotoList)) {
            Integer storageId = orgPhotoList.get(0).getOrgStorageId();
            OrgStorage orgStorage = orgStorageDao.getById(storageId);
            return null == orgStorage ? DEFAULT_ORG_AVATAR : orgStorage.getUrl(imgServerLink);
        }
        return DEFAULT_ORG_AVATAR;
    }

    @Override
    public boolean isOptimal(Long orgId) {
        if (OPTIMAL_ORG_IDS.contains(orgId)) {
            return true;
        } else {
            return false;
        }
    }
}
