package com.baijia.tianxiao.sal.organization.finance.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.finance.po.OrgBankCard;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgBankCardDto;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgBankInfoDto;
import com.baijia.tianxiao.sal.organization.finance.dto.request.BaseUserRoleDto;
import com.baijia.tianxiao.sal.organization.finance.dto.request.CorBankCardRequest;
import com.baijia.tianxiao.sal.organization.finance.dto.request.CorCardInfoDto;
import com.baijia.tianxiao.sal.organization.finance.dto.request.DrawCashRequest;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxSuggestBankDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxWithdrawBankDto;
import com.baijia.tianxiao.sal.organization.finance.service.TxBankCardService;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.pay.PayHttpRestUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/7/11 Time: 上午10:37 To change this template use File | Settings
 * | File Templates.
 */
@Service
@Slf4j
public class TxBankCardServiceImpl implements TxBankCardService {

    @Resource
    private OrgAccountDao orgAccountDao;

    @Override
    public List<OrgBankInfoDto> commonBanks() throws BussinessException, IOException {
        List<OrgBankInfoDto> result = Lists.newArrayList();

        Map<String, String> params = new HashMap<>();
        params.put("class", "Account\\UserMarketingAccount");
        params.put("method", "billBankList");
        params.put("_param", "[]");
        params.put("_time", System.currentTimeMillis() + "");
        params.put("_client", "1");// pc
        params.put("flag", "1");// 1service,2dao

        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.API_PAY_RUL, params);
        if (isNotNullJsonNode(data)) {
            JSONObject jsondata = JSONObject.fromObject(data);
            JSONArray records = jsondata.getJSONArray("list");
            List<OrgBankInfoDto> datas = JacksonUtil.str2List(records.toString(), OrgBankInfoDto.class);

            for (OrgBankInfoDto orgBankInfoDto:datas){
                orgBankInfoDto.setIcon_url(StringUtils.imgToHttps(orgBankInfoDto.getIcon_url()));
                result.add(orgBankInfoDto);
            }
        }
        return result;
    }

    @Override
    public TxWithdrawBankDto getOrgBankInfo(Long orgId) throws BussinessException, IOException {

        List<TxWithdrawBankDto> list = Lists.newArrayList();

        Map<String, String> params = new HashMap<>();
        params.put("class", "Wallet\\WalletData");
        params.put("method", "getUserCardList");
        params.put("_time", System.currentTimeMillis() + "");
        params.put("_client", "1");// pc
        params.put("flag", "1");// 1service,2dao

        BaseUserRoleDto baseUserRole = new BaseUserRoleDto();
        baseUserRole.setUserId(orgId);
        baseUserRole.setUserRole(UserRole.ORGANIZATION.getRole());
        params.put("_param", JacksonUtil.obj2Str(baseUserRole));

        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.API_PAY_RUL, params);
        if (isNotNullJsonNode(data)) {
            JSONObject jsondata = JSONObject.fromObject(data);
            JSONArray records = jsondata.getJSONArray("withdraw_list");
            try {
                list = JacksonUtil.str2List(records.toString(), TxWithdrawBankDto.class);
            } catch (Exception e) {
                log.warn("e", e);
            }
        }
        if (!list.isEmpty()) {
            TxWithdrawBankDto result = list.get(0);
            OrgAccount orgAccount = orgAccountDao.getAccountById(orgId.intValue());
            if (orgAccount != null) {
                result.setOwner_mobile(orgAccount.getMobile());
            }
            String owner_name = result.getOwner_name();
            int length = owner_name.length();
            StringBuffer sb = new StringBuffer();
            sb.append(owner_name.charAt(0));
            if (length > 2) {
                for (int i = 1; i < length - 1; i++) {
                    sb.append("*");
                }
                sb.append(owner_name.charAt(length - 1));
            } else {
                sb.append("*");
            }
            result.setOwner_name(sb.toString());
            result.setBank_icon_url(StringUtils.imgToHttps(result.getBank_icon_url()));
            return result;
        }
        return null;
    }

    @Override
    public TxSuggestBankDto suggestBank(String cardNo) throws BussinessException, IOException {
        TxSuggestBankDto dto = null;

        Map<String, String> params = new HashMap<>();
        params.put("card_no", cardNo);

        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.PAY_SERVICE + "/wallet/suggestBank", params);
        if (isNotNullJsonNode(data)) {
            JSONObject jsondata = JSONObject.fromObject(data);
            try {
                dto = JacksonUtil.str2Obj(jsondata.toString(), TxSuggestBankDto.class);
            } catch (Exception e) {
                log.warn("e", e);
            }
        }
        return dto;
    }

    @Override
    public String drawCash(DrawCashRequest request) throws BussinessException, IOException {
        Map<String, String> result = null;

        Map<String, String> params = new HashMap<>();
        params.put("user_id", request.getOrgId() + "");
        params.put("user_role", UserRole.ORGANIZATION.getRole() + "");
        params.put("pay_password", request.getPayPassword());
        params.put("money", request.getMoney() + "");
        params.put("card_id", request.getCardId() + "");
        params.put("sms_code", request.getSmsCode());
        params.put("_time", System.currentTimeMillis() + "");
        params.put("_client", request.getClient() + "");
        params.put("wxFlag", "");

        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.PAY_SERVICE + "/wallet/createDrawCashOrder", params);
        if (isNotNullJsonNode(data)) {
            JSONObject jsondata = JSONObject.fromObject(data);
            try {
                result = JacksonUtil.str2Obj(jsondata.toString(), HashMap.class);
            } catch (Exception e) {
                log.warn("e", e);
            }
        }
        return result.get("purchase_id");
    }

    @Override
    public boolean bindCotCard(OrgBankCard bankCard) throws BussinessException, IOException {
        Map<String, String> params = new HashMap<>();
        params.put("class", "Org\\BindCard");
        params.put("method", "bindCotCard");
        params.put("_time", System.currentTimeMillis() + "");
        params.put("_client", "1");// pc
        params.put("flag", "1");// 1service,2dao

        CorBankCardRequest corBankCardRequest = new CorBankCardRequest();
        corBankCardRequest.setOrgId(bankCard.getOrgId());

        CorCardInfoDto corCardInfoDto = new CorCardInfoDto();
        corCardInfoDto.setOwner_name(bankCard.getCardOwnerName());
        corCardInfoDto.setBank_name(bankCard.getBankName());
        corCardInfoDto.setUnique_id(bankCard.getCardNum());
        corCardInfoDto.setBank_no(bankCard.getBankNo());
        corCardInfoDto.setRegion(bankCard.getRegion());
        corCardInfoDto.setOpen_location(bankCard.getCardOpenLocation());

        corBankCardRequest.setCardInfo(corCardInfoDto);
        params.put("_param", JacksonUtil.obj2Str(corBankCardRequest));

        PayHttpRestUtil.rest(PayHttpRestUtil.API_PAY_RUL, params);
        return true;
    }

    @Override
    public boolean checkPassword(Long orgId, String payPassword) throws BussinessException, IOException {
        Map<String, String> params = new HashMap<>();
        params.put("class", "Org\\OrgPayPasswd");
        params.put("method", "verifyPasswd");

        // Map<String, String> userPwd = new HashMap<>();
        // userPwd.put("orgId", orgId + "");
        // userPwd.put("pwd", payPassword);
        //
        // params.put("_param", JacksonUtil.obj2Str(userPwd));
        // 见鬼了
        params.put("_param", "{\"orgId\":\"" + orgId + "\",\"pwd\":\"" + payPassword + "\"}");
        params.put("_time", System.currentTimeMillis() + "");
        params.put("_client", "1");// pc
        params.put("flag", "1");// 1service,2dao

        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.API_PAY_RUL, params);
        return (Boolean) data;
    }

    @Override
    public boolean setPassword(Long orgId, String payPassword) throws BussinessException, IOException {
        Map<String, String> params = new HashMap<>();
        params.put("class", "Org\\OrgPayPasswd");
        params.put("method", "setPassword");

        // Map<String, String> userPwd = new HashMap<>();
        // userPwd.put("orgId", orgId + "");
        // userPwd.put("pwd", payPassword);
        //
        // params.put("_param", JacksonUtil.obj2Str(userPwd));
        // 见鬼了
        params.put("_param", "{\"orgId\":\"" + orgId + "\",\"pwd\":\"" + payPassword + "\"}");
        params.put("_time", System.currentTimeMillis() + "");
        params.put("_client", "1");// pc
        params.put("flag", "1");// 1service,2dao

        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.API_PAY_RUL, params);
        return (Boolean) data;
    }

    @Override
    public boolean unBindOrgCard(Long orgId) throws BussinessException, IOException {
        Map<String, String> params = new HashMap<>();
        params.put("class", "Org\\BindCard");
        params.put("method", "unBindOrgCard");
        params.put("_time", System.currentTimeMillis() + "");
        params.put("_client", "1");// pc
        params.put("flag", "1");// 1service,2dao

        BaseUserRoleDto baseUserRole = new BaseUserRoleDto();
        baseUserRole.setUserId(orgId);
        baseUserRole.setUserRole(UserRole.ORGANIZATION.getRole());
        params.put("_param", JacksonUtil.obj2Str(baseUserRole));

        PayHttpRestUtil.rest(PayHttpRestUtil.API_PAY_RUL, params);
        return true;
    }

    @Override
    public Map<String, String> sendSMS(OrgBankCardDto orgBankCardDto) throws BussinessException, IOException {
        Map<String, String> params = new HashMap<>();
        Map<String, String> result = null;

        params.put("owner_name", orgBankCardDto.getName());
        params.put("id_number", orgBankCardDto.getIdNumber());
        params.put("card_no", orgBankCardDto.getCardNumber());
        params.put("mobile", orgBankCardDto.getMobile());
        params.put("bank_no", orgBankCardDto.getBankNo());
        params.put("card_type", "D");
        params.put("bind_type", "0");
        params.put("region", orgBankCardDto.getRegion());
        params.put("user_id", orgBankCardDto.getOrgId() + "");
        params.put("user_role", UserRole.ORGANIZATION.getRole() + "");

        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.PAY_SERVICE + "/bank_card/sendSMS", params);
        if (isNotNullJsonNode(data)) {
            JSONObject jsondata = JSONObject.fromObject(data);
            try {
                result = JacksonUtil.str2Obj(jsondata.toString(), HashMap.class);
            } catch (Exception e) {
                log.warn("e", e);
            }
        }
        return result;
    }

    @Override
    public void verifyCard(OrgBankCardDto orgBankCardDto) throws BussinessException, IOException {
        Map<String, String> params = new HashMap<>();

        params.put("token", orgBankCardDto.getToken());
        params.put("code", orgBankCardDto.getCode());
        params.put("force", orgBankCardDto.isCan_force_bind() == true ? "1" : "0");
        params.put("user_id", orgBankCardDto.getOrgId() + "");
        params.put("user_role", UserRole.ORGANIZATION.getRole() + "");

        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.PAY_SERVICE + "/bank_card/verifyCard", params);
        if (isNotNullJsonNode(data)) {
            log.info("band per card success");
        }
    }

    @Override
    public int drawCashCount(Long orgId, String start_date, String end_date) throws BussinessException, IOException {
        Map<String, String> params = new HashMap<>();
        Map<String, String> result = null;

        params.put("org_id", orgId + "");
        params.put("start_date", start_date);
        params.put("end_date", end_date);

        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.PAY_SERVICE + "/org/countDrawCash", params);
        if (isNotNullJsonNode(data)) {
            JSONObject jsondata = JSONObject.fromObject(data);
            try {
                result = JacksonUtil.str2Obj(jsondata.toString(), HashMap.class);
            } catch (Exception e) {
                log.warn("e", e);
            }
        }
        if (result == null || result.get("count") == null || result.get("count").equals("")) {
            return 1;
        }

        return Integer.parseInt(result.get("count").toString());
    }

    private static boolean isNotNullJsonNode(Object node) {
        if (node != null && !node.equals("null") && !node.toString().equals("{}") && !node.toString().equals("[]")) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isPayPwdExist(Long orgId) throws BussinessException, IOException {
        Map<String, String> params = new HashMap<>();
        params.put("class", "Org\\OrgPayPasswd");
        params.put("method", "checkIsSetPasswd");
        params.put("_param", "{\"orgId\":\"" + orgId + "\"}");
        params.put("_time", System.currentTimeMillis() + "");
        params.put("_client", "1");// pc
        params.put("flag", "1");// 1service,2dao
        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.API_PAY_RUL, params);
        return (Boolean) data;
    }
}
