package com.baijia.tianxiao.sal.organization.dto;

import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.sal.organization.constant.ClientType;
import com.baijia.tianxiao.sal.organization.constant.Config;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.client.utils.URLEncodedUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;

import java.io.IOException;
import java.net.URLEncoder;

/**
 * Created by wengshengli on 2017/3/24.
 */
@Data
@Slf4j
public class AuthToken extends BaseDto {

    //appid
    private String appId;

    //secertKey
    private String secertKey;

    //被接入方客户端类型 ClientType
    private int clientType;

    //接入方类型 SystemType
    private int systemType;

    //机构id，如果SystemType=SystemType.PLATFORM，orgId就是机构Id，
    //SystemType=SystemType.ORGANIZATION orgId为-1
    private Long orgId;

    private String orgName;

    //当前登录业务系统的用户id
    private Long userId;

    //用户角色
    private Integer userRole;

    //名称
    private String userName;

    //请求的时间戳
    private Long timestamp;

    //跳转Url
    private String redirectUrl;

    public static AuthToken paraseToken(String token) throws Exception {
        String json = EncryptUtils.strDecode(token);
        AuthToken authToken = JacksonUtil.str2Obj(json, AuthToken.class);
        return authToken;
    }

    public static String uniqDoorGodUrl(ClientType clientTyp, DeviceType deviceType) {
        if (deviceType==DeviceType.APP){
            return Config.TX_KE_URL + "/uniRedirect.json?clientType=" + clientTyp.getCode() + "&deviceType=" + deviceType.getCode();
        }else {
            return Config.TX_ERP_URL + "/uniRedirect.json?clientType=" + clientTyp.getCode() + "&deviceType=" + deviceType.getCode();
        }
    }

    public static String assignMentStudentToken(Long orgId, String orgName, Long studentId, String userName, Integer doorgodRole, ClientType clientType) {
        AuthToken token = new AuthToken();
        token.setAppId(clientType.getAppId());
        token.setSecertKey(clientType.getSecertKey());
        token.setClientType(clientType.getCode());
        token.setOrgId(orgId);
        if (clientType == ClientType.HW) {
            token.setRedirectUrl(Config.TX_ASSIGNMENT_URL + "/mmain.do");//temp
        } else if (clientType == ClientType.EXAM) {
            token.setRedirectUrl(Config.TX_EXAM_URL + "/mmain.do");//temp
        } else if (clientType == ClientType.POINTS) {
            token.setRedirectUrl(Config.TX_POINTS_URL + "/mmain.do");
        } else {
            token.setRedirectUrl(Config.TX_GRADE_URL + "/mgrade.do");
        }
        token.setSystemType(0);//天校平台
        token.setTimestamp(System.currentTimeMillis());
        token.setUserId(studentId);
        token.setUserRole(doorgodRole);//学生
        try {
            token.setOrgName(URLEncoder.encode(orgName, "UTF-8"));
            token.setUserName(URLEncoder.encode(userName, "UTF-8"));
        } catch (Exception e) {
            token.setOrgName("");
            token.setUserName("");
        }
        String strToken = EncryptUtils.base64EncodeStrWithFactor(token);
        log.debug("[token]={}", token);
        return Config.TX_DOORGOD_URL + "/authrization/auth.do?token=" + strToken;
    }

    /**
     * 作业系统生成的token
     *
     * @param orgId
     * @param cascadeId
     * @param doorgodRole
     * @return
     */
    public static String assignMentToken(Long orgId, String orgName, Long cascadeId, String userName, Integer doorgodRole, ClientType clientType) {
        AuthToken token = new AuthToken();
        token.setAppId(clientType.getAppId());
        token.setSecertKey(clientType.getSecertKey());
        token.setClientType(clientType.getCode());
        token.setOrgId(orgId);
        if (clientType == ClientType.HW) {
            token.setRedirectUrl(Config.TX_ASSIGNMENT_URL + "/main.do");//temp
        } else if (clientType == ClientType.EXAM) {
            token.setRedirectUrl(Config.TX_EXAM_URL + "/main.do");//temp
        } else if (clientType == ClientType.POINTS) {
            token.setRedirectUrl(Config.TX_POINTS_URL + "/main.do");//temp
        } else {
            token.setRedirectUrl(Config.TX_GRADE_URL + "/grade.do");//temp
        }
        token.setSystemType(0);//天校平台
        token.setTimestamp(System.currentTimeMillis());
        token.setUserId(cascadeId);
        token.setUserRole(doorgodRole);
        try {
            token.setOrgName(URLEncoder.encode(orgName, "UTF-8"));
            token.setUserName(URLEncoder.encode(userName, "UTF-8"));
        } catch (Exception e) {
            token.setOrgName("");
            token.setUserName("");
        }
        log.debug("token = {}", token);
        String strToken = EncryptUtils.base64EncodeStrWithFactor(token);
        return Config.TX_DOORGOD_URL + "/authrization/auth.do?token=" + strToken;
    }

    public static String encodeToken(AuthToken token) throws Exception {
        return EncryptUtils.base64EncodeStrWithFactor(token);
    }

    public static void main(String args[]) throws JsonGenerationException, JsonMappingException, IOException, Exception {
        AuthToken token = new AuthToken();
        token.setAppId("tx201704221528");
        token.setSecertKey("baijiahulian_grade");
        token.setClientType(3);//成绩
        token.setOrgId(3794l);
        token.setRedirectUrl("http://test-grade.ctest.baijiahulian.com/grade.do");
        token.setSystemType(0);//pingtai
        token.setTimestamp(System.currentTimeMillis());
        token.setUserId(0l);
        token.setUserRole(2);
        String strToken = EncryptUtils.base64EncodeStrWithFactor(token);
        System.out.println(strToken);
    }
}
