/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.pcAuthority.dao.TXPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.sal.organization.constant.ClientType;
import com.baijia.tianxiao.sal.organization.constant.auth.TianYanPermissionCode;
import com.baijia.tianxiao.sal.organization.org.dto.auth.PcAccountCanSettingPermission;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXPermissionService;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TXPermissionServiceImpl
implements TXPermissionService {
    private static final Logger log = LoggerFactory.getLogger(TXPermissionServiceImpl.class);
    @Autowired
    private TXPermissionDao txPermissionDao;
    @Autowired
    private TXAccountService txAccountService;

    @Override
    public Map<Long, TXPermission> getTXPermissionsMap(List<Long> codes) {
        HashMap data = Maps.newHashMap();
        List txPermissions = this.txPermissionDao.geTxPermissions(codes);
        if (CollectionUtils.isNotEmpty((Collection)txPermissions)) {
            for (TXPermission txPermission : txPermissions) {
                data.put(txPermission.getCode(), txPermission);
            }
        }
        return data;
    }

    @Override
    public List<TXPermission> getTXPermissionsList(List<Long> codes) {
        List txPermissions = this.txPermissionDao.geTxPermissions(codes);
        return txPermissions;
    }

    @Override
    public void saveAll(List<TXPermission> txPermissions) {
        this.txPermissionDao.saveAll(txPermissions, new String[0]);
    }

    @Override
    public List<TXPermission> getAllByPid(List<Integer> ids) {
        List list = this.txPermissionDao.getByIds(ids, new String[0]);
        return list;
    }

    @Override
    public TXPermission getTXPermission(Long code) {
        TXPermission txPermission = this.txPermissionDao.getTXPermission(code);
        return txPermission;
    }

    @Override
    public Map<Integer, TXPermission> getAllTXPermissionsIDMap() {
        HashMap data = Maps.newHashMap();
        List txPermissions = this.txPermissionDao.getAll(new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)txPermissions)) {
            for (TXPermission txPermission : txPermissions) {
                data.put(txPermission.getId(), txPermission);
            }
        }
        return data;
    }

    @Override
    public Map<Long, TXPermission> getAllTXPermissionsCodeMap() {
        HashMap data = Maps.newHashMap();
        List txPermissions = this.txPermissionDao.getAll(new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)txPermissions)) {
            for (TXPermission txPermission : txPermissions) {
                data.put(txPermission.getCode(), txPermission);
            }
        }
        return data;
    }

    @Override
    public List<PcAccountCanSettingPermission> listPcAccountAllAuth(Integer orgId) {
        List pcSettingPermission = this.txPermissionDao.getByParentCode(TianYanPermissionCode.PC_SETTING_CODE.getCode());
        if (CollectionUtils.isEmpty((Collection)pcSettingPermission)) {
            return Collections.EMPTY_LIST;
        }
        Map txPermissionMap = BaseUtils.listToMap((List)pcSettingPermission, (String)"code");
        List subSettingPermission = this.txPermissionDao.getByParentCodes(txPermissionMap.keySet());
        Map subPermissionMap = CollectorUtil.group((Collection)subSettingPermission, (Function)new Function<TXPermission, Long>(){

            public Long apply(TXPermission txPermission) {
                return txPermission.getParentId();
            }
        });
        log.debug("Subpermission map = {}", (Object)subPermissionMap);
        ArrayList data = Lists.newArrayList();
        for (TXPermission txPermission : pcSettingPermission) {
            List oneSubTxPermissions = (List)subPermissionMap.get((long)txPermission.getCode());
            PcAccountCanSettingPermission dto = PcAccountCanSettingPermission.buildByTxPermission(txPermission);
            dto.setSubPermission(PcAccountCanSettingPermission.buildByTxPermissions(oneSubTxPermissions));
            data.add(dto);
        }
        TXAccount txAccount = this.txAccountService.getByOrgId(orgId, new String[0]);
        if (txAccount != null && !StringUtils.isEmpty((String)txAccount.getModuleAuth())) {
            TXPermission customParent = this.txPermissionDao.getTXPermission(TianYanPermissionCode.CUSTOM_MODULE_CODE.getCode());
            PcAccountCanSettingPermission customDto = PcAccountCanSettingPermission.buildByTxPermission(customParent);
            ArrayList customSubNode = Lists.newArrayList();
            List customModulePermission = this.txPermissionDao.getByParentCode(TianYanPermissionCode.CUSTOM_MODULE_CODE.getCode());
            Map customModuleMap = BaseUtils.listToMap((List)customModulePermission, (String)"code");
            log.debug("Custom module map = {}", (Object)customModuleMap);
            List modules = BaseUtils.strToList((String)txAccount.getModuleAuth(), (String)",");
            log.debug("txAccount module = {}", (Object)modules);
            for (String moduleStr : modules) {
                TXPermission txPermission;
                ClientType clientType = ClientType.getByCode(Integer.parseInt(moduleStr));
                if (clientType == null || (txPermission = (TXPermission)customModuleMap.get((long)clientType.getPermissionCode())) == null) continue;
                customSubNode.add(txPermission);
            }
            customDto.setSubPermission(PcAccountCanSettingPermission.buildByTxPermissions(customSubNode));
            data.add(customDto);
        }
        return data;
    }
}

