/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.index.service.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.index.constant.TxVisitorStatus;
import com.baijia.tianxiao.dal.index.dao.TxVisitorDao;
import com.baijia.tianxiao.dal.index.po.TxVisitor;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.organization.dto.request.TxVisitorRequest;
import com.baijia.tianxiao.sal.organization.index.dto.TxVisitorDto;
import com.baijia.tianxiao.sal.organization.index.service.TxVisitorService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.yunying.hag.service.HagService;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TxVisitorServiceImpl
implements TxVisitorService {
    private static final Logger log = LoggerFactory.getLogger(TxVisitorServiceImpl.class);
    public static String defaultServerPhone = "4000910910";
    @Deprecated
    private static String TRY_OPEN_TEMPLATE = "\u60a8\u5df2\u5f00\u901a\u5929\u6821\u4f53\u9a8c\uff0c\u7528\u6237\u540d%s\uff0c\u5bc6\u7801%s\uff0c%s\u5929\u6709\u6548\u3002App\u4e0b\u8f7d%s";
    @Deprecated
    private static String FREE_SMS1 = "\u60a8\u7684\u5929\u6821\u5927\u4f17\u7248\u5e10\u53f7\u7533\u8bf7\u5df2\u63d0\u4ea4\uff0c\u6211\u4eec\u5f88\u5feb\u4f1a\u548c\u60a8\u8054\u7cfb\u3002\u8be6\u8be2\u5ba2\u670d" + defaultServerPhone;
    private static int DEFAULT_VISITOR_DAY = 7;
    private static final String DEFAULT_TRY_PWD = "abc123";
    private static final String DEFAULT_FREE_PWD = "a123456";
    private static final String PROD_MANAGER_MOBILE = "15311745604";
    @Autowired
    private TxVisitorDao txVisitorDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired(required=false)
    private HagService hagService;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private CommonMsgService commonMsgService;
    @Autowired
    private TXAccountDao txAccountDao;

    @Override
    public void saveVisitor(TxVisitorRequest request) {
        if (null == request.getApplyType()) {
            request.setApplyType(0);
        }
        OrgAccount orgAcc = this.orgAccountDao.getAccountByMobile(request.getMobile());
        log.info("the visitor mobile is bind with orgAccount =={}", (Object)orgAcc);
        if (null != orgAcc) {
            TXAccount txAccount;
            OrgSubAccount subAcc = this.orgSubAccountDao.getByOrgId(orgAcc.getId(), new String[0]);
            log.info("the visitor mobile is bind with OrgSubAccount =={}", (Object)subAcc);
            if (null != subAcc && subAcc.getStatus().intValue() == DataStatus.NORMAL.getValue() && (txAccount = this.txAccountService.getTXAccountByOrgId(subAcc.getPid() == 0 ? subAcc.getOrgId() : subAcc.getPid(), new String[0])) != null) {
                TXAccountType txAccountType = TXAccountType.getTXAccountTypeByCode((Integer)txAccount.getVipLevel());
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5c0a\u656c\u7684" + (txAccountType == null ? "" : txAccountType.getLabel()) + "\u7528\u6237,\u8bf7\u60a8\u76f4\u63a5\u767b\u5f55\u5929\u6821,\u65e0\u9700\u7533\u8bf7\u4f53\u9a8c");
            }
        }
        log.info("save visitor request1 =={}", (Object)request);
        TxVisitor txVisitor = null;
        List exist = this.txVisitorDao.getByMobile(request.getMobile());
        if (CollectionUtils.isNotEmpty((Collection)exist) && ((TxVisitor)exist.get(0)).getApplyType() == 0 && request.getApplyType() == 0) {
            txVisitor = (TxVisitor)exist.get(0);
            if (txVisitor.getStartTime() != null && txVisitor.getStatus().intValue() == TxVisitorStatus.ACTIVE.getCode() && DateUtil.getDateDiff((Date)txVisitor.getStartTime(), (Date)new Date()) < DEFAULT_VISITOR_DAY) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u60a8\u5df2\u5f00\u901a\u5929\u6821\u4f53\u9a8c\u8d26\u53f7\uff0c\u8bf7\u76f4\u63a5\u767b\u5f55");
            }
        } else {
            if (CollectionUtils.isNotEmpty((Collection)exist) && ((TxVisitor)exist.get(0)).getApplyType() == 1 && request.getApplyType() == 0) {
                log.info("I don't save exist visitor from free to try ! request1:{}", (Object)request);
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6b64\u624b\u673a\u53f7\u7801\u5df2\u5728\u5927\u4f17\u7248\u7533\u8bf7\u5217\u8868\u4e2d\uff0c\u65e0\u6cd5\u518d\u7533\u8bf7\u4f53\u9a8c\u7248");
            }
            if (CollectionUtils.isNotEmpty((Collection)exist) && ((TxVisitor)exist.get(0)).getApplyType() == 1 && request.getApplyType() == 1) {
                log.info("I don't save exist visitor for free! request1:{}", (Object)request);
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6b64\u624b\u673a\u53f7\u7801\u5df2\u5728\u5927\u4f17\u7248\u7533\u8bf7\u5217\u8868\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019");
            }
            if (CollectionUtils.isNotEmpty((Collection)exist) && ((TxVisitor)exist.get(0)).getApplyType() == 0 && request.getApplyType() == 1) {
                log.info("I will upgrade the visitor level! request1:{}", (Object)request);
                txVisitor = this.upgradeFromTryToFreeTXVister(request);
                this.commonMsgService.sendTxSms(null, null, null, null, null, TxSmsCodeType.OPEN_DAZHONGBAN, null, txVisitor.getMobile(), SmsContentHelper.createDaZhongBanKaiTongSmsMsg());
                log.info("upgrade the visitor level success =={}", (Object)txVisitor);
                return;
            }
        }
        if (txVisitor == null) {
            txVisitor = new TxVisitor();
            if (StringUtils.isEmpty((Object)request.getOrgName()) || request.getOrgName().length() > 32) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784\u540d\u79f0\u9519\u8bef");
            }
            txVisitor.setOrgName(request.getOrgName());
            if (StringUtils.isEmpty((Object)request.getName()) || request.getName().length() > 10) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8054\u7cfb\u4eba\u59d3\u540d\u9519\u8bef");
            }
            txVisitor.setName(request.getName());
            if (StringUtils.isEmpty((Object)request.getMobile())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u624b\u673a\u53f7\u9519\u8bef");
            }
            txVisitor.setMobile(request.getMobile());
            if (request.getProvinceId() == null || request.getCityId() == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u9009\u62e9\u57ce\u5e02\u9519\u8bef");
            }
            txVisitor.setProvince(request.getProvince());
            txVisitor.setCity(request.getCity());
            txVisitor.setProvinceId(request.getProvinceId());
            txVisitor.setCityId(request.getCityId());
            if (!StringUtils.isEmpty((Object)request.getRemark()) && request.getRemark().length() > 200) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5907\u6ce8\u9519\u8bef");
            }
            txVisitor.setRemark(request.getRemark());
            if (request.getApplyType() == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u7533\u8bf7\u7c7b\u578b\u9519\u8bef");
            }
            txVisitor.setApplyType(request.getApplyType());
            txVisitor.setSource(request.getSource());
            txVisitor.setStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
            txVisitor.setCreateTime(new Date());
            txVisitor.setUpdateTime(new Date());
            txVisitor.setIsdel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            txVisitor.setPassword(PasswordUtil.createHash((String)DEFAULT_TRY_PWD));
            txVisitor.setStartTime(new Date());
            txVisitor.setRemainDay(Integer.valueOf(DEFAULT_VISITOR_DAY - 1));
            txVisitor.setStatus(Integer.valueOf(TxVisitorStatus.ACTIVE.getCode()));
            this.txVisitorDao.save((Object)txVisitor, new String[0]);
            log.info("save visitor success =={}", (Object)txVisitor);
        } else {
            txVisitor.setExtendCount(Integer.valueOf(txVisitor.getExtendCount() + 1));
            txVisitor.setStatus(Integer.valueOf(TxVisitorStatus.ACTIVE.getCode()));
            txVisitor.setRemainDay(Integer.valueOf(DEFAULT_VISITOR_DAY - 1));
            txVisitor.setSendMail(Integer.valueOf(0));
            txVisitor.setRemark(StringUtils.isEmpty((Object)request.getRemark()) ? txVisitor.getRemark() : request.getRemark());
            txVisitor.setStartTime(new Date());
            txVisitor.setUpdateTime(new Date());
            this.txVisitorDao.update((Object)txVisitor, new String[]{"status", "extendCount", "remark", "startTime", "updateTime", "remainDay", "sendMail"});
            log.info("update visitor success =={}", (Object)txVisitor);
        }
        if (request.getApplyType() == 0) {
            String openMsg = SmsContentHelper.createTryExpTianxiaoTemplateSmsMsg((String)txVisitor.getMobile(), (String)DEFAULT_TRY_PWD, (int)DEFAULT_VISITOR_DAY);
            this.commonMsgService.sendTxSms(null, null, null, null, null, TxSmsCodeType.TRY_OPEN_TEMPLATE, null, txVisitor.getMobile(), openMsg);
        } else if (request.getApplyType() == 1) {
            this.commonMsgService.sendTxSms(null, null, null, null, null, TxSmsCodeType.TRY_OPEN_TEMPLATE, null, txVisitor.getMobile(), SmsContentHelper.createDaZhongBanKaiTongSmsMsg());
        }
        log.info("save visitor success =={}", (Object)txVisitor);
    }

    private TxVisitor upgradeFromTryToFreeTXVister(TxVisitorRequest request) {
        TxVisitor txVisitor = new TxVisitor();
        if (StringUtils.isEmpty((Object)request.getOrgName()) || request.getOrgName().length() > 32) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setOrgName(request.getOrgName());
        if (StringUtils.isEmpty((Object)request.getName()) || request.getName().length() > 10) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setName(request.getName());
        if (StringUtils.isEmpty((Object)request.getMobile())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setMobile(request.getMobile());
        if (request.getProvinceId() == null || request.getCityId() == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setProvince(request.getProvince());
        txVisitor.setCity(request.getCity());
        txVisitor.setProvinceId(request.getProvinceId());
        txVisitor.setCityId(request.getCityId());
        if (!StringUtils.isEmpty((Object)request.getRemark()) && request.getRemark().length() > 200) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setRemark(request.getRemark());
        if (request.getApplyType() == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setApplyType(request.getApplyType());
        txVisitor.setSource(request.getSource());
        txVisitor.setStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        txVisitor.setCreateTime(new Date());
        txVisitor.setUpdateTime(new Date());
        txVisitor.setIsdel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        this.txVisitorDao.updateByMobile(txVisitor);
        return txVisitor;
    }

    @Override
    public List<TxVisitor> getListByDate(Date startDate, Date endDate) {
        List list = this.txVisitorDao.listByTime(startDate, endDate);
        log.debug("get visitor startDate={},endDate={}, list =={}", new Object[]{startDate, endDate, list.size()});
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public List<TxVisitor> getBeforeAndUpdateMail(Date thisDate) {
        List list = this.txVisitorDao.listBeforeTime(thisDate);
        log.info("get visitor thisDate={} list =={}", (Object)thisDate, (Object)list.size());
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        Map visitorMap = CollectorUtil.collectMap((Collection)list, (Function)new Function<TxVisitor, Integer>(){

            public Integer apply(TxVisitor u) {
                return u.getId();
            }
        });
        this.txVisitorDao.changeSendMail(visitorMap.keySet());
        return list;
    }

    @Override
    public Integer getActiveCount() {
        Integer count = this.txVisitorDao.getActiveCount();
        return count;
    }

    @Override
    public List<TxVisitor> getByMobile(String mobile) {
        if (StringUtils.isEmpty((Object)mobile)) {
            return null;
        }
        List visitors = this.txVisitorDao.getByMobile(mobile);
        return visitors;
    }

    @Override
    public boolean isOrgAccountValid(Integer orgId) {
        boolean result = false;
        if (orgId != null) {
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
            log.info("oorgAccountrgId:{}", (Object)orgAccount);
            if (orgAccount != null && this.hagService.hasPermission((Object)orgAccount.getNumber(), 0, "tianxiao_trial_account", new Object[0])) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public void updateVisitor(TxVisitor txVisitor) {
        this.txVisitorDao.saveOrUpdate((Object)txVisitor, new String[0]);
    }

    @Override
    public void modifyPassword(String mobile, String encryptPwd) {
        this.txVisitorDao.modifyPassword(mobile, encryptPwd);
    }

    @Override
    public List<TxVisitor> getReleaseAccount(int remainDay) {
        Date endDate = DateUtil.getDiffDateTime((Date)new Date(), (int)(-DEFAULT_VISITOR_DAY + remainDay));
        Date startDate = DateUtil.getDiffHourTime((Date)endDate, (int)-1);
        return this.txVisitorDao.releaseAccount(DateUtil.getStartOfHour((Date)startDate), DateUtil.getStartOfHour((Date)endDate));
    }

    @Override
    public List<TxVisitorDto> buildVisitorList(List<TxVisitor> list) {
        List orgIds;
        List subAccounts;
        List mobiles = BaseUtils.getListFilter(list, (String)"mobile");
        List orgAccountList = this.orgAccountDao.getAccountByMobiles(mobiles);
        Map orgAccountMap = BaseUtils.listToMap((List)orgAccountList, (String)"mobile");
        Map txAccountMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)orgAccountList) && CollectionUtils.isNotEmpty((Collection)(subAccounts = this.orgSubAccountDao.getOrgSubAccountByOrgIds((Collection)(orgIds = BaseUtils.getListFilter((List)orgAccountList, (String)"id")), null)))) {
            ArrayList txOrgIds = Lists.newArrayList();
            for (OrgSubAccount orgSubAccount : subAccounts) {
                if (orgSubAccount.getPid() != null && orgSubAccount.getPid() > 0) {
                    txOrgIds.add(orgSubAccount.getPid().longValue());
                    continue;
                }
                txOrgIds.add(orgSubAccount.getId().longValue());
            }
            if (CollectionUtils.isNotEmpty((Collection)txOrgIds)) {
                txAccountMap = this.txAccountDao.getAccountTypeMap((Collection)txOrgIds);
            }
        }
        ArrayList result = Lists.newArrayList();
        for (TxVisitor txVisitor : list) {
            TXAccountType txAccountType;
            TXAccount tempTxAccount;
            TxVisitorDto txVisitorDto = TxVisitorDto.buildByPo(txVisitor);
            OrgAccount tempOrgAccount = (OrgAccount)orgAccountMap.get(txVisitor.getMobile());
            if (tempOrgAccount != null && (tempTxAccount = (TXAccount)txAccountMap.get(tempOrgAccount.getId())) != null && (txAccountType = TXAccountType.getTXAccountTypeByCode((Integer)tempTxAccount.getVipLevel())) != null) {
                txVisitorDto.setSystemTips(DateUtil.getStrByDate((Date)tempTxAccount.getStartTime()) + "\u5df2\u5f00\u901a\u5929\u6821" + txAccountType.getLabel());
            }
            result.add(txVisitorDto);
        }
        return result;
    }
}

