/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.impl;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orgAccountService")
public class OrgAccountServiceImpl
implements OrgAccountService {
    private static final Logger log = LoggerFactory.getLogger(OrgAccountServiceImpl.class);
    @Autowired
    private OrgAccountDao orgAccountDao;

    @Override
    public OrgAccount getOrgAccountByNumber(Integer number) {
        OrgAccount account = this.orgAccountDao.getAccountByNumber(number, new String[0]);
        log.debug("org number = {},orgaccount = {}", (Object)number, (Object)account);
        return account;
    }

    @Override
    public OrgAccount getOrgAccountById(Integer orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        return account;
    }

    @Override
    public OrgAccount getOrgAccountByMobile(String mobile) {
        OrgAccount account = this.orgAccountDao.getAccountByMobile(mobile);
        return account;
    }

    @Override
    public Map<Integer, OrgAccount> getOrgAccountMap(List<Integer> orgIds) {
        HashMap orgAccountMap = Maps.newHashMap();
        List orgAccounts = this.orgAccountDao.getByIds(orgIds, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)orgAccounts)) {
            for (OrgAccount orgAccount : orgAccounts) {
                orgAccountMap.put(orgAccount.getId(), orgAccount);
            }
        }
        return orgAccountMap;
    }
}

