package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.pcAuthority.constant.ApplicationType;
import com.baijia.tianxiao.dal.pcAuthority.constant.PermissionOperationType;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxAccountPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxRolePermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.ApplicationAuthConfig;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.dal.pcAuthority.po.TxAccountPermission;
import com.baijia.tianxiao.dal.pcAuthority.po.TxRolePermission;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionAccountType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionHasType;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.AuthorityDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.PermissionDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto.AccountPermissionDto;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAuthApplicationMenuService;
import com.baijia.tianxiao.sal.organization.org.service.TXPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @author Rezar
 * @createDate :Jun 1, 2016 10:27:16 AM
 * @desc :
 */
@Service
@Slf4j
public class TxAccountPermissionServiceImpl implements TxAccountPermissionService, InitializingBean {

    @Autowired
    private TxAccountPermissionDao txAccountPermissionDao;
    @Autowired
    private TXAuthApplicationMenuService txAuthApplicationMenuService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXPermissionService txPermissionService;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private TxRolePermissionDao txRolePermissionDao;

    private static final Integer TX_ACCOUNT_TYPE_FORMAL = 0; // 正式账号
    private static final Integer TX_ACCOUNT_TYPE_TRAIL = 1; // 试用账号
    public static OrgAccount trailOrgAccount;//依赖hag稳定性,启动时加载一次

    @Data
    private static class HagDownload {
        private Integer status;
        private List<String> data;
        private Object errorcode;
    }

    private final static List<PermissionDto> expermissinDefaultPermission = new ArrayList<>();
    static {
        expermissinDefaultPermission.add(new PermissionDto(0L, "校验输入的支付密码", "10601", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "提现", "10602", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "收款页面", "10302", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "添加机构电话", "4060302", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "删除机构电话", "4060301", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "编辑机构电话", "4060303", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "设置支付密码", "10603", 1));
    }

    @Override
    public List<PermissionDto> listAllAuthModules(Integer pType, Integer deviceType, Long uId, Integer uType) {
        List<TxAccountPermission> permissions =
            txAccountPermissionDao.listAllConfigs(pType, deviceType, uId.intValue(), uType);
        if (GenericsUtils.isNullOrEmpty(permissions)) {
            return Collections.emptyList();
        }
        List<Long> pIds = ListUtil.toKeyList(permissions, "pId", TxAccountPermission.class);
        Map<Long, TxAccountPermission> permissionMaps =
            Maps.uniqueIndex(permissions, new Function<TxAccountPermission, Long>() {
                @Override
                public Long apply(TxAccountPermission arg0) {
                    return Long.valueOf(arg0.getPId());
                }
            });
        List<ApplicationAuthConfig> findApplicationMenus = txAuthApplicationMenuService.findApplicationMenus(pIds);
        if (GenericsUtils.isNullOrEmpty(findApplicationMenus)) {
            return Collections.emptyList();
        }
        List<PermissionDto> retPermissions = new ArrayList<>(findApplicationMenus.size());
        for (ApplicationAuthConfig config : findApplicationMenus) {
            TxAccountPermission permission = permissionMaps.get(config.getId());
            Integer type = 0;
            if (permission != null) {
                type = permission.getPType();
            }
            PermissionDto pd = new PermissionDto();
            pd.setName(config.getModuleName());
            pd.setTag(config.getModuleCode());
            pd.setType(type);
            retPermissions.add(pd);
        }
        return retPermissions;
    }

    /**
     * @param : deviceType 0:pc 1:app pc app查询权限接口
     */
    @Override
    public AuthorityDto findAuths(Long orgId, Integer casCadeId, Integer deviceType) {
        log.info("the orgAccount which is get from hag is:{}",trailOrgAccount);
        if(orgId.intValue() == trailOrgAccount.getId()){
            return this.findAuths(orgId, casCadeId, deviceType, TX_ACCOUNT_TYPE_TRAIL);
        }else{
            return this.findAuths(orgId, casCadeId, deviceType, TX_ACCOUNT_TYPE_FORMAL);
        }
    }

    private List<PermissionDto> toExperiecceAccountPermissions() {
        Collection<TXPermission> txPermissionList = txPermissionService.getAllTXPermissionsCodeMap().values();
        List<PermissionDto> dtoList = Lists.newArrayList();
        for(TXPermission txp : txPermissionList){
            PermissionDto dto = new PermissionDto();
            dto.setName(txp.getName());
            dto.setTag(txp.getCode().toString());
            dto.setType(TXPermissionHasType.OWN.getCode());
            dtoList.add(dto);
        }
        dtoList.addAll(expermissinDefaultPermission);
        return dtoList;
    }

    private List<PermissionDto> toTxPermissionDto(List<TxAccountPermission> permissions) {

        if (GenericsUtils.isNullOrEmpty(permissions)) {
            return Collections.emptyList();
        }
        List<TxAccountPermission> devicePermissions = new ArrayList<>();
        for (TxAccountPermission tap : permissions) {
            devicePermissions.add(tap);
        }
        log.info("find all txAccountPermissions, size:{} ", devicePermissions.size());

        Map<Integer, TXPermission> allByPidMap = txPermissionService.getAllTXPermissionsIDMap();
        List<PermissionDto> retDtos = new ArrayList<>();
        for (TxAccountPermission tap : devicePermissions) {
            Integer pId = tap.getPId();
            TXPermission tp = allByPidMap.get(pId);
            if (tp == null) {
                continue;
            }
            PermissionDto dto = new PermissionDto();
            dto.setName(tp.getName());
            dto.setTag(String.valueOf(tp.getCode()));
            dto.setType(tap.getPType());
            retDtos.add(dto);
        }
        return retDtos;
    }

    private List<TxAccountPermission> pickPermissions(List<TxAccountPermission> Permissions, Set<Long> ControlSet) {
        Map<Integer, TXPermission> allPIdMap = txPermissionService.getAllTXPermissionsIDMap();
        List<TxAccountPermission> result = Lists.newLinkedList(Permissions);

        Iterator<TxAccountPermission> iter = result.iterator();
        while (iter.hasNext()) {
            if (!ControlSet.contains(allPIdMap.get(iter.next().getPId()).getCode())) {
                iter.remove();
            }
        }
        return result;
    }

    @Override
    public List<TxAccountPermission> getAllPByUidLevelRoleDevice(Integer cascadeId, Integer vipLevel, Integer role,
        Integer device) {
        List<TxRolePermission> txRolePermissions =
            txRolePermissionDao.getTxRolePermissionsByVipLevelAndRole(vipLevel, role, device);
        List<TxAccountPermission> defaultPermissions = buildPermissions(txRolePermissions);// 先得到默认权限列表
        log.debug("the defaultPermissions size:{}", defaultPermissions.size());
        if (null != cascadeId) {
            Map<Integer, Integer> PCMap = Maps.newHashMap();
            Map<Integer, Integer> APPMap = Maps.newHashMap();
            List<TxAccountPermission> txAccountPermissions = // 得到用户当前权限
                txAccountPermissionDao.listAllConfigs(null, device, cascadeId,
                    TXPermissionAccountType.CASCADE_ACCOUNT.getCode());

            /* 控制获取的权限 */
            txAccountPermissions = pickPermissions(txAccountPermissions, TXPermissionConst.PERMISSION_SAVE_CONTROL_SET);
            log.debug("after pick the permission list size:{}", txAccountPermissions.size());

            if (CollectionUtils.isNotEmpty(txAccountPermissions)) {
                for (TxAccountPermission p : txAccountPermissions) {
                    if (p.getDeviceType().equals(DeviceType.PC.getCode())) {
                        PCMap.put(p.getPId(), p.getPType());
                    }
                    if (p.getDeviceType().equals(DeviceType.APP.getCode())) {
                        APPMap.put(p.getPId(), p.getPType());
                    }
                }
            }

            for (TxAccountPermission tap : defaultPermissions) {
                if (tap.getDeviceType().equals(DeviceType.PC.getCode()) && PCMap.containsKey(tap.getPId())) {
                    tap.setPType(PCMap.get(tap.getPId()));
                }
                if (tap.getDeviceType().equals(DeviceType.APP.getCode()) && APPMap.containsKey(tap.getPId())) {
                    tap.setPType(APPMap.get(tap.getPId()));
                }
            }
        }
        return defaultPermissions;
    }

    /**
     * @param txRolePermissions
     * @return
     */
    private List<TxAccountPermission> buildPermissions(List<TxRolePermission> txRolePermissions) {
        List<TxAccountPermission> result = Lists.newArrayList();
        for (TxRolePermission trp : txRolePermissions) {
            TxAccountPermission tap = new TxAccountPermission();
            // tap.setId(id);
            tap.setPId(trp.getPId());
            // tap.setUId(uId);
            tap.setPType(trp.getPType());
            tap.setUType(0);
            tap.setDeviceType(trp.getDeviceType());
            // tap.setCreateTime(createTime);
            // tap.setUpdateTime(updateTime);
            result.add(tap);
        }
        return result;
    }

    @Override
    public Map<Integer, TxAccountPermission> getPMapByUidLevelRoleDevice(Integer uid, Integer vipLevel, Integer role,
        Integer device) {
        Map<Integer, TxAccountPermission> data = Maps.newHashMap();
        List<TxAccountPermission> list = getAllPByUidLevelRoleDevice(uid, vipLevel, role, device);
        for (TxAccountPermission txAccountPermission : list) {
            data.put(txAccountPermission.getPId(), txAccountPermission);
        }
        log.debug("the length of TxAccountPermission pMap is{}", data.size());
        return data;
    }

    @Override
    public void saveAll(List<TxAccountPermission> txAccountPermissions) {
        txAccountPermissionDao.saveAll(txAccountPermissions);
    }

    @Override
    public void updateAll(List<TxAccountPermission> txAccountPermissions) {
        if (CollectionUtils.isNotEmpty(txAccountPermissions)) {
            for (TxAccountPermission txAccountPermission : txAccountPermissions) {
                txAccountPermissionDao.update(txAccountPermission);
            }
        }
    }

    @Override
    public boolean hasPermission(Long cascadeId, ApplicationType deviceType, TXPermissionConst permission) {
        List<Long> codes = new ArrayList<Long>();
        codes.add(permission.getpCode().longValue());
        List<TXPermission> permissionList = txPermissionService.getTXPermissionsList(codes);
        if (CollectionUtils.isEmpty(permissionList)) {
            return false;
        }

        TxAccountPermission txAccountPermission = txAccountPermissionDao
            .getTxAccountPermission(permissionList.get(0).getId(), deviceType.type, cascadeId.intValue());
        if (txAccountPermission != null
            && txAccountPermission.getPType().equals(PermissionOperationType.CAN_USE.type)) {
            return true;
        }
        return false;
    }

    /**
     * @param accountTypeOfUser :当前账号是否是体验账号 0:正式 1:体验账号
     * @param deviceType :0:pc 1:app
     */
    @Override
    public AuthorityDto findAuths(Long orgId, Integer casCadeId, Integer deviceType, Integer accountTypeOfUser) {
        if (accountTypeOfUser == null) {
            accountTypeOfUser = TX_ACCOUNT_TYPE_FORMAL;
        }
        AuthorityDto authorityDto = new AuthorityDto();
        RoleType superRole = null;
        Long roleValue = null;
        String roleName = "";
        Integer uId = casCadeId;
        TXAccount superAccount = null;
        List<PermissionDto> permissionDtos = null;
        if (accountTypeOfUser == TX_ACCOUNT_TYPE_FORMAL) {// 正式账号的情况
            if (casCadeId != null && casCadeId != 0L) {// 员工子账号
                TXCascadeAccount tca = this.txCascadeAccountDao.getById(casCadeId);
                if (tca == null) {
                    log.info("can not find any cascade account with cadcadeId : {} ", casCadeId);
                    return null;
                }
                // 为了查询vip级别,必须查superAccount
                OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(tca.getOrgId());
                if (osa == null) {
                    OrgAccount accountById = this.orgAccountDao.getAccountById(tca.getOrgId());
                    superAccount = txAccountService.getByOrgId(tca.getOrgId());
                    if (accountById == null || null == superAccount) {
                        log.info(" can not find any org account with orgId : {} ", orgId);
                        return null;
                    }
                } else {
                    Integer pId = osa.getPid();
                    if (0 == pId) {
                        superAccount = txAccountService.getByOrgId(tca.getOrgId());
                    } else {
                        superAccount = txAccountService.getByOrgId(pId);
                    }
                } // 查询结束

                Integer accountType = tca.getAccountType();
                superRole = RoleType.getRoleType(accountType);
            } else {// 校长 or 分校长
                OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(orgId.intValue());
                if (osa == null) {
                    OrgAccount accountById = this.orgAccountDao.getAccountById(orgId.intValue());
                    superAccount = txAccountService.getByOrgId(orgId.intValue());
                    if (accountById == null || null == superAccount) {
                        log.info(" can not find any org account with orgId : {} ", orgId);
                        return null;
                    }
                    superRole = RoleType.PRESIDENT;
                } else {
                    Integer pId = osa.getPid();
                    if (0 == pId) {
                        superAccount = txAccountService.getByOrgId(orgId.intValue());
                        superRole = RoleType.PRESIDENT;
                    } else {
                        superAccount = txAccountService.getByOrgId(pId);
                        superRole = RoleType.BRANCH_SCH_PRESIDENT;
                    }
                }
                uId = orgId.intValue();
            }
            
            if(null == superAccount){
                log.info("getAuth cannot get the TXAccount by orgId:{},cascadeId:{}",orgId,casCadeId);
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR,"抱歉，无法查询到您的账户信息。");
            }
            
            log.info("uId is :{} and roleType is : {} ", uId, superRole);

            List<TxAccountPermission> permissions = null;
            if (superRole == RoleType.CHARAGE || superRole == RoleType.EMPLOYEE) {// 是员工子账号
                permissions = getAllPByUidLevelRoleDevice(uId, superAccount.getVipLevel(), superRole.type, deviceType);
                log.info("convert to txPermissionDto with : {} ", permissions.size());
                permissionDtos = toTxPermissionDto(permissions);
            } else if (superRole == RoleType.PRESIDENT || superRole == RoleType.BRANCH_SCH_PRESIDENT) {// 是校长账号
                permissions = getAllPByUidLevelRoleDevice(null, superAccount.getVipLevel(), superRole.type, deviceType);
                log.info("convert to txPermissionDto with : {} ", permissions.size());
                permissionDtos = toTxPermissionDto(permissions);
            }

        } else if (accountTypeOfUser == TX_ACCOUNT_TYPE_TRAIL) {
            superRole = RoleType.PRESIDENT;
            permissionDtos = toExperiecceAccountPermissions();
        }

        roleValue = superRole.type.longValue();
        roleName = superRole.desc;

        authorityDto.setRole(roleValue);
        authorityDto.setRoleName(roleName);
        authorityDto.setHasPermissions(permissionDtos);
        if (null != superAccount) {
            if (superAccount.getVipLevel().equals(TXAccountType.DAZHONG.getCode())) {
                authorityDto.setVipName(TXAccountType.DAZHONG.getLabel());
            }
        }
        return authorityDto;
    }

    @Override
    public List<TxAccountPermission> getAccountPermission(Integer uid, Integer pid) {
        List<TxAccountPermission> txAccountPermissions = txAccountPermissionDao.geTxAccountPermission(pid, uid);
        return txAccountPermissions;
    }

    @Override
    public List<TxAccountPermission> getAccountPermission(Integer uid, List<Integer> pid) {
        List<TxAccountPermission> txAccountPermissions = txAccountPermissionDao.geTxAccountPermission(pid, uid);
        return txAccountPermissions;
    }

    @Override
    public TxAccountPermissionsDto universalGetPermissions(int orgId, Integer cascadeId) {
        TxAccountPermissionsDto result = null;
        List<TxRolePermission> plist = null;
        // 找爹
        OrgSubAccount subAcc = null;
        TXAccount superAcc = null;
        subAcc = orgSubAccountDao.getByOrgId(orgId);
        if (0 == subAcc.getPid()) {// 先找到天校账号
            superAcc = txAccountService.getByOrgId(orgId);
        } else {
            superAcc = txAccountService.getByOrgId(subAcc.getPid());
        } // 找爹done
        log.debug("universalGetPermissions param is[ orgId:{},cascadeId:{}],superAcc:{}", orgId, cascadeId, superAcc);
        if (null == cascadeId) {// 校区账号
            if (0 == subAcc.getPid()) {// 主校区
                plist = txRolePermissionDao.getTxRolePermissionsByVipLevelAndRole(superAcc.getVipLevel(),
                    RoleType.PRESIDENT.type);
                result = rolePermissionsToDto(orgId, cascadeId, plist);
            } else if (0 != subAcc.getPid()) {// 分校区
                plist = txRolePermissionDao.getTxRolePermissionsByVipLevelAndRole(superAcc.getVipLevel(),
                    RoleType.BRANCH_SCH_PRESIDENT.type);
                result = rolePermissionsToDto(orgId, cascadeId, plist);
            }
        } else {// 员工子账号
            TXCascadeAccount txCasAcc = txCascadeAccountDao.getById(cascadeId);
            List<TxAccountPermission> txAccountPermissions =
                getAllPByUidLevelRoleDevice(cascadeId, superAcc.getVipLevel(), txCasAcc.getAccountType(), null);
            result = buildDto2(orgId, cascadeId, txAccountPermissions);
        }
        return result;
    }

    private TxAccountPermissionsDto buildDto2(int orgId, Integer cascadeId,
        List<TxAccountPermission> txAccountPermissions) {
        Map<Integer, TXPermission> pMap = txPermissionService.getAllTXPermissionsIDMap();
        TxAccountPermissionsDto result = new TxAccountPermissionsDto();
        result.setOrgID(orgId);
        result.setCascadeId(cascadeId);
        List<TxAccountPermissionsDto.AccountPermissionDto> PCps = Lists.newArrayList();
        List<TxAccountPermissionsDto.AccountPermissionDto> APPps = Lists.newArrayList();
        for (TxAccountPermission rp : txAccountPermissions) {// 根据TxAccountPermission的设备放入不同的list中
            TXPermission permission = pMap.get(rp.getPId());
            if (rp.getDeviceType().equals(DeviceType.PC.getCode())) {
                PCps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), permission.getCode(),
                    permission.getName(), rp.getPType(), rp.getDeviceType()));
            } else if (rp.getDeviceType().equals(DeviceType.APP.getCode())) {
                APPps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), permission.getCode(),
                    permission.getName(), rp.getPType(), rp.getDeviceType()));
            }
        }
        result.setPCps(PCps);
        result.setAPPps(APPps);
        return result;
    }

    private TxAccountPermissionsDto rolePermissionsToDto(int orgId, Integer cascadeId, List<TxRolePermission> plist) {
        log.debug("rolePermissionsToDto the input rolePermissions list size is{}", plist.size());
        Map<Integer, TXPermission> pIdMap = txPermissionService.getAllTXPermissionsIDMap();

        TxAccountPermissionsDto result = new TxAccountPermissionsDto();
        result.setOrgID(orgId);
        result.setCascadeId(cascadeId);
        List<TxAccountPermissionsDto.AccountPermissionDto> PCps = Lists.newArrayList();
        List<TxAccountPermissionsDto.AccountPermissionDto> APPps = Lists.newArrayList();
        for (TxRolePermission rp : plist) {// 根据TxAccountPermission的设备放入不同的list中
            if (rp.getDeviceType().equals(DeviceType.PC.getCode())) {
                PCps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), rp.getPCode(),
                    pIdMap.get(rp.getPId()).getName(), rp.getPType(), rp.getDeviceType()));
            } else if (rp.getDeviceType().equals(DeviceType.APP.getCode())) {
                APPps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), rp.getPCode(),
                    pIdMap.get(rp.getPId()).getName(), rp.getPType(), rp.getDeviceType()));
            }
        }
        result.setPCps(PCps);
        result.setAPPps(APPps);
        return result;
    }

    @Override
    public TxAccountPermissionsDto universalGetPermissions(int orgId, Integer cascadeId, Collection<Long> pCodes) {
        TxAccountPermissionsDto result = null;
        if (CollectionUtils.isEmpty(pCodes)) {
            result = new TxAccountPermissionsDto();
            result.setOrgID(orgId);
            result.setCascadeId(cascadeId);
            result.setAPPps(new ArrayList<AccountPermissionDto>());
            result.setPCps(new ArrayList<AccountPermissionDto>());
            return result;
        }
        List<TxRolePermission> plist = null;
        OrgSubAccount subAcc = null;
        TXAccount superAcc = null;
        subAcc = orgSubAccountDao.getByOrgId(orgId);
        if (0 == subAcc.getPid()) {// 先找到天校账号
            superAcc = txAccountService.getByOrgId(orgId);
        } else {
            superAcc = txAccountService.getByOrgId(subAcc.getPid());
        }

        if (null == cascadeId) {// 校区账号
            if (0 == subAcc.getPid()) {// 主校区
                plist = txRolePermissionDao.getTxRolePermissionsByCodes(superAcc.getVipLevel(), RoleType.PRESIDENT.type,
                    pCodes);
                result = rolePermissionsToDto(orgId, cascadeId, plist);
            }
            if (0 != subAcc.getPid()) {// 分校区
                plist = txRolePermissionDao.getTxRolePermissionsByCodes(superAcc.getVipLevel(),
                    RoleType.BRANCH_SCH_PRESIDENT.type, pCodes);
                result = rolePermissionsToDto(orgId, cascadeId, plist);
            }
        } else {// 员工子账号
            TXCascadeAccount txCasAcc = txCascadeAccountDao.getById(cascadeId);
            List<TxAccountPermission> txAccountPermissions =
                getAllPByUidLevelRoleDevice(cascadeId, superAcc.getVipLevel(), txCasAcc.getAccountType(), null);
            result = buildDtoByFilter(orgId, cascadeId, txAccountPermissions, pCodes);
        }
        return result;
    }

    private TxAccountPermissionsDto buildDtoByFilter(int orgId, Integer cascadeId,
        List<TxAccountPermission> txAccountPermissions, Collection<Long> pCodes) {
        Map<Integer, TXPermission> pMap = txPermissionService.getAllTXPermissionsIDMap();
        TxAccountPermissionsDto result = new TxAccountPermissionsDto();
        result.setOrgID(orgId);
        result.setCascadeId(cascadeId);
        List<TxAccountPermissionsDto.AccountPermissionDto> PCps = Lists.newArrayList();
        List<TxAccountPermissionsDto.AccountPermissionDto> APPps = Lists.newArrayList();
        Set<Long> pCodeSet = Sets.newHashSet(pCodes);// 过滤
        for (TxAccountPermission rp : txAccountPermissions) {// 根据TxAccountPermission的设备放入不同的list中
            TXPermission permission = pMap.get(rp.getPId());
            if (!pCodeSet.contains(permission.getCode())) {// 进行过滤
                continue;
            }
            if (rp.getDeviceType().equals(DeviceType.PC.getCode())) {
                PCps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), permission.getCode(),
                    permission.getName(), rp.getPType(), rp.getDeviceType()));
            } else if (rp.getDeviceType().equals(DeviceType.APP.getCode())) {
                APPps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), permission.getCode(),
                    permission.getName(), rp.getPType(), rp.getDeviceType()));
            }
        }
        result.setAPPps(APPps);
        result.setPCps(PCps);
        return result;
    }

    public static void main(String[] args) {
        String response = "{\"status\":200,\"data\":[\"458130179#0\"],\"errorCode\":null}";
        try {
            System.out.println(JacksonUtil.str2Obj(response, HagDownload.class));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        String numberStr = null;
        String url = null;
        try {
            Map<String, String> params = Maps.newHashMap();
            params.put("resource", "tianxiao_trial_account");
            try{
                url = PropertiesReader.getValue("hag", "hag.http.url.downloadList");
            }catch (MissingResourceException mre){
                log.warn("this project donot contains hag.properties file! the trial orgAccount won't be initialized!");
                return;
            }
            String response = HttpClientUtils.doPost(url, params);
            log.info("hagResponse:{}",response);
            HagDownload hagDto = JacksonUtil.str2Obj(response, HagDownload.class);
            log.info("hagDto:{}",hagDto);
            if (hagDto == null || CollectionUtils.isEmpty(hagDto.getData())) {
                return;
            }
            numberStr = hagDto.getData().get(0).split("#")[0];
            Integer number = Integer.parseInt(numberStr);
            trailOrgAccount = orgAccountDao.getAccountByNumber(number);
            log.info("the orgAccount which is get from hag is:{}",trailOrgAccount);
        } catch (Exception e) {
            log.error("get orgAccount by hag error!", e);
        }        
    }
}