
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXKefuRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.TXKefuRule;
import com.baijia.tianxiao.sal.organization.constant.TXKefuRuleValue;
import com.baijia.tianxiao.sal.organization.org.service.TXKefuRuleService;

/**
 * @title TXKefuServiceImpl
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年6月1日
 * @version 1.0
 */

@Service
public class TXKefuServiceImpl implements TXKefuRuleService {

    @Autowired
    private TXKefuRuleDao txKefuRuleDao;
    @Autowired
    private OrgAccountDao orgAccountDao;

    @Override
    public TXKefuRule getByOrgId(Integer orgId) {
        TXKefuRule txKefuRule = txKefuRuleDao.getByOrgId(orgId);
        if(txKefuRule == null){
            txKefuRule = new TXKefuRule();
            txKefuRule.setBespeakRule(TXKefuRuleValue.BESPEAKRULE_MESSAGE.getCode());
            txKefuRule.setConsultRule(TXKefuRuleValue.CONSULT_RULE_AUTO.getCode());
            txKefuRule.setCreateTime(new Date());
            txKefuRule.setOrgId(orgId);
            OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
            txKefuRule.setOrgNumber(orgAccount.getNumber());
//            txKefuRuleDao.save(txKefuRule);
        }
        return txKefuRule;
    }

    @Override
    public void saveTXKefuRule(TXKefuRule txKefuRule) {
        txKefuRuleDao.saveOrUpdate(txKefuRule);
    }
}