
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.organization.org.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;

/**
 * @title TXCampusAccountServiceImpl
 * @desc TODO
 * @author caoliang
 * @date 2016年5月10日
 * @version 1.0
 */
@Service
public class TXAccountServiceImpl implements TXAccountService {

    @Autowired
    private TXAccountDao txAccountDao;

    @Override
    public TXAccount getByOrgId(Integer orgId) {
        TXAccount account = txAccountDao.getByOrgId(orgId);
        return account;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.sal.organization.org.service.TXAccountService#getByIdAndOrgId(java.lang.Integer,
     * java.lang.Integer)
     */

    @Override
    public TXAccount getByIdAndOrgId(Integer id, Integer orgId) {
        TXAccount account = txAccountDao.getByIdAndOrgId(id, orgId);
        return account;
    }

    @Override
    public TXAccount getByOrgNumber(Integer orgNumber) {
        TXAccount txAccount = txAccountDao.getByOrgNumber(orgNumber);
        return txAccount;
    }

}
