
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.util.Date;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.show.dao.OrgShowInfoDao;
import com.baijia.tianxiao.dal.show.po.OrgShowInfo;
import com.baijia.tianxiao.sal.organization.org.service.OrgShowInfoService;


/**
 * @title OrgShowInfoServiceImpl
 * @desc TODO 
 * @author zhangbing
 * @date 2016年3月15日
 * @version 1.0
 */
@Service
public class OrgShowInfoServiceImpl implements OrgShowInfoService {
    
    @Resource
    private OrgShowInfoDao orgShowInfoDao;

    @Override
    public OrgShowInfo getOrgShowInfo(long orgId, int type) {
        OrgShowInfo showInfo = orgShowInfoDao.getShowInfo(orgId, type);
        return showInfo;
    }

    @Override
    public void saveOrgShowInfo(long orgId, int type, String content) {
        OrgShowInfo showInfo = orgShowInfoDao.getShowInfo(orgId, type);
        if (showInfo == null) {
            showInfo = new OrgShowInfo();
            showInfo.setContent(content);
            showInfo.setCreateTime(new Date());
            showInfo.setOrgId(orgId);
            showInfo.setType(type);
            
            this.orgShowInfoDao.save(showInfo);
        } else {
            showInfo.setContent(content);
            showInfo.setUpdateTime(new Date());
            
            this.orgShowInfoDao.update(showInfo, "content", "updateTime");
        }
    }
}

    