package com.baijia.tianxiao.sal.organization.org.service;

import com.baijia.tianxiao.dal.pcAuthority.constant.ApplicationType;
import com.baijia.tianxiao.dal.pcAuthority.po.TxAccountPermission;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.AuthorityDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.PermissionDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author Rezar
 * @createDate :Jun 1, 2016 10:24:16 AM
 * @desc :
 */

/**
 * @title TxAccountPermissionService
 * @desc 增加了两个universal通用方法,用于获取权限,尽量使用universal方法.
 * @author hongyan
 * @date 2016年8月6日
 * @version 1.0
 */
public interface TxAccountPermissionService {
    /**
     * 自动根据orgId或cascadeId所属的天校主账号的 会员等级,身份,返回对应的权限or默认权限.
     * 
     * @param orgId 非空机构id
     * @param cascadeId 可空,空值查询校区账号权限,非空查询子账号权限
     * @return 校区账号或子账号拥有的权限
     */
    public TxAccountPermissionsDto universalGetPermissions(int orgId, Integer cascadeId);

    /**
     * 增加了权限码,只返回该权限码对应的PC 与 APP 权限;
     * 
     * @param orgId 非空机构id
     * @param cascadeId 可空,空值查询校区账号权限,非空查询子账号权限
     * @param pCode 指定的权限码
     * @return 校区账号或子账号拥有的权限中 对应该权限码的权限拥有情况
     */
    public TxAccountPermissionsDto universalGetPermissions(int orgId, Integer cascadeId, Collection<Long> pCode);

    public List<PermissionDto> listAllAuthModules(Integer pType, Integer deviceType, Long uId, Integer uType);

    public AuthorityDto findAuths(Long orgId, Integer casCadeId, Integer deviceType);

    public AuthorityDto findAuths(Long orgId, Integer casCadeId, Integer deviceType, Integer accountType);

    /**
     * 子账号的全部权限,若uid不为空,则先查询用户的权限,若uid为空,则查询默认权限.这个取到的权限永远都是全的!
     * 
     * @param uid 子账号用户id
     * @param vipLevel 子账号所属机构的会员等级
     * @param role 子账号身份 员工 or 主管
     * @param device 设备 pc or app
     * @return
     */
    public List<TxAccountPermission> getAllPByUidLevelRoleDevice(Integer uid, Integer vipLevel, Integer role,
        Integer device);
    /**
     * 子账号的全部权限
     * 
     * @param uid 子账号用户id
     * @param vipLevel 子账号所属机构的会员等级
     * @param role 子账号身份 员工 or 主管
     * @param device 设备 pc or app
     * @return
     */
    public Map<Integer, TxAccountPermission> getPMapByUidLevelRoleDevice(Integer uid, Integer vipLevel, Integer role,
        Integer device);

    public void saveAll(List<TxAccountPermission> txAccountPermissions);

    public void updateAll(List<TxAccountPermission> txAccountPermissions);

    public boolean hasPermission(Long cascadeId, ApplicationType deviceType, TXPermissionConst permission);
    
    public List<TxAccountPermission> getAccountPermission(Integer uid, Integer pid);
    
    public List<TxAccountPermission> getAccountPermission(Integer uid, List<Integer> pid);
}
