
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.organization.impl;

import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @author zhangbing
 * @version 1.0
 * @title OrgAccountServiceImpl
 * @desc TODO
 * @date 2015年12月2日
 */
@Service("orgAccountService")
@Slf4j
public class OrgAccountServiceImpl implements OrgAccountService {

    @Autowired
    private OrgAccountDao orgAccountDao;

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.sal.organization.api.OrgAccountService#getOrgAccountByNumber(java.lang.Integer)
     */

    @Override
    public OrgAccount getOrgAccountByNumber(Integer number) {

        OrgAccount account = this.orgAccountDao.getAccountByNumber(number);

        log.debug("org number = {},orgaccount = {}", number, account);
        return account;
    }

    @Override
    public OrgAccount getOrgAccountById(Integer orgId) {
        
        OrgAccount account = this.orgAccountDao.getAccountById(orgId);
        return account;
    }

    @Override
    public OrgAccount getOrgAccountByMobile(String mobile) {
        OrgAccount account = this.orgAccountDao.getAccountByMobile(mobile);
        return account;
            
    }

    @Override
    public Map<Integer, OrgAccount> getOrgAccountMap(List<Integer> orgIds) {
        Map<Integer, OrgAccount> orgAccountMap = Maps.newHashMap();
        List<OrgAccount> orgAccounts = orgAccountDao.getByIds(orgIds);
        if(CollectionUtils.isNotEmpty(orgAccounts)){
            for(OrgAccount orgAccount : orgAccounts){
                orgAccountMap.put(orgAccount.getId(), orgAccount);
            }
        }
        return orgAccountMap;
            
    }
}

    