package com.baijia.tianxiao.sal.organization.finance.service;

import com.baijia.tianxiao.dal.finance.po.OrgBankCard;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgBankCardDto;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgBankInfoDto;
import com.baijia.tianxiao.sal.organization.finance.dto.request.DrawCashRequest;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxSuggestBankDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxWithdrawBankDto;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/7/11
 * Time: 上午10:37
 * To change this template use File | Settings | File Templates.
 */
public interface TxBankCardService {

    List<OrgBankInfoDto> commonBanks() throws BussinessException, IOException;

    TxWithdrawBankDto getOrgBankInfo(Long orgId) throws BussinessException, IOException;

    TxSuggestBankDto suggestBank(String cardNo) throws BussinessException, IOException;

    boolean bindCotCard(OrgBankCard bankCard) throws BussinessException, IOException;

    boolean unBindOrgCard(Long orgId) throws BussinessException, IOException;

    boolean checkPassword(Long orgId, String payPassword) throws BussinessException, IOException;


    /**
     * 个人绑卡 步骤一  发短信
     *
     * @param orgBankCardDto
     * @return
     * @throws BussinessException
     * @throws IOException
     */
    Map<String, String> sendSMS(OrgBankCardDto orgBankCardDto) throws BussinessException, IOException;

    /**
     * 个人绑卡步骤2 验证
     *
     * @param orgBankCardDto
     * @return
     * @throws BussinessException
     * @throws IOException
     */
    void verifyCard(OrgBankCardDto orgBankCardDto) throws BussinessException, IOException;

    String drawCash(DrawCashRequest request) throws BussinessException, IOException;

    int drawCashCount(Long orgId, String start_date, String end_date) throws BussinessException, IOException;

}
