package com.baijia.tianxiao.sal.organization.finance.constant;


import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/7/9
 * Time: 下午5:44
 * To change this template use File | Settings | File Templates.
 */
public enum FinancePayTypeCode {

    POS(0, "POS支付"),
    CASH(4, "现金支付"),
    ONLINE(51, "在线支付"),;

    private Integer code;
    private String name;

    private static Map<Integer, FinancePayTypeCode> map = Maps.newHashMap();

    static {
        for (FinancePayTypeCode one : FinancePayTypeCode.values()) {
            map.put(one.getCode(), one);
        }
    }

    FinancePayTypeCode(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getPayName(Integer code) {
        return map.get(code) == null ? POS.getName() : map.get(code).getName();
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
