/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.organization.constant;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;

/**
 * @title TXPermissionConst
 * @desc 重构的constant,只用于方便查询.当有新权限增加时,rd需在这里增加枚举值
 * @author hongyan
 * @date 2016年8月6日
 * @version 1.0
 */
public enum TXPermissionConst {
    CAMPUS_SETTING(100, "校区设置"),
    ACCOUNT_SETTING(101,"账号设置"),
    ZIJIN(102,"资金管理"),
    SHEZHIGUIZE(103,"设置规则"),
    CHAXUN_ZIXUNJULU(104,"查看机构所有咨询记录"),
    CHULI_ZIJI_ZIXUN(105,"处理分配给自己的咨询"),
    CHAKAN_XIANSUO(106,"查看机构所有线索信息"),
    SHANCHU_XIANSUO(107,"删除线索"),
    FENPEI_XIANSUO(108,"分配线索"),
    DAOCHU_XIANSUO(109,"导出线索"),
    JIHUO_WUXIAO_XIANSUO(110,"激活无效线索"),
    JGUANLI_ZIJI_XIANSUO(111,"管理分配给自己的线索"),
    CHAKAN_SUOYOU_XUEYUAN(112,"查看机构所有学员信息"),
    SHANCHU_XUEYUAN(113,"删除学员"),
    DAOCHU_XUEYUAN(114,"导出学员"),
    GUANLI_ZIJI_XUEYUAN(115,"管理分配给自己的学员"),
    XINZENG_BANJI(116,"新增班级"),
    XINZENG_LAOSHI(117,"新增老师"),
    XINZENG_JIAOSHI(118,"新增教室"),
    FENPEI_BANZHUREN(119,"分配班主任"),
    PAIKE(124,"是否可排课"),
    QIANDAO(121,"是否可签到"),
    SHOUKUAN(122,"是否可收款"),
    XINZENG_YINGXIAO(123,"新增营销活动"),
    PAIKE_XIANSHI(120,"是否可管理排课"),
    QIANDAO_XIANSHI(125,"是否可管理签到"),
    //ZIJIN_XIANSHI(78,126,"是否可管理资金"),
    //LAOSHI_XIANSHI(79,127,"是否可管理老师"),
    KEBIAO_XIANSHI(128,"是否可管理课表"),
    KEBIAO_GUANLI(129,"是否可以使用课表"),
    WX_GUANJIA(145,"微信管家"),
    ZHUANJIESHAO(146,"转介绍"),
    QUANWANGBAOWEN(147,"全网爆文"),
    GSXTUIGUANG(150,"跟谁学推广"),
    ZHAOSHENGLOUDOU(131,"招生漏斗图"),
    ZIXUNLAIYUANFENXI(132,"咨询来源分析报表"),
    WXFENSIQUSHI(133,"微信粉丝增减趋势"),
    TOUPIAO(152,"投票"),
    CHOUJIANG(153,"抽奖"),
    QUNFAXIAOXI(154,"群发消息"),
    ;
    private Long pCode;
    private String pName;

    TXPermissionConst(Integer pCode, String pName) {
        this.pCode = pCode.longValue();
        this.pName = pName;
     }
    public Long getpCode() {
        return pCode;
    }
    public void setpCode(Long pCode) {
        this.pCode = pCode;
    }
    public String getpName() {
        return pName;
    }
    public void setpName(String pName) {
        this.pName = pName;
    }

    /* ===================================以下保存特殊逻辑使用的常量集合==================================== */

    /**
     * @author caoliang
     */
    public static Map<Long,TXPermissionConst> MARKET_ENTRY_PERMISSION_MAP = new HashMap<>();
    static {
        MARKET_ENTRY_PERMISSION_MAP.put(WX_GUANJIA.getpCode(),WX_GUANJIA);
        MARKET_ENTRY_PERMISSION_MAP.put(ZHUANJIESHAO.getpCode(),ZHUANJIESHAO);
        MARKET_ENTRY_PERMISSION_MAP.put(QUANWANGBAOWEN.getpCode(),QUANWANGBAOWEN);
        MARKET_ENTRY_PERMISSION_MAP.put(GSXTUIGUANG.getpCode(),GSXTUIGUANG);
        MARKET_ENTRY_PERMISSION_MAP.put(TOUPIAO.getpCode(),TOUPIAO);
        MARKET_ENTRY_PERMISSION_MAP.put(CHOUJIANG.getpCode(),CHOUJIANG);
        MARKET_ENTRY_PERMISSION_MAP.put(QUNFAXIAOXI.getpCode(),QUNFAXIAOXI);
    }

    /**
     * @desc 重构的权限更改一对多map,将只保存冗余的对应关系,自身对应被剔除.对应关系被改为code.
     * @author hongyan
     * @date 2016年8月6日
     * @version 1.0
     */
    public static final Multimap<Long, Long> ONE_MULTY_CODE_MAP = ArrayListMultimap.create();
    static {
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.PAIKE_XIANSHI.getpCode(), TXPermissionConst.PAIKE.getpCode());
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.PAIKE_XIANSHI.getpCode(), TXPermissionConst.KEBIAO_XIANSHI.getpCode());
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.PAIKE_XIANSHI.getpCode(), TXPermissionConst.KEBIAO_GUANLI.getpCode());
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.QIANDAO.getpCode(), TXPermissionConst.QIANDAO_XIANSHI.getpCode());
        ONE_MULTY_CODE_MAP.put(TXPermissionConst.XINZENG_YINGXIAO.getpCode(), TXPermissionConst.QUNFAXIAOXI.getpCode());
    }
    
    /**
     * @desc 权限保存控制表,总校长在crm对员工进行权限控制时,set中有的code将被反映到数据库,其他值使用默认权限 前端若增加了权限控制勾选项目,需要在这个set中增加对应权限码.
     * @author hongyan
     */
    public static final Set<Long> PERMISSION_SAVE_CONTROL_SET = Sets.newHashSet();
    static {
        // PERMISSION_SAVE_CONTROL_SET.add(CAMPUS_SETTING.getpCode());// 100
        // PERMISSION_SAVE_CONTROL_SET.add(ACCOUNT_SETTING.getpCode());// 101
        // PERMISSION_SAVE_CONTROL_SET.add(ZIJIN.getpCode());// 102

        PERMISSION_SAVE_CONTROL_SET.add(SHEZHIGUIZE.getpCode());// 103

        PERMISSION_SAVE_CONTROL_SET.add(CHAXUN_ZIXUNJULU.getpCode());// 104
        PERMISSION_SAVE_CONTROL_SET.add(CHULI_ZIJI_ZIXUN.getpCode());// 105

        PERMISSION_SAVE_CONTROL_SET.add(CHAKAN_XIANSUO.getpCode());// 106
        PERMISSION_SAVE_CONTROL_SET.add(SHANCHU_XIANSUO.getpCode());// 107
        PERMISSION_SAVE_CONTROL_SET.add(FENPEI_XIANSUO.getpCode());// 108
        PERMISSION_SAVE_CONTROL_SET.add(DAOCHU_XIANSUO.getpCode());// 109
        PERMISSION_SAVE_CONTROL_SET.add(JIHUO_WUXIAO_XIANSUO.getpCode());// 110
        PERMISSION_SAVE_CONTROL_SET.add(JGUANLI_ZIJI_XIANSUO.getpCode());// 111

        PERMISSION_SAVE_CONTROL_SET.add(CHAKAN_SUOYOU_XUEYUAN.getpCode());// 112
        PERMISSION_SAVE_CONTROL_SET.add(SHANCHU_XUEYUAN.getpCode());// 113
        PERMISSION_SAVE_CONTROL_SET.add(DAOCHU_XUEYUAN.getpCode());// 114
        PERMISSION_SAVE_CONTROL_SET.add(GUANLI_ZIJI_XUEYUAN.getpCode());// 115

        PERMISSION_SAVE_CONTROL_SET.add(XINZENG_BANJI.getpCode());// 116
        PERMISSION_SAVE_CONTROL_SET.add(XINZENG_LAOSHI.getpCode());// 117
        PERMISSION_SAVE_CONTROL_SET.add(XINZENG_JIAOSHI.getpCode());// 118
        PERMISSION_SAVE_CONTROL_SET.add(FENPEI_BANZHUREN.getpCode());// 119
        PERMISSION_SAVE_CONTROL_SET.add(QIANDAO.getpCode());// 121
        PERMISSION_SAVE_CONTROL_SET.add(PAIKE_XIANSHI.getpCode());// 120

        PERMISSION_SAVE_CONTROL_SET.add(SHOUKUAN.getpCode());// 122

        PERMISSION_SAVE_CONTROL_SET.add(XINZENG_YINGXIAO.getpCode());// 123
        /* =============================上面是前端控制的code=================================== */
        /* =============================下面是一对多map增加的code=================================== */
        PERMISSION_SAVE_CONTROL_SET.addAll(ONE_MULTY_CODE_MAP.values());
    }


    public static void main(String[] args) {
        System.out.println(PERMISSION_SAVE_CONTROL_SET);
    }
}
