/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.organization.constant;

import com.google.common.collect.Maps;

import java.util.Map;


/**   
 * @title       : CascadeSearchType 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年5月26日 下午4:24:22 
 */
public enum CascadeSearchSource {
	
	CONSULTER_PASSTO(1,"线索转交 - 指定同事"),
	CONSULTER_SEARCH(2,"下属线索 - 根据同事筛选"),
	COMMENT_NOTUFY_COLLEAGUE(3,"跟进记录 - 通知同事");
    
    private int value;
    private String desc;
    private CascadeSearchSource(int value, String desc){
        this.value = value;
        this.desc = desc;
    };
    
    private static Map<Integer, CascadeSearchSource> mapping = Maps.newHashMap();
    
    static{
        for(CascadeSearchSource cut : CascadeSearchSource.values()){
            mapping.put(cut.value, cut);
        }
    }
    
    public static CascadeSearchSource getByValue(Integer value) {
        return mapping.get(value);
    }

    public int getValue(){
        return value;
    }

    public String getDesc(){
        return desc;
    }

}
