package com.baijia.tianxiao.sal.organization.todo.dto;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import com.baijia.tianxiao.dto.BaseDto;

/**
 * @title BacklogDto
 * @desc 待办事项关联学员
 * @author wangsixia
 * @date 2016年02月26日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class RelatedStudent extends BaseDto {

    private static final long serialVersionUID = -2315635170328641457L;
    
    private int type;
    
    private Long studentId;
    
    private String name;

    private String avatar;
    
    public RelatedStudent(){
    }
    
    public RelatedStudent(int type, Long studentId, String name){
    	this.type = type;
    	this.studentId = studentId;
    	this.name = name;
    }
    
    public static RelatedStudent createStudent(Integer type, Long studentId) {
        RelatedStudent student = null;
        if(null != type && (0 == type || 1 == type) && null != studentId && studentId > 0) {
            student = new RelatedStudent();
            student.setType(type);
            student.setStudentId(studentId);
        }
        return student;
    }
}
