package com.baijia.tianxiao.sal.organization.todo.constant;

/**
 * @title RemindType
 * @desc 提醒时间类型
 * @author wangsixia
 * @date 2016年02月26日
 * @version 1.0
 */
public enum TaskStatus {
    UNFINISH(0,"未完成"),FINISH(1,"已完成");
  
    int value;
    String note;
    
    private TaskStatus(int value, String note){
        this.value = value;
        this.note = note;
    }
    
    public int getValue(){
        return this.value;
    }
    
    public String getNote(){
        return this.note;
    }
    
    public static String getNoteByValue(int value) {
        String note = null;
        for(TaskStatus status : values()) {
            if(status.getValue() == value) {
                note = status.getNote();
                break;
            }
        }
        return note;
    }
}

