package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.pcAuthority.constant.ApplicationType;
import com.baijia.tianxiao.dal.pcAuthority.constant.PermissionOperationType;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxAccountPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxRolePermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.ApplicationAuthConfig;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.dal.pcAuthority.po.TxAccountPermission;
import com.baijia.tianxiao.dal.pcAuthority.po.TxRolePermission;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.constant.ClientType;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.DoorgodUserRole;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionAccountType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionHasType;
import com.baijia.tianxiao.sal.organization.dto.AuthToken;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.AuthorityDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.PermissionDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto.AccountPermissionDto;
import com.baijia.tianxiao.sal.organization.org.service.*;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @author Rezar
 * @createDate :Jun 1, 2016 10:27:16 AM
 * @desc :
 */
@Service
@Slf4j
public class TxAccountPermissionServiceImpl implements TxAccountPermissionService, InitializingBean {

    @Autowired
    private TxAccountPermissionDao txAccountPermissionDao;
    @Autowired
    private TXAuthApplicationMenuService txAuthApplicationMenuService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXPermissionService txPermissionService;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private TxRolePermissionDao txRolePermissionDao;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private OrgInfoService orgInfoService;

    private static final Integer TX_ACCOUNT_TYPE_FORMAL = 0; // 正式账号
    private static final Integer TX_ACCOUNT_TYPE_TRAIL = 1; // 试用账号
    public static OrgAccount trailOrgAccount;// 依赖hag稳定性,启动时加载一次

    @Data
    private static class HagDownload {
        private Integer status;
        private List<String> data;
        private Object errorcode;
    }

    private final static List<PermissionDto> expermissinDefaultPermission = new ArrayList<>();

    static {
        expermissinDefaultPermission.add(new PermissionDto("校验输入的支付密码", "10601", 1));
        expermissinDefaultPermission.add(new PermissionDto("提现", "10602", 1));
        expermissinDefaultPermission.add(new PermissionDto("收款页面", "10302", 1));
        expermissinDefaultPermission.add(new PermissionDto("添加机构电话", "4060302", 1));
        expermissinDefaultPermission.add(new PermissionDto("删除机构电话", "4060301", 1));
        expermissinDefaultPermission.add(new PermissionDto("编辑机构电话", "4060303", 1));
        expermissinDefaultPermission.add(new PermissionDto("设置支付密码", "10603", 1));
    }

    @Override
    @Deprecated
    public List<PermissionDto> listAllAuthModules(Integer pType, Integer deviceType, Long uId, Integer uType) {
        List<TxAccountPermission> permissions =
                txAccountPermissionDao.listAllConfigs(pType, deviceType, uId.intValue(), uType);
        if (GenericsUtils.isNullOrEmpty(permissions)) {
            return Collections.emptyList();
        }
        List<Long> pIds = ListUtil.toKeyList(permissions, "pId", TxAccountPermission.class);
        Map<Long, TxAccountPermission> permissionMaps =
                Maps.uniqueIndex(permissions, new Function<TxAccountPermission, Long>() {
                    @Override
                    public Long apply(TxAccountPermission arg0) {
                        return Long.valueOf(arg0.getPId());
                    }
                });
        List<ApplicationAuthConfig> findApplicationMenus = txAuthApplicationMenuService.findApplicationMenus(pIds);
        if (GenericsUtils.isNullOrEmpty(findApplicationMenus)) {
            return Collections.emptyList();
        }
        List<PermissionDto> retPermissions = new ArrayList<>(findApplicationMenus.size());
        for (ApplicationAuthConfig config : findApplicationMenus) {
            TxAccountPermission permission = permissionMaps.get(config.getId());
            Integer type = 0;
            if (permission != null) {
                type = permission.getPType();
            }
            PermissionDto pd = new PermissionDto();
            pd.setName(config.getModuleName());
            pd.setTag(config.getModuleCode());
            pd.setType(type);
            retPermissions.add(pd);
        }
        return retPermissions;
    }

    /**
     * @param : deviceType 0:pc 1:app pc app查询权限接口
     */
    @Override
    public AuthorityDto findAuths(Long orgId, Integer casCadeId, Integer deviceType) {
        if (null != trailOrgAccount && orgId.intValue() == trailOrgAccount.getId()) {
            return this.findAuths(orgId, casCadeId, deviceType, TX_ACCOUNT_TYPE_TRAIL);
        } else {
            return this.findAuths(orgId, casCadeId, deviceType, TX_ACCOUNT_TYPE_FORMAL);
        }
    }

    private List<PermissionDto> toExperiecceAccountPermissions() {
        Collection<TXPermission> txPermissionList = txPermissionService.getAllTXPermissionsCodeMap().values();
        List<PermissionDto> dtoList = Lists.newArrayList();
        for (TXPermission txp : txPermissionList) {
            PermissionDto dto = new PermissionDto();
            dto.setName(txp.getName());
            dto.setTag(txp.getCode().toString());
            dto.setType(TXPermissionHasType.OWN.getCode());
            dtoList.add(dto);
        }
        dtoList.addAll(expermissinDefaultPermission);
        return dtoList;
    }

    private List<PermissionDto> toTxPermissionDto(List<TxAccountPermission> permissions) {
        if (GenericsUtils.isNullOrEmpty(permissions)) {
            return Collections.emptyList();
        }
        List<PermissionDto> retDtos = new ArrayList<>();
        for (TxAccountPermission tap : permissions) {
            PermissionDto dto = new PermissionDto();
            dto.setName(tap.getName());
            dto.setTag(String.valueOf(tap.getPCode()));
            dto.setType(tap.getPType());
            dto.setUrl(tap.getUrl());
            retDtos.add(dto);
        }
        return retDtos;
    }

    private List<TxAccountPermission> pickPermissions(List<TxAccountPermission> Permissions, Set<Long>... controlSet) {
        List<TxAccountPermission> result = Lists.newLinkedList();
        Set<Long> allSet = Sets.newHashSet();
        Arrays.stream(controlSet).forEach(set -> allSet.addAll(set));
        for (TxAccountPermission permission : Permissions) {
            if (allSet.contains(permission.getPCode())) {
                result.add(permission);
            }
        }
        return result;
    }

    @Override
    public List<TxAccountPermission> getAllPByUidLevelRoleDevice(Long orgId, Integer cascadeId, TXAccount txAccount,
                                                                 Integer role, Integer device) {
        List<TxRolePermission> txRolePermissions =
                txRolePermissionDao.getTxRolePermissionsByVipLevelAndRole(txAccount.getVipLevel(), role, device);
        List<TxAccountPermission> defaultPermissions = buildPermissions(txRolePermissions);// 先得到默认权限列表
        // fill code and name
        Map<Integer, TXPermission> allPIdMap = txPermissionService.getAllTXPermissionsIDMap();
        for (TxAccountPermission tap : defaultPermissions) {
            TXPermission permission = allPIdMap.get(tap.getPId());
            tap.setName(permission.getName());
            tap.setPCode(permission.getCode());
        }
        log.debug("the defaultPermissions size:{}", defaultPermissions.size());
        OrgSubAccount orgSubAccount = orgSubAccountDao.getByOrgId(orgId.intValue());
        Integer onlineType = orgSubAccount.getOnlineType();
        if (onlineType == Flag.TRUE.getInt()) {
            defaultPermissions.stream()
                    .filter(txAccountPermission -> TXPermissionConst.WANGXIAO_NO_PERMISSION_SET
                            .contains(txAccountPermission.getPCode()))
                    .forEach(txAccountPermission -> txAccountPermission.setPType(TXPermissionHasType.LOST.getCode()));
        }
        if (null != cascadeId) {
            Map<Integer, Integer> PCMap = Maps.newHashMap();
            Map<Integer, Integer> APPMap = Maps.newHashMap();
            List<TxAccountPermission> txAccountPermissions = // 得到用户当前权限
                    txAccountPermissionDao.listAllConfigs(null, device, cascadeId,
                            TXPermissionAccountType.CASCADE_ACCOUNT.getCode());
            for (TxAccountPermission tap : txAccountPermissions) {
                TXPermission permission = allPIdMap.get(tap.getPId());
                tap.setName(permission.getName());
                tap.setPCode(permission.getCode());
            }
            Integer pid = orgSubAccount.getPid();
            /* 控制获取的权限 */
            if (onlineType == Flag.TRUE.getInt()) {
                txAccountPermissions = pickPermissions(txAccountPermissions, TXPermissionConst.WANGXIAO_PERMISSION_SET);
            } else {
                // 总校主管额外有俩可编辑权限.
                if (pid == 0 && role == RoleType.CHARAGE.type) {
                    txAccountPermissions =
                            pickPermissions(txAccountPermissions, TXPermissionConst.NORMAL_PERMISSION_SET,
                                    TXPermissionConst.MAIN_CAMPUS_MANAGER_ADDITIONAL_PERMISSION_SET,
                                    TXPermissionConst.TIMESCARD_PERMISSION_SET);
                } else {
                    txAccountPermissions = pickPermissions(txAccountPermissions,
                            TXPermissionConst.NORMAL_PERMISSION_SET, TXPermissionConst.TIMESCARD_PERMISSION_SET);
                }
            }
            log.debug("after pick the permission list size:{}", txAccountPermissions.size());
            if (CollectionUtils.isNotEmpty(txAccountPermissions)) {
                for (TxAccountPermission p : txAccountPermissions) {
                    if (p.getDeviceType().equals(DeviceType.PC.getCode())) {
                        PCMap.put(p.getPId(), p.getPType());
                    }
                    if (p.getDeviceType().equals(DeviceType.APP.getCode())) {
                        APPMap.put(p.getPId(), p.getPType());
                    }
                }
            }
            for (TxAccountPermission tap : defaultPermissions) {
                if (tap.getDeviceType().equals(DeviceType.PC.getCode()) && PCMap.containsKey(tap.getPId())) {
                    tap.setPType(PCMap.get(tap.getPId()));
                }
                if (tap.getDeviceType().equals(DeviceType.APP.getCode()) && APPMap.containsKey(tap.getPId())) {
                    tap.setPType(APPMap.get(tap.getPId()));
                }
            }
        }
        // 增值模块
        List<String> accountModuleAuth = null;
        if (txAccount != null && StringUtils.isNotBlank(txAccount.getModuleAuth())) {
            accountModuleAuth = BaseUtils.strToList(txAccount.getModuleAuth(), ",");
        }

        for (TxAccountPermission tap : defaultPermissions) {
            if (tap.getPType().intValue() == TXPermissionHasType.OWN.getCode()) {
                if (tap.getPCode() == TXPermissionConst.ASSIGNMENT_MENU.getPCode()) {
                    log.debug("[TXPermission code]={},[accountModuleAuth]={}", tap.getPCode(), accountModuleAuth);
                    if (CollectionUtils.isNotEmpty(accountModuleAuth)
                            && accountModuleAuth.contains(String.valueOf(ClientType.HW.getCode()))) {
                        tap.setUrl(AuthToken.uniqDoorGodUrl(ClientType.HW,DeviceType.PC));
                    } else {
                        tap.setPType(TXPermissionHasType.LOST.getCode());
                    }
                } else if (tap.getPCode() == TXPermissionConst.EXAM_MENU.getPCode()) {
                    log.debug("[TXPermission code]={},[accountModuleAuth]={}", tap.getPCode(), accountModuleAuth);
                    if (CollectionUtils.isNotEmpty(accountModuleAuth)
                            && accountModuleAuth.contains(String.valueOf(ClientType.EXAM.getCode()))) {
                        tap.setUrl(AuthToken.uniqDoorGodUrl(ClientType.EXAM,DeviceType.PC));
                    } else {
                        tap.setPType(TXPermissionHasType.LOST.getCode());
                    }
                } else if (tap.getPCode() == TXPermissionConst.POINTS_MENU.getPCode()) {
                    log.debug("[TXPermission code]={},[accountModuleAuth]={}", tap.getPCode(), accountModuleAuth);
                    if (CollectionUtils.isNotEmpty(accountModuleAuth)
                            && accountModuleAuth.contains(String.valueOf(ClientType.POINTS.getCode()))) {
                        tap.setUrl(AuthToken.uniqDoorGodUrl(ClientType.POINTS,DeviceType.PC));
                    } else {
                        tap.setPType(TXPermissionHasType.LOST.getCode());
                    }
                } else if (tap.getPCode() == TXPermissionConst.GRADE_MENU.getPCode()) {
                    log.debug("[TXPermission code]={},[accountModuleAuth]={}", tap.getPCode(), accountModuleAuth);
                    if (CollectionUtils.isNotEmpty(accountModuleAuth)
                            && accountModuleAuth.contains(String.valueOf(ClientType.GRADE.getCode()))) {
                        tap.setUrl(AuthToken.uniqDoorGodUrl(ClientType.GRADE,DeviceType.PC));
                    } else {
                        tap.setPType(TXPermissionHasType.LOST.getCode());
                    }
                } else if (tap.getPCode() == TXPermissionConst.LIJIA_KEXIAO.getPCode()) {
                    if (CollectionUtils.isNotEmpty(accountModuleAuth)
                            && accountModuleAuth.contains(String.valueOf(ClientType.LIJIA_KEXIAO.getCode()))) {
                        tap.setUrl("");
                    } else {
                        tap.setPType(TXPermissionHasType.LOST.getCode());
                    }
                } else if (tap.getPCode() == TXPermissionConst.TIMESCARD_MANAGEMENT.getPCode()) {
                    if (onlineType != Flag.TRUE.getInt() && CollectionUtils.isNotEmpty(accountModuleAuth)
                            && accountModuleAuth.contains(String.valueOf(ClientType.TIMESCARD.getCode()))) {
                        tap.setUrl("");
                    } else {
                        tap.setPType(TXPermissionHasType.LOST.getCode());
                    }
                } else if (tap.getPCode() == TXPermissionConst.CUSTOM_COMMENT.getPCode()) {
                    if (onlineType != Flag.TRUE.getInt() && CollectionUtils.isNotEmpty(accountModuleAuth)
                            && accountModuleAuth.contains(String.valueOf(ClientType.CUSTOM_COMMENT.getCode()))) {
                        tap.setUrl("");
                    } else {
                        tap.setPType(TXPermissionHasType.LOST.getCode());
                    }
                } else if (tap.getPCode() == TXPermissionConst.CUSTOM_RECORD_TEMPLATE.getPCode()) {
                    if (onlineType != Flag.TRUE.getInt() && CollectionUtils.isNotEmpty(accountModuleAuth)
                            && accountModuleAuth.contains(String.valueOf(ClientType.CUSTOM_RECORD_TEMPLATE.getCode()))) {
                        tap.setUrl("");
                    } else {
                        tap.setPType(TXPermissionHasType.LOST.getCode());
                    }
                }
            }
        }
        oneMultiControl(defaultPermissions);
        return defaultPermissions;
    }

    private void oneMultiControl(List<TxAccountPermission> defaultPermissions) {
        Set<Long> lostKeyCodes = Sets.newHashSet();
        Set<Long> ownKeyCodes = Sets.newHashSet();
        for (TxAccountPermission tap : defaultPermissions) {
            if (TXPermissionConst.ONE_MULTY_CODE_MAP.containsKey(tap.getPCode())) {
                if (tap.getPType() == TXPermissionHasType.LOST.getCode()) {
                    lostKeyCodes.addAll(TXPermissionConst.ONE_MULTY_CODE_MAP.get(tap.getPCode()));
                } else if (tap.getPType() == TXPermissionHasType.OWN.getCode()) {
                    ownKeyCodes.addAll(TXPermissionConst.ONE_MULTY_CODE_MAP.get(tap.getPCode()));
                }
            }
            if (TXPermissionConst.ONE_MULTY_CODE_LOST_MAP.containsKey(tap.getPCode())) {
                if (tap.getPType() == TXPermissionHasType.LOST.getCode()) {
                    lostKeyCodes.addAll(TXPermissionConst.ONE_MULTY_CODE_LOST_MAP.get(tap.getPCode()));
                }
            }
        }
        log.info("lostKeyCodes is:{}", lostKeyCodes);
        log.info("ownKeyCodes is:{}", ownKeyCodes);
        for (TxAccountPermission tap : defaultPermissions) {
            if (lostKeyCodes.contains(tap.getPCode())) {
                tap.setPType(TXPermissionHasType.LOST.getCode());
            }
            if (ownKeyCodes.contains(tap.getPCode())) {
                tap.setPType(TXPermissionHasType.OWN.getCode());
            }
        }
    }

    /**
     * @param txRolePermissions
     * @return
     */
    private List<TxAccountPermission> buildPermissions(List<TxRolePermission> txRolePermissions) {
        List<TxAccountPermission> result = Lists.newArrayList();
        for (TxRolePermission trp : txRolePermissions) {
            TxAccountPermission tap = new TxAccountPermission();
            // tap.setId(id);
            tap.setPId(trp.getPId());
            // tap.setUId(uId);
            tap.setPType(trp.getPType());
            tap.setUType(0);
            tap.setDeviceType(trp.getDeviceType());
            // tap.setCreateTime(createTime);
            // tap.setUpdateTime(updateTime);
            result.add(tap);
        }
        return result;
    }

    @Override
    public Map<Integer, TxAccountPermission> getPMapByUidLevelRoleDevice(Long orgId, Integer uid, TXAccount txAccount,
                                                                         Integer role, Integer device) {
        if (null != device) {
            Map<Integer, TxAccountPermission> data = Maps.newHashMap();
            List<TxAccountPermission> list = getAllPByUidLevelRoleDevice(orgId, uid, txAccount, role, device);
            for (TxAccountPermission txAccountPermission : list) {
                data.put(txAccountPermission.getPId(), txAccountPermission);
            }
            log.debug("the length of TxAccountPermission pMap is{}", data.size());
            return data;
        } else {// 当device为null时,以拥有的为准
            Map<Integer, TxAccountPermission> data = Maps.newHashMap();
            List<TxAccountPermission> list = getAllPByUidLevelRoleDevice(orgId, uid, txAccount, role, device);
            for (TxAccountPermission txAccountPermission : list) {
                data.put(txAccountPermission.getPId(), txAccountPermission);
            }
            for (TxAccountPermission txAccountPermission : list) {
                if (txAccountPermission.getPType() == TXPermissionHasType.OWN.getCode()) {
                    data.put(txAccountPermission.getPId(), txAccountPermission);
                }
            }
            log.debug("the length of TxAccountPermission pMap is{}", data.size());
            return data;
        }
    }

    @Override
    public void saveAll(List<TxAccountPermission> txAccountPermissions) {
        txAccountPermissionDao.saveAll(txAccountPermissions);
    }

    @Override
    public void updateAll(List<TxAccountPermission> txAccountPermissions) {
        if (CollectionUtils.isNotEmpty(txAccountPermissions)) {
            for (TxAccountPermission txAccountPermission : txAccountPermissions) {
                txAccountPermissionDao.update(txAccountPermission);
            }
        }
    }

    @Override
    @Deprecated // 这个不准的 因为有默认权限的概念 权限不一定都在数据库中 不要用
    public boolean hasPermission(Long cascadeId, ApplicationType deviceType, TXPermissionConst permission) {
        List<Long> codes = new ArrayList<Long>();
        codes.add(permission.getPCode());
        List<TXPermission> permissionList = txPermissionService.getTXPermissionsList(codes);
        if (CollectionUtils.isEmpty(permissionList)) {
            return false;
        }

        TxAccountPermission txAccountPermission = txAccountPermissionDao
                .getTxAccountPermission(permissionList.get(0).getId(), deviceType.type, cascadeId.intValue());
        if (txAccountPermission != null
                && txAccountPermission.getPType().equals(PermissionOperationType.CAN_USE.type)) {
            return true;
        }
        return false;
    }

    /**
     * @param accountTypeOfUser :当前账号是否是体验账号 0:正式 1:体验账号
     * @param deviceType        :0:pc 1:app
     */
    @Override
    public AuthorityDto findAuths(Long orgId, Integer casCadeId, Integer deviceType, Integer accountTypeOfUser) {
        if (accountTypeOfUser == null) {
            accountTypeOfUser = TX_ACCOUNT_TYPE_FORMAL;
        }
        AuthorityDto authorityDto = new AuthorityDto();
        RoleType superRole = null;
        TXAccount superAccount = null;
        List<PermissionDto> permissionDtos = null;
        try {
            if (casCadeId != null && casCadeId != 0L) {// 员工子账号
                TXCascadeAccount tca = this.txCascadeAccountDao.getById(casCadeId);
                OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(tca.getOrgId());
                superAccount = (0 == osa.getPid()) ? txAccountService.getByOrgId(tca.getOrgId())
                        : txAccountService.getByOrgId(osa.getPid());
                superRole = RoleType.getRoleType(tca.getAccountType());
            } else {// 校长 or 分校长
                OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(orgId.intValue());
                superAccount = (0 == osa.getPid()) ? txAccountService.getByOrgId(orgId.intValue())
                        : txAccountService.getByOrgId(osa.getPid());
                superRole = (0 == osa.getPid()) ? RoleType.PRESIDENT : RoleType.BRANCH_SCH_PRESIDENT;
            }
            Preconditions.checkNotNull(superAccount);
        } catch (NullPointerException npe) {
            log.warn("getAuth cannot get the TXAccount by orgId:{},cascadeId:{},error:{}", orgId, casCadeId, npe);
            throw new BussinessException(CommonErrorCode.NEED_RE_LOGIN, "抱歉，无法查询到您的账户信息。");
        }

        log.info("orgId is :{},cascadeId is:{} roleType is : {}, accountTypeOfUser is:{} ", orgId, casCadeId, superRole,
                accountTypeOfUser);

        List<TxAccountPermission> permissions = null;
        if (superRole == RoleType.CHARAGE || superRole == RoleType.EMPLOYEE) {// 是员工子账号
            permissions = getAllPByUidLevelRoleDevice(orgId, casCadeId, superAccount, superRole.type, deviceType);
            log.info("convert to txPermissionDto with : {} ", permissions.size());
            permissionDtos = toTxPermissionDto(permissions);
        } else if (superRole == RoleType.PRESIDENT || superRole == RoleType.BRANCH_SCH_PRESIDENT) {// 是校长账号
            permissions = getAllPByUidLevelRoleDevice(orgId, null, superAccount, superRole.type, deviceType);
            log.info("convert to txPermissionDto with : {} ", permissions.size());
            permissionDtos = toTxPermissionDto(permissions);
        }

        if (accountTypeOfUser == TX_ACCOUNT_TYPE_TRAIL) {
            permissionDtos.addAll(expermissinDefaultPermission);
        }

        authorityDto.setRole(superRole.type.longValue());
        authorityDto.setRoleName(superRole.desc);
        authorityDto.setHasPermissions(permissionDtos);
        if (null != superAccount && superAccount.getVipLevel().equals(TXAccountType.DAZHONG.getCode())) {
            authorityDto.setVipName(TXAccountType.DAZHONG.getLabel());
        }
        return authorityDto;
    }

    @Override
    public List<TxAccountPermission> getAccountPermission(Integer uid, Integer pid) {
        List<TxAccountPermission> txAccountPermissions = txAccountPermissionDao.geTxAccountPermission(pid, uid);
        return txAccountPermissions;
    }

    @Override
    public List<TxAccountPermission> getAccountPermission(Integer uid, List<Integer> pid) {
        List<TxAccountPermission> txAccountPermissions = txAccountPermissionDao.geTxAccountPermission(pid, uid);
        return txAccountPermissions;
    }

    @Override
    public TxAccountPermissionsDto universalGetPermissions(int orgId, Integer cascadeId) {
        TxAccountPermissionsDto result = null;
        List<TxRolePermission> plist = null;
        // 找爹
        OrgSubAccount subAcc = null;
        TXAccount superAcc = null;
        subAcc = orgSubAccountDao.getByOrgIdIgnoreDelStatus(orgId);
        if (0 == subAcc.getPid()) {// 先找到天校账号
            superAcc = txAccountService.getByOrgId(orgId);
            if (superAcc == null) {
                throw new BussinessException(CommonErrorCode.NEED_RE_LOGIN, "主账号不存在或已暂停使用");
            }
        } else {
            superAcc = txAccountService.getByOrgId(subAcc.getPid());
        } // 找爹done
        log.debug("universalGetPermissions param is[ orgId:{},cascadeId:{}],superAcc:{}", orgId, cascadeId, superAcc);

        if (null == cascadeId || 0 == cascadeId) {// 校区账号
            if (0 == subAcc.getPid()) {// 主校区
                plist = txRolePermissionDao.getTxRolePermissionsByVipLevelAndRole(superAcc.getVipLevel(),
                        RoleType.PRESIDENT.type);
                result = rolePermissionsToDto(orgId, cascadeId, plist);
            } else if (0 != subAcc.getPid()) {// 分校区
                plist = txRolePermissionDao.getTxRolePermissionsByVipLevelAndRole(superAcc.getVipLevel(),
                        RoleType.BRANCH_SCH_PRESIDENT.type);
                result = rolePermissionsToDto(orgId, cascadeId, plist);
            }
        } else {// 员工子账号
            TXCascadeAccount txCasAcc = txCascadeAccountDao.getById(cascadeId);
            List<TxAccountPermission> txAccountPermissions =
                    getAllPByUidLevelRoleDevice(new Long(orgId), cascadeId, superAcc, txCasAcc.getAccountType(), null);
            result = buildDto2(orgId, cascadeId, txAccountPermissions);
        }
        return result;
    }

    private TxAccountPermissionsDto buildDto2(int orgId, Integer cascadeId,
                                              List<TxAccountPermission> txAccountPermissions) {
        TxAccountPermissionsDto result = new TxAccountPermissionsDto();
        result.setOrgID(orgId);
        result.setCascadeId(cascadeId);
        List<TxAccountPermissionsDto.AccountPermissionDto> PCps = Lists.newArrayList();
        List<TxAccountPermissionsDto.AccountPermissionDto> APPps = Lists.newArrayList();
        for (TxAccountPermission rp : txAccountPermissions) {// 根据TxAccountPermission的设备放入不同的list中
            if (rp.getDeviceType().equals(DeviceType.PC.getCode())) {
                PCps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), rp.getPCode(), rp.getName(),
                        rp.getPType(), rp.getDeviceType()));
            } else if (rp.getDeviceType().equals(DeviceType.APP.getCode())) {
                APPps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), rp.getPCode(), rp.getName(),
                        rp.getPType(), rp.getDeviceType()));
            }
        }
        result.setPCps(PCps);
        result.setAPPps(APPps);
        return result;
    }

    private TxAccountPermissionsDto rolePermissionsToDto(int orgId, Integer cascadeId, List<TxRolePermission> plist) {
        log.debug("rolePermissionsToDto the input rolePermissions list size is{}", plist.size());
        Map<Integer, TXPermission> pIdMap = txPermissionService.getAllTXPermissionsIDMap();

        TxAccountPermissionsDto result = new TxAccountPermissionsDto();
        result.setOrgID(orgId);
        result.setCascadeId(cascadeId);
        List<TxAccountPermissionsDto.AccountPermissionDto> PCps = Lists.newArrayList();
        List<TxAccountPermissionsDto.AccountPermissionDto> APPps = Lists.newArrayList();
        for (TxRolePermission rp : plist) {// 根据TxAccountPermission的设备放入不同的list中
            if (rp.getDeviceType().equals(DeviceType.PC.getCode())) {
                PCps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), rp.getPCode(),
                        pIdMap.get(rp.getPId()).getName(), rp.getPType(), rp.getDeviceType()));
            } else if (rp.getDeviceType().equals(DeviceType.APP.getCode())) {
                APPps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), rp.getPCode(),
                        pIdMap.get(rp.getPId()).getName(), rp.getPType(), rp.getDeviceType()));
            }
        }
        result.setPCps(PCps);
        result.setAPPps(APPps);
        return result;
    }

    @Override
    public TxAccountPermissionsDto universalGetPermissions(int orgId, Integer cascadeId, Collection<Long> pCodes) {
        TxAccountPermissionsDto result = null;
        if (CollectionUtils.isEmpty(pCodes)) {
            result = new TxAccountPermissionsDto();
            result.setOrgID(orgId);
            result.setCascadeId(cascadeId);
            result.setAPPps(new ArrayList<AccountPermissionDto>());
            result.setPCps(new ArrayList<AccountPermissionDto>());
            return result;
        }
        List<TxRolePermission> plist = null;
        OrgSubAccount subAcc = null;
        TXAccount superAcc = null;
        subAcc = orgSubAccountDao.getByOrgIdIgnoreDelStatus(orgId);
        try {
            if (0 == subAcc.getPid()) {// 先找到天校账号
                superAcc = txAccountService.getByOrgId(orgId);
            } else {
                superAcc = txAccountService.getByOrgId(subAcc.getPid());
            }
            if (null == superAcc) {
                return result;
            }
        } catch (NullPointerException npe) {
            log.warn("get permission npe! maybe status forbidden. e:{}", npe);
            return result;
        }

        if (null == cascadeId || 0 == cascadeId) {// 校区账号
            if (0 == subAcc.getPid()) {// 主校区
                plist = txRolePermissionDao.getTxRolePermissionsByCodes(superAcc.getVipLevel(), RoleType.PRESIDENT.type,
                        pCodes);
                result = rolePermissionsToDto(orgId, cascadeId, plist);
            }
            if (0 != subAcc.getPid()) {// 分校区
                plist = txRolePermissionDao.getTxRolePermissionsByCodes(superAcc.getVipLevel(),
                        RoleType.BRANCH_SCH_PRESIDENT.type, pCodes);
                result = rolePermissionsToDto(orgId, cascadeId, plist);
            }
        } else {// 员工子账号
            TXCascadeAccount txCasAcc = txCascadeAccountDao.getById(cascadeId);
            List<TxAccountPermission> txAccountPermissions =
                    getAllPByUidLevelRoleDevice(new Long(orgId), cascadeId, superAcc, txCasAcc.getAccountType(), null);
            result = buildDtoByFilter(orgId, cascadeId, txAccountPermissions, pCodes);
        }
        return result;
    }

    private TxAccountPermissionsDto buildDtoByFilter(int orgId, Integer cascadeId,
                                                     List<TxAccountPermission> txAccountPermissions, Collection<Long> pCodes) {
        Map<Integer, TXPermission> pMap = txPermissionService.getAllTXPermissionsIDMap();
        TxAccountPermissionsDto result = new TxAccountPermissionsDto();
        result.setOrgID(orgId);
        result.setCascadeId(cascadeId);
        List<TxAccountPermissionsDto.AccountPermissionDto> PCps = Lists.newArrayList();
        List<TxAccountPermissionsDto.AccountPermissionDto> APPps = Lists.newArrayList();
        Set<Long> pCodeSet = Sets.newHashSet(pCodes);// 过滤
        for (TxAccountPermission rp : txAccountPermissions) {// 根据TxAccountPermission的设备放入不同的list中
            TXPermission permission = pMap.get(rp.getPId());
            if (!pCodeSet.contains(permission.getCode())) {// 进行过滤
                continue;
            }
            if (rp.getDeviceType().equals(DeviceType.PC.getCode())) {
                PCps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), permission.getCode(),
                        permission.getName(), rp.getPType(), rp.getDeviceType()));
            } else if (rp.getDeviceType().equals(DeviceType.APP.getCode())) {
                APPps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), permission.getCode(),
                        permission.getName(), rp.getPType(), rp.getDeviceType()));
            }
        }
        result.setAPPps(APPps);
        result.setPCps(PCps);
        return result;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        String numberStr = null;
        String url = null;
        try {
            Map<String, String> params = Maps.newHashMap();
            params.put("resource", "tianxiao_trial_account");
            try {
                url = PropertiesReader.getValue("hag", "hag.http.url.downloadList");
            } catch (MissingResourceException mre) {
                log.warn("this project donot contains hag.properties file! the trial orgAccount won't be initialized!");
                return;
            }
            String response = HttpClientUtils.doPost(url, params);
            log.info("hagResponse:{}", response);
            HagDownload hagDto = JacksonUtil.str2Obj(response, HagDownload.class);
            log.info("hagDto:{}", hagDto);
            if (hagDto == null || CollectionUtils.isEmpty(hagDto.getData())) {
                return;
            }
            numberStr = hagDto.getData().get(0).split("#")[0];
            Integer number = Integer.parseInt(numberStr);
            trailOrgAccount = orgAccountDao.getAccountByNumber(number);
            log.info("the orgAccount which is get from hag is:{}", trailOrgAccount);
        } catch (Exception e) {
            log.error("get orgAccount by hag error!", e);
            trailOrgAccount = orgAccountDao.getAccountByNumber(458130179);// 小流量异常的话,避免getAuth接口无法使用//临时做法
        }
    }

    @Override
    public boolean checkPermission(Long orgId, Integer cascadeId, DeviceType deviceType, Long pCode) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "机构id错误");
        Preconditions.checkArgument(deviceType != null && pCode != null, "参数错误");
        boolean hasPermission = false;
        TxAccountPermissionsDto permissions =
                this.universalGetPermissions(orgId.intValue(), cascadeId, Sets.newHashSet(pCode));
        if (permissions != null) {
            AccountPermissionDto permissionDto = null;
            if (deviceType.getCode() == DeviceType.APP.getCode()
                    && CollectionUtils.isNotEmpty(permissions.getAPPps())) {
                permissionDto = permissions.getAPPps().get(0);
            } else if (deviceType.getCode() == DeviceType.PC.getCode()
                    && CollectionUtils.isNotEmpty(permissions.getPCps())) {
                permissionDto = permissions.getPCps().get(0);
            }
            if (permissionDto.getPCode().longValue() == pCode.longValue() && permissionDto.getPType().intValue() == 0) {
                hasPermission = true;
            }
        }
        return hasPermission;
    }

    @Override
    public String getUniqDoorgodUrl(Long orgId, Integer cascadeId, Integer clientType, Integer deviceType) {
        Map<Long, String> cascadeMap = txCascadeCredentialService.getByTxCasCadeIds(orgId);
        Long cacadeIdLong = (cascadeId == null) ? 0 : cascadeId.longValue();

        OrgInfo orgInfo = orgInfoService.getOrgInfoByOrgId(orgId.intValue());
        String orgShortName = orgInfo == null ? "" : orgInfo.getShortName();

        if (DeviceType.APP.getCode() == deviceType.intValue()) {
            return AuthToken.assignMentStudentToken(orgId, orgShortName, cacadeIdLong, cascadeMap.get(cacadeIdLong),
                    DoorgodUserRole.STAFF.getRole(), ClientType.getByCode(clientType));
        } else {
            return AuthToken.assignMentToken(orgId, orgShortName, cacadeIdLong, cascadeMap.get(cacadeIdLong),
                    DoorgodUserRole.STAFF.getRole(), ClientType.getByCode(clientType));
        }
    }
}
