package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sal.organization.constant.ClientType;
import com.baijia.tianxiao.sal.organization.org.dto.auth.PcAccountCanSettingPermission;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.pcAuthority.dao.TXPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.sal.organization.org.service.TXPermissionService;
import com.google.common.collect.Maps;

import static com.baijia.tianxiao.sal.organization.constant.auth.TianYanPermissionCode.CUSTOM_MODULE_CODE;
import static com.baijia.tianxiao.sal.organization.constant.auth.TianYanPermissionCode.PC_SETTING_CODE;

/**
 * @author caoliang
 * @version 1.0
 * @title TXPermissionServiceImpl
 * @desc O(∩_∩)O~
 * @date 2016年6月2日
 */

@Service
@Slf4j
public class TXPermissionServiceImpl implements TXPermissionService {

    @Autowired
    private TXPermissionDao txPermissionDao;

    @Autowired
    private TXAccountService txAccountService;

    @Override
    public Map<Long, TXPermission> getTXPermissionsMap(List<Long> codes) {
        Map<Long, TXPermission> data = Maps.newHashMap();
        List<TXPermission> txPermissions = txPermissionDao.geTxPermissions(codes);
        if (CollectionUtils.isNotEmpty(txPermissions)) {
            for (TXPermission txPermission : txPermissions) {
                data.put(txPermission.getCode(), txPermission);
            }
        }
        return data;
    }

    @Override
    public List<TXPermission> getTXPermissionsList(List<Long> codes) {
        List<TXPermission> txPermissions = txPermissionDao.geTxPermissions(codes);
        return txPermissions;

    }

    @Override
    public void saveAll(List<TXPermission> txPermissions) {
        txPermissionDao.saveAll(txPermissions);
    }

    @Override
    public List<TXPermission> getAllByPid(List<Integer> ids) {
        List<TXPermission> list = txPermissionDao.getByIds(ids);
        return list;

    }

    @Override
    public TXPermission getTXPermission(Long code) {
        TXPermission txPermission = txPermissionDao.getTXPermission(code);
        return txPermission;
    }

    @Override
    public Map<Integer, TXPermission> getAllTXPermissionsIDMap() {
        Map<Integer, TXPermission> data = Maps.newHashMap();
        List<TXPermission> txPermissions = txPermissionDao.getAll();
        if (CollectionUtils.isNotEmpty(txPermissions)) {
            for (TXPermission txPermission : txPermissions) {
                data.put(txPermission.getId(), txPermission);
            }
        }
        return data;
    }

    @Override
    public Map<Long, TXPermission> getAllTXPermissionsCodeMap() {
        Map<Long, TXPermission> data = Maps.newHashMap();
        List<TXPermission> txPermissions = txPermissionDao.getAll();
        if (CollectionUtils.isNotEmpty(txPermissions)) {
            for (TXPermission txPermission : txPermissions) {
                data.put(txPermission.getCode(), txPermission);
            }
        }
        return data;
    }

    @Override
    public List<PcAccountCanSettingPermission> listPcAccountAllAuth(Integer orgId) {
        List<TXPermission> pcSettingPermission = txPermissionDao.getByParentCode(PC_SETTING_CODE.getCode());
        if (CollectionUtils.isEmpty(pcSettingPermission)) {
            return Collections.EMPTY_LIST;
        }

        Map<Long, TXPermission> txPermissionMap = BaseUtils.listToMap(pcSettingPermission, "code");
        List<TXPermission> subSettingPermission = txPermissionDao.getByParentCodes(txPermissionMap.keySet());
        Map<Long, List<TXPermission>> subPermissionMap = CollectorUtil.group(subSettingPermission, new Function<TXPermission, Long>() {
            @Override
            public Long apply(TXPermission txPermission) {
                return txPermission.getParentId();
            }
        });
        log.debug("Subpermission map = {}", subPermissionMap);

        List<PcAccountCanSettingPermission> data = Lists.newArrayList();
        for (TXPermission txPermission : pcSettingPermission) {
            List<TXPermission> oneSubTxPermissions = subPermissionMap.get(txPermission.getCode().longValue());
            PcAccountCanSettingPermission dto = PcAccountCanSettingPermission.buildByTxPermission(txPermission);
            dto.setSubPermission(PcAccountCanSettingPermission.buildByTxPermissions(oneSubTxPermissions));
            data.add(dto);
        }

        /**
         * 处理定制专享
         */
        TXAccount txAccount = txAccountService.getByOrgId(orgId);
        if (txAccount != null && !StringUtils.isEmpty(txAccount.getModuleAuth())) {
            TXPermission customParent = txPermissionDao.getTXPermission(CUSTOM_MODULE_CODE.getCode());
            PcAccountCanSettingPermission customDto = PcAccountCanSettingPermission.buildByTxPermission(customParent);
            List<TXPermission> customSubNode = Lists.newArrayList();

            List<TXPermission> customModulePermission = txPermissionDao.getByParentCode(CUSTOM_MODULE_CODE.getCode());
            Map<Long, TXPermission> customModuleMap = BaseUtils.listToMap(customModulePermission, "code");
            log.debug("Custom module map = {}", customModuleMap);
            List<String> modules = BaseUtils.strToList(txAccount.getModuleAuth(), ",");
            log.debug("txAccount module = {}", modules);

            for (String moduleStr : modules) {
                ClientType clientType = ClientType.getByCode(Integer.parseInt(moduleStr));
                if (clientType != null) {
                    TXPermission txPermission = customModuleMap.get(clientType.getPermissionCode().longValue());
                    if (txPermission != null) {
                        customSubNode.add(txPermission);
                    }
                }
            }
            customDto.setSubPermission(PcAccountCanSettingPermission.buildByTxPermissions(customSubNode));
            data.add(customDto);
        }
        return data;
    }

}
