package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.addressbook.dao.TXAddressBookDao;
import com.baijia.tianxiao.dal.addressbook.po.TXAddressBook;
import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.sal.organization.org.dto.addressbook.TXAddressBookDto;
import com.baijia.tianxiao.sal.organization.org.service.TXAddressBookService;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;
import com.baijia.tianxiao.util.mobile.EmojiUtils;
import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
@Slf4j

public class TXAddressBookServiceImpl implements TXAddressBookService {
    @Autowired
    private TXAddressBookDao txAddressBookDao;
    @Autowired
    private OrgBranchsDao orgBranchsDao;

    @Override
    @Transactional(readOnly = true)
    public List<TXAddressBookDto> getOrgAddressBook(long orgId) {
        List<TXAddressBook> addressBookList = txAddressBookDao.getAddressByOrgId(orgId);
        List<TXAddressBookDto> addressBookDtoList = new ArrayList<>();
        for (TXAddressBook txAddressBook : addressBookList) {
            TXAddressBookDto txAddressBookDto = new TXAddressBookDto();
            txAddressBookDto.setUnit(txAddressBook.getUnit());
            txAddressBookDto.setProvince(txAddressBook.getProvince());
            txAddressBookDto.setName(txAddressBook.getName());
            txAddressBookDto.setLongitude(txAddressBook.getLongitude());
            txAddressBookDto.setLatitude(txAddressBook.getLatitude());
            txAddressBookDto.setDistrict(txAddressBook.getDistrict());
            txAddressBookDto.setDescription(txAddressBook.getDescription());
            txAddressBookDto.setId(txAddressBook.getId());
            txAddressBookDto.setCity(txAddressBook.getCity());
            addressBookDtoList.add(txAddressBookDto);
        }
        return addressBookDtoList;
    }

    @Override
    @Transactional(readOnly = true)
    public TXAddressBookDto getAddress(long id) {
        BussinessPreconditions.checkArgument(id>0, "地址id无效");
        TXAddressBookDto txAddressBookDto = new TXAddressBookDto();
        TXAddressBook txAddressBook = txAddressBookDao.getById(id);
        BussinessPreconditions.checkArgument(txAddressBook != null, "地址不存在");
        if (txAddressBook != null) {
            txAddressBookDto.setCity(txAddressBook.getCity());
            txAddressBookDto.setDescription(txAddressBook.getDescription());
            txAddressBookDto.setDistrict(txAddressBook.getDistrict());
            txAddressBookDto.setLatitude(txAddressBook.getLatitude());
            txAddressBookDto.setLongitude(txAddressBook.getLongitude());
            txAddressBookDto.setName(txAddressBook.getName());
            txAddressBookDto.setProvince(txAddressBook.getProvince());
            txAddressBookDto.setUnit(txAddressBook.getUnit());
            txAddressBookDto.setId(id);
        }
        log.debug("txAddressBookDto={ }", txAddressBookDto);
        return txAddressBookDto;

    }

    @Override
    @Transactional
    public void updateAddressBook(TXAddressBookDto txAddressBookDto) {
        BussinessPreconditions.checkArgument(txAddressBookDto.getId() != null, "无效的地址id");
        BussinessPreconditions.checkArgument(EmojiUtils.containsEmoji(txAddressBookDto.getUnit())==false,"不能含有Emoji字符");
        TXAddressBook txAddressBook = txAddressBookDao.getById(txAddressBookDto.getId());
        log.debug("update txAddressBookDto={ },", txAddressBookDto);
        BussinessPreconditions.checkArgument(txAddressBook != null, "地址不存在");
        if (txAddressBook != null) {

            txAddressBook.setDistrict(txAddressBookDto.getDistrict());
            txAddressBook.setCity(txAddressBookDto.getCity());
            txAddressBook.setProvince(txAddressBookDto.getProvince());
            txAddressBook.setLatitude(txAddressBookDto.getLatitude());
            txAddressBook.setLongitude(txAddressBookDto.getLongitude());
            txAddressBook.setDescription(txAddressBookDto.getDescription());
            txAddressBook.setUnit(txAddressBookDto.getUnit());
            txAddressBook.setName(txAddressBookDto.getName());
            txAddressBook.setUpdateTime(new Date());
            log.debug("update txAddressBook={ },", txAddressBook);
            txAddressBookDao.update(txAddressBook);
        }
    }

    @Override
    @Transactional
    public long newAddress(long orgId, TXAddressBookDto txAddressBookDto) {
        int num=txAddressBookDao.getAddressNum(orgId);
        BussinessPreconditions.checkArgument(num>=0&&num<100,"最多只能存储100个地址，请先删除一些地址后再试");
        TXAddressBook txAddressBook = new TXAddressBook();
        log.debug("update txAddressBookDto={ },", txAddressBookDto);
        BussinessPreconditions.checkArgument(EmojiUtils.containsEmoji(txAddressBookDto.getUnit())==false,"不能含有Emoji字符");
        txAddressBook.setDistrict(txAddressBookDto.getDistrict());
        txAddressBook.setCity(txAddressBookDto.getCity());
        txAddressBook.setProvince(txAddressBookDto.getProvince());
        txAddressBook.setLatitude(txAddressBookDto.getLatitude());
        txAddressBook.setLongitude(txAddressBookDto.getLongitude());
        txAddressBook.setDescription(txAddressBookDto.getDescription());
        txAddressBook.setUnit(txAddressBookDto.getUnit());
        txAddressBook.setName(txAddressBookDto.getName());
        txAddressBook.setOrgId(orgId);
        txAddressBook.setUpdateTime(new Date());
        txAddressBook.setCreateTime(new Date());
        log.debug("new txAddressBook={ },", txAddressBook);
        txAddressBookDao.save(txAddressBook);
        long id = txAddressBook.getId();
        return id;

    }



    @Override
    public void deleteAddress(long id) {

        txAddressBookDao.delById(id);
    }

    @Override
    public void changLastUse(long addressId, long orgId) {
        TXAddressBook txAddressBookuse= txAddressBookDao.getLastUseAddress(orgId);
        if(txAddressBookuse!=null) {
            txAddressBookuse.setLastUse(0);
            txAddressBookDao.update(txAddressBookuse);
        }
        TXAddressBook txAddressBook=txAddressBookDao.getById(addressId);
        txAddressBook.setLastUse(1);
        txAddressBookDao.update(txAddressBook);

    }


}
