
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.organization.org.service.impl;

 import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
 import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
 import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
 import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
 import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

 import org.springframework.beans.factory.annotation.Autowired;
 import org.springframework.stereotype.Service;

 import java.util.Collection;
 import java.util.List;

/**
 * @title TXCampusAccountServiceImpl
 * @desc TODO 
 * @author caoliang
 * @date 2016年5月10日
 * @version 1.0
 */
@Service
public class OrgSubAccountServiceImpl implements OrgSubAccountService {

    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    
    @Override
    public OrgSubAccount getMaster(Integer orgId) {
        OrgSubAccount account = orgSubAccountDao.getMasterByOrgId(orgId);
        return account;
    }

    @Override
    public List<OrgSubAccount> getSlaves(Integer orgId, PageDto pageDto) {
        List<OrgSubAccount> accounts = orgSubAccountDao.getSlavesByMasterOrgId(orgId, pageDto);
        return accounts;
    }
    
    @Override
    public List<OrgSubAccount> getMasterAndSlaves(Integer orgId, PageDto pageDto, String... props) {
        List<OrgSubAccount> accounts = orgSubAccountDao.getMasterAndSlaves(orgId, pageDto, props);
        return accounts;
    }

    public List<OrgSubAccount> getMasterAndSlaves(Integer orgId, String searchKey,PageDto pageDto) {
        List<OrgSubAccount> accounts = orgSubAccountDao.getMasterAndSlaves(orgId, pageDto);
        return accounts;
    }

    @Override
    public Integer getSlaveCount(Integer orgId) {
        Integer count = orgSubAccountDao.getSlavesCountByMasterOrgId(orgId);
        return count;
    }

    @Override
    public void addOrgSubAccount(OrgSubAccount orgSubAccount) {
        this.orgSubAccountDao.save(orgSubAccount);
    }

    @Override
    public OrgSubAccount getByOrgId(Integer orgId, String... props) {
        OrgSubAccount subAccount = orgSubAccountDao.getByOrgId(orgId, props);
        return subAccount;
    }
    
    @Override
    public List<OrgSubAccount> getByOrgIds(Collection<Integer> orgIds, String...props) {
        List<OrgSubAccount> subAccounts =
            orgSubAccountDao.getByOrgIds(orgIds, OrgSubAccountStatus.NORMAL.getCode(), props);
        return subAccounts;
    }
    
    @Override
    public OrgSubAccount getByOrgIdIgnoreDelStatus(Integer orgId) {
        OrgSubAccount subAccount = orgSubAccountDao.getByOrgIdIgnoreDelStatus(orgId);
        return subAccount;
    }

    @Override
    public void update(OrgSubAccount orgSubAccount) {
        orgSubAccountDao.update(orgSubAccount);
    }

    @Override
    public OrgSubAccount getSlaveIgnoreStatus(Integer orgId, Integer masterId) {
        OrgSubAccount subAccount = orgSubAccountDao.getSlaveIgnoreStatus(orgId, masterId);
        return subAccount;
    }

    @Override
    public List<OrgSubAccount> getSlavesIgnoreStatus(Integer orgId, PageDto pageDto) {
        List<OrgSubAccount> accounts = orgSubAccountDao.getSlavesIgnoreStatus(orgId, pageDto);
        return accounts;
            
    }
    
    @Override
    public OrgSubAccount getByOrgIdIgnoreIsdel(Integer orgId) {
        OrgSubAccount subAccount = orgSubAccountDao.getByOrgIdIgnoreIsdel(orgId);
        return subAccount;
    }
}

    