package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.addressbook.dao.TXAddressBookDao;
import com.baijia.tianxiao.dal.addressbook.po.TXAddressBook;
import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.dal.org.po.OrgBranchs;
import com.baijia.tianxiao.sal.organization.index.dto.OrgBranchsDto;
import com.baijia.tianxiao.sal.organization.org.dto.addressbook.TXAddressBookDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgBranchsService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;
import com.baijia.tianxiao.util.json.JacksonUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/3/2
 * Time: 下午3:18
 * To change this template use File | Settings | File Templates.
 */
@Slf4j
@Service
public class OrgBranchsServicesImpl implements OrgBranchsService {

    @Autowired
    private OrgBranchsDao orgBranchsDao;
    @Autowired
    private TXAddressBookDao txAddressBookDao;
    @Override
    public OrgBranchs getDefaultOrgBranchs(int orgId) {

        List<OrgBranchs> branchsList = orgBranchsDao.listBranchsByOrgId(orgId);
        if (branchsList != null && branchsList.size() > 0) {
            return branchsList.get(0);
        }
        return new OrgBranchs();
    }

    @Override
    public OrgBranchsDto getDefOrgBranchsDto(int orgId) {
        OrgBranchsDto dto = new OrgBranchsDto();
        List<OrgBranchs> branchsList = orgBranchsDao.listBranchsByOrgId(orgId);
        if (branchsList != null && branchsList.size() > 0) {
            OrgBranchs orgBranchs = branchsList.get(0);
            dto.setProvince(orgBranchs.getProvince());
            dto.setCounty(orgBranchs.getCounty());
            dto.setDistrict(orgBranchs.getDistrict());
            dto.setAddress(orgBranchs.getAddress());
            dto.setLongitude(orgBranchs.getLongitude());
            dto.setLatitude(orgBranchs.getLatitude());

        }
        return dto;
    }

    @Override
    public void saveOrUpdate(int orgId, String province, String county, String district, String address, String longitude, String latitude) {
        OrgBranchs orgBranchs = this.getDefaultOrgBranchs(orgId);
        Date now = new Date();
        if (orgBranchs == null) {
            orgBranchs = new OrgBranchs();
            orgBranchs.setCreateTime(now);
        }
        if (StringUtils.isEmpty(orgBranchs.getBranchName())) {
            orgBranchs.setBranchName("主校区");
        }
        orgBranchs.setOrgId(orgId);
        orgBranchs.setProvince(province);
        orgBranchs.setCounty(county);
        orgBranchs.setDistrict(district);
        orgBranchs.setAddress(address);
        orgBranchs.setLongitude(longitude);
        orgBranchs.setLatitude(latitude);
        orgBranchs.setUpdateTime(now);

        log.debug("save or update orgBranch==={}", orgBranchs);
        orgBranchsDao.saveOrUpdate(orgBranchs);
    }

    @Override
    public void saveAddressDetail(int orgId, String addressDetail) {
        OrgBranchs orgBranchs=getDefaultOrgBranchs(orgId);
        if(GenericsUtils.isNullOrEmpty(orgBranchs.getId())){
            OrgBranchs orgBranchsNew=new OrgBranchs();
            orgBranchsNew.setAddressDetail(addressDetail);
            orgBranchsNew.setOrgId(orgId);
            orgBranchsNew.setCreateTime(new Date());
            orgBranchsNew.setUpdateTime(new Date());
            orgBranchsDao.save(orgBranchsNew);
        }else {
            orgBranchs.setAddressDetail(addressDetail);
            orgBranchs.setUpdateTime(new Date());
            orgBranchsDao.update(orgBranchs);
        }

    }


}
