
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.blackboard.dao.OrgBlackboardDao;
import com.baijia.tianxiao.dal.blackboard.po.Blackboard;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.enums.BlackBoardType;
import com.baijia.tianxiao.sal.organization.org.dto.OrgBlackboardResponseDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgBlackboardService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Lists;


/**
 * @title OrgBlackboardServiceImpl
 * @desc TODO 
 * @author zhangbing
 * @date 2015年12月26日
 * @version 1.0
 */
@Service
public class OrgBlackboardServiceImpl implements OrgBlackboardService {

    @Autowired
    private OrgBlackboardDao orgBlackboardDao;
    
    @Autowired
    private OrgStorageDao orgStorageDao;
    
    /**
     * 获取黑板报列表
     */
    @Override
    public List<OrgBlackboardResponseDto> getOrgBlackboardList(Long orgId, PageDto pageDto) {
        List<Blackboard> blackboards = orgBlackboardDao.getOrgBlackboardList(orgId, pageDto);
        
        List<OrgBlackboardResponseDto> data = Lists.newArrayList();
        if (blackboards != null && !blackboards.isEmpty()) {
            String host = PropertiesReader.getValue("wxm", "gsx-m.server");
            String imgServer = PropertiesReader.getValue("wxm", "img.server");
            for (Blackboard blackboard : blackboards) {
                OrgBlackboardResponseDto dto = this.copyFrom(blackboard, host, imgServer);
                if (dto != null) {
                    data.add(dto);
                }
            }
        }
        return data;
    }
    
    private OrgBlackboardResponseDto copyFrom(Blackboard blackboard, String host, String imgServer) {
        OrgBlackboardResponseDto dto = new OrgBlackboardResponseDto();
        Long id = blackboard.getId();
        
        dto.setActivityId(id);
        dto.setName(blackboard.getTitle());
        int type = blackboard.getBbType();
        dto.setTypeId(type);
        dto.setType(BlackBoardType.values()[type].getLabel());
        if (BlackBoardType.NOTICE.getType() == type) {
            dto.setLink(BizConf.ORG_ACTIVITY_BLACKBOARD_LINK.replace("{host1}", host).replace("{id}", id.toString()));
        } else {
            dto.setLink(BizConf.ORG_BLACKBOARD_LINK.replace("{host1}", host).replace("{id}", id.toString()));
        }
        
        int storageId = blackboard.getStorageId();
        OrgStorage storage = orgStorageDao.getById(storageId);
        if (storage != null) {
            dto.setUrl(constructUrl(storage, imgServer));
        }
        return dto;
    }
    
    /**
     * 构造机构系统图片url
     *
     * @param storage
     * @return
     */
    public static String constructUrl(OrgStorage storage, String imgServer) {
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = ((MIMEType.values())[storage.getMimeType() - 1]).getExtension();
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    @Override
    public OrgBlackboardResponseDto getOrgBlackboardDetail(Long orgId, Long id) {
        Blackboard blackboard = this.orgBlackboardDao.getById(id);
        OrgBlackboardResponseDto dto = null;
        if (blackboard != null) {
            String host = PropertiesReader.getValue("wxm", "gsx-m.server");
            String imgServer = PropertiesReader.getValue("wxm", "img.server");
            dto = this.copyFrom(blackboard, host, imgServer);
        }
        return dto;
    }
}

    