
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.organization.impl;

import com.baijia.commons.lang.utils.SystemClock;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author zhangbing
 * @version 1.0
 * @title OrgAccountServiceImpl
 * @desc TODO
 * @date 2015年12月2日
 */
@Service("orgAccountService")
@Slf4j
public class OrgAccountServiceImpl implements OrgAccountService {

    @Autowired
    private OrgAccountDao orgAccountDao;

    @Autowired
    private OrgSubAccountDao orgSubAccountDao;

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.sal.organization.api.OrgAccountService#getOrgAccountByNumber(java.lang.Integer)
     */

    @Override
    public OrgAccount getOrgAccountByNumber(Integer number, String... props) {

        OrgAccount account = this.orgAccountDao.getAccountByNumber(number, props);

        log.debug("org number = {},orgaccount = {}", number, account);
        return account;
    }

    @Override
    public OrgAccount getOrgAccountById(Integer orgId) {

        OrgAccount account = this.orgAccountDao.getAccountById(orgId);
        return account;
    }

    @Override
    public OrgAccount getOrgAccountByMobile(String mobile) {
        OrgAccount account = this.orgAccountDao.getAccountByMobile(mobile);
        return account;

    }

    @Override
    public Map<Integer, OrgAccount> getOrgAccountMap(List<Integer> orgIds) {
        Map<Integer, OrgAccount> orgAccountMap = Maps.newHashMap();
        List<OrgAccount> orgAccounts = orgAccountDao.getByIds(orgIds);
        if (CollectionUtils.isNotEmpty(orgAccounts)) {
            for (OrgAccount orgAccount : orgAccounts) {
                orgAccountMap.put(orgAccount.getId(), orgAccount);
            }
        }
        return orgAccountMap;

    }

    @Override
    @Transactional
    public OrgAccount modifyPassword(Integer id, String password) {
        OrgAccount account = orgAccountDao.getById(id);
        account.setPassword(password);
        account.setUpdateTime(new Date(SystemClock.currentTimeStamp()));
        orgAccountDao.saveOrUpdate(account);

        //kick out online user
        orgSubAccountDao.incrVersionByOrgId(account.getId());

        return account;
    }
}

    