package com.baijia.tianxiao.sal.organization.finance.service.impl;

import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpTo;
import com.baijia.tianxiao.sal.organization.finance.constant.FinancePayTypeCode;
import com.baijia.tianxiao.sal.organization.finance.dto.request.TxFinanceRecordRequest;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxFinanceRecordDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxTypeRecordDto;
import com.baijia.tianxiao.sal.organization.finance.service.TxFinanceRecordService;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/7/8
 * Time: 上午10:59
 * To change this template use File | Settings | File Templates.
 */
@Service
@Slf4j
public class TxFinanceRecordServiceImpl implements TxFinanceRecordService {

    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;

    @Override
    public List<TxFinanceRecordDto> financeByDay(Long orgId, TxFinanceRecordRequest recordRequest) {
        Date startDate = null;
        Date endDate = null;

        if (recordRequest.getDate() != null) {
            startDate = endDate = DateUtil.getDateByDay(recordRequest.getYear(), recordRequest.getMonth(), recordRequest.getDate());
        } else {
            startDate = DateUtil.getDateByYearMonth(recordRequest.getYear(), recordRequest.getMonth());
            endDate = DateUtil.endDateByYearMonth(recordRequest.getYear(), recordRequest.getMonth());
        }

        List<TxFinanceRecordDay> list = txFinanceRecordDayDao.list(orgId, DateUtil.getStartOfDay(startDate), DateUtil.getEndOfDay(endDate));
        if (CollectionUtils.isEmpty(list)) {
            return Collections.EMPTY_LIST;
        }

        return buildDto(list, startDate, endDate, 1);
    }

    private List<TxFinanceRecordDto> buildDto(List<TxFinanceRecordDay> list, Date startDate, Date endDate, int type) {
        List<TxFinanceRecordDto> result = Lists.newArrayList();
        Map<String, TxFinanceRecordDto> map = Maps.newHashMap();

//        List<Date> dateList = DateUtil.getDateBetween(startDate, endDate);
//        for (int i = dateList.size() - 1; i >= 0; i--) {
//            TxFinanceRecordDto dto = new TxFinanceRecordDto();
//            dto.setCreateTime(dateList.get(i));
//            if (type == 1) {
//                map.put(DateUtil.getStrByDate(dateList.get(i)), dto);
//            } else {
//                map.put(DateUtil.getMonthStrByDate(dateList.get(i)), dto);
//            }
//        }

        for (TxFinanceRecordDay txFinanceRecordDay : list) {

            String key = "";
            if (type == 1) {
                key = DateUtil.getStrByDate(txFinanceRecordDay.getMdate());
            } else {
                key = DateUtil.getMonthStrByDate(txFinanceRecordDay.getMdate());
            }
            TxFinanceRecordDto dto = map.get(key);
            if (dto == null) {
                dto = new TxFinanceRecordDto();
            }

            dto.setCreateTime(txFinanceRecordDay.getMdate());
            if (txFinanceRecordDay.getOpTo().intValue() == FinanceOpTo.INCOME.getCode()) {
                dto.setIncomeSum(dto.getIncomeSum() + txFinanceRecordDay.getOpPrice());
                dto.setIncomeNum(dto.getIncomeNum() + txFinanceRecordDay.getOpCount());

                if (type == 1) {
                    TxTypeRecordDto typeRecordDto = new TxTypeRecordDto();
                    typeRecordDto.setType(txFinanceRecordDay.getOpType());
                    typeRecordDto.setTypeStr(FinancePayTypeCode.getPayName(typeRecordDto.getType()));
                    typeRecordDto.setTypeSum(txFinanceRecordDay.getOpPrice());
                    typeRecordDto.setTypeNum(txFinanceRecordDay.getOpCount());

                    dto.getIncomeList().add(typeRecordDto);
                }
            } else {
                dto.setExpendSum(dto.getExpendSum() + txFinanceRecordDay.getOpPrice());
                dto.setExpendNum(dto.getExpendNum() + txFinanceRecordDay.getOpCount());
                if (type == 1) {
                    TxTypeRecordDto typeRecordDto = new TxTypeRecordDto();
                    typeRecordDto.setType(txFinanceRecordDay.getOpType());
                    typeRecordDto.setTypeStr(FinancePayTypeCode.getPayName(typeRecordDto.getType()));
                    typeRecordDto.setTypeSum(txFinanceRecordDay.getOpPrice());
                    typeRecordDto.setTypeNum(txFinanceRecordDay.getOpCount());

                    dto.getExpendList().add(typeRecordDto);
                }
            }

            dto.setIncomeSum(ArithUtil.round(dto.getIncomeSum(), 2));
            dto.setExpendSum(ArithUtil.round(dto.getExpendSum(), 2));
            dto.setAllBalance(ArithUtil.round(dto.getIncomeSum() - dto.getExpendSum(), 2));
            map.put(key, dto);
        }

        result.addAll(map.values());

        Collections.sort(result, new Comparator<TxFinanceRecordDto>() {
            @Override
            public int compare(TxFinanceRecordDto o1, TxFinanceRecordDto o2) {
                return DateUtil.dateCompare(o1.getCreateTime(), o2.getCreateTime());
            }
        });
        return result;
    }


    @Override
    public List<TxFinanceRecordDto> financeByMonth(Long orgId, TxFinanceRecordRequest recordRequest) {
        Date startDate = DateUtil.getDateByYear(recordRequest.getYear());
        Date endDate = DateUtil.endDateByYear(recordRequest.getYear());

        List<TxFinanceRecordDay> list = txFinanceRecordDayDao.list(orgId, startDate, endDate);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.EMPTY_LIST;
        }
        return buildDto(list, startDate, endDate, 2);
    }

}
