package com.baijia.tianxiao.sal.organization.finance.service.impl;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpType;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceStatus;
import com.baijia.tianxiao.sal.organization.finance.dto.request.TxFinanceInfoRequest;
import com.baijia.tianxiao.sal.organization.finance.dto.request.TxFinanceRecordRequest;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxFinanceInfoAppDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxFinanceInfoDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxFinanceRecordDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxFreezeAccountListDto;
import com.baijia.tianxiao.sal.organization.finance.service.ExcelFinanceExportService;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.sal.organization.finance.service.TxFinanceInfoService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.*;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/7/8 Time: 上午11:00 To change this template use File | Settings
 * | File Templates.
 */
@Service
@Slf4j
public class TxFinanceInfoServiceImpl implements TxFinanceInfoService {

    @Resource
    private TxFinanceInfoDao txFinanceinfoDao;

    @Resource
    private OrgInfoDao orgInfoDao;

    @Resource
    private OrgAccountDao orgAccountDao;

    @Resource
    private OrgFinanceAccountService orgFinanceAccountService;

    @Resource
    private CoursePurchaseDao coursePurchaseDao;

    @Override
    public List<TxFinanceInfoDto> list(Long orgId, TxFinanceInfoRequest request, PageDto page) {

        TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
        if (request.getOpType() != null && request.getOpType().size() != 0) {
            txFinanceInfo.setOpTypes(FinanceOpType.getByOpType(request.getOpType()));
        }
        if (request.getOpTo() != null && request.getOpTo().size() != 0) {
            txFinanceInfo.setOpTos(request.getOpTo());
        }
        if (request.getPayType() != null && request.getPayType().size() != 0) {
            txFinanceInfo.setPayTypes(request.getPayType());
        }
        if (request.getStartPrice() != null && request.getEndPrice() != null) {
            txFinanceInfo.setStartBalance(request.getStartPrice());
            txFinanceInfo.setEndBalance(request.getEndPrice());
        }

        txFinanceInfo.setStartTime(request.getStartTime());
        txFinanceInfo.setEndTime(request.getEndTime());
        txFinanceInfo.setOrgId(orgId);

        List<TxxFinanceInfo> result = txFinanceinfoDao.list(txFinanceInfo, request.getSearchKey(), page);
        if (CollectionUtils.isEmpty(result)) {
            return Collections.EMPTY_LIST;
        }
        return buildDto(result);
    }

    @Override
    public List<TxFinanceInfoAppDto> appList(Long orgId, TxFinanceInfoRequest request, PageDto page) {

        TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
        txFinanceInfo.setStartTime(request.getStartTime());
        txFinanceInfo.setEndTime(request.getEndTime());
        txFinanceInfo.setOrgId(orgId);

        List<TxxFinanceInfo> data = txFinanceinfoDao.list(txFinanceInfo, request.getSearchKey(), page);
        if (CollectionUtils.isEmpty(data)) {
            return Collections.EMPTY_LIST;
        }

        List<TxFreezeAccountListDto> txFreezeAccountListDtos = orgFinanceAccountService.settleList(orgId, null);
        final Set<Long> purchaseIds = Sets.newHashSet();
        Map<String, TxFreezeAccountListDto> purchaseMap =
            CollectorUtil.collectMap(txFreezeAccountListDtos, new Function<TxFreezeAccountListDto, String>() {
                @Override
                public String apply(TxFreezeAccountListDto txFreezeAccountListDto) {
                    purchaseIds.add(txFreezeAccountListDto.getPurchase_id());
                    return txFreezeAccountListDto.getPurchase_id() + "";
                }
            });

        Map<String, CoursePurchase> signPurchaseMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(purchaseIds)) {
            List<CoursePurchase> coursePurchaseList = coursePurchaseDao.getByPurcahseIds(purchaseIds);
            Map<String, CoursePurchase> signPurchaseMap1 =
                CollectorUtil.collectMap(coursePurchaseList, new Function<CoursePurchase, String>() {
                    @Override
                    public String apply(CoursePurchase coursePurchase) {
                        return coursePurchase.getParentPurchaseId() + "";
                    }
                });

            signPurchaseMap.putAll(signPurchaseMap1);
        }

        List<TxFinanceInfoAppDto> result = Lists.newArrayList();
        for (TxxFinanceInfo txxFinanceInfo : data) {
            TxFinanceInfoAppDto txFinanceInfoAppDto = new TxFinanceInfoAppDto();
            txFinanceInfoAppDto.setPayTime(DateUtil.getPayTime(txxFinanceInfo.getCreateTime()));
            txFinanceInfoAppDto.setOpInfo(txxFinanceInfo.getOpInfo());
            if (txxFinanceInfo.getOpTo().intValue() == 2) {
                txFinanceInfoAppDto.setOpMoney(NumberUtil.numberWithDelimiter(-txxFinanceInfo.getOpMoney()));
            } else {
                txFinanceInfoAppDto.setOpMoney(NumberUtil.numberWithDelimiter(txxFinanceInfo.getOpMoney()));
            }
            txFinanceInfoAppDto.setPayTypeStr(FinanceOpType.getByCode(txxFinanceInfo.getOpType()));

            TxFreezeAccountListDto txfreeAccount = purchaseMap.get(txxFinanceInfo.getPurchaseId());
            CoursePurchase coursePurchase = null;
            if (txfreeAccount == null) {
                coursePurchase = signPurchaseMap.get(txxFinanceInfo.getPurchaseId());
            }

            if ((txfreeAccount != null || coursePurchase != null)
                && !txFinanceInfoAppDto.getOpMoney().startsWith("-")) {
                txFinanceInfoAppDto.setStatusStr(FinanceStatus.SETTLE.getValue());
                txFinanceInfoAppDto.setStatus(FinanceStatus.SETTLE.getCode());
            } else {
                txFinanceInfoAppDto.setStatusStr("");
            }
            result.add(txFinanceInfoAppDto);
        }

        return result;
    }

    private List<TxFinanceInfoDto> buildDto(List<TxxFinanceInfo> list) {
        List<TxFinanceInfoDto> result = Lists.newArrayList();
        for (TxxFinanceInfo txFinanceInfo : list) {
            TxFinanceInfoDto dto = new TxFinanceInfoDto();
            dto.setPurchaseId(txFinanceInfo.getPurchaseId());
            dto.setCourseId(txFinanceInfo.getCourseId());
            dto.setCreateTime(txFinanceInfo.getCreateTime());
            dto.setOpType(txFinanceInfo.getOpType());
            dto.setOpTypeStr(FinanceOpType.getByCode(dto.getOpType()));
            dto.setOpTo(txFinanceInfo.getOpTo());
            dto.setPayType(txFinanceInfo.getPayType());
            dto.setPayTypeStr(PayType.getByCode(dto.getPayType()));
            dto.setBalance(txFinanceInfo.getCurrBalance() + txFinanceInfo.getCurrFreezeMoney()
                + txFinanceInfo.getExpectedEarning());
            dto.setBalance(ArithUtil.round(dto.getBalance(), 2));
            dto.setOpInfo(txFinanceInfo.getOpInfo());
            dto.setOpMoney(txFinanceInfo.getOpTo() == 2 ? -txFinanceInfo.getOpMoney() : txFinanceInfo.getOpMoney());
            dto.setOpMoney(ArithUtil.round(dto.getOpMoney(), 2));
            // dto.setId(txFinanceInfo.getId());
            result.add(dto);
        }
        return result;
    }

    @Override
    public void export(HttpServletResponse response, TxFinanceRecordRequest recordRequest,
        List<TxFinanceRecordDto> recordDtos, List<TxFinanceInfoDto> infoDtos) {
        Preconditions.checkArgument(recordDtos != null, "汇总数据不能为空");
        Preconditions.checkArgument(infoDtos != null, "明细数据不能为空");

        OrgInfo orgInfo = orgInfoDao.getOrgInfo(recordRequest.getOrgId().intValue());
        OrgAccount orgAccount = orgAccountDao.getAccountById(recordRequest.getOrgId().intValue());

        Date startDate = null;
        Date endDate = null;

        if (recordRequest.getDate() != null) {
            startDate = endDate =
                DateUtil.getDateByDay(recordRequest.getYear(), recordRequest.getMonth(), recordRequest.getDate());
        } else {
            startDate = DateUtil.getDateByYearMonth(recordRequest.getYear(), recordRequest.getMonth());
            endDate = DateUtil.endDateByYearMonth(recordRequest.getYear(), recordRequest.getMonth());
        }
        startDate = DateUtil.getStartOfDay(startDate);
        endDate = DateUtil.getEndOfDay(endDate);

        SXSSFWorkbook workbook = null;

        try {
            workbook = new SXSSFWorkbook(1000);
            HashMap cellStyleMap = new HashMap();
            List recordFields = Lists.newArrayList();
            recordFields.add(new ExportField("类型", "@", 5120));
            recordFields.add(new ExportField("收入笔数", "@", 5120));
            recordFields.add(new ExportField("收入金额（+元）", "@", 5120));
            recordFields.add(new ExportField("支出笔数", "@", 5120));
            recordFields.add(new ExportField("支出金额（-元））", "@", 5120));
            recordFields.add(new ExportField("总金额（元）", "@", 5120));
            List recordTitles = Lists.newArrayList();
            recordTitles.add("#天校资金汇总查询");
            recordTitles.add("#账号:" + orgInfo.getShortName() + "(" + orgAccount.getNumber() + ")");
            recordTitles
                .add("#起始日期：[" + DateUtil.getAllDayStr(startDate) + "]  终止日期：[" + DateUtil.getAllDayStr(endDate) + "]");
            recordTitles
                .add(" #-----------------------------------------账务汇总列表----------------------------------------");

            ExcelFinanceExportService.createFinanceRecordSheet(workbook, "汇总", recordTitles, cellStyleMap, recordFields,
                recordDtos);

            List infoFields = Lists.newArrayList();
            infoFields.add(new ExportField("业务流水号", "@", 5120));
            infoFields.add(new ExportField("业务类型", "@", 5120));
            infoFields.add(new ExportField("业务摘要", "@", 5120));
            infoFields.add(new ExportField("业务时间", "@", 5120));
            infoFields.add(new ExportField("收入金额（+元）", "@", 5120));
            infoFields.add(new ExportField("支出金额（-元）", "@", 5120));
            infoFields.add(new ExportField("资金类型", "@", 5120));
            infoFields.add(new ExportField("天校账户余额", "@", 5120));

            List infoTitles = Lists.newArrayList();
            infoTitles.add("#天校业务明细查询");
            infoTitles.add("#账号:" + orgInfo.getShortName() + "(" + orgAccount.getNumber() + ")");
            infoTitles
                .add("#起始日期：[" + DateUtil.getAllDayStr(startDate) + "]  终止日期：[" + DateUtil.getAllDayStr(endDate) + "]");
            infoTitles.add(" #-----------------------------------------业务明细列表----------------------------------------");

            ExcelFinanceExportService.createFinanceInfoSheet(workbook, "明细", infoTitles, cellStyleMap, infoFields,
                infoDtos);
            ExcelFinanceExportService.exportExcel(response, workbook, "天校收支记录.xlsx");

        } catch (Exception var20) {
            log.warn("export catch exception:", var20);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "导出数据处理异常");
        } finally {
            try {
                workbook.close();
            } catch (IOException var19) {
                log.warn("close workbook catch error:", var19);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String json1 = FileUtils.readFileToString(new File("/Users/wengshengli/Downloads/response1.json"));
        List<TxFinanceRecordDto> recordDtos = JacksonUtil.str2List(json1, TxFinanceRecordDto.class);

        String json2 = FileUtils.readFileToString(new File("/Users/wengshengli/Downloads/response2.json"));
        List<TxFinanceInfoDto> infoDtos = JacksonUtil.str2List(json2, TxFinanceInfoDto.class);

        SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
        workbook = new SXSSFWorkbook(1000);
        HashMap cellStyleMap = new HashMap();
        List recordFields = Lists.newArrayList();
        recordFields.add(new ExportField("类型", "@", 5120));
        recordFields.add(new ExportField("收入笔数", "@", 5120));
        recordFields.add(new ExportField("收入金额（+元）", "@", 5120));
        recordFields.add(new ExportField("支出笔数", "@", 5120));
        recordFields.add(new ExportField("支出金额（-元））", "@", 5120));
        recordFields.add(new ExportField("总金额（元）", "@", 5120));
        List recordTitles = Lists.newArrayList();
        recordTitles.add("#天校资金汇总查询");
        recordTitles.add("#账号: ()");
        recordTitles.add("#起始日期：[]  终止日期：[]");
        recordTitles.add(" #-----------------------------------------账务汇总列表----------------------------------------");

        ExcelFinanceExportService.createFinanceRecordSheet(workbook, "汇总", recordTitles, cellStyleMap, recordFields,
            recordDtos);

        List infoFields = Lists.newArrayList();
        infoFields.add(new ExportField("业务流水号", "@", 5120));
        infoFields.add(new ExportField("业务类型", "@", 5120));
        infoFields.add(new ExportField("业务摘要", "@", 5120));
        infoFields.add(new ExportField("业务时间", "@", 5120));
        infoFields.add(new ExportField("收入金额（+元）", "@", 5120));
        infoFields.add(new ExportField("支出金额（-元）", "@", 5120));
        infoFields.add(new ExportField("资金类型", "@", 5120));
        infoFields.add(new ExportField("天校账户余额", "@", 5120));

        List infoTitles = Lists.newArrayList();
        infoTitles.add("#天校业务明细查询");
        infoTitles.add("#账号: )");
        infoTitles.add("#起始日期：[");
        infoTitles.add(" #-----------------------------------------业务明细列表----------------------------------------");

        ExcelFinanceExportService.createFinanceInfoSheet(workbook, "明细", infoTitles, cellStyleMap, infoFields,
            infoDtos);

        File excelFile = new File("/Users/wengshengli/Documents/test1.xlsx");
        workbook.write(new FileOutputStream(excelFile));
    }
}
