package com.baijia.tianxiao.sal.organization.finance.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.finance.dao.CwDrawcashPurchaseDao;
import com.baijia.tianxiao.dal.finance.po.CWDrawcashPurchase;
import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountRecordDao;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccount;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpType;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceStatus;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgFinanceAccountDto;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgFinanceAccountRecordDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.FinanceAccountDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.FinanceAccountIncomeDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.OrgFinanceAccountRecordFromPay;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxFreezeAccountListDto;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.sal.organization.finance.service.TxBankCardService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.pay.PayHttpRestUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/7/9 Time: 上午10:17 To change this template use File | Settings
 * | File Templates.
 */
@Service
@Slf4j
public class OrgFinanceAcountServiceImpl implements OrgFinanceAccountService {

    private static List<Integer> SPLIT_CODES_NOT_SIGN =
            Lists.newArrayList(SplitCourseResult.PENDING.getCode(), SplitCourseResult.NOT_COMMIT.getCode());
    private static List<Integer> PURCHASE_CODES_NOT_SIGN = Lists.newArrayList(PayResult.SUCCESS.getCode());
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private CwDrawcashPurchaseDao cwDrawcashPurchaseDao;
    @Resource
    private TxBankCardService txBankCardService;
    @Resource
    private OrgFinanceAccountRecordDao orgFinanceAccountRecordDao;
    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;

    private static boolean isNotNullJsonNode(Object node) {
        if (node != null && !node.equals("null") && !node.toString().equals("{}") && !node.toString().equals("[]")) {
            return true;
        }
        return false;
    }

    @Override
    public FinanceAccountDto getInfo(Long orgId) throws Exception {
        // 不访问数据表，调用支付的接口
        // OrgFinanceAccount account = orgFinanceAccountDao.getByOrgId(orgId);
        OrgFinanceAccount account = getAccountInfo(orgId);
        if (account == null) {
            return new FinanceAccountDto();
        }
        Long signupMoney = orgSignupInfoDao.sumByPurchaseStatus(orgId, Lists.newArrayList(PayResult.SUCCESS.getCode()),
                Lists.newArrayList(SplitCourseResult.PENDING.getCode(), SplitCourseResult.NOT_COMMIT.getCode()), null,
                true);
        double withdrawMoney = orgFinanceAccountRecordDao.sumDrawcashMoney(orgId);

        double settleMoney = getSettleMoney(orgId);

        int drawCashTime = txBankCardService.drawCashCount(orgId, DateUtil.getStrByDate(new Date()),
                DateUtil.getStrByDate(new Date()));

        return buildDto(account, signupMoney, withdrawMoney, settleMoney, drawCashTime);
    }

    private FinanceAccountDto buildDto(OrgFinanceAccount account, Long signupMoney, double withdrawMondy,
                                       double settleMoney, int drawCashTime) {
        FinanceAccountDto dto = new FinanceAccountDto();
        dto.setBalance(NumberUtil.numberWithDelimiter(account.getBalance()).substring(1));
        dto.setWithdrawMoney(NumberUtil.numberWithDelimiter(withdrawMondy).substring(1));
        dto.setSettleMoney(NumberUtil.numberWithDelimiter(settleMoney).substring(1));
        dto.setSignupMoney(signupMoney == null ? "0"
                : NumberUtil.numberWithDelimiter(ArithUtil.div(signupMoney, 100, 2)).substring(1));

        dto.setFreezeMoney(
                NumberUtil.numberWithDelimiter(account.getFreezeMoney() + account.getExpectedEarning()).substring(1));
        dto.setAssureMoney(NumberUtil.numberWithDelimiter(account.getFreezeMoney() + account.getExpectedEarning()
                - withdrawMondy - settleMoney - ArithUtil.div(signupMoney == null ? 0 : signupMoney, 100, 2)).substring(1));

        dto.setWithdrawLeftTimes(TianXiaoConstant.WITHDRAW_TIME - drawCashTime);
        return dto;
    }

    private Double getSettleMoney(Long orgId) {
        List<TxFreezeAccountListDto> txFreezeAccountListDtos = settleList(orgId, null);
        double result = 0.0d;
        for (TxFreezeAccountListDto txFreezeAccountListDto : txFreezeAccountListDtos) {
            result += Double.parseDouble(txFreezeAccountListDto.getOpMoney());
        }
        return result;
    }

    @Override
    public List<TxFreezeAccountListDto> signupList(Long orgId, PageDto pageDto) {

        List<OrgSignupInfo> signupInfos = orgSignupInfoDao.listByStatus(orgId, PURCHASE_CODES_NOT_SIGN,
                SPLIT_CODES_NOT_SIGN, TianxiaoMContext.getTXCascadeId(), true, pageDto);

        if (signupInfos.isEmpty()) {
            return Collections.EMPTY_LIST;
        }

        List<TxFreezeAccountListDto> result = Lists.newArrayList();
        for (OrgSignupInfo orgSignupInfo : signupInfos) {
            TxFreezeAccountListDto txFreezeAccountListDto = new TxFreezeAccountListDto();
            double opMoney = orgSignupInfo.getTotalPrices();
            txFreezeAccountListDto.setOpMoney(NumberUtil.numberWithDelimiter(opMoney / 100));
            txFreezeAccountListDto.setPayTypeStr("支付");
            txFreezeAccountListDto.setPayTime(DateUtil.getPayTime(orgSignupInfo.getPayTime()));
            txFreezeAccountListDto.setStatusStr("");
            txFreezeAccountListDto.setOpInfo("机构报名收款");

            result.add(txFreezeAccountListDto);
        }
        return result;
    }

    @Override
    public List<TxFreezeAccountListDto> settleList(Long orgId, PageDto pageDto) {
        List<OrgFinanceAccountRecordFromPay> dto = Lists.newArrayList();

        Map<String, String> params = new HashMap<>();
        params.put("user_id", orgId + "");
        params.put("user_role", UserRole.ORGANIZATION.getRole() + "");
        if (pageDto != null) {
            params.put("page", String.valueOf(pageDto.getPageNum()));
            params.put("size", String.valueOf(pageDto.getPageSize()));
        }
        params.put("_time", System.currentTimeMillis() + "");
        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.PAY_SERVICE + "/wallet/noSettlementRecords", params);
        if (isNotNullJsonNode(data)) {
            JSONArray jsondata = JSONArray.fromObject(data);
            try {
                dto = JacksonUtil.str2List(jsondata.toString(), OrgFinanceAccountRecordFromPay.class);
            } catch (Exception e) {
                log.warn("e", e);
            }
        }
        if (dto.isEmpty()) {
            return Collections.EMPTY_LIST;
        }

        List<TxFreezeAccountListDto> result = Lists.newArrayList();
        for (OrgFinanceAccountRecordFromPay financeAccountRecord : dto) {
            TxFreezeAccountListDto listDto = new TxFreezeAccountListDto();
            listDto.setOpInfo(financeAccountRecord.getOp_info());
            listDto.setStatusStr(FinanceStatus.SETTLE.getValue());
            listDto.setStatus(FinanceStatus.SETTLE.getCode());
            listDto.setPayTime(DateUtil
                    .getPayTime(DateUtil.getStrToDate("yyyy-MM-dd HH:mm:ss", financeAccountRecord.getCreate_time())));
            listDto.setOpMoney(NumberUtil.get2FromDouble(financeAccountRecord.getOp_money()));
            listDto.setPayTypeStr(FinanceOpType.getByCode(financeAccountRecord.getOp_type()));
            listDto.setPurchase_id(financeAccountRecord.getPurchase_id());
            result.add(listDto);
        }

        return result;
    }

    @Override
    public List<TxFreezeAccountListDto> withdrawList(Long orgId, Integer status, PageDto pageDto) {
        List<CWDrawcashPurchase> list = Lists.newArrayList();
        if (status != null && status == 0) {
            list = cwDrawcashPurchaseDao.listDrawcashing(orgId, pageDto);
        } else {
            list = cwDrawcashPurchaseDao.listAll(orgId, pageDto);
        }

        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List<TxFreezeAccountListDto> result = Lists.newArrayList();
        for (CWDrawcashPurchase dto : list) {
            TxFreezeAccountListDto listDto = new TxFreezeAccountListDto();
            listDto.setPayTime(DateUtil.getPayTime(dto.getUpdateTime()));
            if (dto.getStatus().intValue() == 3 || dto.getStatus().intValue() == 5) {
                listDto.setOpMoney(NumberUtil.numberWithDelimiter(dto.getAmount()));
            } else {
                listDto.setOpMoney(NumberUtil.numberWithDelimiter(-dto.getAmount()));
            }
            listDto.setPayTypeStr("提现");
            listDto.setStatusStr(dto.getStatus().intValue() == 2 ? "提现成功"
                    : (dto.getStatus().intValue() == 3 || dto.getStatus().intValue() == 5) ? "提现退回" : "提现中");
            listDto.setOpInfo("提现至" + dto.getBankName() + ((dto.getCardNum() != null && dto.getCardNum().length() > 4)
                    ? "(" + dto.getCardNum().substring(dto.getCardNum().length() - 4) + ")" : ""));
            if (listDto.getStatusStr().equals("提现中")) {
                listDto.setStatus(FinanceStatus.WITHDRAW.getCode());
            }
            result.add(listDto);
        }
        return result;
    }

    @Override
    public OrgFinanceAccount getAccountInfo(Long orgId) {
        OrgFinanceAccountDto dto = null;
        Map<String, String> params = new HashMap<>();
        params.put("org_id", String.valueOf(orgId));
        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.PAY_SERVICE + "/org/orgAccountInfo", params);
        if (isNotNullJsonNode(data)) {
            JSONObject jsondata = JSONObject.fromObject(data);
            try {
                dto = JacksonUtil.str2Obj(jsondata.toString(), OrgFinanceAccountDto.class);
            } catch (Exception e) {
                log.warn("e", e);
            }
        }
        return bulidAccount(dto);
    }

    @Override
    public Map<Integer, OrgFinanceAccountDto> getAccountInfos(List<Long> orgIds) {
        Map<Integer, OrgFinanceAccountDto> map = Maps.newHashMap();
        StringBuffer stringBuffer = new StringBuffer();
        for (Long id : orgIds) {
            stringBuffer.append(",").append(id);
        }
        String param = stringBuffer.toString().substring(1);
        Map<String, String> params = new HashMap<>();
        params.put("orgIds", param);
        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.PAY_SERVICE + "/org/getBatchAccountInfo", params);
        if (isNotNullJsonNode(data)) {
            try {
                JSONObject jsonObject = JSONObject.fromObject(data);
//                map = JSONObject.fromObject(jsonObject);
                Map<String, Object> mapJson = JSONObject.fromObject(jsonObject);
                for (Map.Entry<String, Object> entry : mapJson.entrySet()) {
                    Object strval1 = entry.getValue();
                    JSONObject str = JSONObject.fromObject(strval1);
                    OrgFinanceAccountDto oo = JacksonUtil.str2Obj(str.toString(), OrgFinanceAccountDto.class);
                    map.put(Integer.parseInt(entry.getKey()), oo);
                }
            } catch (Exception e) {
                log.warn("e", e);
            }
        }
        return map;
    }

    @Override
    public OrgFinanceAccountRecord getAccountRecordInfo(Long orgId, Date date) {
        OrgFinanceAccountRecordDto dto = null;
        Map<String, String> params = new HashMap<>();
        params.put("org_id", String.valueOf(orgId));
        params.put("create_time", String.valueOf(date));
        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.PAY_SERVICE + "/org/getRecordInfo", params);
        if (isNotNullJsonNode(data)) {
            JSONObject jsondata = JSONObject.fromObject(data);
            try {
                dto = JacksonUtil.str2Obj(jsondata.toString(), OrgFinanceAccountRecordDto.class);
            } catch (Exception e) {
                log.warn("e", e);
            }
        }
        if (dto == null || dto.getId() == null) {
            return null;
        }
        return buildRecord(dto);
    }

    @Override
    public List<OrgFinanceAccountRecord> getAccountRecordInfos(Long syncId, Integer maxSize) {
        List<OrgFinanceAccountRecordDto> list = Lists.newArrayList();
        Map<String, String> params = new HashMap<>();
        params.put("id", String.valueOf(syncId));
        params.put("maxSize", maxSize.toString());
        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.PAY_SERVICE + "/org/orgAccountIncreasedRecord", params);
        if (isNotNullJsonNode(data)) {
            JSONArray records = JSONArray.fromObject(data);
            try {
                list = JacksonUtil.str2List(records.toString(), OrgFinanceAccountRecordDto.class);
            } catch (Exception e) {
                log.warn("e", e);
            }
        }
        return buildAccounts(list);
    }

    private OrgFinanceAccount bulidAccount(OrgFinanceAccountDto dto) {
        OrgFinanceAccount account = new OrgFinanceAccount();
        account.setExpectedEarning(
                StringUtils.isEmpty(dto.getExpected_earning()) ? 0.00 : Double.parseDouble(dto.getExpected_earning()));
        account.setBalance(StringUtils.isEmpty(dto.getBalance()) ? 0.00 : Double.parseDouble(dto.getBalance()));
        account.setFreezeMoney(StringUtils.isEmpty(dto.getFreeze_money()) ? 0.00 : Double.parseDouble(dto.getFreeze_money()));
        account.setCreatTime(StringUtils.isEmpty(dto.getCreate_time()) ? null : DateUtil.getDateByStr(dto.getCreate_time()));
        account.setId(StringUtils.isEmpty(dto.getId()) ? 0 : Integer.parseInt(dto.getId()));
        account.setIncome(StringUtils.isEmpty(dto.getIncome()) ? 0.00 : Double.parseDouble(dto.getIncome()));
        account.setOrgName(StringUtils.isEmpty(dto.getOrg_name()) ? "" : dto.getOrg_name());
        account.setUpdateTime(StringUtils.isEmpty(dto.getUpdate_time()) ? null : DateUtil.getDateByStr(dto.getUpdate_time()));
        account.setOrgId(StringUtils.isEmpty(dto.getOrg_id()) ? null : Long.parseLong(dto.getOrg_id()));
        return account;
    }

    private OrgFinanceAccountRecord buildRecord(OrgFinanceAccountRecordDto dto) {
        OrgFinanceAccountRecord record = new OrgFinanceAccountRecord();
        record.setCurrBalance(StringUtils.isEmpty(dto.getCurr_balance()) ? 0 : Double.parseDouble(dto.getCurr_balance()));
        record.setCurrFreezeMoney(
                StringUtils.isEmpty(dto.getCurr_freeze_money()) ? 0 : Double.parseDouble(dto.getCurr_freeze_money()));
        record.setCurrExpectedEarning(
                StringUtils.isEmpty(dto.getCurr_expected_earning()) ? 0 : Double.parseDouble(dto.getCurr_expected_earning()));
        record.setActivitySourceUserRole(
                StringUtils.isEmpty(dto.getActivity_source_user_role()) ? null : Integer.parseInt(dto.getActivity_source_user_role()));
        record.setCreateTime((dto.getCreate_time() == null || dto.getCreate_time().equals("0000-00-00 00:00:00")) ? new Timestamp(System.currentTimeMillis())
                : Timestamp.valueOf(dto.getCreate_time()));
        record.setCurrIncome(StringUtils.isEmpty(dto.getCurr_income()) ? 0 : Double.parseDouble(dto.getCurr_income()));
        record.setCurrPayType(StringUtils.isEmpty(dto.getCurr_pay_type()) ? null : dto.getCurr_pay_type());
        record.setDestId(StringUtils.isEmpty(dto.getDest_id()) ? null : Long.parseLong(dto.getDest_id()));
        record.setId(Integer.parseInt(dto.getId()));
        record.setIsShow(StringUtils.isEmpty(dto.getIs_show()) ? 1 : Integer.parseInt(dto.getIs_show()));
        record.setNote(dto.getNote());
        record.setOpDesc(dto.getOp_desc());
        record.setOpInfo(dto.getOp_info());
        record.setOpMoney(StringUtils.isEmpty(dto.getOp_money()) ? 0 : Double.parseDouble(dto.getOp_money()));
        record.setOpMoneyType(StringUtils.isEmpty(dto.getOp_money_type()) ? null : Integer.parseInt(dto.getOp_money_type()));
        record.setOpStatus(StringUtils.isEmpty(dto.getOp_status()) ? null : Integer.parseInt(dto.getOp_status()));
        record.setOpType(StringUtils.isEmpty(dto.getOp_type()) ? 1 : Integer.parseInt(dto.getOp_type()));
        record.setOrderLessonId(StringUtils.isEmpty(dto.getOrder_lesson_id()) ? null : Long.parseLong(dto.getOrder_lesson_id()));
        record.setOrgId(StringUtils.isEmpty(dto.getOrg_id()) ? 0 : Long.parseLong(dto.getOrg_id()));
        record.setOrgName(dto.getOrg_name());
        record.setPayType(dto.getPay_type());
        record.setPreBalance(StringUtils.isEmpty(dto.getPre_balance()) ? 0 : Double.parseDouble(dto.getPre_balance()));
        record.setPreExpectedEarning(
                StringUtils.isEmpty(dto.getPre_expected_earning()) ? 0 : Double.parseDouble(dto.getPre_expected_earning()));
        record.setPreFreezeMoney(StringUtils.isEmpty(dto.getPre_freeze_money()) ? 0 : Double.parseDouble(dto.getPre_freeze_money()));
        record.setPreIncome(StringUtils.isEmpty(dto.getPre_income()) ? 0 : Double.parseDouble(dto.getPre_income()));
        record.setPurchaseId(StringUtils.isEmpty(dto.getPurchase_id()) ? null : Long.parseLong(dto.getPurchase_id()));
        // record.setTeacherId(dto.getTeacher_id()==null?null:Long.parseLong(dto.getTeacher_id()));
        return record;
    }

    private List<OrgFinanceAccountRecord> buildAccounts(List<OrgFinanceAccountRecordDto> list) {
        List<OrgFinanceAccountRecord> result = Lists.newArrayList();
        for (OrgFinanceAccountRecordDto dto : list) {
            OrgFinanceAccountRecord o = buildRecord(dto);
            result.add(o);
        }
        return result;
    }

    @Override
    public FinanceAccountIncomeDto getIncome(Long orgId) {
        FinanceAccountIncomeDto dto = new FinanceAccountIncomeDto();
        Double day = txFinanceRecordDayDao.getIncome(orgId, DateUtil.getCurrentDate(), DateUtil.getDayDiff(1));
        Double week = txFinanceRecordDayDao.getIncome(orgId, DateUtil.getStartOfWeek(), DateUtil.getEndOfWeek());
        Double month = txFinanceRecordDayDao.getIncome(orgId, DateUtil.getStartOfMonth(), DateUtil.getEndOfMonth());
        Double total = txFinanceRecordDayDao.getIncome(orgId, null, null);
        log.debug("---------------{},{},{},{}", day, week, month, total);
        String incomeToday = NumberUtil.numberWithDelimiter(day).substring(1);
        String incomeWeek = NumberUtil.numberWithDelimiter(week).substring(1);
        String incomeMonth = NumberUtil.numberWithDelimiter(month).substring(1);
        String income = NumberUtil.numberWithDelimiter(total).substring(1);
        dto.setIncome(income);
        dto.setIncomeToday(incomeToday);
        dto.setIncomeMonth(incomeMonth);
        dto.setIncomeWeek(incomeWeek);
        return dto;
    }
}