/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.dto;

import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.sal.organization.constant.ClientType;
import com.baijia.tianxiao.sal.organization.constant.Config;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthToken
extends BaseDto {
    private static final Logger log = LoggerFactory.getLogger(AuthToken.class);
    private String appId;
    private String secertKey;
    private int clientType;
    private int systemType;
    private Long orgId;
    private Long userId;
    private Integer userRole;
    private String userName;
    private Long timestamp;
    private String redirectUrl;

    public static AuthToken paraseToken(String token) throws Exception {
        String json = EncryptUtils.strDecode((String)token);
        AuthToken authToken = (AuthToken)((Object)JacksonUtil.str2Obj((String)json, AuthToken.class));
        return authToken;
    }

    public static String assignMentStudentToken(Long orgId, Long studentId, String userName, Integer doorgodRole, ClientType clientType) {
        AuthToken token = new AuthToken();
        token.setAppId(clientType.getAppId());
        token.setSecertKey(clientType.getSecertKey());
        token.setClientType(clientType.getCode());
        token.setOrgId(orgId);
        if (clientType == ClientType.HW) {
            token.setRedirectUrl(Config.TX_ASSIGNMENT_URL + "/mmain.do");
        } else if (clientType == ClientType.EXAM) {
            token.setRedirectUrl(Config.TX_EXAM_URL + "/mmain.do");
        } else {
            token.setRedirectUrl(Config.TX_GRADE_URL + "/mgrade.do");
        }
        token.setSystemType(0);
        token.setTimestamp(System.currentTimeMillis());
        token.setUserId(studentId);
        token.setUserRole(doorgodRole);
        token.setUserName(userName);
        String strToken = EncryptUtils.base64EncodeStrWithFactor((Object)((Object)token));
        log.debug("[token]={}", (Object)token);
        return Config.TX_DOORGOD_URL + "/authrization/auth.do?token=" + strToken;
    }

    public static String assignMentToken(Long orgId, Long cascadeId, String userName, Integer doorgodRole, ClientType clientType) {
        AuthToken token = new AuthToken();
        token.setAppId(clientType.getAppId());
        token.setSecertKey(clientType.getSecertKey());
        token.setClientType(clientType.getCode());
        token.setOrgId(orgId);
        if (clientType == ClientType.HW) {
            token.setRedirectUrl(Config.TX_ASSIGNMENT_URL + "/main.do");
        } else if (clientType == ClientType.EXAM) {
            token.setRedirectUrl(Config.TX_EXAM_URL + "/main.do");
        } else {
            token.setRedirectUrl(Config.TX_GRADE_URL + "/grade.do");
        }
        token.setSystemType(0);
        token.setTimestamp(System.currentTimeMillis());
        token.setUserId(cascadeId);
        token.setUserRole(doorgodRole);
        token.setUserName(userName);
        log.debug("token = {}", (Object)token);
        String strToken = EncryptUtils.base64EncodeStrWithFactor((Object)((Object)token));
        return Config.TX_DOORGOD_URL + "/authrization/auth.do?token=" + strToken;
    }

    public static String encodeToken(AuthToken token) throws Exception {
        return EncryptUtils.base64EncodeStrWithFactor((Object)((Object)token));
    }

    public static void main(String[] args) throws JsonGenerationException, JsonMappingException, IOException, Exception {
        AuthToken token = new AuthToken();
        token.setAppId("tx201704221528");
        token.setSecertKey("baijiahulian_grade");
        token.setClientType(3);
        token.setOrgId(3794L);
        token.setRedirectUrl("http://test-grade.ctest.baijiahulian.com/grade.do");
        token.setSystemType(0);
        token.setTimestamp(System.currentTimeMillis());
        token.setUserId(0L);
        token.setUserRole(2);
        String strToken = EncryptUtils.base64EncodeStrWithFactor((Object)((Object)token));
        System.out.println(strToken);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getSecertKey() {
        return this.secertKey;
    }

    public int getClientType() {
        return this.clientType;
    }

    public int getSystemType() {
        return this.systemType;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public Integer getUserRole() {
        return this.userRole;
    }

    public String getUserName() {
        return this.userName;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setSecertKey(String secertKey) {
        this.secertKey = secertKey;
    }

    public void setClientType(int clientType) {
        this.clientType = clientType;
    }

    public void setSystemType(int systemType) {
        this.systemType = systemType;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setUserRole(Integer userRole) {
        this.userRole = userRole;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthToken)) {
            return false;
        }
        AuthToken other = (AuthToken)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$secertKey = this.getSecertKey();
        String other$secertKey = other.getSecertKey();
        if (this$secertKey == null ? other$secertKey != null : !this$secertKey.equals(other$secertKey)) {
            return false;
        }
        if (this.getClientType() != other.getClientType()) {
            return false;
        }
        if (this.getSystemType() != other.getSystemType()) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$userRole = this.getUserRole();
        Integer other$userRole = other.getUserRole();
        if (this$userRole == null ? other$userRole != null : !((Object)this$userRole).equals(other$userRole)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$redirectUrl = this.getRedirectUrl();
        String other$redirectUrl = other.getRedirectUrl();
        return !(this$redirectUrl == null ? other$redirectUrl != null : !this$redirectUrl.equals(other$redirectUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $secertKey = this.getSecertKey();
        result = result * 59 + ($secertKey == null ? 43 : $secertKey.hashCode());
        result = result * 59 + this.getClientType();
        result = result * 59 + this.getSystemType();
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $userRole = this.getUserRole();
        result = result * 59 + ($userRole == null ? 43 : ((Object)$userRole).hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $redirectUrl = this.getRedirectUrl();
        result = result * 59 + ($redirectUrl == null ? 43 : $redirectUrl.hashCode());
        return result;
    }

    public String toString() {
        return "AuthToken(appId=" + this.getAppId() + ", secertKey=" + this.getSecertKey() + ", clientType=" + this.getClientType() + ", systemType=" + this.getSystemType() + ", orgId=" + this.getOrgId() + ", userId=" + this.getUserId() + ", userRole=" + this.getUserRole() + ", userName=" + this.getUserName() + ", timestamp=" + this.getTimestamp() + ", redirectUrl=" + this.getRedirectUrl() + ")";
    }
}

