package com.baijia.tianxiao.sal.organization.tx.service.impl;

import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.tx.dao.TxAccountOperateRecordDao;
import com.baijia.tianxiao.dal.tx.po.TxAccountOperateRecord;
import com.baijia.tianxiao.sal.organization.tx.constant.TXAccountConstant;
import com.baijia.tianxiao.sal.organization.tx.constant.TianXiaoAccountOperatStatus;
import com.baijia.tianxiao.sal.organization.tx.service.TxAccountOperateRecordService;
import lombok.extern.slf4j.Slf4j;
import org.apache.solr.common.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * Created by wengshengli on 2017/8/1.
 */
@Service
@Slf4j
public class TxAccountOperateRecordServiceImpl implements TxAccountOperateRecordService {

    @Autowired
    private TxAccountOperateRecordDao txAccountOperateRecordDao;


    @Override
    public void saveTxAccountOperate(Integer opType, Integer orgId, String detail) {
        TxAccountOperateRecord record = new TxAccountOperateRecord();
        record.setOpTime(new Date());
        record.setOpType(opType);
        record.setOpOrgId(orgId);
        record.setOpAccount("系统");
        record.setOpDetail(detail);
        if (StringUtils.isEmpty(detail)) {
            return;
        }
        txAccountOperateRecordDao.saveOrUpdate(record);
    }

    @Override
    public String getTXOpDetail(Integer opType, TXAccount before, TXAccount after) {
        if (opType == TianXiaoAccountOperatStatus.ADD.getStatus()) {
            return "新建账号";
        } else if (opType == TianXiaoAccountOperatStatus.CLOSE.getStatus()) {
            return "停用账号";
        } else if (opType == TianXiaoAccountOperatStatus.OPEN.getStatus()) {
            return "启用账号";
        } else {
            return getTXEditDetail(before, after);
        }
    }

    private String getTXEditDetail(TXAccount before, TXAccount after) {
        StringBuilder sb = new StringBuilder();
        if (before.getVipLevel() != after.getVipLevel()) {
            sb.append(TXAccountConstant.P_START).append("版本 ").append(TXAccountType.getTXAccountTypeByCode(before.getVipLevel()).getLabel());
            sb.append(" 更改为 ").append(TXAccountType.getTXAccountTypeByCode(after.getVipLevel()).getLabel()).append(TXAccountConstant.P_END);
        }

        if (before.getCampusCount().intValue() != after.getCampusCount().intValue()) {
            sb.append(TXAccountConstant.P_START).append("校区数 ").append(before.getCampusCount());
            sb.append(" 更改为 ").append(after.getCampusCount()).append(TXAccountConstant.P_END);
        }
        if (before.getCascadeAccountCount().intValue() != after.getCascadeAccountCount().intValue()) {
            sb.append(TXAccountConstant.P_START).append("账号数 ").append(before.getCascadeAccountCount());
            sb.append(" 更改为 ").append(after.getCascadeAccountCount()).append(TXAccountConstant.P_END);
        }

        if (before.getSmsCount().intValue() != after.getSmsCount().intValue()) {
            sb.append(TXAccountConstant.P_START).append("短信数 ").append(before.getSmsCount());
            sb.append(" 更改为 ").append(after.getSmsCount()).append(TXAccountConstant.P_END);
        }
        if (before.getSmsGate() != after.getSmsGate()) {
            sb.append(TXAccountConstant.P_START).append("短信网关 ").append(before.getSmsGate());
            sb.append(" 更改为 ").append(after.getSmsGate()).append(TXAccountConstant.P_END);
        }
        if (before.getTotalCallTime().intValue() != after.getTotalCallTime().intValue()) {
            sb.append(TXAccountConstant.P_START).append("通话分钟数 ").append(before.getTotalCallTime());
            sb.append(" 更改为 ").append(after.getTotalCallTime()).append(TXAccountConstant.P_END);
        }
        if (before.getStorageSpace().intValue() != after.getStorageSpace().intValue()) {
            sb.append(TXAccountConstant.P_START).append("存储空间 ").append(before.getStorageSpace());
            sb.append(" 更改为 ").append(after.getStorageSpace()).append(TXAccountConstant.P_END);
        }
        if (before.getStudentCount().intValue() != after.getStudentCount().intValue()) {
            sb.append(TXAccountConstant.P_START).append("在读学员数 ").append(before.getStudentCount());
            sb.append(" 更改为 ").append(after.getStudentCount()).append(TXAccountConstant.P_END);
        }
        if (before.getCloudStorageSpace().intValue() != after.getCloudStorageSpace().intValue()) {
            sb.append(TXAccountConstant.P_START).append("云存储空间 ").append(before.getCloudStorageSpace());
            sb.append(" 更改为 ").append(after.getCloudStorageSpace()).append(TXAccountConstant.P_END);
        }
        if (before.getConcurrentNumber().intValue() != after.getConcurrentNumber().intValue()) {
            sb.append(TXAccountConstant.P_START).append("并发数 ").append(before.getConcurrentNumber());
            sb.append(" 更改为 ").append(after.getConcurrentNumber()).append(TXAccountConstant.P_END);
        }
        if (before.getFlowrate().intValue() != after.getFlowrate().intValue()) {
            sb.append(TXAccountConstant.P_START).append("流量 ").append(before.getFlowrate());
            sb.append(" 更改为 ").append(after.getFlowrate()).append(TXAccountConstant.P_END);
        }
        if (before.getCustomerId().longValue() != after.getCustomerId().longValue()) {
            sb.append(TXAccountConstant.P_START).append("客户ID ").append(before.getCustomerId());
            sb.append(" 更改为 ").append(after.getCustomerId()).append(TXAccountConstant.P_END);
        }
        log.info("======================",sb.toString());
        return sb.toString();
    }
}
