package com.baijia.tianxiao.sal.organization.todo.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.util.date.DateUtil;

import lombok.Data;


@Data
public class BacklogHomepageSearchDto extends BaseDto {
	
	private static final long serialVersionUID = -4248690471834213862L;
	
	private Date minEndTime;
    private Date maxEndTime;
    private Integer finish;
    
    public void setEndTimeRange(Date minEndTime, Date maxEndTime){
    	this.minEndTime = minEndTime;
    	this.maxEndTime = maxEndTime;
    }
    
    public void resetBySearch(Integer searchStatus, Integer searchFinish){
    	if(searchStatus!=null){
	    	if(searchStatus==0){//待办
				this.minEndTime = DateUtil.getCurrentDate();
				this.maxEndTime = null;
			}else if(searchStatus==1){//过期
				this.minEndTime = null;
				this.maxEndTime = DateUtil.getCurrentDate();
			}
    	}
    	
    	if(searchFinish!=null){
    		this.finish = searchFinish;
    	}
    }
    
    
    public Object chooseListByFinish(Object all, Object finish, Object unfinish){
    	if(this.finish!=null){
			if( this.finish == Flag.TRUE.getInt() ){
				return finish;
			}else if(this.finish == Flag.FALSE.getInt()){
				return unfinish;
			}
		}
    	return all;
    }
    
}
