/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.organization.todo.dto;

import java.util.Date;

import com.baijia.tianxiao.dal.todo.constant.BacklogStatus;
import com.baijia.tianxiao.util.date.DateUtil;

import lombok.Data;

@Data
public class BackLogHomePageListDto {
	
	private Long backlogId;
	
	private Integer backlogType;
	    
    private String content;
    
    private Long endTime;
    
    private Integer status;
    
    private Integer finish;
    
    private RelatedStudent relatedStudent;
    
    public Integer getStatus(){
    	if(this.endTime==null){
    		return BacklogStatus.UNKNOWN.getValue();
    	}
    	
    	if(this.endTime >= DateUtil.getCurrentDate().getTime()){
    		return BacklogStatus.UNEXPIRED.getValue();
    	}else{
    		return BacklogStatus.EXPIRED.getValue();
    	}
    }
}

