package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sal.organization.constant.ClientType;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountModuleAuthService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collection;

import lombok.NonNull;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 31/07/2017 4:12 PM
 */
@Service
public class TxAccountModuleAuthServiceImpl implements TxAccountModuleAuthService {
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;

    @Override
    public Collection<ClientType> getAllClientTypes(@NonNull Long orgId) {
        OrgSubAccount orgSubAccount = orgSubAccountDao.getByOrgIdIgnoreDelStatus(orgId.intValue());
        TXAccount txAccount = orgSubAccount.getPid() == 0 ? txAccountDao.getByOrgId(orgSubAccount.getOrgId(), null)
            : txAccountDao.getByOrgId(orgSubAccount.getPid(), null);
        return ClientType.getByCodes(txAccount.getModuleAuth());
    }

    @Override
    public boolean hasClientType(Long orgId, ClientType clientType) {
        return null == orgId ? false : getAllClientTypes(orgId).contains(clientType);
    }

    @Override
    public String getModuleAuthValueStr(Long orgId, ClientType clientType) {
        OrgSubAccount orgSubAccount = orgSubAccountDao.getByOrgIdIgnoreDelStatus(orgId.intValue());
        TXAccount txAccount = orgSubAccount.getPid() == 0 ? txAccountDao.getByOrgId(orgSubAccount.getOrgId(), null)
            : txAccountDao.getByOrgId(orgSubAccount.getPid(), null);
        return null == txAccount ? null : txAccount.getModuleAuthDataMap().get(String.valueOf(clientType.getCode()));
    }

}
