
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.sal.organization.org.dto.OrgBaseInfoModel;
import com.baijia.tianxiao.sal.organization.org.service.OrgBaseService;
import com.baijia.tianxiao.util.storage.StorageUtil;

/**
 * @title OrgBaseServiceImpl
 * @desc TODO
 * @author bjhl
 * @date 2016年1月4日
 * @version 1.0
 */
@Service
public class OrgBaseServiceImpl implements OrgBaseService {

    @Resource
    private OrgInfoDao orgInfoDao;

    @Resource
    private OrgAccountDao orgAccountDao;

    @Resource
    private OrgPhotoDao orgPhotoDao;

    @Resource
    private OrgStorageDao orgStorageDao;

    @Override
    public OrgBaseInfoModel getOrgBaseInfoModel(Long orgId) {
        OrgBaseInfoModel model = new OrgBaseInfoModel();
        getAndSetBaseInfo(orgId, model);
        getAndSetLogo(orgId, model);
        return model;
    }

    public void getAndSetBaseInfo(Long orgId, OrgBaseInfoModel model) {
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId.intValue());
        model.setShortName(orgInfo.getShortName());
        model.setExtension(orgInfo.getExtension());
    }

    public void getAndSetLogo(Long orgId, OrgBaseInfoModel model) {
        OrgImgType imgType = OrgImgType.ORG_LOGO;
        List<OrgPhoto> photoes = orgPhotoDao.getByOrgIdAndCategory(orgId.intValue(), imgType.getValue());
        String photoUrl = imgType.getDefaultUrl();
        if (CollectionUtils.isNotEmpty(photoes)) {
            OrgStorage storage = orgStorageDao.getById(photoes.get(0).getOrgStorageId(), "fid", "sn", "mimeType");
            photoUrl = StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType());
        }
        model.setLogo(photoUrl);
    }

}
