package com.baijia.tianxiao.sal.organization.org.dto.auth;

import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.dto.BaseDto;
import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.util.Collections;
import java.util.List;

/**
 * Created by wengshengli on 2017/6/13.
 */
@Data
public class PcAccountCanSettingPermission extends BaseDto {

    private Long code;
    private String name;
    private Long parentCode;
    private List<PcAccountCanSettingPermission> subPermission;
    private Integer choosed;
    private Integer setting;

    public static PcAccountCanSettingPermission buildByTxPermission(TXPermission txPermission) {
        PcAccountCanSettingPermission result = new PcAccountCanSettingPermission();
        result.setCode(txPermission.getCode());
        result.setName(txPermission.getName());
        result.setParentCode(txPermission.getParentId());
        return result;
    }

    public static List<PcAccountCanSettingPermission> buildByTxPermissions(List<TXPermission> txPermissions) {
        if (CollectionUtils.isEmpty(txPermissions)) {
            return Collections.EMPTY_LIST;
        }
        List<PcAccountCanSettingPermission> result = Lists.newArrayList();
        for (TXPermission one : txPermissions) {
            result.add(buildByTxPermission(one));
        }
        return result;
    }

}
