/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.organization.org.dto;

import com.baijia.tianxiao.constant.AvatarConstants;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;


/**   
 * @title       : TxCascadeCredentialSelectionDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年6月16日 上午11:41:11 
 */
@Data
public class TxCascadeCredentialSelectionDto {
    private Integer cascadeId; //子账号id 主账号为0
    private String name;    //员工姓名
    private String avatarUrl;   //头像url
    private String initial;   //首字母
    private String userTypeStr;  //身份类型描述
    private String mobile;
    private String campusName;
    private String roleName;
    
    public static TxCascadeCredentialSelectionDto getInstance(TXCascadeCredential txCascadCredential, TXCascadeAccount txCascadeAccount){
        TxCascadeCredentialSelectionDto txCascadeCredentialDto = new TxCascadeCredentialSelectionDto();
        txCascadeCredentialDto.setCascadeId(txCascadeAccount.getId());
        txCascadeCredentialDto.setName(txCascadCredential.getName() == null ? txCascadCredential.getMobile() : txCascadCredential.getName());
        if(StringUtils.isNotBlank(txCascadCredential.getAvatar())){
            txCascadeCredentialDto.setAvatarUrl(txCascadCredential.getAvatar());
        }else {
            txCascadeCredentialDto.setAvatarUrl(AvatarConstants.STUFF_AVATAR_URL);
        }
        txCascadeCredentialDto.setUserTypeStr(CampusAccountType.getLabelByCode(txCascadeAccount.getAccountType()));
        txCascadeCredentialDto.setRoleName(CampusAccountType.getLabelByCode(txCascadeAccount.getAccountType()));
        return txCascadeCredentialDto;
    }
    
    public static TxCascadeCredentialSelectionDto getInstanceByOrgInfo(Integer type, OrgInfo orgInfo){
        TxCascadeCredentialSelectionDto txCascadeCredentialDto = new TxCascadeCredentialSelectionDto();
        txCascadeCredentialDto.setCascadeId(0);
        txCascadeCredentialDto.setName(orgInfo.getShowName());
        txCascadeCredentialDto.setAvatarUrl(AvatarConstants.STUFF_AVATAR_URL);
        txCascadeCredentialDto.setUserTypeStr(CampusAccountType.getLabelByCode(type));
        txCascadeCredentialDto.setRoleName(CampusAccountType.getLabelByCode(type));
        return txCascadeCredentialDto;
    }

}
