package com.baijia.tianxiao.sal.organization.constant;

import com.baijia.tianxiao.util.BaseUtils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.Getter;

/**
 * Created by wengshengli on 2017/3/24.
 */
public enum ClientType {

    HW(1, "作业系统", "tx201703221528", "baijiahulian", 185l),

    EXAM(2, "考试系统", "tx201703221528", "baijiahulian", 187l),

    GRADE(3, "成绩系统", "tx201704221528", "baijiahulian_grade", 189l),

    SCORE(4, "积分系统", "", "", 0l),

    CALL_SERVICE(5, "双呼", "", "", 0l),

    LIJIA_KEXIAO(6, "立加课消报表", "", "", 196l),

    TIMESCARD(7, "次卡管理", "", "", 0L),

    CUSTOM_COMMENT(8, "自定义评价项(规则设置&微信个人中心)", "", "", 0L),

    CUSTOM_RECORD_TEMPLATE(9, "自定义记录模板(规则设置&学员成长档案)", "", "", 0L),

    ;
    @Getter
    private int code;
    @Getter
    private String name;
    @Getter
    private String appId;
    @Getter
    private String secertKey;
    @Getter
    private Long permissionCode;

    private static final Map<Integer, ClientType> codeMap = Maps.newHashMap();

    static {
        for (ClientType clientType : ClientType.values()) {
            codeMap.put(clientType.getCode(), clientType);
        }
    }

    ClientType(int code, String name, String appId, String secertKey, Long permissionCode) {
        this.code = code;
        this.name = name;
        this.appId = appId;
        this.secertKey = secertKey;
        this.permissionCode = permissionCode;
    }

    public static ClientType getByCode(Integer code) {
        return codeMap.get(code);
    }

    /**
     * txAccount.getModuleAuth()
     * 
     * @param codeStr
     * @return
     */
    public static Collection<ClientType> getByCodes(String codeStr) {
        List<String> codes = BaseUtils.strToList(codeStr, ",");
        Set<ClientType> result = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(codes)) {
            codes.stream().filter(code -> StringUtils.isNumeric(code)).forEach(s -> {
                ClientType clientType = codeMap.get(Integer.valueOf(s));
                if (null != clientType) {
                    result.add(clientType);
                }
            });
        }
        return result;
    }
}
