/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.pcAuthority.constant.ApplicationType;
import com.baijia.tianxiao.dal.pcAuthority.constant.PermissionOperationType;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxAccountPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxRolePermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.ApplicationAuthConfig;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.dal.pcAuthority.po.TxAccountPermission;
import com.baijia.tianxiao.dal.pcAuthority.po.TxRolePermission;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.constant.ClientType;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.DoorgodUserRole;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionAccountType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionHasType;
import com.baijia.tianxiao.sal.organization.dto.AuthToken;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.AuthorityDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.PermissionDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAuthApplicationMenuService;
import com.baijia.tianxiao.sal.organization.org.service.TXPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TxAccountPermissionServiceImpl
implements TxAccountPermissionService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TxAccountPermissionServiceImpl.class);
    @Autowired
    private TxAccountPermissionDao txAccountPermissionDao;
    @Autowired
    private TXAuthApplicationMenuService txAuthApplicationMenuService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXPermissionService txPermissionService;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private TxRolePermissionDao txRolePermissionDao;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    private static final Integer TX_ACCOUNT_TYPE_FORMAL = 0;
    private static final Integer TX_ACCOUNT_TYPE_TRAIL = 1;
    public static OrgAccount trailOrgAccount;
    private static final List<PermissionDto> expermissinDefaultPermission;

    @Override
    @Deprecated
    public List<PermissionDto> listAllAuthModules(Integer pType, Integer deviceType, Long uId, Integer uType) {
        List permissions = this.txAccountPermissionDao.listAllConfigs(pType, deviceType, Integer.valueOf(uId.intValue()), uType);
        if (GenericsUtils.isNullOrEmpty((Object)permissions)) {
            return Collections.emptyList();
        }
        List pIds = ListUtil.toKeyList((Collection)permissions, (String)"pId", TxAccountPermission.class);
        ImmutableMap permissionMaps = Maps.uniqueIndex((Iterable)permissions, (Function)new Function<TxAccountPermission, Long>(){

            public Long apply(TxAccountPermission arg0) {
                return (long)arg0.getPId();
            }
        });
        List<ApplicationAuthConfig> findApplicationMenus = this.txAuthApplicationMenuService.findApplicationMenus(pIds);
        if (GenericsUtils.isNullOrEmpty(findApplicationMenus)) {
            return Collections.emptyList();
        }
        ArrayList<PermissionDto> retPermissions = new ArrayList<PermissionDto>(findApplicationMenus.size());
        for (ApplicationAuthConfig config : findApplicationMenus) {
            TxAccountPermission permission = (TxAccountPermission)permissionMaps.get(config.getId());
            Integer type = 0;
            if (permission != null) {
                type = permission.getPType();
            }
            PermissionDto pd = new PermissionDto();
            pd.setName(config.getModuleName());
            pd.setTag(config.getModuleCode());
            pd.setType(type);
            retPermissions.add(pd);
        }
        return retPermissions;
    }

    @Override
    public AuthorityDto findAuths(Long orgId, Integer casCadeId, Integer deviceType) {
        if (null != trailOrgAccount && orgId.intValue() == trailOrgAccount.getId().intValue()) {
            return this.findAuths(orgId, casCadeId, deviceType, TX_ACCOUNT_TYPE_TRAIL);
        }
        return this.findAuths(orgId, casCadeId, deviceType, TX_ACCOUNT_TYPE_FORMAL);
    }

    private List<PermissionDto> toExperiecceAccountPermissions() {
        Collection<TXPermission> txPermissionList = this.txPermissionService.getAllTXPermissionsCodeMap().values();
        ArrayList dtoList = Lists.newArrayList();
        for (TXPermission txp : txPermissionList) {
            PermissionDto dto = new PermissionDto();
            dto.setName(txp.getName());
            dto.setTag(txp.getCode().toString());
            dto.setType(TXPermissionHasType.OWN.getCode());
            dtoList.add(dto);
        }
        dtoList.addAll(expermissinDefaultPermission);
        return dtoList;
    }

    private List<PermissionDto> toTxPermissionDto(Long orgId, Integer cacadeId, List<TxAccountPermission> permissions, TXAccount superAccount) {
        log.info("TxAccountPermissionServiceImpl ->toTxPermissionDto=={},{},{},{},{}", new Object[]{orgId, cacadeId, permissions, superAccount});
        if (GenericsUtils.isNullOrEmpty(permissions)) {
            return Collections.emptyList();
        }
        ArrayList<TxAccountPermission> devicePermissions = new ArrayList<TxAccountPermission>();
        for (TxAccountPermission tap : permissions) {
            devicePermissions.add(tap);
        }
        log.info("find all txAccountPermissions, size:{} ", (Object)devicePermissions.size());
        List accountModuleAuth = null;
        if (superAccount != null && !StringUtils.isEmpty((String)superAccount.getModuleAuth())) {
            accountModuleAuth = BaseUtils.strToList((String)superAccount.getModuleAuth(), (String)",");
        }
        Map<Integer, TXPermission> allByPidMap = this.txPermissionService.getAllTXPermissionsIDMap();
        Map<Long, String> cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIds(orgId);
        Long cacadeIdLong = cacadeId == null ? 0L : cacadeId.longValue();
        ArrayList<PermissionDto> retDtos = new ArrayList<PermissionDto>();
        for (TxAccountPermission tap : devicePermissions) {
            Integer pId = tap.getPId();
            TXPermission tp = allByPidMap.get(pId);
            if (tp == null) continue;
            PermissionDto dto = new PermissionDto();
            dto.setName(tp.getName());
            dto.setTag(String.valueOf(tp.getCode()));
            dto.setType(tap.getPType());
            if (tap.getPType().intValue() == TXPermissionHasType.OWN.getCode()) {
                if ((long)tp.getCode().intValue() == TXPermissionConst.ASSIGNMENT_MENU.getpCode()) {
                    log.debug("[TXPermission code]={},[accountModuleAuth]={}", (Object)tp.getCode(), (Object)accountModuleAuth);
                    if (CollectionUtils.isNotEmpty((Collection)accountModuleAuth) && accountModuleAuth.contains(String.valueOf(ClientType.HW.getCode()))) {
                        dto.setUrl(AuthToken.assignMentToken(orgId, cacadeIdLong, cascadeMap.get(cacadeIdLong), DoorgodUserRole.STAFF.getRole(), ClientType.HW));
                    } else {
                        dto.setType(TXPermissionHasType.LOST.getCode());
                    }
                } else if ((long)tp.getCode().intValue() == TXPermissionConst.EXAM_MENU.getpCode()) {
                    log.debug("[TXPermission code]={},[accountModuleAuth]={}", (Object)tp.getCode(), (Object)accountModuleAuth);
                    if (CollectionUtils.isNotEmpty((Collection)accountModuleAuth) && accountModuleAuth.contains(String.valueOf(ClientType.EXAM.getCode()))) {
                        dto.setUrl(AuthToken.assignMentToken(orgId, cacadeIdLong, cascadeMap.get(cacadeIdLong), DoorgodUserRole.STAFF.getRole(), ClientType.EXAM));
                    } else {
                        dto.setType(TXPermissionHasType.LOST.getCode());
                    }
                } else if ((long)tp.getCode().intValue() == TXPermissionConst.GRADE_MENU.getpCode()) {
                    log.debug("[TXPermission code]={},[accountModuleAuth]={}", (Object)tp.getCode(), (Object)accountModuleAuth);
                    if (CollectionUtils.isNotEmpty((Collection)accountModuleAuth) && accountModuleAuth.contains(String.valueOf(ClientType.GRADE.getCode()))) {
                        dto.setUrl(AuthToken.assignMentToken(orgId, cacadeIdLong, cascadeMap.get(cacadeIdLong), DoorgodUserRole.STAFF.getRole(), ClientType.GRADE));
                    } else {
                        dto.setType(TXPermissionHasType.LOST.getCode());
                    }
                }
            }
            retDtos.add(dto);
        }
        return retDtos;
    }

    private List<TxAccountPermission> pickPermissions(List<TxAccountPermission> Permissions, Set<Long> ... controlSet) {
        Map<Integer, TXPermission> allPIdMap = this.txPermissionService.getAllTXPermissionsIDMap();
        LinkedList result = Lists.newLinkedList();
        HashSet allSet = Sets.newHashSet();
        Arrays.stream(controlSet).forEach(set -> allSet.addAll(set));
        for (TxAccountPermission tap : Permissions) {
            if (!allSet.contains(allPIdMap.get(tap.getPId()).getCode())) continue;
            result.add(tap);
        }
        return result;
    }

    @Override
    public List<TxAccountPermission> getAllPByUidLevelRoleDevice(Long orgId, Integer cascadeId, Integer vipLevel, Integer role, Integer device) {
        List txRolePermissions = this.txRolePermissionDao.getTxRolePermissionsByVipLevelAndRole(vipLevel, role, device);
        List<TxAccountPermission> defaultPermissions = this.buildPermissions(txRolePermissions);
        log.debug("the defaultPermissions size:{},{},{},{},{},{}", new Object[]{orgId, cascadeId, vipLevel, role, device, defaultPermissions});
        log.debug("the defaultPermissions size:{}", (Object)defaultPermissions.size());
        if (null != cascadeId) {
            HashMap PCMap = Maps.newHashMap();
            HashMap APPMap = Maps.newHashMap();
            List<TxAccountPermission> txAccountPermissions = this.txAccountPermissionDao.listAllConfigs(null, device, cascadeId, Integer.valueOf(TXPermissionAccountType.CASCADE_ACCOUNT.getCode()));
            OrgSubAccount orgSubAccount = this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId.intValue()), new String[0]);
            Integer onlineType = orgSubAccount.getOnlineType();
            Integer pid = orgSubAccount.getPid();
            txAccountPermissions = onlineType.intValue() == Flag.TRUE.getInt() ? this.pickPermissions(txAccountPermissions, TXPermissionConst.WANGXIAO_PERMISSION_SET) : (onlineType.intValue() == Flag.FALSE.getInt() ? (pid == 0 && role == RoleType.CHARAGE.type ? this.pickPermissions(txAccountPermissions, TXPermissionConst.NORMAL_PERMISSION_SET, TXPermissionConst.MAIN_CAMPUS_MANAGER_ADDITIONAL_PERMISSION_SET) : this.pickPermissions(txAccountPermissions, TXPermissionConst.NORMAL_PERMISSION_SET)) : this.pickPermissions(txAccountPermissions, TXPermissionConst.PERMISSION_SAVE_CONTROL_SET));
            log.debug("after pick the permission list size:{}", (Object)txAccountPermissions.size());
            if (CollectionUtils.isNotEmpty(txAccountPermissions)) {
                for (TxAccountPermission p : txAccountPermissions) {
                    if (p.getDeviceType().equals(DeviceType.PC.getCode())) {
                        PCMap.put(p.getPId(), p.getPType());
                    }
                    if (!p.getDeviceType().equals(DeviceType.APP.getCode())) continue;
                    APPMap.put(p.getPId(), p.getPType());
                }
            }
            for (TxAccountPermission tap : defaultPermissions) {
                if (tap.getDeviceType().equals(DeviceType.PC.getCode()) && PCMap.containsKey(tap.getPId())) {
                    tap.setPType((Integer)PCMap.get(tap.getPId()));
                }
                if (!tap.getDeviceType().equals(DeviceType.APP.getCode()) || !APPMap.containsKey(tap.getPId())) continue;
                tap.setPType((Integer)APPMap.get(tap.getPId()));
            }
            this.oneMultiControl(defaultPermissions);
        }
        return defaultPermissions;
    }

    private void oneMultiControl(List<TxAccountPermission> defaultPermissions) {
        Map<Integer, TXPermission> allPIdMap = this.txPermissionService.getAllTXPermissionsIDMap();
        HashSet lostKeyCodes = Sets.newHashSet();
        HashSet ownKeyCodes = Sets.newHashSet();
        for (TxAccountPermission tap : defaultPermissions) {
            if (!TXPermissionConst.ONE_MULTY_CODE_MAP.containsKey((Object)allPIdMap.get(tap.getPId()).getCode())) continue;
            if (tap.getPType().intValue() == TXPermissionHasType.LOST.getCode()) {
                lostKeyCodes.addAll(TXPermissionConst.ONE_MULTY_CODE_MAP.get((Object)allPIdMap.get(tap.getPId()).getCode()));
                continue;
            }
            if (tap.getPType().intValue() != TXPermissionHasType.OWN.getCode()) continue;
            ownKeyCodes.addAll(TXPermissionConst.ONE_MULTY_CODE_MAP.get((Object)allPIdMap.get(tap.getPId()).getCode()));
        }
        log.info("lostKeyCodes is:{}", (Object)lostKeyCodes);
        log.info("ownKeyCodes is:{}", (Object)ownKeyCodes);
        for (TxAccountPermission tap : defaultPermissions) {
            if (lostKeyCodes.contains(allPIdMap.get(tap.getPId()).getCode())) {
                tap.setPType(Integer.valueOf(TXPermissionHasType.LOST.getCode()));
            }
            if (!ownKeyCodes.contains(allPIdMap.get(tap.getPId()).getCode())) continue;
            tap.setPType(Integer.valueOf(TXPermissionHasType.OWN.getCode()));
        }
    }

    private List<TxAccountPermission> buildPermissions(List<TxRolePermission> txRolePermissions) {
        ArrayList result = Lists.newArrayList();
        for (TxRolePermission trp : txRolePermissions) {
            TxAccountPermission tap = new TxAccountPermission();
            tap.setPId(trp.getPId());
            tap.setPType(trp.getPType());
            tap.setUType(Integer.valueOf(0));
            tap.setDeviceType(trp.getDeviceType());
            result.add(tap);
        }
        return result;
    }

    @Override
    public Map<Integer, TxAccountPermission> getPMapByUidLevelRoleDevice(Long orgId, Integer uid, Integer vipLevel, Integer role, Integer device) {
        if (null != device) {
            HashMap data = Maps.newHashMap();
            List<TxAccountPermission> list = this.getAllPByUidLevelRoleDevice(orgId, uid, vipLevel, role, device);
            for (TxAccountPermission txAccountPermission : list) {
                data.put(txAccountPermission.getPId(), txAccountPermission);
            }
            log.debug("the length of TxAccountPermission pMap is{}", (Object)data.size());
            return data;
        }
        HashMap data = Maps.newHashMap();
        List<TxAccountPermission> list = this.getAllPByUidLevelRoleDevice(orgId, uid, vipLevel, role, device);
        for (TxAccountPermission txAccountPermission : list) {
            data.put(txAccountPermission.getPId(), txAccountPermission);
        }
        for (TxAccountPermission txAccountPermission : list) {
            if (txAccountPermission.getPType().intValue() != TXPermissionHasType.OWN.getCode()) continue;
            data.put(txAccountPermission.getPId(), txAccountPermission);
        }
        log.debug("the length of TxAccountPermission pMap is{}", (Object)data.size());
        return data;
    }

    @Override
    public void saveAll(List<TxAccountPermission> txAccountPermissions) {
        this.txAccountPermissionDao.saveAll(txAccountPermissions, new String[0]);
    }

    @Override
    public void updateAll(List<TxAccountPermission> txAccountPermissions) {
        if (CollectionUtils.isNotEmpty(txAccountPermissions)) {
            for (TxAccountPermission txAccountPermission : txAccountPermissions) {
                this.txAccountPermissionDao.update((Object)txAccountPermission, new String[0]);
            }
        }
    }

    @Override
    @Deprecated
    public boolean hasPermission(Long cascadeId, ApplicationType deviceType, TXPermissionConst permission) {
        ArrayList<Long> codes = new ArrayList<Long>();
        codes.add(permission.getpCode());
        List<TXPermission> permissionList = this.txPermissionService.getTXPermissionsList(codes);
        if (CollectionUtils.isEmpty(permissionList)) {
            return false;
        }
        TxAccountPermission txAccountPermission = this.txAccountPermissionDao.getTxAccountPermission(permissionList.get(0).getId(), deviceType.type, Integer.valueOf(cascadeId.intValue()));
        return txAccountPermission != null && txAccountPermission.getPType().equals(PermissionOperationType.CAN_USE.type);
    }

    @Override
    public AuthorityDto findAuths(Long orgId, Integer casCadeId, Integer deviceType, Integer accountTypeOfUser) {
        if (accountTypeOfUser == null) {
            accountTypeOfUser = TX_ACCOUNT_TYPE_FORMAL;
        }
        AuthorityDto authorityDto = new AuthorityDto();
        RoleType superRole = null;
        TXAccount superAccount = null;
        List<PermissionDto> permissionDtos = null;
        try {
            if (casCadeId != null && (long)casCadeId.intValue() != 0L) {
                TXCascadeAccount tca = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)casCadeId, new String[0]);
                OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(tca.getOrgId(), new String[0]);
                superAccount = 0 == osa.getPid() ? this.txAccountService.getByOrgId(tca.getOrgId(), new String[0]) : this.txAccountService.getByOrgId(osa.getPid(), new String[0]);
                superRole = RoleType.getRoleType((Integer)tca.getAccountType());
            } else {
                OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId.intValue()), new String[0]);
                superAccount = 0 == osa.getPid() ? this.txAccountService.getByOrgId(orgId.intValue(), new String[0]) : this.txAccountService.getByOrgId(osa.getPid(), new String[0]);
                superRole = 0 == osa.getPid() ? RoleType.PRESIDENT : RoleType.BRANCH_SCH_PRESIDENT;
            }
            Preconditions.checkNotNull((Object)superAccount);
        }
        catch (NullPointerException npe) {
            log.warn("getAuth cannot get the TXAccount by orgId:{},cascadeId:{},error:{}", new Object[]{orgId, casCadeId, npe});
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NEED_RE_LOGIN, "\u62b1\u6b49\uff0c\u65e0\u6cd5\u67e5\u8be2\u5230\u60a8\u7684\u8d26\u6237\u4fe1\u606f\u3002");
        }
        log.info("orgId is :{},cascadeId is:{} roleType is : {}, accountTypeOfUser is:{} ", new Object[]{orgId, casCadeId, superRole, accountTypeOfUser});
        List<TxAccountPermission> permissions = null;
        if (superRole == RoleType.CHARAGE || superRole == RoleType.EMPLOYEE) {
            permissions = this.getAllPByUidLevelRoleDevice(orgId, casCadeId, superAccount.getVipLevel(), superRole.type, deviceType);
            log.info("convert to txPermissionDto with : {} ", (Object)permissions.size());
            permissionDtos = this.toTxPermissionDto(orgId, casCadeId, permissions, superAccount);
        } else if (superRole == RoleType.PRESIDENT || superRole == RoleType.BRANCH_SCH_PRESIDENT) {
            permissions = this.getAllPByUidLevelRoleDevice(orgId, null, superAccount.getVipLevel(), superRole.type, deviceType);
            log.info("convert to txPermissionDto with : {} ", (Object)permissions.size());
            permissionDtos = this.toTxPermissionDto(orgId, casCadeId, permissions, superAccount);
        }
        if (accountTypeOfUser == TX_ACCOUNT_TYPE_TRAIL) {
            permissionDtos.addAll(expermissinDefaultPermission);
        }
        authorityDto.setRole(superRole.type.longValue());
        authorityDto.setRoleName(superRole.desc);
        authorityDto.setHasPermissions(permissionDtos);
        if (null != superAccount && superAccount.getVipLevel().equals(TXAccountType.DAZHONG.getCode())) {
            authorityDto.setVipName(TXAccountType.DAZHONG.getLabel());
        }
        return authorityDto;
    }

    @Override
    public List<TxAccountPermission> getAccountPermission(Integer uid, Integer pid) {
        List txAccountPermissions = this.txAccountPermissionDao.geTxAccountPermission(pid, uid);
        return txAccountPermissions;
    }

    @Override
    public List<TxAccountPermission> getAccountPermission(Integer uid, List<Integer> pid) {
        List txAccountPermissions = this.txAccountPermissionDao.geTxAccountPermission(pid, uid);
        return txAccountPermissions;
    }

    @Override
    public TxAccountPermissionsDto universalGetPermissions(int orgId, Integer cascadeId) {
        TxAccountPermissionsDto result = null;
        List plist = null;
        OrgSubAccount subAcc = null;
        TXAccount superAcc = null;
        subAcc = this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId), new String[0]);
        if (0 == subAcc.getPid()) {
            superAcc = this.txAccountService.getByOrgId(orgId, new String[0]);
            if (superAcc == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.INVALIDATE_CLIENTID, "\u4e3b\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u5df2\u6682\u505c\u4f7f\u7528");
            }
        } else {
            superAcc = this.txAccountService.getByOrgId(subAcc.getPid(), new String[0]);
        }
        log.debug("universalGetPermissions param is[ orgId:{},cascadeId:{}],superAcc:{}", new Object[]{orgId, cascadeId, superAcc});
        if (null == cascadeId || 0 == cascadeId) {
            if (0 == subAcc.getPid()) {
                plist = this.txRolePermissionDao.getTxRolePermissionsByVipLevelAndRole(superAcc.getVipLevel(), RoleType.PRESIDENT.type);
                result = this.rolePermissionsToDto(orgId, cascadeId, plist);
            } else if (0 != subAcc.getPid()) {
                plist = this.txRolePermissionDao.getTxRolePermissionsByVipLevelAndRole(superAcc.getVipLevel(), RoleType.BRANCH_SCH_PRESIDENT.type);
                result = this.rolePermissionsToDto(orgId, cascadeId, plist);
            }
        } else {
            TXCascadeAccount txCasAcc = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            List<TxAccountPermission> txAccountPermissions = this.getAllPByUidLevelRoleDevice(new Long(orgId), cascadeId, superAcc.getVipLevel(), txCasAcc.getAccountType(), null);
            result = this.buildDto2(orgId, cascadeId, txAccountPermissions);
        }
        return result;
    }

    private TxAccountPermissionsDto buildDto2(int orgId, Integer cascadeId, List<TxAccountPermission> txAccountPermissions) {
        Map<Integer, TXPermission> pMap = this.txPermissionService.getAllTXPermissionsIDMap();
        TxAccountPermissionsDto result = new TxAccountPermissionsDto();
        result.setOrgID(orgId);
        result.setCascadeId(cascadeId);
        ArrayList PCps = Lists.newArrayList();
        ArrayList APPps = Lists.newArrayList();
        for (TxAccountPermission rp : txAccountPermissions) {
            TXPermission permission = pMap.get(rp.getPId());
            if (rp.getDeviceType().equals(DeviceType.PC.getCode())) {
                PCps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), permission.getCode(), permission.getName(), rp.getPType(), rp.getDeviceType()));
                continue;
            }
            if (!rp.getDeviceType().equals(DeviceType.APP.getCode())) continue;
            APPps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), permission.getCode(), permission.getName(), rp.getPType(), rp.getDeviceType()));
        }
        result.setPCps(PCps);
        result.setAPPps(APPps);
        return result;
    }

    private TxAccountPermissionsDto rolePermissionsToDto(int orgId, Integer cascadeId, List<TxRolePermission> plist) {
        log.debug("rolePermissionsToDto the input rolePermissions list size is{}", (Object)plist.size());
        Map<Integer, TXPermission> pIdMap = this.txPermissionService.getAllTXPermissionsIDMap();
        TxAccountPermissionsDto result = new TxAccountPermissionsDto();
        result.setOrgID(orgId);
        result.setCascadeId(cascadeId);
        ArrayList PCps = Lists.newArrayList();
        ArrayList APPps = Lists.newArrayList();
        for (TxRolePermission rp : plist) {
            if (rp.getDeviceType().equals(DeviceType.PC.getCode())) {
                PCps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), rp.getPCode(), pIdMap.get(rp.getPId()).getName(), rp.getPType(), rp.getDeviceType()));
                continue;
            }
            if (!rp.getDeviceType().equals(DeviceType.APP.getCode())) continue;
            APPps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), rp.getPCode(), pIdMap.get(rp.getPId()).getName(), rp.getPType(), rp.getDeviceType()));
        }
        result.setPCps(PCps);
        result.setAPPps(APPps);
        return result;
    }

    @Override
    public TxAccountPermissionsDto universalGetPermissions(int orgId, Integer cascadeId, Collection<Long> pCodes) {
        TxAccountPermissionsDto result = null;
        if (CollectionUtils.isEmpty(pCodes)) {
            result = new TxAccountPermissionsDto();
            result.setOrgID(orgId);
            result.setCascadeId(cascadeId);
            result.setAPPps(new ArrayList<TxAccountPermissionsDto.AccountPermissionDto>());
            result.setPCps(new ArrayList<TxAccountPermissionsDto.AccountPermissionDto>());
            return result;
        }
        List plist = null;
        OrgSubAccount subAcc = null;
        TXAccount superAcc = null;
        subAcc = this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId), new String[0]);
        superAcc = 0 == subAcc.getPid() ? this.txAccountService.getByOrgIdIgnoreStatus(orgId, new String[0]) : this.txAccountService.getByOrgIdIgnoreStatus(subAcc.getPid(), new String[0]);
        if (null == cascadeId || 0 == cascadeId) {
            if (0 == subAcc.getPid()) {
                plist = this.txRolePermissionDao.getTxRolePermissionsByCodes(superAcc.getVipLevel(), RoleType.PRESIDENT.type, pCodes);
                result = this.rolePermissionsToDto(orgId, cascadeId, plist);
            }
            if (0 != subAcc.getPid()) {
                plist = this.txRolePermissionDao.getTxRolePermissionsByCodes(superAcc.getVipLevel(), RoleType.BRANCH_SCH_PRESIDENT.type, pCodes);
                result = this.rolePermissionsToDto(orgId, cascadeId, plist);
            }
        } else {
            TXCascadeAccount txCasAcc = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            List<TxAccountPermission> txAccountPermissions = this.getAllPByUidLevelRoleDevice(new Long(orgId), cascadeId, superAcc.getVipLevel(), txCasAcc.getAccountType(), null);
            result = this.buildDtoByFilter(orgId, cascadeId, txAccountPermissions, pCodes);
        }
        return result;
    }

    private TxAccountPermissionsDto buildDtoByFilter(int orgId, Integer cascadeId, List<TxAccountPermission> txAccountPermissions, Collection<Long> pCodes) {
        Map<Integer, TXPermission> pMap = this.txPermissionService.getAllTXPermissionsIDMap();
        TxAccountPermissionsDto result = new TxAccountPermissionsDto();
        result.setOrgID(orgId);
        result.setCascadeId(cascadeId);
        ArrayList PCps = Lists.newArrayList();
        ArrayList APPps = Lists.newArrayList();
        HashSet pCodeSet = Sets.newHashSet(pCodes);
        for (TxAccountPermission rp : txAccountPermissions) {
            TXPermission permission = pMap.get(rp.getPId());
            if (!pCodeSet.contains(permission.getCode())) continue;
            if (rp.getDeviceType().equals(DeviceType.PC.getCode())) {
                PCps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), permission.getCode(), permission.getName(), rp.getPType(), rp.getDeviceType()));
                continue;
            }
            if (!rp.getDeviceType().equals(DeviceType.APP.getCode())) continue;
            APPps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), permission.getCode(), permission.getName(), rp.getPType(), rp.getDeviceType()));
        }
        result.setAPPps(APPps);
        result.setPCps(PCps);
        return result;
    }

    public void afterPropertiesSet() throws Exception {
        String numberStr = null;
        String url = null;
        try {
            HashMap params = Maps.newHashMap();
            params.put("resource", "tianxiao_trial_account");
            try {
                url = PropertiesReader.getValue((String)"hag", (String)"hag.http.url.downloadList");
            }
            catch (MissingResourceException mre) {
                log.warn("this project donot contains hag.properties file! the trial orgAccount won't be initialized!");
                return;
            }
            String response = HttpClientUtils.doPost((String)url, (Map)params);
            log.info("hagResponse:{}", (Object)response);
            HagDownload hagDto = (HagDownload)JacksonUtil.str2Obj((String)response, HagDownload.class);
            log.info("hagDto:{}", (Object)hagDto);
            if (hagDto == null || CollectionUtils.isEmpty(hagDto.getData())) {
                return;
            }
            numberStr = hagDto.getData().get(0).split("#")[0];
            Integer number = Integer.parseInt(numberStr);
            trailOrgAccount = this.orgAccountDao.getAccountByNumber(number, new String[0]);
            log.info("the orgAccount which is get from hag is:{}", (Object)trailOrgAccount);
        }
        catch (Exception e) {
            log.error("get orgAccount by hag error!", (Throwable)e);
            trailOrgAccount = this.orgAccountDao.getAccountByNumber(Integer.valueOf(458130179), new String[0]);
        }
    }

    @Override
    public boolean checkPermission(Long orgId, Integer cascadeId, DeviceType deviceType, Long pCode) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((deviceType != null && pCode != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u9519\u8bef");
        boolean hasPermission = false;
        TxAccountPermissionsDto permissions = this.universalGetPermissions(orgId.intValue(), cascadeId, Sets.newHashSet((Object[])new Long[]{pCode}));
        if (permissions != null) {
            TxAccountPermissionsDto.AccountPermissionDto permissionDto = null;
            if (deviceType.getCode() == DeviceType.APP.getCode() && CollectionUtils.isNotEmpty(permissions.getAPPps())) {
                permissionDto = permissions.getAPPps().get(0);
            } else if (deviceType.getCode() == DeviceType.PC.getCode() && CollectionUtils.isNotEmpty(permissions.getPCps())) {
                permissionDto = permissions.getPCps().get(0);
            }
            if (permissionDto.getPCode().longValue() == pCode.longValue() && permissionDto.getPType() == 0) {
                hasPermission = true;
            }
        }
        return hasPermission;
    }

    static {
        expermissinDefaultPermission = new ArrayList<PermissionDto>();
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u6821\u9a8c\u8f93\u5165\u7684\u652f\u4ed8\u5bc6\u7801", "10601", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u63d0\u73b0", "10602", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u6536\u6b3e\u9875\u9762", "10302", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u6dfb\u52a0\u673a\u6784\u7535\u8bdd", "4060302", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u5220\u9664\u673a\u6784\u7535\u8bdd", "4060301", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u7f16\u8f91\u673a\u6784\u7535\u8bdd", "4060303", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u8bbe\u7f6e\u652f\u4ed8\u5bc6\u7801", "10603", 1));
    }

    private static class HagDownload {
        private Integer status;
        private List<String> data;
        private Object errorcode;

        public Integer getStatus() {
            return this.status;
        }

        public List<String> getData() {
            return this.data;
        }

        public Object getErrorcode() {
            return this.errorcode;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public void setData(List<String> data) {
            this.data = data;
        }

        public void setErrorcode(Object errorcode) {
            this.errorcode = errorcode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HagDownload)) {
                return false;
            }
            HagDownload other = (HagDownload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$status = this.getStatus();
            Integer other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            List<String> this$data = this.getData();
            List<String> other$data = other.getData();
            if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
                return false;
            }
            Object this$errorcode = this.getErrorcode();
            Object other$errorcode = other.getErrorcode();
            return !(this$errorcode == null ? other$errorcode != null : !this$errorcode.equals(other$errorcode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HagDownload;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            List<String> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            Object $errorcode = this.getErrorcode();
            result = result * 59 + ($errorcode == null ? 43 : $errorcode.hashCode());
            return result;
        }

        public String toString() {
            return "TxAccountPermissionServiceImpl.HagDownload(status=" + this.getStatus() + ", data=" + this.getData() + ", errorcode=" + this.getErrorcode() + ")";
        }
    }
}

