/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.constants.SmsGateGroup;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TXAccountServiceImpl
implements TXAccountService {
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;

    @Override
    public TXAccount getByOrgId(Integer orgId, String ... props) {
        TXAccount account = this.txAccountDao.getByOrgId(orgId, TXAccountStatus.VALID.getCode(), props);
        return account;
    }

    @Override
    public TXAccount getByOrgIdIgnoreStatus(Integer orgId, String ... props) {
        TXAccount account = this.txAccountDao.getByOrgId(orgId, null, props);
        return account;
    }

    @Override
    public TXAccount getByIdAndOrgId(Integer id, Integer orgId) {
        TXAccount account = this.txAccountDao.getByIdAndOrgId(id, orgId);
        return account;
    }

    @Override
    public TXAccount getByOrgNumber(Integer orgNumber) {
        TXAccount txAccount = this.txAccountDao.getByOrgNumber(orgNumber);
        return txAccount;
    }

    @Override
    public TXAccount getTXAccountByOrgId(Integer orgId, String ... props) {
        OrgSubAccount subAcc = this.orgSubAccountDao.getByOrgId(orgId, new String[0]);
        TXAccount superAcc = null;
        superAcc = 0 == subAcc.getPid() ? this.getByOrgId(orgId, props) : this.getByOrgId(subAcc.getPid(), props);
        return superAcc;
    }

    @Override
    public Integer getTxAccountSmsGate(Integer orgId) {
        if (orgId == null) {
            return SmsGateGroup.DEFAULT_SMS_GATE;
        }
        TXAccount txAccount = this.getTXAccountByOrgId((int)orgId, new String[0]);
        if (txAccount == null) {
            return SmsGateGroup.DEFAULT_SMS_GATE;
        }
        return txAccount.getSmsGate();
    }

    @Override
    public void saveTXAccount(TXAccount txAccount) {
        this.txAccountDao.save((Object)txAccount, new String[0]);
    }

    @Override
    public TXAccount getByMobile(String mobile) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountByMobile(mobile);
        TXAccount txAccount = null;
        if (orgAccount != null) {
            txAccount = this.txAccountDao.getByOrgId(orgAccount.getId(), TXAccountStatus.VALID.getCode(), new String[0]);
        }
        return txAccount;
    }
}

