/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXSaleClueRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.sal.organization.constant.TXSaleClueRuleValue;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author caoliang
 * @version 1.0
 * @title TXSaleClueRuleServiceImpl
 * @desc O(∩_∩)O~
 * @date 2016年6月1日
 */

@Service
public class TXSaleClueRuleServiceImpl implements TXSaleClueRuleService {

    @Autowired
    private TXSaleClueRuleDao txSaleClueRuleDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;

    @Override
    public TXSaleClueRule getByOrgId(Integer orgId) {
        TXSaleClueRule txSaleClueRule = txSaleClueRuleDao.getByOrgId(orgId);
        if (txSaleClueRule == null) {
            txSaleClueRule = new TXSaleClueRule();
            txSaleClueRule.setClueAllot(TXSaleClueRuleValue.CLUEALLOT_STAFF_CAN_HAVE.getCode());
            txSaleClueRule.setClueTransValid(TXSaleClueRuleValue.CLUETRANSVALID_PRIVATE.getCode());
            txSaleClueRule.setCreateTime(new Date());
            txSaleClueRule.setMaxClueCount(TXSaleClueRuleValue.MAXCLUECOUNT.getCode());
            txSaleClueRule.setMaxClueDelay(TXSaleClueRuleValue.MAXCLUEDELAY.getCode());
            txSaleClueRule.setOrgId(orgId);
            txSaleClueRule.setAttendClassMsg(TXSaleClueRuleValue.SEND_MSG.getCode());
            txSaleClueRule.setSigninMsg(TXSaleClueRuleValue.SEND_MSG.getCode());
            txSaleClueRule.setEvaluateMsg(TXSaleClueRuleValue.SEND_MSG.getCode());
            txSaleClueRule.setSignupMsg(TXSaleClueRuleValue.SEND_MSG.getCode());
            OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
            if (orgAccount != null) {
                txSaleClueRule.setOrgNumber(orgAccount.getNumber());
            }
            txSaleClueRule.setReturnClue(TXSaleClueRuleValue.RETURNCLUE_CAN.getCode());
            // txSaleClueRuleDao.save(txSaleClueRule);
        }
        TXAccount txAccount = txAccountDao.getByOrgId(orgId, TXAccountStatus.VALID.getCode());
        boolean forbidSms = false;
        if (txAccount == null) {
            OrgSubAccount orgSubAccount = orgSubAccountDao.getByOrgId(orgId);
            if (orgSubAccount == null) {
                forbidSms = true;
            } else {
                txAccount = txAccountDao.getByOrgId(orgSubAccount.getPid(), TXAccountStatus.VALID.getCode());
                if (txAccount == null || txAccount.getVipLevel() == TXAccountType.DAZHONG.getCode().intValue()) {
                    forbidSms = true;
                }
            }
        } else if (txAccount.getVipLevel() == TXAccountType.DAZHONG.getCode().intValue()) {
            forbidSms = true;
        }
        if (forbidSms) {
            txSaleClueRule.setAttendClassMsg(TXSaleClueRuleValue.DONOT_SEND_MSG.getCode());
            txSaleClueRule.setSigninMsg(TXSaleClueRuleValue.DONOT_SEND_MSG.getCode());
            txSaleClueRule.setEvaluateMsg(TXSaleClueRuleValue.DONOT_SEND_MSG.getCode());
            txSaleClueRule.setSignupMsg(TXSaleClueRuleValue.DONOT_SEND_MSG.getCode());
        }
        return txSaleClueRule;
    }

    @Override
    public void saveTXSaleClueRule(TXSaleClueRule txSaleClueRule) {
        txSaleClueRuleDao.saveOrUpdate(txSaleClueRule);
    }

    @Override
    public Map<Integer, TXSaleClueRule> queryByIds(Collection<Integer> idList) {
        List<TXSaleClueRule> list = txSaleClueRuleDao.queryByOrgIds(idList);
        Map<Integer, TXSaleClueRule> map = new HashMap<Integer, TXSaleClueRule>();
        for (TXSaleClueRule rule : list) {
            Integer orgId = rule.getOrgId();
            if (orgId != null) {
                map.put(orgId, rule);
            }
        }
        return map;

    }
}
