
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved. Baijiahulian.com Inc. Copyright (c) 2014-2016 All
 * Rights Reserved. Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCommonRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.sal.organization.constant.TXCommonRuleValue;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;

/**
 * @title TXCommonServiceImpl
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年6月1日
 * @version 1.0
 */

@Service
public class TXCommonServiceImpl implements TXCommonRuleService {

    @Autowired
    private TXCommonRuleDao txCommonRuleDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXAccountService txAccountService;

    @Override
    public TXCommonRule getByOrgId(Integer orgId) {
        TXCommonRule txCommonRule = txCommonRuleDao.getByOrgId(orgId);
        if (txCommonRule == null) {
            txCommonRule = new TXCommonRule();
            txCommonRule.setCallMobileRule(TXCommonRuleValue.NOT_USE_OWN_MOBILE_CALL.getCode());
            txCommonRule.setCreateTime(new Date());
            txCommonRule.setOrgId(orgId);
            OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
            txCommonRule.setOrgNumber(orgAccount.getNumber());
            txCommonRule.setStudentMobileRule(TXCommonRuleValue.STUDENT_MOBILE_NOT_DISPLAY.getCode());
            txCommonRule.setCallSendMsgRule(TXCommonRuleValue.NOT_SEND_MSG_AFTER_CALL.getCode());

            // txCommonRuleDao.save(txCommonRule);
        }
        if (txCommonRule.getConsumeRule() == null) {
            txCommonRule.setConsumeRule(TXCommonRuleValue.DEFAULT_CONSUME_RULE.getCode());
        }
        if (txCommonRule.getVipConsumeRule() == null) {
            txCommonRule.setVipConsumeRule(TXCommonRuleValue.DEFAULT_VIP_CONSUME_RULE.getCode());// 设置一对一默认的课消规则
        }
        TXAccount txAccount = txAccountService.getByOrgId(orgId);
        if (txAccount != null && txAccount.getVipLevel() == TXAccountType.DAZHONG.getCode().intValue()) {
            txCommonRule.setCallMobileRule(TXCommonRuleValue.USE_OWN_MOBILE_CALL.getCode());
            txCommonRule.setStudentMobileRule(TXCommonRuleValue.STUDENT_MOBILE_DISPLAY.getCode());
        }
        return txCommonRule;
    }

    @Override
    public void saveTXCommonRule(TXCommonRule txCommonRule) {
        txCommonRuleDao.saveOrUpdate(txCommonRule);
    }
}
