package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.dao.OrgTemplateCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgTemplateCourse;
import com.baijia.tianxiao.sal.organization.org.dto.TemplateCourseDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgTemplateCourseService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/1/28
 * Time: 下午3:51
 * To change this template use File | Settings | File Templates.
 */
@Service
@Slf4j
public class OrgTemplateCourseServiceImpl implements OrgTemplateCourseService {

    @Resource
    private OrgTemplateCourseDao orgTemplateCourseDao;

    @Override
    public void batchEdit(int orgId, int templateId, Map<Integer, List<TemplateCourseDto>> templateCourseDtoMap) {

        log.debug("orgid={},templateId={},templateCourse={}", orgId, templateId, templateCourseDtoMap);
        List<Integer> modules = new ArrayList(templateCourseDtoMap.keySet());
        if (!modules.isEmpty()) {
            orgTemplateCourseDao.delByModule(orgId, templateId, modules);
            log.debug("delete old module course success..");

            List<OrgTemplateCourse> result = Lists.newArrayList();
            Date now = new Date();
            for (Integer module : modules) {
                List<TemplateCourseDto> templateCourseDtos = templateCourseDtoMap.get(module);
                for (int i = 0; i < templateCourseDtos.size(); i++) {
                    TemplateCourseDto dto = templateCourseDtos.get(i);

                    OrgTemplateCourse one = new OrgTemplateCourse();
                    one.setOrgId(orgId);
                    one.setTemplateId(templateId);
                    one.setCourseId(dto.getCourseId());
                    one.setCourseType(dto.getCourseType());
                    one.setDisplayOrder(i);
                    one.setCreateTime(now);
                    one.setUpdateTime(now);
                    one.setModuleType(module);
                    one.setIsDel(DataStatus.NORMAL.getValue());
                    result.add(one);
                }
            }

            orgTemplateCourseDao.saveAll(result);
            log.debug("save new module couse success..");
        }
    }


    @Override
    public List<OrgTemplateCourse> getByOrgIdTemplate(int orgId, Integer templateId, int module) {
        if (templateId == null) {
            log.error("templateId is  null");
        }
        List<OrgTemplateCourse> list = orgTemplateCourseDao.getByModule(orgId, templateId, module);

        log.info("getByOrgIdTemplate====orgId={},templateId={},module={},list={}", orgId, templateId, module,list);

        if (list == null || list.isEmpty()) {
            list = Lists.newArrayList();
        }

        return list;
    }
}
