
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.OrgCourseStatus;
import com.baijia.tianxiao.constants.TeacherClassCourseStatus;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.callservice.dao.TX400PhoneDao;
import com.baijia.tianxiao.dal.callservice.dao.impl.TX400PhoneDaoImpl;
import com.baijia.tianxiao.dal.callservice.po.TX400Phone;
import com.baijia.tianxiao.dal.constant.ClassCourseStatus;
import com.baijia.tianxiao.dal.course.dao.ClassCoursePhotoDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.dao.OrgRecommendCourseDao;
import com.baijia.tianxiao.dal.course.dao.SubjectDao;
import com.baijia.tianxiao.dal.course.dao.TeacherClassCourseDao;
import com.baijia.tianxiao.dal.course.po.ClassCoursePhoto;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroup;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroupRelate;
import com.baijia.tianxiao.dal.course.po.OrgRecommendCourse;
import com.baijia.tianxiao.dal.course.po.TeacherClassCourse;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.AuditColumType;
import com.baijia.tianxiao.dal.org.constant.MIMEType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.constant.TemplateStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageConfigDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageTemplateDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgBranchs;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgHomepageConfig;
import com.baijia.tianxiao.dal.org.po.OrgHomepageTemplate;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgTemplateCourse;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.UnifiedWechatAccountDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.UnifiedWechatAccount;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.OrgErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.OrganizationInfoAPIService;
import com.baijia.tianxiao.sal.common.utils.OrgInfoCampare;
import com.baijia.tianxiao.sal.organization.constant.TemplatModuleType;
import com.baijia.tianxiao.sal.organization.dto.OptionalParams;
import com.baijia.tianxiao.sal.organization.org.dto.OrgBaseInfoModel;
import com.baijia.tianxiao.sal.organization.org.dto.OrgRecommendCourseList;
import com.baijia.tianxiao.sal.organization.org.dto.init.DefaultTemplateData;
import com.baijia.tianxiao.sal.organization.org.dto.init.DefaultTemplateDataList;
import com.baijia.tianxiao.sal.organization.org.dto.k12.K12TemplateData;
import com.baijia.tianxiao.sal.organization.org.dto.k12.OrgHotCourseDto;
import com.baijia.tianxiao.sal.organization.org.dto.kaixue.KaixueTemplateDate;
import com.baijia.tianxiao.sal.organization.org.service.OrgIndexService;
import com.baijia.tianxiao.sal.organization.org.service.OrgTemplateCourseService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author zhangbing
 * @version 1.0
 * @title IndexServiceImpl
 * @desc TODO
 * @date 2015年12月4日
 */
@Service("orgIndexService")
@Slf4j
public class OrgIndexServiceImpl implements OrgIndexService {

    private static final Logger logger = LoggerFactory.getLogger(OrgIndexServiceImpl.class);

    @Autowired
    private OrgAccountDao orgAccountDao;

    @Autowired
    private OrgHomepageConfigDao orgHomepageConfigDao;

    @Autowired
    private OrgHomepageTemplateDao orgHomepageTemplateDao;

    @Autowired
    private TeacherClassCourseDao teacherClassCourseDao;

    @Autowired
    private OrgRecommendCourseDao orgRecommendCourseDao;

    @Autowired
    private OrgCourseGroupDao orgCourseGroupDao;

    @Autowired
    private OrgCourseDao orgCourseDao;

    @Autowired
    private OrgInfoDao orgInfoDao;

    @Autowired
    private OrgTxtMsgDao orgTxtMsgDao;

    @Autowired
    private OrgPhotoDao orgPhotoDao;

    @Autowired
    private OrgStorageDao orgStorageDao;

    @Autowired
    private StorageDao storageDao;

    @Autowired
    private SubjectDao subjectDao;

    @Autowired
    private OrgBranchsDao orgBranchsDao;

    @Autowired
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;

    @Autowired
    private ClassCoursePhotoDao classCoursePhotoDao;

    @Autowired
    private OrgTemplateCourseService orgTemplateCourseService;
    @Autowired
    private UnifiedWechatAccountDao unifiedWechatAccountDao;
    @Autowired
    private OrganizationInfoAPIService organizationInfoAPIService;

    @Autowired
    private TX400PhoneDao tx400PhoneDao;

    /**
     * 渲染机构模板
     *
     * @param orgId 机构ID
     */
    @Override
    public JSONObject render(Integer orgId, Boolean readOnly, OptionalParams params) throws BussinessException {
        String scheme = "default";
        JSONObject content = null;
        if (params.getTemplateId() == null) {
            OrgHomepageConfig usingTemplate =
                    orgHomepageConfigDao.getTemplateConfByStatus(orgId, TemplateStatus.USING.getCode());
            if (usingTemplate != null) {
                params.setTemplateId(usingTemplate.getTemplateId());
            }

            if (usingTemplate != null) {
                String config = usingTemplate.getContent();
                OrgHomepageTemplate template =
                        this.orgHomepageTemplateDao.getById(usingTemplate.getTemplateId(), new String[]{});
                if (template != null) {
                    JSONObject templateJson = JSONObject.fromObject(template.getContent());
                    templateJson.put("config", JSONObject.fromObject(config));
                    content = templateJson;
                }
            } else {
                // OrgHomepageTemplate defaultTemplate =
                // orgHomepageTemplateDao.getTemplate(BooleanStatus.TRUE.getStatus());
                // content = defaultTemplate.getContent();
                throw new BussinessException(OrgErrorCode.NO_TEMPLATE_SELECTED);
            }
        } else {
            OrgHomepageTemplate template = this.orgHomepageTemplateDao.getById(params.getTemplateId());
            if (template == null) {
                throw new BussinessException(OrgErrorCode.NO_TEMPLATE_SELECTED);
            } else {
                OrgHomepageConfig usingTemplate =
                        orgHomepageConfigDao.getTemplateConfByStatus(orgId, TemplateStatus.USING.getCode());
                if (usingTemplate != null && usingTemplate.getTemplateId() == params.getTemplateId()) {
                    String config = usingTemplate.getContent();
                    content = JSONObject.fromObject(template.getContent());
                    content.put("config", JSONObject.fromObject(config));
                } else {
                    usingTemplate = orgHomepageConfigDao.getTemplateConf(orgId, params.getTemplateId());
                    if (usingTemplate != null) {
                        String config = usingTemplate.getContent();
                        content = JSONObject.fromObject(template.getContent());
                        content.put("config", JSONObject.fromObject(config));
                    } else {
                        content = JSONObject.fromObject(template.getContent());
                    }
                }
            }
        }

        scheme = content.getString("scheme");
        return dispatch(orgId, scheme, content.toString(), readOnly, params);
    }

    /**
     * 渲染模板分发
     *
     * @param orgId   机构ID
     * @param scheme  模板类型
     * @param content 模板内容
     * @return 模板填充的内容
     */
    private JSONObject dispatch(Integer orgId, String scheme, String content, Boolean readOnly, OptionalParams params) {
        JSONObject templateJson = null;
        if ("abroad".equalsIgnoreCase(scheme)) {
            templateJson = wrapperAbroadTemplate(orgId, content, params);
        } else if ("art".equalsIgnoreCase(scheme)) {
            templateJson = wrapperArtTemplate(orgId, content, params);
        } else if ("k12".equalsIgnoreCase(scheme)) {
            templateJson = wrapperK12Template(orgId, content, params, readOnly);
        } else if ("kaixue".equalsIgnoreCase(scheme)) {
            templateJson = wrapperKaixueTemplate(orgId, content, params, readOnly);
        } else if ("zaojiao".equalsIgnoreCase(scheme)) {
            templateJson = wrapperZaojiaoTemplate(orgId, content, params, readOnly);
        } else if ("default".equalsIgnoreCase(scheme)) {
            templateJson = wrapperDefaultTemplate(orgId, content, params);
        } else if ("life".equalsIgnoreCase(scheme)) {
            templateJson = wrapperK12Template(orgId, content, params, readOnly);
        } else if ("language".equalsIgnoreCase(scheme)) {
            templateJson = wrapperK12Template(orgId, content, params, readOnly);
        } else {
            throw new BussinessException(OrgErrorCode.TEMPLATE_NOT_EXISTS);
        }

        templateJson.put("scheme", scheme);
        templateJson.put("templateId", params.getTemplateId());
        templateJson.put("readOnly", readOnly ? BizConf.TRUE.toString() : BizConf.FALSE.toString());
        logger.info("dispatch.templateScheme:{}", templateJson.toString());
        return templateJson;
    }

    /**
     * 渲染默认机构主页模板
     *
     * @param orgId
     * @param content 模板内容
     * @return
     */
    private JSONObject wrapperDefaultTemplate(Integer orgId, String content, OptionalParams params) {
        OrgBaseInfoModel model = this.getAndSetOrgInfoModel(orgId, params);

        DefaultTemplateData data = new DefaultTemplateData();
        List<DefaultTemplateDataList> subList =
                getAboutUsLinks(model.getNumber(), params.getMonkeySiteHost(), params.getGsxSiteHost());
        data.setGrid(subList);

        JSONObject defaultJson = JSONObject.fromObject(content);
        defaultJson.put("orgInfo", JSONObject.fromObject(model));

        JSONObject dataJson = JSONObject.fromObject(data);
        defaultJson.put("data", dataJson);

        return defaultJson;
    }

    /**
     * 获取机构基本信息
     *
     * @param orgId
     * @return
     */
    private OrgBaseInfoModel getAndSetOrgInfoModel(Integer orgId, OptionalParams params) {
        OrgBaseInfoModel model = new OrgBaseInfoModel();
        this.getAndSetOrgNumber(orgId, model, params.getMonkeySiteHost());
        getAndSetSummary(orgId, model);
        getAndSetAddress(orgId, model);
        getAndSetTags(orgId, model);
        getAndSetOrgLogo(orgId, model, params.getImgServer());
        JSONArray branchJsonObj = JSONArray.fromObject(this.listAllCampusUseUnifiedAccount(orgId));
        model.setBranches(branchJsonObj);

        // JSONObject links = JSONObject.fromObject(BizConf.ORG_INFO_LINKS.replaceAll("host",
        // params.getMonkeySiteHost()).replaceAll("number", model.getNumber().toString()));

        OrgHomepageConfig usingTemplate =
                orgHomepageConfigDao.getTemplateConfByStatus(orgId, TemplateStatus.USING.getCode());
        if (usingTemplate != null) {
            model.setTemplateId(usingTemplate.getTemplateId());
        }

        model.setLinks(getFooterLinks(model.getNumber(), params.getMonkeySiteHost(), params.getGsxSiteHost()));
        return model;
    }

    private JSONObject getFooterLinks(Integer number, String monkeySizeHost, String gsxSiteHost) {
        JSONObject links = new JSONObject();
        links.put("course", getLink(BizConf.ORG_COURSE_LINK, number, monkeySizeHost, gsxSiteHost));
        links.put("brief", getLink(BizConf.ABOUT_US, number, monkeySizeHost, gsxSiteHost));
        links.put("comment", getLink(BizConf.ORG_COMMENT_LINK, number, monkeySizeHost, gsxSiteHost));
        links.put("album", getLink(BizConf.ORG_PHOTO_LINK, number, monkeySizeHost, gsxSiteHost));
        links.put("branch", getLink(BizConf.ORG_BRANCH_LINK, number, monkeySizeHost, gsxSiteHost));
        links.put("teacher", getLink(BizConf.ORG_TEACHER_LINK, number, monkeySizeHost, gsxSiteHost));
        links.put("coupon", getLink(BizConf.ORG_COUPON_LINK, number, monkeySizeHost, gsxSiteHost));

        return links;
    }

    public List<Map<String, Object>> listAllCampusUseUnifiedAccount(Integer orgId) {
        if (orgId == null) {
            return GenericsUtils.emptyList();
        }

        List<Map<String, Object>> campusInfoDtos = Lists.newArrayList();
        Map<Integer, OrgInfo> orgInfoMap = Maps.newHashMap();
        Map<Integer, Integer> orgNumberMapper = Maps.newHashMap();
        fillAllCampusOrgInfo(orgInfoMap, orgNumberMapper, orgId);

        log.info("try to find campusUseUnifiedWechatAccount :{}", orgInfoMap.values().size());

        List<OrgInfo> orgInfos = new ArrayList<>(orgInfoMap.values());
        Collections.sort(orgInfos, new Comparator<OrgInfo>() {
            @Override
            public int compare(OrgInfo o1, OrgInfo o2) {
                return OrgInfoCampare.compareUsePinyin(o1.getShortName(), o2.getShortName());
            }
        });

        String keyOfOrgName = "orgName";
        String keyOfOrgMHost = "mUrl";
        String keyOfNumber = "number";

        String lhost = PropertiesReader.getValue("wxm", "m.server");
        log.info("find lHost is :{} ", lhost);
        for (OrgInfo orgInfo : orgInfos) {
            Integer orgId_ = orgInfo.getOrgId();
            Integer number = orgNumberMapper.get(orgId_);
            String orgName = orgInfo.getShortName();
            String mHost = lhost + "/i/" + number;
            Map<String, Object> dtoMap = Maps.newHashMapWithExpectedSize(2);
            dtoMap.put(keyOfOrgName, orgName);
            dtoMap.put(keyOfOrgMHost, mHost);
            dtoMap.put(keyOfNumber, number);
            campusInfoDtos.add(dtoMap);
        }
        return campusInfoDtos;
    }

    private void fillAllCampusOrgInfo(Map<Integer, OrgInfo> orgInfoMap, Map<Integer, Integer> orgNumberMapper,
                                      Integer orgId) {
        if (orgId == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "invalid orgId :" + orgId);
        }
        List<UnifiedWechatAccount> findUnifiedWechatRecords =
                this.unifiedWechatAccountDao.listAllCampusWithAnyOneOrgInfo(orgId.longValue(), true);
        if (GenericsUtils.isNullOrEmpty(findUnifiedWechatRecords)) {
            return;
        }
        List<Integer> orgIds = GenericsUtils.toFieldList(findUnifiedWechatRecords, "orgId");
        log.info("orgIds is :{} ", orgIds);
        orgInfoMap.putAll(this.organizationInfoAPIService.getOrgInfoMap(orgIds));
        List<OrgAccount> allOrgAccounts = this.orgAccountDao.getByIds(orgInfoMap.keySet(), "id", "number");
        // 所有机构id和机构number的映射
        orgNumberMapper.putAll(
                GenericsUtils.<List<OrgAccount>, OrgAccount, Integer, Integer>toFieldMap(allOrgAccounts, "id", "number"));
    }

    /**
     * 渲染艺体模板
     *
     * @param orgId
     * @return
     */
    private JSONObject wrapperArtTemplate(Integer orgId, String content, OptionalParams params) {
        OrgBaseInfoModel model = this.getAndSetOrgInfoModel(orgId, params);
        JSONObject artJson = JSONObject.fromObject(content);

        List<String> subjects = getOrgCourseSubject(orgId, model.getNumber(), BizConf.MAX_SUBJECT_DISPLAY);
        List<DefaultTemplateDataList> kinds =
                this.getCourseSubjects(subjects, BizConf.MAX_SUBJECT_DISPLAY, model, params);
        JSONObject dataJson = artJson.getJSONObject("data");
        dataJson.put("kinds", JSONArray.fromObject(kinds));

        artJson.put("orgInfo", JSONObject.fromObject(model));
        artJson.put("data", dataJson);
        return artJson;
    }

    /**
     * 渲染K12模板
     *
     * @param orgId
     * @return
     */
    private JSONObject wrapperK12Template(Integer orgId, String content, OptionalParams params, Boolean readOnly) {
        OrgBaseInfoModel model = getAndSetOrgInfoModel(orgId, params);

        K12TemplateData data = new K12TemplateData();
        List<OrgRecommendCourseList> courseList = this.getAndSetRecommentCourseList(orgId, params);
        data.setCourseList(courseList);
        List<DefaultTemplateDataList> grid =
                this.getOrgCourseSubjects(orgId, model.getNumber(), params.getMonkeySiteHost(), params.getGsxSiteHost());
        data.setGrid(grid);

        // 如果是编辑状态，九宫格不显示分类，但下面的分类要显示
        if (readOnly) {
            if (grid != null && !grid.isEmpty()) {
                data.setClassifyCourseList(getOrgHotCourseList(model.getNumber(), grid, params.getImgServer(),
                        params.getMonkeySiteHost(), readOnly));
            } else {
                data.setClassifyCourseList(Collections.<OrgHotCourseDto>emptyList());
            }
        } else {
            List<DefaultTemplateDataList> tempGrid = getTempGrids(orgId, grid);
            data.setClassifyCourseList(getOrgHotCourseList(model.getNumber(), tempGrid, params.getImgServer(),
                    params.getMonkeySiteHost(), readOnly));
        }

        JSONObject k12Json = JSONObject.fromObject(content);
        k12Json.put("orgInfo", JSONObject.fromObject(model));

        JSONObject dataJson = JSONObject.fromObject(data);
        k12Json.put("data", dataJson);

        return k12Json;
    }

    /**
     * 渲染开学季模板
     *
     * @param orgId
     * @return
     */
    private JSONObject wrapperKaixueTemplate(Integer orgId, String content, OptionalParams params, Boolean readOnly) {
        OrgBaseInfoModel model = getAndSetOrgInfoModel(orgId, params);

        KaixueTemplateDate data = new KaixueTemplateDate();
        logger.info("params=={},", params);

        data.setMiaoshaList(convertToKaixue(params, orgTemplateCourseService.getByOrgIdTemplate(orgId,
                params.getTemplateId(), TemplatModuleType.MIAOSHA.getValue()), readOnly));
        data.setTehuiList(convertToKaixue(params, orgTemplateCourseService.getByOrgIdTemplate(orgId,
                params.getTemplateId(), TemplatModuleType.TEHUI.getValue()), readOnly));

        logger.info("data=={},", data);

        List<DefaultTemplateDataList> grid =
                this.getOrgCourseSubjects(orgId, model.getNumber(), params.getMonkeySiteHost(), params.getGsxSiteHost());

        List<DefaultTemplateDataList> tempGrid = getTempGrids(orgId, grid);
        data.setClassifyCourseList(getOrgHotCourseList(model.getNumber(), tempGrid, params.getImgServer(),
                params.getMonkeySiteHost(), readOnly));

        JSONObject kaixueJson = JSONObject.fromObject(content);
        kaixueJson.put("orgInfo", JSONObject.fromObject(model));

        JSONObject dataJson = JSONObject.fromObject(data);
        kaixueJson.put("data", dataJson);

        return kaixueJson;
    }

    /**
     * 渲染早教模板
     *
     * @param orgId
     * @return
     */
    private JSONObject wrapperZaojiaoTemplate(Integer orgId, String content, OptionalParams params, Boolean readOnly) {
        OrgBaseInfoModel model = getAndSetOrgInfoModel(orgId, params);

        K12TemplateData data = new K12TemplateData();

        List<DefaultTemplateDataList> grid =
                this.getOrgCourseSubjects(orgId, model.getNumber(), params.getMonkeySiteHost(), params.getGsxSiteHost());

        List<DefaultTemplateDataList> tempGrid = getTempGrids(orgId, grid);
        data.setClassifyCourseList(getOrgHotCourseList(model.getNumber(), tempGrid, params.getImgServer(),
                params.getMonkeySiteHost(), readOnly));

        JSONObject zaojiaoJson = JSONObject.fromObject(content);
        zaojiaoJson.put("orgInfo", JSONObject.fromObject(model));

        JSONObject dataJson = JSONObject.fromObject(data);
        zaojiaoJson.put("data", dataJson);

        return zaojiaoJson;
    }

    /**
     * 编辑状态时，空的分类也要显示
     *
     * @param orgId
     * @return
     */
    private List<DefaultTemplateDataList> getTempGrids(Integer orgId, List<DefaultTemplateDataList> grids) {
        List<DefaultTemplateDataList> tempGrids = Lists.newArrayList();
        Map<Integer, DefaultTemplateDataList> existGrids = Maps.newHashMap();
        // 有课的分类
        if (CollectionUtils.isNotEmpty(grids)) {
            for (DefaultTemplateDataList grid : grids) {
                if (grid.getCourseGroupId() != null) {
                    existGrids.put(grid.getCourseGroupId(), grid);
                }
            }
            if (existGrids.size() >= BizConf.MAX_COURSE_GROUP) {
                return grids;
            }
        }
        List<OrgCourseGroup> orgCourseGroupList = this.orgCourseGroupDao.getOrgCourseGroupList(orgId);
        if (CollectionUtils.isNotEmpty(orgCourseGroupList)) {
            for (OrgCourseGroup group : orgCourseGroupList) {
                if (tempGrids.size() >= BizConf.MAX_COURSE_GROUP) {
                    break;
                }
                // 已经存在的，要保持顺序
                if (!existGrids.containsKey(group.getId())) {
                    DefaultTemplateDataList item = new DefaultTemplateDataList();
                    item.setCourseGroupId(group.getId());
                    item.setName(group.getName());
                    tempGrids.add(item);
                } else {
                    tempGrids.add(existGrids.get(group.getId()));
                }
            }
        }
        logger.info("####################### tempGrids:{}", tempGrids);
        return tempGrids;
    }

    /**
     * 获取机构自定义课程分类
     *
     * @param orgId
     * @return
     */
    private List<DefaultTemplateDataList> getOrgCourseSubjects(Integer orgId, Integer number, String monkeySiteHost,
                                                               String gsxSiteHost) {
        List<OrgCourseGroup> orgCourseGroupList = this.orgCourseGroupDao.getOrgCourseGroupList(orgId);
        List<DefaultTemplateDataList> gridList = Lists.newArrayList();
        String link = getLink(BizConf.ORG_COURSE_LINK, number, monkeySiteHost, gsxSiteHost);

        DefaultTemplateDataList item = null;
        if (orgCourseGroupList != null && !orgCourseGroupList.isEmpty()) {

            List<Integer> ids = Lists.newArrayList();
            for (OrgCourseGroup courseGroup : orgCourseGroupList) {
                ids.add(courseGroup.getId());
            }
            // 每个OrgCourseGroup的id对应一组OrgCourseGroupRelate
            List<OrgCourseGroupRelate> classList = Lists.newArrayList();
            List<OrgCourseGroupRelate> orgCourseList = Lists.newArrayList();
            // 根据OrgCourseGroup的[[[ids]]]去找全部
            classList = getOrgCourseGroupRelateList(classList, ids, CourseType.CLASS.getCode());
            orgCourseList = getOrgCourseGroupRelateList(orgCourseList, ids, CourseType.ORG_COURSE.getCode());
            orgCourseList.addAll(getOrgCourseGroupRelateList(orgCourseList, ids, CourseType.ORG_COURSE_1v1.getCode()));

            // 每个OrgCourseGroup的id对应多组OrgCourseGroupRelate
            Map<Integer, List<OrgCourseGroupRelate>> classMap = Maps.newHashMap();
            Map<Integer, List<OrgCourseGroupRelate>> orgCourseMap = Maps.newHashMap();
            // 填充map
            classMap = getOrgCourseGroupRelateMap(classList, classMap);
            orgCourseMap = getOrgCourseGroupRelateMap(orgCourseList, orgCourseMap);
            // key为OrgCourseGroupRelate.id value为对应的courseIds
            Map<Integer, List<Integer>> classCourseIdsMap = Maps.newHashMap();
            Map<Integer, List<Integer>> courseCourseIdsMap = Maps.newHashMap();
            // 填充map
            if (classMap.size() > 0) {
                getCourseIdsMapByOrgCourseGroupRelate(classMap, classCourseIdsMap);
            }
            if (orgCourseMap.size() > 0) {
                getCourseIdsMapByOrgCourseGroupRelate(orgCourseMap, courseCourseIdsMap);
            }
            // 所有班课id与所有线下课id
            List<Integer> classIds = Lists.newArrayList();
            List<Integer> orgCourseIds = Lists.newArrayList();
            // 填充数据
            if (classList != null && classList.size() > 0) {
                getCourseIdsListByOrgCourseGroupRelate(classList, classIds);
            }
            if (orgCourseList != null && orgCourseList.size() > 0) {
                getCourseIdsListByOrgCourseGroupRelate(orgCourseList, orgCourseIds);
            }
            // 根据机构number和所有的班课课程id取得一组TeacherClassCourse
            List<TeacherClassCourse> allTeachers = Lists.newArrayList();
            if (classIds.size() > 0) {
                allTeachers = teacherClassCourseDao.getValidClassCourseCountsByIds(number, classIds);
            }
            // 根据机构number和所有的线下课课程id取得一组OrgCourse
            List<OrgCourse> allCourses = Lists.newArrayList();
            if (orgCourseIds.size() > 0) {
                allCourses = orgCourseDao.getValidClassCourseCountsByIds(number, orgCourseIds);
            }
            // 全部TeacherClassCourse的课程id
            List<Integer> allTeacherCourseIds = Lists.newArrayList();
            for (TeacherClassCourse tcc : allTeachers) {
                allTeacherCourseIds.add(tcc.getId().intValue());
            }
            // 全部OrgCourse的课程id
            List<Integer> allOrgCourseIds = Lists.newArrayList();
            for (OrgCourse oc : allCourses) {
                allOrgCourseIds.add(oc.getId().intValue());
            }
            // 根据OrgCourseGroup的[[[courseIds]]]去找全部
            List<OrgCourseGroupRelate> allTeacherCourseList = Lists.newArrayList();
            List<OrgCourseGroupRelate> allOrgCourseList = Lists.newArrayList();
            allTeacherCourseList = getOrgCourseGroupRelateListByCourseIds(allTeacherCourseList, allTeacherCourseIds,
                    CourseType.CLASS.getCode());
            allOrgCourseList = getOrgCourseGroupRelateListByCourseIds(allOrgCourseList, allOrgCourseIds,
                    CourseType.ORG_COURSE.getCode());
            allOrgCourseList.addAll(getOrgCourseGroupRelateListByCourseIds(allOrgCourseList, allOrgCourseIds, CourseType.ORG_COURSE_1v1.getCode()));
            // 每个OrgCourseGroup的id对应多组OrgCourseGroupRelate
            Map<Integer, List<OrgCourseGroupRelate>> allTeacherCourseMap = Maps.newHashMap();
            Map<Integer, List<OrgCourseGroupRelate>> allOrgCourseMap = Maps.newHashMap();
            allTeacherCourseMap = getOrgCourseGroupRelateMap(allTeacherCourseList, allTeacherCourseMap);
            allOrgCourseMap = getOrgCourseGroupRelateMap(allOrgCourseList, allOrgCourseMap);
            // key为OrgCourseGroupRelate.id value为对应的courseIds
            Map<Integer, List<Integer>> allTeacherCourseIdsMap = Maps.newHashMap();
            Map<Integer, List<Integer>> allOrgCourseIdsMap = Maps.newHashMap();
            // 填充map
            if (allTeacherCourseMap.size() > 0) {
                getCourseIdsMapByOrgCourseGroupRelate(allTeacherCourseMap, allTeacherCourseIdsMap);
            }
            if (allOrgCourseMap.size() > 0) {
                getCourseIdsMapByOrgCourseGroupRelate(allOrgCourseMap, allOrgCourseIdsMap);
            }
            // key为OrgCourseGroupRelate.id value为对应的courseCount
            Map<Integer, Integer> classCourseCountMap = Maps.newHashMap();
            Map<Integer, Integer> courseCourseCountMap = Maps.newHashMap();
            // 填充countMap
            getCourseCountMapByOrgCourseGroupRelate(classCourseIdsMap, allTeacherCourseIdsMap, classCourseCountMap);
            getCourseCountMapByOrgCourseGroupRelate(courseCourseIdsMap, allOrgCourseIdsMap, courseCourseCountMap);

            for (OrgCourseGroup courseGroup : orgCourseGroupList) {
                boolean valid = isValidSubject(classCourseCountMap.get(courseGroup.getId()),
                        classCourseIdsMap.get(courseGroup.getId()));
                if (!valid) {
                    valid = isValidSubject(courseCourseCountMap.get(courseGroup.getId()),
                            courseCourseIdsMap.get(courseGroup.getId()));
                }
                if (valid) {
                    item = new DefaultTemplateDataList();
                    item.setLink(link);
                    item.setName(courseGroup.getName());
                    item.setCourseGroupId(courseGroup.getId());
                    gridList.add(item);
                }
                if (gridList.size() == BizConf.MAX_COURSE_GROUP) {
                    break;
                }
            }
        }

        gridList.add(new DefaultTemplateDataList("名师推荐",
                getLink(BizConf.ORG_TEACHER_LINK, number, monkeySiteHost, gsxSiteHost)));
        gridList.add(new DefaultTemplateDataList("学员评价",
                getLink(BizConf.ORG_COMMENT_LINK, number, monkeySiteHost, gsxSiteHost)));
        gridList.add(
                new DefaultTemplateDataList("校区查询", getLink(BizConf.ORG_BRANCH_LINK, number, monkeySiteHost, gsxSiteHost)));
        return gridList;
    }

    private List<OrgCourseGroupRelate> getOrgCourseGroupRelateListByCourseIds(List<OrgCourseGroupRelate> list,
                                                                              List<Integer> ids, int courseType) {
        if (ids.size() > 0) {
            list = orgCourseGroupRelateDao.getCourseGroupRelateByCourseIds(ids, courseType);
        }
        return list;
    }

    private Map<Integer, List<OrgCourseGroupRelate>> getOrgCourseGroupRelateMap(List<OrgCourseGroupRelate> list,
                                                                                Map<Integer, List<OrgCourseGroupRelate>> map) {
        if (list != null && list.size() > 0) {
            map = CollectorUtil.group(list, new Function<OrgCourseGroupRelate, Integer>() {
                @Override
                public Integer apply(OrgCourseGroupRelate o) {
                    return o.getCourseGroupId().intValue();
                }
            });
        }
        return map;
    }

    private List<OrgCourseGroupRelate> getOrgCourseGroupRelateList(List<OrgCourseGroupRelate> list, List<Integer> ids,
                                                                   int courseType) {
        if (ids.size() > 0) {
            list = orgCourseGroupRelateDao.getCourseGroupRelateByGroupIds(ids, courseType);
        }
        return list;
    }

    private void getCourseCountMapByOrgCourseGroupRelate(Map<Integer, List<Integer>> bigMap,
                                                         Map<Integer, List<Integer>> smallMap, Map<Integer, Integer> courseCountMap) {
        for (Integer i : bigMap.keySet()) {
            List<Integer> big = bigMap.get(i);
            List<Integer> small = smallMap.get(i);
            if (small != null) {
                big.retainAll(small);
                courseCountMap.put(i, big.size());
            } else {
                courseCountMap.put(i, 0);
            }
        }
    }

    private void getCourseIdsMapByOrgCourseGroupRelate(Map<Integer, List<OrgCourseGroupRelate>> map,
                                                       Map<Integer, List<Integer>> fill) {
        for (Integer in : map.keySet()) {
            List<Integer> list = Lists.newArrayList();
            List<OrgCourseGroupRelate> temp = map.get(in);
            if (temp == null) {
                continue;
            }
            for (OrgCourseGroupRelate o : temp) {
                list.add(o.getCourseId().intValue());
            }
            fill.put(in, list);
        }
    }

    private void getCourseIdsListByOrgCourseGroupRelate(List<OrgCourseGroupRelate> list, List<Integer> fill) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (int i = 0; i < list.size(); i++) {
            Integer id = list.get(i).getCourseId().intValue();
            fill.add(id);
        }
    }

    /**
     * 验证课程分类是否需要显示
     *
     * @return
     */
    private boolean isValidSubject(Integer c, List<Integer> ids) {
        int count = 0;
        if (ids != null && !ids.isEmpty()) {
            count = c;
        }
        return count > 0;
    }

    /**
     * 获取m站具体tab页链接地址
     *
     * @param url
     * @param number
     * @param monkeySizeHost
     * @return
     */
    private String getLink(String url, Integer number, String monkeySizeHost, String gsxSiteHost) {
        if (url.contains("{host}")) {
            return url.replaceAll("\\{host\\}", monkeySizeHost).replaceAll("\\{number\\}", number.toString());
        } else {
            return url.replaceAll("\\{host1\\}", gsxSiteHost).replaceAll("\\{number\\}", number.toString());
        }
    }

    /**
     * 获取机构推荐课程列表
     *
     * @param orgId 机构ID
     * @return
     */
    private List<OrgRecommendCourseList> getAndSetRecommentCourseList(Integer orgId, OptionalParams params) {
        List<OrgRecommendCourse> recommendCourses = orgRecommendCourseDao.getRecommendCourseList(orgId);

        String imgServer = params.getImgServer();
        String monkeySite = params.getMonkeySiteHost();
        String gsxSite = params.getGsxSiteHost();
        List<OrgRecommendCourseList> data = Lists.newArrayList();
        if (recommendCourses != null && !recommendCourses.isEmpty()) {
            OrgRecommendCourseList subData = null;

            Map<Long, OrgCourse> orgCourseCache = this.getAndCacheOrgCourseInfo(recommendCourses);
            Map<Long, TeacherClassCourse> classCourseCache = this.getAndCacheClassCourseInfo(recommendCourses);
            // TODO: 待优化
            List<Integer> orgCourseStorageIds = Lists.newArrayList();
            for (Long l : orgCourseCache.keySet()) {
                orgCourseStorageIds.add(orgCourseCache.get(l).getCover());
            }
            List<Storage> orgCourseStorageList = storageDao.getByIds(orgCourseStorageIds);
            // key为Storage.id，value为图像
            Map<Integer, Storage> orgCourseStorageMap = Maps.newConcurrentMap();
            for (Storage s : orgCourseStorageList) {
                orgCourseStorageMap.put(s.getId().intValue(), s);
            }

            List<Long> classStorageIds = Lists.newArrayList();
            for (Long l : classCourseCache.keySet()) {
                classStorageIds.add(classCourseCache.get(l).getCover());
            }
            List<ClassCoursePhoto> covers = classCoursePhotoDao.getByIds(classStorageIds);
            // key为ClassCoursePhoto.storageId
            Map<Long, ClassCoursePhoto> coverMap =
                    CollectorUtil.collectMap(covers, new Function<ClassCoursePhoto, Long>() {
                        @Override
                        public Long apply(ClassCoursePhoto o) {
                            return o.getStorageId();
                        }
                    });
            List<Long> storageIds = Lists.newArrayList();
            for (ClassCoursePhoto c : covers) {
                storageIds.add(c.getStorageId());
            }
            List<Storage> classStorageList = storageDao.getByIds(storageIds);
            // key为Storage.id
            Map<Long, Storage> storageMap = CollectorUtil.collectMap(classStorageList, new Function<Storage, Long>() {
                @Override
                public Long apply(Storage storage) {
                    return storage.getId();
                }
            });
            // key为ClassCoursePhoto.id，value为图像
            Map<Long, Storage> classStorageMap = Maps.newConcurrentMap();
            for (Long l : coverMap.keySet()) {
                classStorageMap.put(l, storageMap.get(l));
            }

            for (OrgRecommendCourse course : recommendCourses) {
                Integer courseId = course.getCourseid();
                Integer courseType = course.getCourseType();
                subData = new OrgRecommendCourseList();
                if (courseType == CourseType.CLASS.getCode()) {
                    if (classCourseCache.containsKey(courseId.longValue())) {
                        TeacherClassCourse po = classCourseCache.get(courseId.longValue());
                        // TeacherClassCourse po = this.teacherClassCourseDao.getById(courseId);
                        if (po.getStatus() == TeacherClassCourseStatus.ENROLLING.getStatus()
                                && po.getBeginTime().getTime() > System.currentTimeMillis()) {
                            subData.setCourseType(courseType);
                            subData.setName(po.getName());
                            subData.setNumber(po.getNumber());
                            subData.setPrice(po.getPrice().toString());
                            subData.setPreface("");
                            subData.setCourseId(po.getId());
                            if (po.getCover() != null) {
                                // Storage storage = this.getClassCourseStorage(po.getCover());
                                Storage storage = classStorageMap.get(po.getCover());
                                subData.setPreface(constructUrl(storage, imgServer));
                            }
                            subData.setLink(BizConf.CLASS_COURSE_DETAIL.replace("{host1}", gsxSite).replace("{number}",
                                    po.getNumber().toString()));
                            data.add(subData);
                        }
                    }
                } else if (courseType == CourseType.ORG_COURSE.getCode() || courseType == CourseType.ORG_COURSE_1v1.getCode()) {
                    if (orgCourseCache.containsKey(courseId.longValue())) {
                        OrgCourse po = orgCourseCache.get(courseId.longValue());
                        // OrgCourse po = this.orgCourseDao.getById(courseId);
                        if (po != null && po.getStatus() == OrgCourseStatus.IN_PROGRESS.getCode()) {
                            subData.setCourseType(courseType);
                            subData.setName(po.getName());
                            subData.setNumber(po.getNumber());
                            subData.setPrice(po.getPrice().toString());
                            subData.setPreface("");
                            subData.setCourseId(po.getId());
                            if (po.getCover() != null) {
                                // Storage storage = this.storageDao.getById(po.getCover());
                                Storage storage = orgCourseStorageMap.get(po.getCover());
                                if (storage != null) {
                                    subData.setPreface(constructUrl(storage, imgServer));
                                }
                            }
                            subData.setLink(BizConf.ORG_COURSE_DETAIL.replace("{host}", monkeySite).replace("{number}",
                                    po.getNumber().toString()));
                            data.add(subData);
                        }
                    }
                } else {
                    continue;
                }
            }
        }

        return data;
    }

    /**
     * 批量查询3810课程信息并缓存
     *
     * @param recommendCourses
     */
    private Map<Long, OrgCourse> getAndCacheOrgCourseInfo(List<OrgRecommendCourse> recommendCourses) {
        List<Long> orgCourseIds = Lists.newArrayList();
        for (OrgRecommendCourse course : recommendCourses) {
            Long courseId = course.getCourseid().longValue();
            Integer courseType = course.getCourseType();
            if (courseType == CourseType.ORG_COURSE.getCode() || courseType == CourseType.ORG_COURSE_1v1.getCode()) {
                orgCourseIds.add(courseId);
            }
        }

        return this.getOrgCourseCache(orgCourseIds);
    }

    /**
     * 批量查询班课信息并缓存
     *
     * @param recommendCourses
     */
    private Map<Long, TeacherClassCourse> getAndCacheClassCourseInfo(List<OrgRecommendCourse> recommendCourses) {
        List<Long> classCourseIds = Lists.newArrayList();
        for (OrgRecommendCourse course : recommendCourses) {
            Long courseId = course.getCourseid().longValue();
            Integer courseType = course.getCourseType();
            if (courseType == CourseType.CLASS.getCode()) {
                classCourseIds.add(courseId);
            }
        }

        return getClassCourseCache(classCourseIds);
    }

    /**
     * 批量查询3810课程信息
     */
    private Map<Long, OrgCourse> getOrgCourseCache(List<Long> ids) {
        return this.orgCourseDao.getOrgCourseMap(ids);
    }

    /**
     * 批量查询班课信息
     */
    private Map<Long, TeacherClassCourse> getClassCourseCache(List<Long> ids) {
        return this.teacherClassCourseDao.getTeacherClassCourses(ids);
    }

    /**
     * 1.如果机构有自定义分类，取10个机构的自定义分类 2.如果机构没有自定义分类，取机构班课+3810课的10个分类
     *
     * @param orgId
     * @param number
     * @return
     */
    private List<String> getOrgCourseSubject(Integer orgId, Integer number, int limit) {
        List<String> subjects = this.getOrgCustomClassfication(orgId);

        // Set<String> result = Sets.newHashSet();
        // if (subjects != null && !subjects.isEmpty()) {
        //
        // if (subjects.size() < limit) {
        //// Set<String> names = getClassCourseAndOrgCourseSubjects(number);
        //// result.addAll(subjects);
        //// if (names != null && !names.isEmpty()) {
        // for (String name : subjects) {
        // result.add(name);
        // if (result.size() == limit) {
        // break;
        // }
        // }
        //// }
        // }
        // } else {
        // Set<String> names = getClassCourseAndOrgCourseSubjects(number);
        // if (names != null && !names.isEmpty()) {
        // for (String name : names) {
        // result.add(name);
        // if (result.size() == limit) {
        // break;
        // }
        // }
        // }
        // }

        logger.info("getOrgCourseSubject.orgId:{}, number:{}, limit:{}, subjects:{}", orgId, number, limit, subjects);
        return subjects;
    }

    /**
     * 获取机构班课、3810课程id集合
     *
     * @param courseType
     * @return
     */
    private <T> Collection<Long> getPropertiesVals(List<T> objs, CourseType courseType, String cType, String courseId) {
        Set<Long> excludeIds = Sets.newHashSet();
        switch (courseType) {
            case CLASS:
                for (T obj : objs) {
                    Integer type = BaseUtils.getValue(obj, cType);
                    if (type == CourseType.CLASS.getCode()) {
                        excludeIds.add((Long) BaseUtils.getValue(obj, courseId));
                    }
                }
                break;
            case ORG_COURSE:
                for (T obj : objs) {
                    Integer type = BaseUtils.getValue(obj, cType);
                    if (type == CourseType.ORG_COURSE.getCode()) {
                        excludeIds.add((Long) BaseUtils.getValue(obj, courseId));
                    }
                }
                break;
            case ORG_COURSE_1v1:
                for (T obj : objs) {
                    Integer type = BaseUtils.getValue(obj, cType);
                    if (type == CourseType.ORG_COURSE_1v1.getCode()) {
                        excludeIds.add((Long) BaseUtils.getValue(obj, courseId));
                    }
                }
                break;
            default:
                break;
        }
        return excludeIds;
    }

    /**
     * 获取机构热门推荐课程
     *
     * @param grids
     * @return
     */
    private List<OrgHotCourseDto> getOrgHotCourseList(Integer orgNumber, List<DefaultTemplateDataList> grids,
                                                      String imgServer, String monkeySite, Boolean readOnly) {
        List<OrgHotCourseDto> result = Lists.newArrayList();
        List<OrgRecommendCourseList> subResult = null;
        OrgHotCourseDto subItem = null;
        List<Integer> allId = Lists.newArrayList();
        // 获得全部id
        for (DefaultTemplateDataList grid : grids) {
            allId.add(grid.getCourseGroupId());
        }
        // 全部组
        List<OrgCourseGroupRelate> classList = Lists.newArrayList();
        List<OrgCourseGroupRelate> orgCourseList = Lists.newArrayList();
        classList = getOrgCourseGroupRelateList(classList, allId, CourseType.CLASS.getCode());
        orgCourseList = getOrgCourseGroupRelateList(orgCourseList, allId, CourseType.ORG_COURSE.getCode());
        orgCourseList.addAll(getOrgCourseGroupRelateList(orgCourseList, allId, CourseType.ORG_COURSE_1v1.getCode()));
        // key为组号，value为课组关系
        Map<Integer, List<OrgCourseGroupRelate>> classMap = Maps.newHashMap();
        Map<Integer, List<OrgCourseGroupRelate>> orgCourseMap = Maps.newHashMap();
        classMap = getOrgCourseGroupRelateMap(classList, classMap);
        orgCourseMap = getOrgCourseGroupRelateMap(orgCourseList, orgCourseMap);
        // key为组号，value为组下所有课程id
        Map<Integer, List<Integer>> classCourseIdsMap = Maps.newHashMap();
        Map<Integer, List<Integer>> courseCourseIdsMap = Maps.newHashMap();
        if (classMap.size() > 0) {
            getCourseIdsMapByOrgCourseGroupRelate(classMap, classCourseIdsMap);
        }
        if (orgCourseMap.size() > 0) {
            getCourseIdsMapByOrgCourseGroupRelate(orgCourseMap, courseCourseIdsMap);
        }
        // 全部班课id
        List<Long> allClassId = Lists.newArrayList();
        // 全部线下课id
        List<Long> allOrgCourseId = Lists.newArrayList();
        getCourseIds(classCourseIdsMap, allClassId);
        getCourseIds(courseCourseIdsMap, allOrgCourseId);
        // 所有组下所有班课
        Map<Long, TeacherClassCourse> teacherMap = Maps.newHashMap();
        // 所有组下所有线下课
        Map<Long, OrgCourse> courseMap = Maps.newHashMap();
        if (allClassId != null && !allClassId.isEmpty()) {
            teacherMap = teacherClassCourseDao.getTeacherClassCourses(allClassId);
        }
        if (allOrgCourseId != null && !allOrgCourseId.isEmpty()) {
            courseMap = orgCourseDao.getOrgCourseMap(allOrgCourseId);
        }
        // key为getCourseGroupId，value为班课集合
        Map<Integer, List<TeacherClassCourse>> bkMap = Maps.newHashMap();
        // key为getCourseGroupId，value为线下课集合
        Map<Integer, List<OrgCourse>> xxkMap = Maps.newHashMap();
        // 填充map，key为组，value为组内课
        if (classCourseIdsMap.size() > 0) {
            for (Integer i : classCourseIdsMap.keySet()) {
                List<Integer> ids = classCourseIdsMap.get(i);
                List<TeacherClassCourse> temp = Lists.newArrayList();
                for (Integer ii : ids) {
                    if (teacherMap.containsKey(ii.longValue())) {
                        temp.add(teacherMap.get(ii.longValue()));
                    }
                }
                bkMap.put(i, temp);
            }
        }
        if (courseCourseIdsMap.size() > 0) {
            for (Integer i : courseCourseIdsMap.keySet()) {
                List<Integer> ids = courseCourseIdsMap.get(i);
                List<OrgCourse> temp = Lists.newArrayList();
                for (Integer ii : ids) {
                    if (courseMap.containsKey(ii.longValue())) {
                        temp.add(courseMap.get(ii.longValue()));
                    }
                }
                xxkMap.put(i, temp);
            }
        }
        // 图片
        List<Integer> orgCourseStorageIds = Lists.newArrayList();
        for (Long l : courseMap.keySet()) {
            orgCourseStorageIds.add(courseMap.get(l).getCover());
        }
        List<Storage> orgCourseStorageList = storageDao.getByIds(orgCourseStorageIds);
        // key为Storage.id，value为图像
        Map<Integer, Storage> orgCourseStorageMap = Maps.newConcurrentMap();
        for (Storage s : orgCourseStorageList) {
            orgCourseStorageMap.put(s.getId().intValue(), s);
        }
        logger.debug("-----------------------------orgCourseStorageMap={}", orgCourseStorageMap);
        List<Long> classStorageIds = Lists.newArrayList();
        for (Long l : teacherMap.keySet()) {
            classStorageIds.add(teacherMap.get(l).getCover());
        }
        List<ClassCoursePhoto> covers = classCoursePhotoDao.getByIds(classStorageIds);
        // key为ClassCoursePhoto.storageId
        Map<Long, ClassCoursePhoto> coverMap = CollectorUtil.collectMap(covers, new Function<ClassCoursePhoto, Long>() {
            @Override
            public Long apply(ClassCoursePhoto o) {
                return o.getStorageId();
            }
        });
        List<Long> storageIds = Lists.newArrayList();
        for (ClassCoursePhoto c : covers) {
            storageIds.add(c.getStorageId());
        }
        List<Storage> classStorageList = storageDao.getByIds(storageIds);
        // key为Storage.id
        Map<Long, Storage> storageMap = CollectorUtil.collectMap(classStorageList, new Function<Storage, Long>() {
            @Override
            public Long apply(Storage storage) {
                return storage.getId();
            }
        });
        // key为ClassCoursePhoto.id，value为图像
        Map<Long, Storage> classStorageMap = Maps.newConcurrentMap();
        for (Long l : coverMap.keySet()) {
            classStorageMap.put(l, storageMap.get(l));
        }
        logger.debug("-----------------------------classStorageMap={}", classStorageMap);
        for (DefaultTemplateDataList grid : grids) {
            subItem = new OrgHotCourseDto();
            Integer courseGroupId = grid.getCourseGroupId();
            if (courseGroupId == null) {
                continue;
            }
            subItem.setGroupId(courseGroupId);
            subResult = Lists.newArrayList();
            if (bkMap != null && !bkMap.isEmpty()) {
                subResult.addAll(this.getHotBCourse(classStorageMap, bkMap.get(courseGroupId), imgServer, monkeySite));
            }
            if (xxkMap != null && !xxkMap.isEmpty()) {
                subResult
                        .addAll(this.getHotXXCourse(orgCourseStorageMap, xxkMap.get(courseGroupId), imgServer, monkeySite));
            }

            subItem.setName(grid.getName());
            if (subResult != null && !subResult.isEmpty()) {
                if (readOnly) {
                    // 大于四个显示四个，2、3个时显示2个
                    if (subResult.size() >= BizConf.MAX_COURSE_DISPLAY) {
                        subItem.setList(subResult.subList(0, BizConf.MAX_COURSE_DISPLAY));
                        result.add(subItem);
                    } else if (subResult.size() >= BizConf.MAX_COURSE_DISPLAY / 2
                            && subResult.size() < BizConf.MAX_COURSE_DISPLAY) {
                        subItem.setList(subResult.subList(0, BizConf.MAX_COURSE_DISPLAY / 2));
                        result.add(subItem);
                    } else {
                        continue;
                    }
                } else {
                    // 编辑模式下，不大于四个就给显示了
                    if (subResult.size() >= BizConf.MAX_COURSE_DISPLAY) {
                        subItem.setList(subResult.subList(0, BizConf.MAX_COURSE_DISPLAY));
                        result.add(subItem);
                    } else {
                        subItem.setList(subResult);
                        result.add(subItem);
                    }
                }
            } else {
                if (readOnly) {
                    continue;
                } else {
                    // 编辑模式下，空的也要显示
                    result.add(subItem);
                }
            }
        }

        return result;
    }

    private void getCourseIds(Map<Integer, List<Integer>> map, List<Long> ids) {
        if (map.size() > 0) {
            for (Integer i : map.keySet()) {
                List<Integer> list = map.get(i);
                for (Integer l : list) {
                    ids.add(l.longValue());
                }
            }
        }
    }

    private List<OrgRecommendCourseList> getOrgHotCourseList(Integer orgId, Integer number, OptionalParams params) {
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(BizConf.MAX_SUBJECT_DISPLAY);

        String imgServer = params.getImgServer();
        String monkeySite = params.getMonkeySiteHost();
        List<OrgRecommendCourseList> courses = Lists.newArrayList();
        List<OrgCourseGroupRelate> recommendCourseLists = this.getOrgCustomGroupCourse(orgId, pageDto);
        List<TeacherClassCourse> classCourses = Lists.newArrayList();
        List<OrgCourse> orgCourses = Lists.newArrayList();
        if (recommendCourseLists != null && !recommendCourseLists.isEmpty()) {
            int size = recommendCourseLists.size();
            if (BizConf.MAX_SUBJECT_DISPLAY > size) {
                pageDto.setPageSize(BizConf.MAX_SUBJECT_DISPLAY - size);
                classCourses = getOrgTeacherClassCourseList(number,
                        getPropertiesVals(recommendCourseLists, CourseType.CLASS, "courseType", "courseId"), pageDto);
                if (BizConf.MAX_SUBJECT_DISPLAY > (size + classCourses.size())) {
                    orgCourses = getOrgCourseList(number,
                            getPropertiesVals(recommendCourseLists, CourseType.ORG_COURSE, "courseType", "courseId"),
                            pageDto);
                }
            }
        } else {
            pageDto.setPageSize(BizConf.MAX_SUBJECT_DISPLAY);
            classCourses = getOrgTeacherClassCourseList(number, null, pageDto);
            int size = classCourses.size();
            if (classCourses != null && !classCourses.isEmpty() && BizConf.MAX_SUBJECT_DISPLAY > size) {
                pageDto.setPageSize(BizConf.MAX_SUBJECT_DISPLAY - size);
                orgCourses = this.getOrgCourseList(number, null, pageDto);
            }
        }

        if (recommendCourseLists != null && !recommendCourseLists.isEmpty()) {
            List<Long> courseIds = Lists.newArrayList();
            for (OrgCourseGroupRelate recommendCourse : recommendCourseLists) {
                courseIds.add(recommendCourse.getCourseId());
            }
            List<TeacherClassCourse> classList = teacherClassCourseDao.getByIds(courseIds);
            Map<Long, TeacherClassCourse> classCourseMap =
                    CollectorUtil.collectMap(classList, new Function<TeacherClassCourse, Long>() {
                        @Override
                        public Long apply(TeacherClassCourse teacherClassCourse) {
                            return teacherClassCourse.getId();
                        }
                    });
            List<OrgCourse> orgCourseList = orgCourseDao.getByIds(courseIds);
            Map<Long, OrgCourse> orgCourseCourseMap =
                    CollectorUtil.collectMap(orgCourseList, new Function<OrgCourse, Long>() {
                        @Override
                        public Long apply(OrgCourse o) {
                            return o.getId();
                        }
                    });

            List<Integer> orgCourseStorageIds = Lists.newArrayList();
            for (OrgCourse l : orgCourseList) {
                orgCourseStorageIds.add(l.getCover());
            }
            List<Storage> orgCourseStorageList = storageDao.getByIds(orgCourseStorageIds);
            // key为Storage.id，value为图像
            Map<Integer, Storage> orgCourseStorageMap = Maps.newConcurrentMap();
            for (Storage s : orgCourseStorageList) {
                orgCourseStorageMap.put(s.getId().intValue(), s);
            }

            List<Long> classStorageIds = Lists.newArrayList();
            for (TeacherClassCourse l : classList) {
                classStorageIds.add(l.getCover());
            }
            List<ClassCoursePhoto> covers = classCoursePhotoDao.getByIds(classStorageIds);
            // key为ClassCoursePhoto.storageId
            Map<Long, ClassCoursePhoto> coverMap =
                    CollectorUtil.collectMap(covers, new Function<ClassCoursePhoto, Long>() {
                        @Override
                        public Long apply(ClassCoursePhoto o) {
                            return o.getStorageId();
                        }
                    });
            List<Long> storageIds = Lists.newArrayList();
            for (ClassCoursePhoto c : covers) {
                storageIds.add(c.getStorageId());
            }
            List<Storage> classStorageList = storageDao.getByIds(storageIds);
            // key为Storage.id
            Map<Long, Storage> storageMap = CollectorUtil.collectMap(classStorageList, new Function<Storage, Long>() {
                @Override
                public Long apply(Storage storage) {
                    return storage.getId();
                }
            });
            // key为ClassCoursePhoto.id，value为图像
            Map<Long, Storage> classStorageMap = Maps.newConcurrentMap();
            for (Long l : coverMap.keySet()) {
                classStorageMap.put(l, storageMap.get(l));
            }

            for (OrgCourseGroupRelate recommendCourse : recommendCourseLists) {
                OrgRecommendCourseList dto = null;
                if (recommendCourse.getCourseType() == CourseType.ORG_COURSE.getCode()
                        || recommendCourse.getCourseType() == CourseType.ORG_COURSE_1v1.getCode()) {
                    dto = this.getHotOrgCourses(orgCourseStorageMap,
                            orgCourseCourseMap.get(recommendCourse.getCourseId()), imgServer, monkeySite);
                } else if (recommendCourse.getCourseType() == CourseType.CLASS.getCode()) {
                    dto = this.getHotClassCourses(classStorageMap, classCourseMap.get(recommendCourse.getCourseId()),
                            imgServer, monkeySite);
                }
                if (dto != null) {
                    courses.add(dto);
                }
            }
        }

        if (classCourses != null && !classCourses.isEmpty()) {
            List<Long> courseIds = Lists.newArrayList();
            for (TeacherClassCourse classCourse : classCourses) {
                courseIds.add(classCourse.getId());
            }
            List<TeacherClassCourse> list = teacherClassCourseDao.getByIds(courseIds);
            Map<Long, TeacherClassCourse> classCourseMap =
                    CollectorUtil.collectMap(list, new Function<TeacherClassCourse, Long>() {

                        @Override
                        public Long apply(TeacherClassCourse teacherClassCourse) {
                            return teacherClassCourse.getId();
                        }
                    });
            List<Long> classStorageIds = Lists.newArrayList();
            for (TeacherClassCourse l : list) {
                classStorageIds.add(l.getCover());
            }
            List<ClassCoursePhoto> covers = classCoursePhotoDao.getByIds(classStorageIds);
            // key为ClassCoursePhoto.storageId
            Map<Long, ClassCoursePhoto> coverMap =
                    CollectorUtil.collectMap(covers, new Function<ClassCoursePhoto, Long>() {
                        @Override
                        public Long apply(ClassCoursePhoto o) {
                            return o.getStorageId();
                        }
                    });
            List<Long> storageIds = Lists.newArrayList();
            for (ClassCoursePhoto c : covers) {
                storageIds.add(c.getStorageId());
            }
            List<Storage> classStorageList = storageDao.getByIds(storageIds);
            // key为Storage.id
            Map<Long, Storage> storageMap = CollectorUtil.collectMap(classStorageList, new Function<Storage, Long>() {
                @Override
                public Long apply(Storage storage) {
                    return storage.getId();
                }
            });
            // key为ClassCoursePhoto.id，value为图像
            Map<Long, Storage> classStorageMap = Maps.newConcurrentMap();
            for (Long l : coverMap.keySet()) {
                classStorageMap.put(l, storageMap.get(l));
            }
            for (TeacherClassCourse classCourse : classCourses) {
                OrgRecommendCourseList dto = this.getHotClassCourses(classStorageMap,
                        classCourseMap.get(classCourse.getId()), imgServer, monkeySite);
                if (dto != null) {
                    courses.add(dto);
                }
            }
        }

        if (orgCourses != null && !orgCourses.isEmpty()) {
            List<Long> courseIds = Lists.newArrayList();
            for (OrgCourse orgCourse : orgCourses) {
                courseIds.add(orgCourse.getId());
            }
            List<OrgCourse> orgCourseList = orgCourseDao.getByIds(courseIds);
            Map<Long, OrgCourse> orgCourseCourseMap =
                    CollectorUtil.collectMap(orgCourseList, new Function<OrgCourse, Long>() {
                        @Override
                        public Long apply(OrgCourse o) {
                            return o.getId();
                        }
                    });
            List<Integer> orgCourseStorageIds = Lists.newArrayList();
            for (OrgCourse l : orgCourseList) {
                orgCourseStorageIds.add(l.getCover());
            }
            List<Storage> orgCourseStorageList = storageDao.getByIds(orgCourseStorageIds);
            // key为Storage.id，value为图像
            Map<Integer, Storage> orgCourseStorageMap = Maps.newConcurrentMap();
            for (Storage s : orgCourseStorageList) {
                orgCourseStorageMap.put(s.getId().intValue(), s);
            }
            for (OrgCourse orgCourse : orgCourses) {
                OrgRecommendCourseList dto = this.getHotOrgCourses(orgCourseStorageMap,
                        orgCourseCourseMap.get(orgCourse.getId()), imgServer, monkeySite);
                if (dto != null) {
                    courses.add(dto);
                }
            }
        }
        return courses;
    }

    /**
     * 组装3810课程信息
     *
     * @param orgCourse
     * @param imgServer
     * @return
     */
    private OrgRecommendCourseList getHotOrgCourse(OrgCourse orgCourse, String imgServer, String monkeySite) {
        OrgRecommendCourseList dto = null;
        if (orgCourse != null) {
            if (orgCourse.getStatus() == OrgCourseStatus.IN_PROGRESS.getCode()) {
                dto = new OrgRecommendCourseList();
                dto.setCourseType(CourseType.ORG_COURSE.getCode());
                dto.setName(orgCourse.getName());
                dto.setNumber(orgCourse.getNumber());
                dto.setPrice(orgCourse.getPrice().toString());
                dto.setCourseId(orgCourse.getId());
                Integer cover = orgCourse.getCover();
                if (cover != null) {
                    Storage storage = this.getStorage(cover.longValue());
                    String url = constructUrl(storage, imgServer);
                    dto.setPreface(url);
                }

                dto.setLink(BizConf.ORG_COURSE_DETAIL.replace("{host}", monkeySite).replace("{number}",
                        orgCourse.getNumber().toString()));
            }
        }

        return dto;
    }

    private OrgRecommendCourseList getHotOrgCourses(Map<Integer, Storage> orgCourseStorageMap, OrgCourse orgCourse,
                                                    String imgServer, String monkeySite) {
        logger.info("convertToKaixue ==params={},{},{},{}", orgCourseStorageMap, orgCourse, imgServer, monkeySite);

        OrgRecommendCourseList dto = null;
        if (orgCourse != null) {
            if (orgCourse.getStatus() == OrgCourseStatus.IN_PROGRESS.getCode()) {
                dto = new OrgRecommendCourseList();
                dto.setCourseType(CourseType.ORG_COURSE.getCode());
                dto.setName(orgCourse.getName());
                dto.setNumber(orgCourse.getNumber());
                dto.setPrice(orgCourse.getPrice().toString());
                dto.setCourseId(orgCourse.getId());
                Integer cover = orgCourse.getCover();
                if (cover != null) {
                    // Storage storage = this.getStorage(cover.longValue());
                    Storage storage = orgCourseStorageMap.get(cover);
                    logger.debug("---------------cover={},storage={}", cover, storage);
                    String url = constructUrl(storage, imgServer);
                    dto.setPreface(url);
                }

                dto.setLink(BizConf.ORG_COURSE_DETAIL.replace("{host}", monkeySite).replace("{number}",
                        orgCourse.getNumber().toString()));
            }
        }
        logger.info("convertToKaixue ==params={}", dto);

        return dto;
    }

    /**
     * 组装机构班课信息
     *
     * @param classCourse
     * @param imgServer
     * @return
     */
    private OrgRecommendCourseList getHotClassCourse(TeacherClassCourse classCourse, String imgServer,
                                                     String monkeySite) {
        OrgRecommendCourseList dto = null;
        if (classCourse != null && classCourse.getStatus() == ClassCourseStatus.ENROLLING.getState()
                && classCourse.getBeginTime().getTime() > System.currentTimeMillis()) {
            dto = new OrgRecommendCourseList();
            dto.setCourseType(CourseType.CLASS.getCode());
            dto.setName(classCourse.getName());
            dto.setNumber(classCourse.getNumber());
            dto.setPrice(classCourse.getPrice().toString());
            dto.setCourseId(classCourse.getId());
            Long cover = classCourse.getCover();
            if (cover != null) {
                Storage storage = this.getClassCourseStorage(cover);
                String url = constructUrl(storage, imgServer);
                dto.setPreface(url);
            }
            dto.setLink(BizConf.CLASS_COURSE_DETAIL.replace("{host}", monkeySite).replace("{number}",
                    classCourse.getNumber().toString()));
        }

        return dto;
    }

    private OrgRecommendCourseList getHotClassCourses(Map<Long, Storage> classStorageMap,
                                                      TeacherClassCourse classCourse, String imgServer, String monkeySite) {
        OrgRecommendCourseList dto = null;
        if (classCourse != null && classCourse.getStatus() == ClassCourseStatus.ENROLLING.getState()
                && classCourse.getBeginTime().getTime() > System.currentTimeMillis()) {
            dto = new OrgRecommendCourseList();
            dto.setCourseType(CourseType.CLASS.getCode());
            dto.setName(classCourse.getName());
            dto.setNumber(classCourse.getNumber());
            dto.setPrice(classCourse.getPrice().toString());
            dto.setCourseId(classCourse.getId());
            Long cover = classCourse.getCover();
            if (cover != null) {
                // Storage storage = this.getClassCourseStorage(cover.longValue());
                Storage storage = classStorageMap.get(cover.longValue());
                logger.debug("---------------cover={},storage={}", cover, storage);
                String url = constructUrl(storage, imgServer);
                dto.setPreface(url);
            }
            dto.setLink(BizConf.CLASS_COURSE_DETAIL.replace("{host}", monkeySite).replace("{number}",
                    classCourse.getNumber().toString()));
        }

        return dto;
    }

    /**
     * 组装机构班课信息
     *
     * @param imgServer
     * @return
     */
    private List<OrgRecommendCourseList> getHotBCourse(Map<Long, Storage> classStorageMap, List<TeacherClassCourse> t,
                                                       String imgServer, String monkeySite) {
        List<OrgRecommendCourseList> result = Lists.newArrayList();
        if (t != null && !t.isEmpty()) {
            for (TeacherClassCourse course : t) {
                OrgRecommendCourseList ret = this.getHotClassCourses(classStorageMap, course, imgServer, monkeySite);
                if (ret != null) {
                    result.add(ret);
                }
            }
        }
        return result;
    }

    /**
     * 组装机构班课信息
     *
     * @param imgServer
     * @return
     */
    private List<OrgRecommendCourseList> getHotXXCourse(Map<Integer, Storage> orgCourseStorageMap, List<OrgCourse> c,
                                                        String imgServer, String monkeySite) {
        List<OrgRecommendCourseList> result = Lists.newArrayList();
        if (c != null && !c.isEmpty()) {
            for (OrgCourse course : c) {
                OrgRecommendCourseList ret = this.getHotOrgCourses(orgCourseStorageMap, course, imgServer, monkeySite);
                if (ret != null) {
                    result.add(ret);
                }
            }
        }
        return result;
    }

    /**
     * 获取机构自定义课程分类
     *
     * @param orgId
     * @return
     */
    private List<OrgCourseGroupRelate> getOrgCustomGroupCourse(Integer orgId, PageDto pageDto) {
        return orgCourseGroupRelateDao.getOrgCourseGroup(orgId, pageDto);
    }

    /**
     * 获取机构正在招生的班课列表
     *
     * @param orgNumber 机构number
     * @param pageDto
     * @return
     */
    private List<TeacherClassCourse> getOrgTeacherClassCourseList(Integer orgNumber, Collection<Long> excludeIds,
                                                                  PageDto pageDto) {
        return this.teacherClassCourseDao.getOrgCourseList(orgNumber, excludeIds, pageDto);
    }

    /**
     * 获取机构未下架的3810课程
     *
     * @param orgNumber 机构number
     * @param pageDto
     * @return
     */
    private List<OrgCourse> getOrgCourseList(Integer orgNumber, Collection<Long> excludeIds, PageDto pageDto) {
        return this.orgCourseDao.getAndFilterOrgCourse(orgNumber, excludeIds, CourseTypeEnum.IS_COURSE_TRUE.getCode(),
                null, null, pageDto);
    }

    /**
     * 1:首先取用户自定义课程分类4个 1.1:如果自定义分类等于4个,返回这四个分类
     *
     * @param subjects
     * @param limit
     * @return
     */
    public List<DefaultTemplateDataList> getCourseSubjects(List<String> subjects, int limit, OrgBaseInfoModel model,
                                                           OptionalParams params) {
        List<DefaultTemplateDataList> data = Lists.newArrayList();

        DefaultTemplateDataList item = null;

        String courseUrl = BizConf.ORG_COURSE_LINK.replace("{host}", params.getMonkeySiteHost()).replace("{number}",
                model.getNumber().toString());
        if (subjects != null && !subjects.isEmpty()) {
            int index = 0;
            for (String name : subjects) {
                item = new DefaultTemplateDataList();
                item.setName(name);
                item.setLink(courseUrl);
                data.add(item);
                index++;
                if (index == limit) {
                    break;
                }
            }
        } else {
            int index = 1;
            for (String link : BizConf.PHOTO_LINKS) {
                item = new DefaultTemplateDataList();
                item.setLink(courseUrl);
                item.setName("分类" + index);
                data.add(item);
                index++;
            }
        }

        return data;
    }

    /**
     * 获取机构班课和3810课程分类列表
     *
     * @param number
     * @return
     */
    private Set<String> getClassCourseAndOrgCourseSubjects(Integer number) {
        List<Integer> classCourseSubjectIds = getTeacherClassCourseSubjects(number);
        List<Integer> orgCourseSubjectIds = getOrgCourseSubjects(number);

        Set<String> result = Sets.newHashSet();
        Set<Integer> subjectIds = Sets.newHashSet();
        subjectIds.addAll(classCourseSubjectIds);
        subjectIds.addAll(orgCourseSubjectIds);

        if (subjectIds != null && !subjectIds.isEmpty()) {
            List<String> subLists = this.subjectDao.getSubjectNames(subjectIds, "name");
            result.addAll(subLists);
        }
        return result;
    }

    /**
     * 获取机构自定义分类列表
     *
     * @param orgId jigou Id
     */
    private List<String> getOrgCustomClassfication(Integer orgId) {
        PageDto page = new PageDto();
        page.setPageSize(BizConf.MAX_SUBJECT_DISPLAY);
        return this.orgCourseGroupDao.getDistinctSubject(orgId, page);
    }

    /**
     * 获取机构3810课程分类列表
     *
     * @param number
     * @return
     */
    private List<Integer> getOrgCourseSubjects(Integer number) {
        return orgCourseDao.getOrgCourseSubjectIds(number, null, null, null);
    }

    /**
     * 获取机构班课课程分类列表
     *
     * @param number
     * @return
     */
    private List<Integer> getTeacherClassCourseSubjects(Integer number) {
        return teacherClassCourseDao.getOrgDistinctSubject(number);
    }

    Storage getClassCourseStorage(Long storageId) {
        ClassCoursePhoto cover = this.classCoursePhotoDao.getById(storageId);
        return this.storageDao.getById(cover.getStorageId());
    }

    Storage getStorage(Long storageId) {
        return this.storageDao.getById(storageId);
    }

    /**
     * 渲染出国留学模板
     *
     * @param orgId
     * @return
     */
    private JSONObject wrapperAbroadTemplate(Integer orgId, String content, OptionalParams params) {
        OrgBaseInfoModel model = this.getAndSetOrgInfoModel(orgId, params);
        JSONObject abroadJson = JSONObject.fromObject(content);

        abroadJson.put("orgInfo", JSONObject.fromObject(model));
        return abroadJson;
    }

    /**
     * 设置机构number和domain
     *
     * @param orgId
     * @param model
     */
    private void getAndSetOrgNumber(Integer orgId, OrgBaseInfoModel model, String host) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId);
        if (orgAccount != null) {
            model.setNumber(orgAccount.getNumber());
            model.setDomain(host + "/i/" + model.getNumber());
            getAndSetOrgInfo(orgId, model);
            getAndSetOrgCourse(orgAccount.getNumber(), model);
        } else {
            throw new BussinessException(OrgErrorCode.USER_NOT_FOUND);
        }
    }

    /**
     * 设置机构基本信息
     *
     * @param orgId
     * @param model
     */
    private void getAndSetOrgInfo(Integer orgId, OrgBaseInfoModel model) {
        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId);

        if (orgInfo != null) {
            TX400Phone tx400Phone = tx400PhoneDao.getByOrgId(orgId);
            if (tx400Phone != null) {
                model.setExtension(tx400Phone.getPhone400());
            } else if (TX400PhoneDaoImpl.NO_400_ORGMAP.containsKey(orgId)) {
                model.setExtension(TX400PhoneDaoImpl.NO_400_ORGMAP.get(orgId));
            } else {
                if (StringUtils.isNotBlank(orgInfo.getExtension())) {
                    model.setExtension(BizConf._400_PHONE_PREFIX + "," + orgInfo.getExtension());
                } else {
                    model.setExtension(BizConf._400_PHONE_PREFIX);
                }
            }
            model.setId(orgId);
            model.setShortName(orgInfo.getShortName());
        } else {
            throw new BussinessException(OrgErrorCode.USER_NOT_FOUND);
        }
    }

    /**
     * 设置机构简介
     *
     * @param orgId
     * @param model
     */
    private void getAndSetSummary(Integer orgId, OrgBaseInfoModel model) {
        OrgTxtMsg summary = orgTxtMsgDao.getOrgTxtByIdAndType(orgId, AuditColumType.SUMMARY.getValue());
        if (summary != null) {
            model.setBrief(summary.getValue());
        }
    }

    /**
     * 设置机构分校区地址
     *
     * @param orgId
     * @param model
     */
    private void getAndSetAddress(Integer orgId, OrgBaseInfoModel model) {
        List<OrgBranchs> branchs = this.orgBranchsDao.listBranchsByOrgId(orgId);
        if (branchs != null && !branchs.isEmpty()) {
            OrgBranchs branch = branchs.get(0);
            if (branch != null) {
                branch.setProvince(branch.getProvince() == null ? "" : branch.getProvince());
                branch.setCounty(branch.getCounty() == null ? "" : branch.getCounty());
                branch.setDistrict(branch.getDistrict() == null ? "" : branch.getDistrict());
                branch.setAddress(branch.getAddress() == null ? "" : branch.getAddress());
                model
                        .setAddress(branch.getProvince() + branch.getCounty() + branch.getDistrict() + branch.getAddress());
            } else {
                model.setAddress("");
            }
        } else {
            model.setAddress("");
        }
    }

    /**
     * 设置机构特色标签
     *
     * @param orgId
     * @param model
     */
    private void getAndSetTags(Integer orgId, OrgBaseInfoModel model) {
        OrgTxtMsg tags = orgTxtMsgDao.getOrgTxtByIdAndType(orgId, AuditColumType.TAGS.getValue());
        if (tags != null) {
            String value = tags.getValue();
            if (StringUtils.isNotBlank(value)) {
                model.setTags(value.split("\\s+"));
            }
        }
    }

    /**
     * 设置机构logo
     *
     * @param orgId
     * @param model
     */
    private void getAndSetOrgLogo(Integer orgId, OrgBaseInfoModel model, String imgServer) {
        List<OrgPhoto> imgs = this.orgPhotoDao.getByOrgIdAndCategory(orgId, OrgImgType.ORG_LOGO.getValue());

        logger.info("getAndSetOrgLogo.orgId:{}, imgServer:{}, logogs:{}", orgId, imgServer,
                JSONArray.fromObject(imgs).toString());
        if (imgs != null && !imgs.isEmpty()) {
            OrgPhoto logo = imgs.get(0);
            Integer storageId = logo.getOrgStorageId();
            OrgStorage storage = this.orgStorageDao.getById(storageId);
            if (storage != null) {
                model.setLogo(constructUrl(storage, imgServer));
            }
        } else {
            model.setLogo(BizConf.DEFAULT_LOGO_URL);
        }
    }

    /**
     * 获取机构可报名的3810课程和班课数
     *
     * @param orgNumber
     * @param model
     */
    private void getAndSetOrgCourse(Integer orgNumber, OrgBaseInfoModel model) {
        int classCourseCount = this.teacherClassCourseDao.getVliadClassCourseCount(orgNumber);
        int microCourseCount =
                this.orgCourseDao.getValidOrgCourseCount(orgNumber, CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null);
        model.setCourseCount(microCourseCount);
    }

    /**
     * 获取机构logo地址
     *
     * @param storage
     * @return
     */
    public String constructUrl(OrgStorage storage, String imgServer) {
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = ((MIMEType.values())[storage.getMimeType() - 1]).getExtension();
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    /**
     * 获取cdb.storage表数据对应图片url
     *
     * @param storage
     * @return
     */
    public String constructUrl(Storage storage, String imgServer) {
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = "";
        if (storage == null) {
            return "";
        }
        if (StringUtils.isNotBlank(storage.getMimetype())) {
            if (storage.getMimetype().contains("/")) {
                surfix = storage.getMimetype().split("/")[1];
            } else {
                surfix = storage.getMimetype();
            }
        }
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    // 机构m关于我们链接地址
    private List<DefaultTemplateDataList> getAboutUsLinks(Integer number, String monkeySiteHost, String gsxSiteHost) {
        DefaultTemplateDataList[] list = new DefaultTemplateDataList[]{
                new DefaultTemplateDataList("关于我们",
                        getRealAddress(BizConf.ABOUT_US, monkeySiteHost, gsxSiteHost, number.toString())),
                new DefaultTemplateDataList("最新课程",
                        getRealAddress(BizConf.ORG_COURSE_LINK, monkeySiteHost, gsxSiteHost, number.toString())),
                new DefaultTemplateDataList("老师团队",
                        getRealAddress(BizConf.ORG_TEACHER_LINK, monkeySiteHost, gsxSiteHost, number.toString())),
                new DefaultTemplateDataList("在线预约", "javascript:;"),
                new DefaultTemplateDataList("学员之声",
                        getRealAddress(BizConf.ORG_COMMENT_LINK, monkeySiteHost, gsxSiteHost, number.toString())),
                new DefaultTemplateDataList("优惠活动",
                        getRealAddress(BizConf.ORG_COUPON_LINK, monkeySiteHost, gsxSiteHost, number.toString())),};

        return Arrays.asList(list);
    }

    private String getRealAddress(String source, String monkeySiteHost, String gsxSiteHost, String number) {
        if (source.contains("{host}")) {
            return source.replace("{host}", monkeySiteHost).replace("{number}", number);
        } else {
            return source.replace("{host1}", gsxSiteHost).replace("{number}", number);
        }
    }

    /*
     * (non-Javadoc)
     *
     * @see com.baijia.tianxiao.sal.organization.org.service.OrgIndexService#preview(java.lang.Integer)
     */

    @Override
    public OrgBaseInfoModel preview(Integer orgId, OptionalParams params) {
        return this.getAndSetOrgInfoModel(orgId, params);
    }

    private List<OrgRecommendCourseList> convertToKaixue(OptionalParams params, List<OrgTemplateCourse> list,
                                                         boolean readonly) {
        logger.info("convertToKaixue ==params={},{}", params, list);

        String imgServer = params.getImgServer();
        String monkeySite = params.getMonkeySiteHost();
        List<OrgRecommendCourseList> result = Lists.newArrayList();

        List<Long> courseIds = Lists.newArrayList();
        for (OrgTemplateCourse templateCourse : list) {
            courseIds.add(templateCourse.getCourseId().longValue());
        }
        List<TeacherClassCourse> classList = teacherClassCourseDao.getByIds(courseIds);
        Map<Long, TeacherClassCourse> classCourseMap =
                CollectorUtil.collectMap(classList, new Function<TeacherClassCourse, Long>() {
                    @Override
                    public Long apply(TeacherClassCourse teacherClassCourse) {
                        return teacherClassCourse.getId();
                    }
                });
        List<OrgCourse> orgCourseList = orgCourseDao.getByIds(courseIds);
        Map<Long, OrgCourse> orgCourseCourseMap =
                CollectorUtil.collectMap(orgCourseList, new Function<OrgCourse, Long>() {
                    @Override
                    public Long apply(OrgCourse o) {
                        return o.getId();
                    }
                });

        logger.info("convertToKaixue ==params={},{}", orgCourseList, orgCourseCourseMap);


        List<Integer> orgCourseStorageIds = Lists.newArrayList();
        for (OrgCourse l : orgCourseList) {
            orgCourseStorageIds.add(l.getCover());
        }
        List<Storage> orgCourseStorageList = storageDao.getByIds(orgCourseStorageIds);
        // key为Storage.id，value为图像
        Map<Integer, Storage> orgCourseStorageMap = Maps.newConcurrentMap();
        for (Storage s : orgCourseStorageList) {
            orgCourseStorageMap.put(s.getId().intValue(), s);
        }

        List<Long> classStorageIds = Lists.newArrayList();
        for (TeacherClassCourse l : classList) {
            classStorageIds.add(l.getCover());
        }
        List<ClassCoursePhoto> covers = classCoursePhotoDao.getByIds(classStorageIds);
        // key为ClassCoursePhoto.storageId
        Map<Long, ClassCoursePhoto> coverMap = CollectorUtil.collectMap(covers, new Function<ClassCoursePhoto, Long>() {
            @Override
            public Long apply(ClassCoursePhoto o) {
                return o.getStorageId();
            }
        });
        List<Long> storageIds = Lists.newArrayList();
        for (ClassCoursePhoto c : covers) {
            storageIds.add(c.getStorageId());
        }
        List<Storage> classStorageList = storageDao.getByIds(storageIds);
        // key为Storage.id
        Map<Long, Storage> storageMap = CollectorUtil.collectMap(classStorageList, new Function<Storage, Long>() {
            @Override
            public Long apply(Storage storage) {
                return storage.getId();
            }
        });
        // key为ClassCoursePhoto.id，value为图像
        Map<Long, Storage> classStorageMap = Maps.newConcurrentMap();
        for (Long l : coverMap.keySet()) {
            classStorageMap.put(l, storageMap.get(l));
        }

        for (OrgTemplateCourse templateCourse : list) {
            if (templateCourse.getCourseType().intValue() == CourseType.CLASS.getCode()) {
                OrgRecommendCourseList dto = this.getHotClassCourses(classStorageMap,
                        classCourseMap.get(templateCourse.getCourseId().longValue()), imgServer, monkeySite);
                if (dto != null) {
                    result.add(dto);
                }
            } else if (templateCourse.getCourseType().intValue() == CourseType.ORG_COURSE.getCode()
                    || templateCourse.getCourseType().intValue() == CourseType.ORG_COURSE_1v1.getCode()) {
                logger.info("convertToKaixue ==params={}", templateCourse);

                OrgRecommendCourseList dto = this.getHotOrgCourses(orgCourseStorageMap,
                        orgCourseCourseMap.get(templateCourse.getCourseId().longValue()), imgServer, monkeySite);
                if (dto != null) {
                    result.add(dto);
                }
            }
        }
        if (readonly) {
            if (result.size() == 1 || result.size() == 3) {
                result.remove(result.size() - 1);
            }
        }
        logger.info("convertToKaixue ==params={},result={}", params, result);

        return result;
    }
}
