
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.org.constant.TemplateStatus;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageConfigDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageTemplateDao;
import com.baijia.tianxiao.dal.org.po.OrgHomepageConfig;
import com.baijia.tianxiao.dal.org.po.OrgHomepageTemplate;
import com.baijia.tianxiao.sal.organization.org.dto.OrgHomepageTemplateListDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgHomepageTemplateService;
import com.google.common.collect.Lists;


/**
 * @title OrgHomepageTemplateServiceImpl
 * @desc TODO 
 * @author zhangbing
 * @date 2015年12月5日
 * @version 1.0
 */
@Service
public class OrgHomepageTemplateServiceImpl implements OrgHomepageTemplateService {

    @Autowired
    private OrgHomepageTemplateDao orgHomepageTemplateDao;
    
    @Autowired
    private OrgHomepageConfigDao orgHomepageConfigDao;
    
    /**
     * 获取机构模板列表
     */
    @Override
    public List<OrgHomepageTemplateListDto> getDefaultTemplateList(Integer orgId) {
        OrgHomepageConfig usingTemplate = this.orgHomepageConfigDao.getTemplateConfByStatus(orgId, TemplateStatus.USING.getCode());
        List<OrgHomepageTemplate> templateLists = this.orgHomepageTemplateDao.getAllValidTemplate();
        if (usingTemplate != null) {
            return wrapper(usingTemplate.getTemplateId(), templateLists);
        }
        
        return wrapper(templateLists);
    }
    
    /**
     * 标注已选择的模板
     * @param usedTemplateId
     * @param templateLists
     * @return
     */
    private List<OrgHomepageTemplateListDto> wrapper(int usedTemplateId, List<OrgHomepageTemplate> templateLists) {
        List<OrgHomepageTemplateListDto> data = Lists.newArrayList();
        OrgHomepageTemplateListDto item = null;
        for (OrgHomepageTemplate template : templateLists) {
            item = new OrgHomepageTemplateListDto();
            item.setUsing(template.getId() == usedTemplateId);
            item.setScheme(template.getTemplateName());
            item.setTemplateId(template.getId());
            item.setUrl(template.getUrl());
            item.setName(template.getDisplayName());
            data.add(item);
        }
        return data;
    }
    
    /**
     * 抽取数据
     * @param templateLists
     * @return
     */
    private List<OrgHomepageTemplateListDto> wrapper(List<OrgHomepageTemplate> templateLists) {
        List<OrgHomepageTemplateListDto> data = Lists.newArrayList();
        OrgHomepageTemplateListDto item = null;
        for (OrgHomepageTemplate template : templateLists) {
            item = new OrgHomepageTemplateListDto();
            item.setUsing(false);
            item.setScheme(template.getTemplateName());
            item.setTemplateId(template.getId());
            item.setUrl(template.getUrl());
            item.setName(template.getDisplayName());
            
            data.add(item);
        }
        return data;
    }

    /**
     * 获取模板原始数据
     */
    @Override
    public OrgHomepageTemplate getTemplateById(Integer id) {
        return this.orgHomepageTemplateDao.getById(id);
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.sal.organization.org.service.OrgHomepageTemplateService#update(java.lang.String, java.lang.String)
     */
        
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(String scheme, String content) {
        this.orgHomepageTemplateDao.updateTemplate(scheme, content);
    }
}

    