/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.todo.constant;

public enum RemindType {
    NO_REMIND(0, "\u4e0d\u63d0\u9192", -1L),
    ON_TIME(1, "\u51c6\u65f6", 0L),
    FIVE_MIN_AHEAD(2, "\u63d0\u524d5\u5206\u949f", 300000L),
    TEN_MIN_AHEAD(3, "\u63d0\u524d10\u5206\u949f", 600000L),
    THIRTY_MIN_AHEAD(4, "\u63d0\u524d30\u5206\u949f", 1800000L),
    ONE_HOUR_AHEAD(5, "\u63d0\u524d1\u5c0f\u65f6", 3600000L),
    TWO_HOUR_AHEAD(6, "\u63d0\u524d2\u5c0f\u65f6", 0x6DDD00L),
    ONE_DAY_AHEAD(7, "\u63d0\u524d1\u5929", 86400000L),
    TWO_DAY_AHEAD(8, "\u63d0\u524d2\u5929", 172800000L);

    int value;
    String note;
    long diff;

    private RemindType(int value, String note, long diff) {
        this.value = value;
        this.note = note;
        this.diff = diff;
    }

    public int getValue() {
        return this.value;
    }

    public String getNote() {
        return this.note;
    }

    public long getDiff() {
        return this.diff;
    }

    public static RemindType getByDiff(long diff) {
        RemindType remindType = ON_TIME;
        for (RemindType type : RemindType.values()) {
            if (type.getDiff() != Math.abs(diff)) continue;
            remindType = type;
            break;
        }
        return remindType;
    }

    public static RemindType getByValue(int value) {
        RemindType remindType = null;
        for (RemindType type : RemindType.values()) {
            if (type.getValue() != value) continue;
            remindType = type;
            break;
        }
        return remindType;
    }

    public static long getDiffByValue(int value) {
        long diff = ON_TIME.getDiff();
        for (RemindType type : RemindType.values()) {
            if (type.getValue() != value) continue;
            diff = type.getDiff();
            break;
        }
        return diff;
    }
}

