/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.OrgCourseStatus;
import com.baijia.tianxiao.constants.TeacherClassCourseStatus;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.constant.ClassCourseStatus;
import com.baijia.tianxiao.dal.course.dao.ClassCoursePhotoDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.dao.OrgRecommendCourseDao;
import com.baijia.tianxiao.dal.course.dao.SubjectDao;
import com.baijia.tianxiao.dal.course.dao.TeacherClassCourseDao;
import com.baijia.tianxiao.dal.course.po.ClassCoursePhoto;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroup;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroupRelate;
import com.baijia.tianxiao.dal.course.po.OrgRecommendCourse;
import com.baijia.tianxiao.dal.course.po.TeacherClassCourse;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.AuditColumType;
import com.baijia.tianxiao.dal.org.constant.MIMEType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.constant.TemplateStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageConfigDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageTemplateDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgBranchs;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgHomepageConfig;
import com.baijia.tianxiao.dal.org.po.OrgHomepageTemplate;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgTemplateCourse;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.wechat.dao.UnifiedWechatAccountDao;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.OrgErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.OrganizationInfoAPIService;
import com.baijia.tianxiao.sal.common.utils.OrgInfoCampare;
import com.baijia.tianxiao.sal.organization.constant.TemplatModuleType;
import com.baijia.tianxiao.sal.organization.dto.OptionalParams;
import com.baijia.tianxiao.sal.organization.org.dto.OrgBaseInfoModel;
import com.baijia.tianxiao.sal.organization.org.dto.OrgRecommendCourseList;
import com.baijia.tianxiao.sal.organization.org.dto.init.DefaultTemplateData;
import com.baijia.tianxiao.sal.organization.org.dto.init.DefaultTemplateDataList;
import com.baijia.tianxiao.sal.organization.org.dto.k12.K12TemplateData;
import com.baijia.tianxiao.sal.organization.org.dto.k12.OrgHotCourseDto;
import com.baijia.tianxiao.sal.organization.org.dto.kaixue.KaixueTemplateDate;
import com.baijia.tianxiao.sal.organization.org.service.OrgIndexService;
import com.baijia.tianxiao.sal.organization.org.service.OrgTemplateCourseService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orgIndexService")
public class OrgIndexServiceImpl
implements OrgIndexService {
    private static final Logger log = LoggerFactory.getLogger(OrgIndexServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(OrgIndexServiceImpl.class);
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgHomepageConfigDao orgHomepageConfigDao;
    @Autowired
    private OrgHomepageTemplateDao orgHomepageTemplateDao;
    @Autowired
    private TeacherClassCourseDao teacherClassCourseDao;
    @Autowired
    private OrgRecommendCourseDao orgRecommendCourseDao;
    @Autowired
    private OrgCourseGroupDao orgCourseGroupDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgTxtMsgDao orgTxtMsgDao;
    @Autowired
    private OrgPhotoDao orgPhotoDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private SubjectDao subjectDao;
    @Autowired
    private OrgBranchsDao orgBranchsDao;
    @Autowired
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Autowired
    private ClassCoursePhotoDao classCoursePhotoDao;
    @Autowired
    private OrgTemplateCourseService orgTemplateCourseService;
    @Autowired
    private UnifiedWechatAccountDao unifiedWechatAccountDao;
    @Autowired
    private OrganizationInfoAPIService organizationInfoAPIService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JSONObject render(Integer orgId, Boolean readOnly, OptionalParams params) throws BussinessException {
        String scheme = "default";
        JSONObject content = null;
        if (params.getTemplateId() == null) {
            OrgHomepageConfig usingTemplate = this.orgHomepageConfigDao.getTemplateConfByStatus(orgId, Integer.valueOf(TemplateStatus.USING.getCode()));
            if (usingTemplate != null) {
                params.setTemplateId(usingTemplate.getTemplateId());
            }
            if (usingTemplate == null) throw new BussinessException((UniverseErrorCode)OrgErrorCode.NO_TEMPLATE_SELECTED);
            String config = usingTemplate.getContent();
            OrgHomepageTemplate template = (OrgHomepageTemplate)this.orgHomepageTemplateDao.getById((Serializable)usingTemplate.getTemplateId(), new String[0]);
            if (template != null) {
                JSONObject templateJson = JSONObject.fromObject((Object)template.getContent());
                templateJson.put((Object)"config", (Object)JSONObject.fromObject((Object)config));
                content = templateJson;
            }
        } else {
            OrgHomepageTemplate template = (OrgHomepageTemplate)this.orgHomepageTemplateDao.getById((Serializable)params.getTemplateId(), new String[0]);
            if (template == null) {
                throw new BussinessException((UniverseErrorCode)OrgErrorCode.NO_TEMPLATE_SELECTED);
            }
            OrgHomepageConfig usingTemplate = this.orgHomepageConfigDao.getTemplateConfByStatus(orgId, Integer.valueOf(TemplateStatus.USING.getCode()));
            if (usingTemplate != null && usingTemplate.getTemplateId() == params.getTemplateId()) {
                String config = usingTemplate.getContent();
                content = JSONObject.fromObject((Object)template.getContent());
                content.put((Object)"config", (Object)JSONObject.fromObject((Object)config));
            } else {
                usingTemplate = this.orgHomepageConfigDao.getTemplateConf(orgId, params.getTemplateId());
                if (usingTemplate != null) {
                    String config = usingTemplate.getContent();
                    content = JSONObject.fromObject((Object)template.getContent());
                    content.put((Object)"config", (Object)JSONObject.fromObject((Object)config));
                } else {
                    content = JSONObject.fromObject((Object)template.getContent());
                }
            }
        }
        scheme = content.getString("scheme");
        return this.dispatch(orgId, scheme, content.toString(), readOnly, params);
    }

    private JSONObject dispatch(Integer orgId, String scheme, String content, Boolean readOnly, OptionalParams params) {
        JSONObject templateJson = null;
        if ("abroad".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperAbroadTemplate(orgId, content, params);
        } else if ("art".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperArtTemplate(orgId, content, params);
        } else if ("k12".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperK12Template(orgId, content, params, readOnly);
        } else if ("kaixue".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperKaixueTemplate(orgId, content, params, readOnly);
        } else if ("zaojiao".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperZaojiaoTemplate(orgId, content, params, readOnly);
        } else if ("default".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperDefaultTemplate(orgId, content, params);
        } else if ("life".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperK12Template(orgId, content, params, readOnly);
        } else if ("language".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperK12Template(orgId, content, params, readOnly);
        } else {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.TEMPLATE_NOT_EXISTS);
        }
        templateJson.put((Object)"scheme", (Object)scheme);
        templateJson.put((Object)"templateId", (Object)params.getTemplateId());
        templateJson.put((Object)"readOnly", (Object)(readOnly != false ? BizConf.TRUE.toString() : BizConf.FALSE.toString()));
        logger.info("dispatch.templateScheme:{}", (Object)templateJson.toString());
        return templateJson;
    }

    private JSONObject wrapperDefaultTemplate(Integer orgId, String content, OptionalParams params) {
        OrgBaseInfoModel model = this.getAndSetOrgInfoModel(orgId, params);
        DefaultTemplateData data = new DefaultTemplateData();
        List<DefaultTemplateDataList> subList = this.getAboutUsLinks(model.getNumber(), params.getMonkeySiteHost(), params.getGsxSiteHost());
        data.setGrid(subList);
        JSONObject defaultJson = JSONObject.fromObject((Object)content);
        defaultJson.put((Object)"orgInfo", (Object)JSONObject.fromObject((Object)((Object)model)));
        JSONObject dataJson = JSONObject.fromObject((Object)((Object)data));
        defaultJson.put((Object)"data", (Object)dataJson);
        return defaultJson;
    }

    private OrgBaseInfoModel getAndSetOrgInfoModel(Integer orgId, OptionalParams params) {
        OrgBaseInfoModel model = new OrgBaseInfoModel();
        this.getAndSetOrgNumber(orgId, model, params.getMonkeySiteHost());
        this.getAndSetSummary(orgId, model);
        this.getAndSetAddress(orgId, model);
        this.getAndSetTags(orgId, model);
        this.getAndSetOrgLogo(orgId, model, params.getImgServer());
        JSONArray branchJsonObj = JSONArray.fromObject(this.listAllCampusUseUnifiedAccount(orgId));
        model.setBranches(branchJsonObj);
        OrgHomepageConfig usingTemplate = this.orgHomepageConfigDao.getTemplateConfByStatus(orgId, Integer.valueOf(TemplateStatus.USING.getCode()));
        if (usingTemplate != null) {
            model.setTemplateId(usingTemplate.getTemplateId());
        }
        model.setLinks(this.getFooterLinks(model.getNumber(), params.getMonkeySiteHost(), params.getGsxSiteHost()));
        return model;
    }

    private JSONObject getFooterLinks(Integer number, String monkeySizeHost, String gsxSiteHost) {
        JSONObject links = new JSONObject();
        links.put((Object)"course", (Object)this.getLink("{host}/course/{number}", number, monkeySizeHost, gsxSiteHost));
        links.put((Object)"brief", (Object)this.getLink("{host1}/org/intro/{number}", number, monkeySizeHost, gsxSiteHost));
        links.put((Object)"comment", (Object)this.getLink("{host1}/org/comment/{number}", number, monkeySizeHost, gsxSiteHost));
        links.put((Object)"album", (Object)this.getLink("{host}/photo/{number}", number, monkeySizeHost, gsxSiteHost));
        links.put((Object)"branch", (Object)this.getLink("{host}/branch/{number}", number, monkeySizeHost, gsxSiteHost));
        links.put((Object)"teacher", (Object)this.getLink("{host}/teacher/{number}", number, monkeySizeHost, gsxSiteHost));
        links.put((Object)"coupon", (Object)this.getLink("{host1}/org/couponList?number={number}", number, monkeySizeHost, gsxSiteHost));
        return links;
    }

    public List<Map<String, Object>> listAllCampusUseUnifiedAccount(Integer orgId) {
        if (orgId == null) {
            return GenericsUtils.emptyList();
        }
        ArrayList campusInfoDtos = Lists.newArrayList();
        HashMap orgInfoMap = Maps.newHashMap();
        HashMap orgNumberMapper = Maps.newHashMap();
        this.fillAllCampusOrgInfo(orgInfoMap, orgNumberMapper, orgId);
        log.info("try to find campusUseUnifiedWechatAccount :{}", (Object)orgInfoMap.values().size());
        ArrayList orgInfos = new ArrayList(orgInfoMap.values());
        Collections.sort(orgInfos, new Comparator<OrgInfo>(){

            @Override
            public int compare(OrgInfo o1, OrgInfo o2) {
                return OrgInfoCampare.compareUsePinyin((String)o1.getShortName(), (String)o2.getShortName());
            }
        });
        String keyOfOrgName = "orgName";
        String keyOfOrgMHost = "mUrl";
        String keyOfNumber = "number";
        String lhost = PropertiesReader.getValue((String)"wxm", (String)"m.server");
        log.info("find lHost is :{} ", (Object)lhost);
        for (OrgInfo orgInfo : orgInfos) {
            Integer orgId_ = orgInfo.getOrgId();
            Integer number = (Integer)orgNumberMapper.get(orgId_);
            String orgName = orgInfo.getShortName();
            String mHost = lhost + "/i/" + number;
            HashMap dtoMap = Maps.newHashMapWithExpectedSize((int)2);
            dtoMap.put(keyOfOrgName, orgName);
            dtoMap.put(keyOfOrgMHost, mHost);
            dtoMap.put(keyOfNumber, number);
            campusInfoDtos.add(dtoMap);
        }
        return campusInfoDtos;
    }

    private void fillAllCampusOrgInfo(Map<Integer, OrgInfo> orgInfoMap, Map<Integer, Integer> orgNumberMapper, Integer orgId) {
        if (orgId == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "invalid orgId :" + orgId);
        }
        List findUnifiedWechatRecords = this.unifiedWechatAccountDao.listAllCampusWithAnyOneOrgInfo(Long.valueOf(orgId.longValue()), true);
        if (GenericsUtils.isNullOrEmpty((Object)findUnifiedWechatRecords)) {
            return;
        }
        List orgIds = GenericsUtils.toFieldList((Collection)findUnifiedWechatRecords, (String)"orgId");
        log.info("orgIds is :{} ", (Object)orgIds);
        orgInfoMap.putAll(this.organizationInfoAPIService.getOrgInfoMap((Collection)orgIds));
        List allOrgAccounts = this.orgAccountDao.getByIds(orgInfoMap.keySet(), new String[]{"id", "number"});
        orgNumberMapper.putAll(GenericsUtils.toFieldMap((Collection)allOrgAccounts, (String[])new String[]{"id", "number"}));
    }

    private JSONObject wrapperArtTemplate(Integer orgId, String content, OptionalParams params) {
        OrgBaseInfoModel model = this.getAndSetOrgInfoModel(orgId, params);
        JSONObject artJson = JSONObject.fromObject((Object)content);
        List<String> subjects = this.getOrgCourseSubject(orgId, model.getNumber(), BizConf.MAX_SUBJECT_DISPLAY);
        List<DefaultTemplateDataList> kinds = this.getCourseSubjects(subjects, BizConf.MAX_SUBJECT_DISPLAY, model, params);
        JSONObject dataJson = artJson.getJSONObject("data");
        dataJson.put((Object)"kinds", (Object)JSONArray.fromObject(kinds));
        artJson.put((Object)"orgInfo", (Object)JSONObject.fromObject((Object)((Object)model)));
        artJson.put((Object)"data", (Object)dataJson);
        return artJson;
    }

    private JSONObject wrapperK12Template(Integer orgId, String content, OptionalParams params, Boolean readOnly) {
        OrgBaseInfoModel model = this.getAndSetOrgInfoModel(orgId, params);
        K12TemplateData data = new K12TemplateData();
        List<OrgRecommendCourseList> courseList = this.getAndSetRecommentCourseList(orgId, params);
        data.setCourseList(courseList);
        List<DefaultTemplateDataList> grid = this.getOrgCourseSubjects(orgId, model.getNumber(), params.getMonkeySiteHost(), params.getGsxSiteHost());
        data.setGrid(grid);
        if (readOnly.booleanValue()) {
            if (grid != null && !grid.isEmpty()) {
                data.setClassifyCourseList(this.getOrgHotCourseList(model.getNumber(), grid, params.getImgServer(), params.getMonkeySiteHost(), readOnly));
            } else {
                data.setClassifyCourseList(Collections.emptyList());
            }
        } else {
            List<DefaultTemplateDataList> tempGrid = this.getTempGrids(orgId, grid);
            data.setClassifyCourseList(this.getOrgHotCourseList(model.getNumber(), tempGrid, params.getImgServer(), params.getMonkeySiteHost(), readOnly));
        }
        JSONObject k12Json = JSONObject.fromObject((Object)content);
        k12Json.put((Object)"orgInfo", (Object)JSONObject.fromObject((Object)((Object)model)));
        JSONObject dataJson = JSONObject.fromObject((Object)((Object)data));
        k12Json.put((Object)"data", (Object)dataJson);
        return k12Json;
    }

    private JSONObject wrapperKaixueTemplate(Integer orgId, String content, OptionalParams params, Boolean readOnly) {
        OrgBaseInfoModel model = this.getAndSetOrgInfoModel(orgId, params);
        KaixueTemplateDate data = new KaixueTemplateDate();
        logger.info("params=={},", (Object)params);
        data.setMiaoshaList(this.convertToKaixue(params, this.orgTemplateCourseService.getByOrgIdTemplate(orgId, params.getTemplateId(), TemplatModuleType.MIAOSHA.getValue()), readOnly));
        data.setTehuiList(this.convertToKaixue(params, this.orgTemplateCourseService.getByOrgIdTemplate(orgId, params.getTemplateId(), TemplatModuleType.TEHUI.getValue()), readOnly));
        logger.info("data=={},", (Object)data);
        List<DefaultTemplateDataList> grid = this.getOrgCourseSubjects(orgId, model.getNumber(), params.getMonkeySiteHost(), params.getGsxSiteHost());
        List<DefaultTemplateDataList> tempGrid = this.getTempGrids(orgId, grid);
        data.setClassifyCourseList(this.getOrgHotCourseList(model.getNumber(), tempGrid, params.getImgServer(), params.getMonkeySiteHost(), readOnly));
        JSONObject kaixueJson = JSONObject.fromObject((Object)content);
        kaixueJson.put((Object)"orgInfo", (Object)JSONObject.fromObject((Object)((Object)model)));
        JSONObject dataJson = JSONObject.fromObject((Object)((Object)data));
        kaixueJson.put((Object)"data", (Object)dataJson);
        return kaixueJson;
    }

    private JSONObject wrapperZaojiaoTemplate(Integer orgId, String content, OptionalParams params, Boolean readOnly) {
        OrgBaseInfoModel model = this.getAndSetOrgInfoModel(orgId, params);
        K12TemplateData data = new K12TemplateData();
        List<DefaultTemplateDataList> grid = this.getOrgCourseSubjects(orgId, model.getNumber(), params.getMonkeySiteHost(), params.getGsxSiteHost());
        List<DefaultTemplateDataList> tempGrid = this.getTempGrids(orgId, grid);
        data.setClassifyCourseList(this.getOrgHotCourseList(model.getNumber(), tempGrid, params.getImgServer(), params.getMonkeySiteHost(), readOnly));
        JSONObject zaojiaoJson = JSONObject.fromObject((Object)content);
        zaojiaoJson.put((Object)"orgInfo", (Object)JSONObject.fromObject((Object)((Object)model)));
        JSONObject dataJson = JSONObject.fromObject((Object)((Object)data));
        zaojiaoJson.put((Object)"data", (Object)dataJson);
        return zaojiaoJson;
    }

    private List<DefaultTemplateDataList> getTempGrids(Integer orgId, List<DefaultTemplateDataList> grids) {
        List orgCourseGroupList;
        ArrayList tempGrids = Lists.newArrayList();
        HashMap existGrids = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(grids)) {
            for (DefaultTemplateDataList grid : grids) {
                if (grid.getCourseGroupId() == null) continue;
                existGrids.put(grid.getCourseGroupId(), grid);
            }
            if (existGrids.size() >= BizConf.MAX_COURSE_GROUP) {
                return grids;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(orgCourseGroupList = this.orgCourseGroupDao.getOrgCourseGroupList(orgId)))) {
            for (OrgCourseGroup group : orgCourseGroupList) {
                if (tempGrids.size() >= BizConf.MAX_COURSE_GROUP) break;
                if (!existGrids.containsKey(group.getId())) {
                    DefaultTemplateDataList item = new DefaultTemplateDataList();
                    item.setCourseGroupId(group.getId());
                    item.setName(group.getName());
                    tempGrids.add(item);
                    continue;
                }
                tempGrids.add(existGrids.get(group.getId()));
            }
        }
        logger.info("####################### tempGrids:{}", (Object)tempGrids);
        return tempGrids;
    }

    private List<DefaultTemplateDataList> getOrgCourseSubjects(Integer orgId, Integer number, String monkeySiteHost, String gsxSiteHost) {
        List orgCourseGroupList = this.orgCourseGroupDao.getOrgCourseGroupList(orgId);
        ArrayList gridList = Lists.newArrayList();
        String link = this.getLink("{host}/course/{number}", number, monkeySiteHost, gsxSiteHost);
        DefaultTemplateDataList item = null;
        if (orgCourseGroupList != null && !orgCourseGroupList.isEmpty()) {
            ArrayList ids = Lists.newArrayList();
            for (OrgCourseGroup courseGroup : orgCourseGroupList) {
                ids.add(courseGroup.getId());
            }
            List<Object> classList = Lists.newArrayList();
            List<Object> orgCourseList = Lists.newArrayList();
            classList = this.getOrgCourseGroupRelateList((List<OrgCourseGroupRelate>)classList, ids, CourseType.CLASS.getCode());
            orgCourseList = this.getOrgCourseGroupRelateList((List<OrgCourseGroupRelate>)orgCourseList, ids, CourseType.ORG_COURSE.getCode());
            Map<Object, Object> classMap = Maps.newHashMap();
            Map<Object, Object> orgCourseMap = Maps.newHashMap();
            classMap = this.getOrgCourseGroupRelateMap((List<OrgCourseGroupRelate>)classList, (Map<Integer, List<OrgCourseGroupRelate>>)classMap);
            orgCourseMap = this.getOrgCourseGroupRelateMap((List<OrgCourseGroupRelate>)orgCourseList, (Map<Integer, List<OrgCourseGroupRelate>>)orgCourseMap);
            HashMap classCourseIdsMap = Maps.newHashMap();
            HashMap courseCourseIdsMap = Maps.newHashMap();
            if (classMap.size() > 0) {
                this.getCourseIdsMapByOrgCourseGroupRelate(classMap, classCourseIdsMap);
            }
            if (orgCourseMap.size() > 0) {
                this.getCourseIdsMapByOrgCourseGroupRelate(orgCourseMap, courseCourseIdsMap);
            }
            ArrayList classIds = Lists.newArrayList();
            ArrayList orgCourseIds = Lists.newArrayList();
            if (classList != null && classList.size() > 0) {
                this.getCourseIdsListByOrgCourseGroupRelate(classList, classIds);
            }
            if (orgCourseList != null && orgCourseList.size() > 0) {
                this.getCourseIdsListByOrgCourseGroupRelate(orgCourseList, orgCourseIds);
            }
            List allTeachers = Lists.newArrayList();
            if (classIds.size() > 0) {
                allTeachers = this.teacherClassCourseDao.getValidClassCourseCountsByIds(number, (List)classIds);
            }
            List allCourses = Lists.newArrayList();
            if (orgCourseIds.size() > 0) {
                allCourses = this.orgCourseDao.getValidClassCourseCountsByIds(number, (List)orgCourseIds);
            }
            ArrayList allTeacherCourseIds = Lists.newArrayList();
            for (Object tcc : allTeachers) {
                allTeacherCourseIds.add(tcc.getId().intValue());
            }
            ArrayList allOrgCourseIds = Lists.newArrayList();
            for (OrgCourse oc : allCourses) {
                allOrgCourseIds.add(oc.getId().intValue());
            }
            List<Object> allTeacherCourseList = Lists.newArrayList();
            List<Object> allOrgCourseList = Lists.newArrayList();
            allTeacherCourseList = this.getOrgCourseGroupRelateListByCourseIds(allTeacherCourseList, allTeacherCourseIds, CourseType.CLASS.getCode());
            allOrgCourseList = this.getOrgCourseGroupRelateListByCourseIds(allOrgCourseList, allOrgCourseIds, CourseType.ORG_COURSE.getCode());
            Map<Object, Object> allTeacherCourseMap = Maps.newHashMap();
            Map<Object, Object> allOrgCourseMap = Maps.newHashMap();
            allTeacherCourseMap = this.getOrgCourseGroupRelateMap(allTeacherCourseList, (Map<Integer, List<OrgCourseGroupRelate>>)allTeacherCourseMap);
            allOrgCourseMap = this.getOrgCourseGroupRelateMap(allOrgCourseList, (Map<Integer, List<OrgCourseGroupRelate>>)allOrgCourseMap);
            HashMap allTeacherCourseIdsMap = Maps.newHashMap();
            HashMap allOrgCourseIdsMap = Maps.newHashMap();
            if (allTeacherCourseMap.size() > 0) {
                this.getCourseIdsMapByOrgCourseGroupRelate(allTeacherCourseMap, allTeacherCourseIdsMap);
            }
            if (allOrgCourseMap.size() > 0) {
                this.getCourseIdsMapByOrgCourseGroupRelate(allOrgCourseMap, allOrgCourseIdsMap);
            }
            HashMap classCourseCountMap = Maps.newHashMap();
            HashMap courseCourseCountMap = Maps.newHashMap();
            this.getCourseCountMapByOrgCourseGroupRelate(classCourseIdsMap, allTeacherCourseIdsMap, classCourseCountMap);
            this.getCourseCountMapByOrgCourseGroupRelate(courseCourseIdsMap, allOrgCourseIdsMap, courseCourseCountMap);
            for (OrgCourseGroup courseGroup : orgCourseGroupList) {
                boolean valid = this.isValidSubject((Integer)classCourseCountMap.get(courseGroup.getId()), (List)classCourseIdsMap.get(courseGroup.getId()));
                if (!valid) {
                    valid = this.isValidSubject((Integer)courseCourseCountMap.get(courseGroup.getId()), (List)courseCourseIdsMap.get(courseGroup.getId()));
                }
                if (valid) {
                    item = new DefaultTemplateDataList();
                    item.setLink(link);
                    item.setName(courseGroup.getName());
                    item.setCourseGroupId(courseGroup.getId());
                    gridList.add(item);
                }
                if (gridList.size() != BizConf.MAX_COURSE_GROUP.intValue()) continue;
                break;
            }
        }
        gridList.add(new DefaultTemplateDataList("\u540d\u5e08\u63a8\u8350", this.getLink("{host}/teacher/{number}", number, monkeySiteHost, gsxSiteHost)));
        gridList.add(new DefaultTemplateDataList("\u5b66\u5458\u8bc4\u4ef7", this.getLink("{host1}/org/comment/{number}", number, monkeySiteHost, gsxSiteHost)));
        gridList.add(new DefaultTemplateDataList("\u6821\u533a\u67e5\u8be2", this.getLink("{host}/branch/{number}", number, monkeySiteHost, gsxSiteHost)));
        return gridList;
    }

    private List<OrgCourseGroupRelate> getOrgCourseGroupRelateListByCourseIds(List<OrgCourseGroupRelate> list, List<Integer> ids, int courseType) {
        if (ids.size() > 0) {
            list = this.orgCourseGroupRelateDao.getCourseGroupRelateByCourseIds(ids, courseType);
        }
        return list;
    }

    private Map<Integer, List<OrgCourseGroupRelate>> getOrgCourseGroupRelateMap(List<OrgCourseGroupRelate> list, Map<Integer, List<OrgCourseGroupRelate>> map) {
        if (list != null && list.size() > 0) {
            map = CollectorUtil.group(list, (Function)new Function<OrgCourseGroupRelate, Integer>(){

                public Integer apply(OrgCourseGroupRelate o) {
                    return (int)o.getCourseGroupId();
                }
            });
        }
        return map;
    }

    private List<OrgCourseGroupRelate> getOrgCourseGroupRelateList(List<OrgCourseGroupRelate> list, List<Integer> ids, int courseType) {
        if (ids.size() > 0) {
            list = this.orgCourseGroupRelateDao.getCourseGroupRelateByGroupIds(ids, courseType);
        }
        return list;
    }

    private void getCourseCountMapByOrgCourseGroupRelate(Map<Integer, List<Integer>> bigMap, Map<Integer, List<Integer>> smallMap, Map<Integer, Integer> courseCountMap) {
        for (Integer i : bigMap.keySet()) {
            List<Integer> big = bigMap.get(i);
            List<Integer> small = smallMap.get(i);
            if (small != null) {
                big.retainAll(small);
                courseCountMap.put(i, big.size());
                continue;
            }
            courseCountMap.put(i, 0);
        }
    }

    private void getCourseIdsMapByOrgCourseGroupRelate(Map<Integer, List<OrgCourseGroupRelate>> map, Map<Integer, List<Integer>> fill) {
        for (Integer in : map.keySet()) {
            ArrayList list = Lists.newArrayList();
            List<OrgCourseGroupRelate> temp = map.get(in);
            if (temp == null) continue;
            for (OrgCourseGroupRelate o : temp) {
                list.add(o.getCourseId().intValue());
            }
            fill.put(in, list);
        }
    }

    private void getCourseIdsListByOrgCourseGroupRelate(List<OrgCourseGroupRelate> list, List<Integer> fill) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Integer id = list.get(i).getCourseId().intValue();
            fill.add(id);
        }
    }

    private boolean isValidSubject(Integer c, List<Integer> ids) {
        int count = 0;
        if (ids != null && !ids.isEmpty()) {
            count = c;
        }
        return count > 0;
    }

    private String getLink(String url, Integer number, String monkeySizeHost, String gsxSiteHost) {
        if (url.contains("{host}")) {
            return url.replaceAll("\\{host\\}", monkeySizeHost).replaceAll("\\{number\\}", number.toString());
        }
        return url.replaceAll("\\{host1\\}", gsxSiteHost).replaceAll("\\{number\\}", number.toString());
    }

    private List<OrgRecommendCourseList> getAndSetRecommentCourseList(Integer orgId, OptionalParams params) {
        List recommendCourses = this.orgRecommendCourseDao.getRecommendCourseList(orgId);
        String imgServer = params.getImgServer();
        String monkeySite = params.getMonkeySiteHost();
        String gsxSite = params.getGsxSiteHost();
        ArrayList data = Lists.newArrayList();
        if (recommendCourses != null && !recommendCourses.isEmpty()) {
            OrgRecommendCourseList subData = null;
            Map<Long, OrgCourse> orgCourseCache = this.getAndCacheOrgCourseInfo(recommendCourses);
            Map<Long, TeacherClassCourse> classCourseCache = this.getAndCacheClassCourseInfo(recommendCourses);
            ArrayList orgCourseStorageIds = Lists.newArrayList();
            for (Long l : orgCourseCache.keySet()) {
                orgCourseStorageIds.add(orgCourseCache.get(l).getCover());
            }
            List orgCourseStorageList = this.storageDao.getByIds((Collection)orgCourseStorageIds, new String[0]);
            ConcurrentMap orgCourseStorageMap = Maps.newConcurrentMap();
            for (Object s : orgCourseStorageList) {
                orgCourseStorageMap.put(s.getId().intValue(), s);
            }
            ArrayList classStorageIds = Lists.newArrayList();
            for (Long l : classCourseCache.keySet()) {
                classStorageIds.add(classCourseCache.get(l).getCover());
            }
            List covers = this.classCoursePhotoDao.getByIds((Collection)classStorageIds, new String[0]);
            Map coverMap = CollectorUtil.collectMap((Collection)covers, (Function)new Function<ClassCoursePhoto, Long>(){

                public Long apply(ClassCoursePhoto o) {
                    return o.getStorageId();
                }
            });
            ArrayList storageIds = Lists.newArrayList();
            for (ClassCoursePhoto c : covers) {
                storageIds.add(c.getStorageId());
            }
            List classStorageList = this.storageDao.getByIds((Collection)storageIds, new String[0]);
            Map storageMap = CollectorUtil.collectMap((Collection)classStorageList, (Function)new Function<Storage, Long>(){

                public Long apply(Storage storage) {
                    return storage.getId();
                }
            });
            ConcurrentMap classStorageMap = Maps.newConcurrentMap();
            for (Long l : coverMap.keySet()) {
                classStorageMap.put(l, storageMap.get(l));
            }
            for (OrgRecommendCourse course : recommendCourses) {
                Storage storage;
                TeacherClassCourse po;
                Integer courseId = course.getCourseid();
                Integer courseType = course.getCourseType();
                subData = new OrgRecommendCourseList();
                if (courseType.intValue() == CourseType.CLASS.getCode()) {
                    if (!classCourseCache.containsKey(courseId.longValue()) || (po = classCourseCache.get(courseId.longValue())).getStatus().intValue() != TeacherClassCourseStatus.ENROLLING.getStatus() || po.getBeginTime().getTime() <= System.currentTimeMillis()) continue;
                    subData.setCourseType(courseType);
                    subData.setName(po.getName());
                    subData.setNumber(po.getNumber());
                    subData.setPrice(po.getPrice().toString());
                    subData.setPreface("");
                    subData.setCourseId(po.getId());
                    if (po.getCover() != null) {
                        storage = (Storage)classStorageMap.get(po.getCover());
                        subData.setPreface(this.constructUrl(storage, imgServer));
                    }
                    subData.setLink("{host1}/teacher/classCourseDetail/{number}".replace("{host1}", gsxSite).replace("{number}", po.getNumber().toString()));
                    data.add(subData);
                    continue;
                }
                if (courseType.intValue() != CourseType.ORG_COURSE.getCode() || !orgCourseCache.containsKey(courseId.longValue()) || (po = orgCourseCache.get(courseId.longValue())) == null || po.getStatus().intValue() != OrgCourseStatus.IN_PROGRESS.getCode()) continue;
                subData.setCourseType(courseType);
                subData.setName(po.getName());
                subData.setNumber(po.getNumber());
                subData.setPrice(po.getPrice().toString());
                subData.setPreface("");
                subData.setCourseId(po.getId());
                if (po.getCover() != null && (storage = (Storage)orgCourseStorageMap.get(po.getCover())) != null) {
                    subData.setPreface(this.constructUrl(storage, imgServer));
                }
                subData.setLink("{host}/course/detail/{number}".replace("{host}", monkeySite).replace("{number}", po.getNumber().toString()));
                data.add(subData);
            }
        }
        return data;
    }

    private Map<Long, OrgCourse> getAndCacheOrgCourseInfo(List<OrgRecommendCourse> recommendCourses) {
        ArrayList orgCourseIds = Lists.newArrayList();
        for (OrgRecommendCourse course : recommendCourses) {
            Long courseId = course.getCourseid().longValue();
            Integer courseType = course.getCourseType();
            if (courseType.intValue() != CourseType.ORG_COURSE.getCode()) continue;
            orgCourseIds.add(courseId);
        }
        return this.getOrgCourseCache(orgCourseIds);
    }

    private Map<Long, TeacherClassCourse> getAndCacheClassCourseInfo(List<OrgRecommendCourse> recommendCourses) {
        ArrayList classCourseIds = Lists.newArrayList();
        for (OrgRecommendCourse course : recommendCourses) {
            Long courseId = course.getCourseid().longValue();
            Integer courseType = course.getCourseType();
            if (courseType.intValue() != CourseType.CLASS.getCode()) continue;
            classCourseIds.add(courseId);
        }
        return this.getClassCourseCache(classCourseIds);
    }

    private Map<Long, OrgCourse> getOrgCourseCache(List<Long> ids) {
        return this.orgCourseDao.getOrgCourseMap(ids, new String[0]);
    }

    private Map<Long, TeacherClassCourse> getClassCourseCache(List<Long> ids) {
        return this.teacherClassCourseDao.getTeacherClassCourses(ids);
    }

    private List<String> getOrgCourseSubject(Integer orgId, Integer number, int limit) {
        List<String> subjects = this.getOrgCustomClassfication(orgId);
        logger.info("getOrgCourseSubject.orgId:{}, number:{}, limit:{}, subjects:{}", new Object[]{orgId, number, limit, subjects});
        return subjects;
    }

    private <T> Collection<Long> getPropertiesVals(List<T> objs, CourseType courseType, String cType, String courseId) {
        HashSet excludeIds = Sets.newHashSet();
        switch (courseType) {
            case CLASS: {
                for (T obj : objs) {
                    Integer type = (Integer)BaseUtils.getValue(obj, (String)cType);
                    if (type.intValue() != CourseType.CLASS.getCode()) continue;
                    excludeIds.add((Long)BaseUtils.getValue(obj, (String)courseId));
                }
                break;
            }
            case ORG_COURSE: {
                for (T obj : objs) {
                    Integer type = (Integer)BaseUtils.getValue(obj, (String)cType);
                    if (type.intValue() != CourseType.ORG_COURSE.getCode()) continue;
                    excludeIds.add((Long)BaseUtils.getValue(obj, (String)courseId));
                }
                break;
            }
        }
        return excludeIds;
    }

    private List<OrgHotCourseDto> getOrgHotCourseList(Integer orgNumber, List<DefaultTemplateDataList> grids, String imgServer, String monkeySite, Boolean readOnly) {
        Object temp;
        List ids;
        ArrayList result = Lists.newArrayList();
        ArrayList subResult = null;
        OrgHotCourseDto subItem = null;
        ArrayList allId = Lists.newArrayList();
        for (DefaultTemplateDataList grid : grids) {
            allId.add(grid.getCourseGroupId());
        }
        List<Object> classList = Lists.newArrayList();
        List<Object> orgCourseList = Lists.newArrayList();
        classList = this.getOrgCourseGroupRelateList(classList, allId, CourseType.CLASS.getCode());
        orgCourseList = this.getOrgCourseGroupRelateList(orgCourseList, allId, CourseType.ORG_COURSE.getCode());
        Map<Object, Object> classMap = Maps.newHashMap();
        Map<Object, Object> orgCourseMap = Maps.newHashMap();
        classMap = this.getOrgCourseGroupRelateMap(classList, (Map<Integer, List<OrgCourseGroupRelate>>)classMap);
        orgCourseMap = this.getOrgCourseGroupRelateMap(orgCourseList, (Map<Integer, List<OrgCourseGroupRelate>>)orgCourseMap);
        HashMap classCourseIdsMap = Maps.newHashMap();
        HashMap courseCourseIdsMap = Maps.newHashMap();
        if (classMap.size() > 0) {
            this.getCourseIdsMapByOrgCourseGroupRelate(classMap, classCourseIdsMap);
        }
        if (orgCourseMap.size() > 0) {
            this.getCourseIdsMapByOrgCourseGroupRelate(orgCourseMap, courseCourseIdsMap);
        }
        ArrayList allClassId = Lists.newArrayList();
        ArrayList allOrgCourseId = Lists.newArrayList();
        this.getCourseIds(classCourseIdsMap, allClassId);
        this.getCourseIds(courseCourseIdsMap, allOrgCourseId);
        Map teacherMap = Maps.newHashMap();
        Map courseMap = Maps.newHashMap();
        if (allClassId != null && !allClassId.isEmpty()) {
            teacherMap = this.teacherClassCourseDao.getTeacherClassCourses((Collection)allClassId);
        }
        if (allOrgCourseId != null && !allOrgCourseId.isEmpty()) {
            courseMap = this.orgCourseDao.getOrgCourseMap((Collection)allOrgCourseId, new String[0]);
        }
        HashMap bkMap = Maps.newHashMap();
        HashMap xxkMap = Maps.newHashMap();
        if (classCourseIdsMap.size() > 0) {
            for (Object i : classCourseIdsMap.keySet()) {
                ids = (List)classCourseIdsMap.get(i);
                temp = Lists.newArrayList();
                for (Integer ii : ids) {
                    if (!teacherMap.containsKey(ii.longValue())) continue;
                    temp.add(teacherMap.get(ii.longValue()));
                }
                bkMap.put(i, temp);
            }
        }
        if (courseCourseIdsMap.size() > 0) {
            for (Object i : courseCourseIdsMap.keySet()) {
                ids = (List)courseCourseIdsMap.get(i);
                temp = Lists.newArrayList();
                for (Integer ii : ids) {
                    if (!courseMap.containsKey(ii.longValue())) continue;
                    temp.add(courseMap.get(ii.longValue()));
                }
                xxkMap.put(i, temp);
            }
        }
        ArrayList orgCourseStorageIds = Lists.newArrayList();
        for (Long l : courseMap.keySet()) {
            orgCourseStorageIds.add(((OrgCourse)courseMap.get(l)).getCover());
        }
        List orgCourseStorageList = this.storageDao.getByIds((Collection)orgCourseStorageIds, new String[0]);
        ConcurrentMap orgCourseStorageMap = Maps.newConcurrentMap();
        for (Object s : orgCourseStorageList) {
            orgCourseStorageMap.put(s.getId().intValue(), s);
        }
        logger.debug("-----------------------------orgCourseStorageMap={}", (Object)orgCourseStorageMap);
        ArrayList classStorageIds = Lists.newArrayList();
        for (Long l : teacherMap.keySet()) {
            classStorageIds.add(((TeacherClassCourse)teacherMap.get(l)).getCover());
        }
        List covers = this.classCoursePhotoDao.getByIds((Collection)classStorageIds, new String[0]);
        Map coverMap = CollectorUtil.collectMap((Collection)covers, (Function)new Function<ClassCoursePhoto, Long>(){

            public Long apply(ClassCoursePhoto o) {
                return o.getStorageId();
            }
        });
        ArrayList storageIds = Lists.newArrayList();
        for (ClassCoursePhoto c : covers) {
            storageIds.add(c.getStorageId());
        }
        List classStorageList = this.storageDao.getByIds((Collection)storageIds, new String[0]);
        Map storageMap = CollectorUtil.collectMap((Collection)classStorageList, (Function)new Function<Storage, Long>(){

            public Long apply(Storage storage) {
                return storage.getId();
            }
        });
        ConcurrentMap classStorageMap = Maps.newConcurrentMap();
        for (Long l : coverMap.keySet()) {
            classStorageMap.put(l, storageMap.get(l));
        }
        logger.debug("-----------------------------classStorageMap={}", (Object)classStorageMap);
        for (DefaultTemplateDataList grid : grids) {
            subItem = new OrgHotCourseDto();
            Integer courseGroupId = grid.getCourseGroupId();
            if (courseGroupId == null) continue;
            subItem.setGroupId(courseGroupId);
            subResult = Lists.newArrayList();
            if (bkMap != null && !bkMap.isEmpty()) {
                subResult.addAll(this.getHotBCourse(classStorageMap, (List)bkMap.get(courseGroupId), imgServer, monkeySite));
            }
            if (xxkMap != null && !xxkMap.isEmpty()) {
                subResult.addAll(this.getHotXXCourse(orgCourseStorageMap, (List)xxkMap.get(courseGroupId), imgServer, monkeySite));
            }
            subItem.setName(grid.getName());
            if (subResult != null && !subResult.isEmpty()) {
                if (readOnly.booleanValue()) {
                    if (subResult.size() >= BizConf.MAX_COURSE_DISPLAY) {
                        subItem.setList(subResult.subList(0, BizConf.MAX_COURSE_DISPLAY));
                        result.add(subItem);
                        continue;
                    }
                    if (subResult.size() < BizConf.MAX_COURSE_DISPLAY / 2 || subResult.size() >= BizConf.MAX_COURSE_DISPLAY) continue;
                    subItem.setList(subResult.subList(0, BizConf.MAX_COURSE_DISPLAY / 2));
                    result.add(subItem);
                    continue;
                }
                if (subResult.size() >= BizConf.MAX_COURSE_DISPLAY) {
                    subItem.setList(subResult.subList(0, BizConf.MAX_COURSE_DISPLAY));
                    result.add(subItem);
                    continue;
                }
                subItem.setList(subResult);
                result.add(subItem);
                continue;
            }
            if (readOnly.booleanValue()) continue;
            result.add(subItem);
        }
        return result;
    }

    private void getCourseIds(Map<Integer, List<Integer>> map, List<Long> ids) {
        if (map.size() > 0) {
            for (Integer i : map.keySet()) {
                List<Integer> list = map.get(i);
                for (Integer l : list) {
                    ids.add(l.longValue());
                }
            }
        }
    }

    private List<OrgRecommendCourseList> getOrgHotCourseList(Integer orgId, Integer number, OptionalParams params) {
        Object orgCourseCourseMap;
        int size;
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(BizConf.MAX_SUBJECT_DISPLAY);
        String imgServer = params.getImgServer();
        String monkeySite = params.getMonkeySiteHost();
        ArrayList courses = Lists.newArrayList();
        List<OrgCourseGroupRelate> recommendCourseLists = this.getOrgCustomGroupCourse(orgId, pageDto);
        List<Object> classCourses = Lists.newArrayList();
        List<Object> orgCourses = Lists.newArrayList();
        if (recommendCourseLists != null && !recommendCourseLists.isEmpty()) {
            size = recommendCourseLists.size();
            if (BizConf.MAX_SUBJECT_DISPLAY > size) {
                pageDto.setPageSize(Integer.valueOf(BizConf.MAX_SUBJECT_DISPLAY - size));
                classCourses = this.getOrgTeacherClassCourseList(number, this.getPropertiesVals(recommendCourseLists, CourseType.CLASS, "courseType", "courseId"), pageDto);
                if (BizConf.MAX_SUBJECT_DISPLAY > size + classCourses.size()) {
                    orgCourses = this.getOrgCourseList(number, this.getPropertiesVals(recommendCourseLists, CourseType.ORG_COURSE, "courseType", "courseId"), pageDto);
                }
            }
        } else {
            pageDto.setPageSize(BizConf.MAX_SUBJECT_DISPLAY);
            classCourses = this.getOrgTeacherClassCourseList(number, null, pageDto);
            size = classCourses.size();
            if (classCourses != null && !classCourses.isEmpty() && BizConf.MAX_SUBJECT_DISPLAY > size) {
                pageDto.setPageSize(Integer.valueOf(BizConf.MAX_SUBJECT_DISPLAY - size));
                orgCourses = this.getOrgCourseList(number, null, pageDto);
            }
        }
        if (recommendCourseLists != null && !recommendCourseLists.isEmpty()) {
            Object s22;
            ArrayList courseIds = Lists.newArrayList();
            for (OrgCourseGroupRelate orgCourseGroupRelate : recommendCourseLists) {
                courseIds.add(orgCourseGroupRelate.getCourseId());
            }
            List classList = this.teacherClassCourseDao.getByIds((Collection)courseIds, new String[0]);
            Map map = CollectorUtil.collectMap((Collection)classList, (Function)new Function<TeacherClassCourse, Long>(){

                public Long apply(TeacherClassCourse teacherClassCourse) {
                    return teacherClassCourse.getId();
                }
            });
            List orgCourseList = this.orgCourseDao.getByIds((Collection)courseIds, new String[0]);
            orgCourseCourseMap = CollectorUtil.collectMap((Collection)orgCourseList, (Function)new Function<OrgCourse, Long>(){

                public Long apply(OrgCourse o) {
                    return o.getId();
                }
            });
            ArrayList orgCourseStorageIds = Lists.newArrayList();
            for (OrgCourse orgCourse : orgCourseList) {
                orgCourseStorageIds.add(orgCourse.getCover());
            }
            List orgCourseStorageList = this.storageDao.getByIds((Collection)orgCourseStorageIds, new String[0]);
            ConcurrentMap concurrentMap = Maps.newConcurrentMap();
            for (Object s22 : orgCourseStorageList) {
                concurrentMap.put(s22.getId().intValue(), s22);
            }
            ArrayList classStorageIds = Lists.newArrayList();
            s22 = classList.iterator();
            while (s22.hasNext()) {
                TeacherClassCourse l = (TeacherClassCourse)s22.next();
                classStorageIds.add(l.getCover());
            }
            List covers = this.classCoursePhotoDao.getByIds((Collection)classStorageIds, new String[0]);
            Map coverMap = CollectorUtil.collectMap((Collection)covers, (Function)new Function<ClassCoursePhoto, Long>(){

                public Long apply(ClassCoursePhoto o) {
                    return o.getStorageId();
                }
            });
            ArrayList arrayList = Lists.newArrayList();
            for (ClassCoursePhoto c : covers) {
                arrayList.add(c.getStorageId());
            }
            List classStorageList = this.storageDao.getByIds((Collection)arrayList, new String[0]);
            Map storageMap = CollectorUtil.collectMap((Collection)classStorageList, (Function)new Function<Storage, Long>(){

                public Long apply(Storage storage) {
                    return storage.getId();
                }
            });
            ConcurrentMap classStorageMap = Maps.newConcurrentMap();
            for (Long l : coverMap.keySet()) {
                classStorageMap.put(l, storageMap.get(l));
            }
            for (OrgCourseGroupRelate recommendCourse : recommendCourseLists) {
                OrgRecommendCourseList dto = null;
                if (recommendCourse.getCourseType().intValue() == CourseType.ORG_COURSE.getCode()) {
                    dto = this.getHotOrgCourses(concurrentMap, (OrgCourse)orgCourseCourseMap.get(recommendCourse.getCourseId()), imgServer, monkeySite);
                } else if (recommendCourse.getCourseType().intValue() == CourseType.CLASS.getCode()) {
                    dto = this.getHotClassCourses(classStorageMap, (TeacherClassCourse)map.get(recommendCourse.getCourseId()), imgServer, monkeySite);
                }
                if (dto == null) continue;
                courses.add(dto);
            }
        }
        if (classCourses != null && !classCourses.isEmpty()) {
            ArrayList courseIds = Lists.newArrayList();
            for (TeacherClassCourse teacherClassCourse : classCourses) {
                courseIds.add(teacherClassCourse.getId());
            }
            List list = this.teacherClassCourseDao.getByIds((Collection)courseIds, new String[0]);
            Map map = CollectorUtil.collectMap((Collection)list, (Function)new Function<TeacherClassCourse, Long>(){

                public Long apply(TeacherClassCourse teacherClassCourse) {
                    return teacherClassCourse.getId();
                }
            });
            ArrayList classStorageIds = Lists.newArrayList();
            orgCourseCourseMap = list.iterator();
            while (orgCourseCourseMap.hasNext()) {
                TeacherClassCourse l = (TeacherClassCourse)orgCourseCourseMap.next();
                classStorageIds.add(l.getCover());
            }
            List covers = this.classCoursePhotoDao.getByIds((Collection)classStorageIds, new String[0]);
            Map coverMap = CollectorUtil.collectMap((Collection)covers, (Function)new Function<ClassCoursePhoto, Long>(){

                public Long apply(ClassCoursePhoto o) {
                    return o.getStorageId();
                }
            });
            ArrayList storageIds = Lists.newArrayList();
            Iterator iterator = covers.iterator();
            while (iterator.hasNext()) {
                ClassCoursePhoto c = (ClassCoursePhoto)iterator.next();
                storageIds.add(c.getStorageId());
            }
            List list2 = this.storageDao.getByIds((Collection)storageIds, new String[0]);
            Map storageMap = CollectorUtil.collectMap((Collection)list2, (Function)new Function<Storage, Long>(){

                public Long apply(Storage storage) {
                    return storage.getId();
                }
            });
            ConcurrentMap classStorageMap = Maps.newConcurrentMap();
            for (Long l : coverMap.keySet()) {
                classStorageMap.put(l, storageMap.get(l));
            }
            for (TeacherClassCourse teacherClassCourse : classCourses) {
                OrgRecommendCourseList dto = this.getHotClassCourses(classStorageMap, (TeacherClassCourse)map.get(teacherClassCourse.getId()), imgServer, monkeySite);
                if (dto == null) continue;
                courses.add(dto);
            }
        }
        if (orgCourses != null && !orgCourses.isEmpty()) {
            ArrayList courseIds = Lists.newArrayList();
            for (OrgCourse orgCourse : orgCourses) {
                courseIds.add(orgCourse.getId());
            }
            List orgCourseList = this.orgCourseDao.getByIds((Collection)courseIds, new String[0]);
            Map map = CollectorUtil.collectMap((Collection)orgCourseList, (Function)new Function<OrgCourse, Long>(){

                public Long apply(OrgCourse o) {
                    return o.getId();
                }
            });
            ArrayList orgCourseStorageIds = Lists.newArrayList();
            for (TeacherClassCourse l : orgCourseList) {
                orgCourseStorageIds.add(l.getCover());
            }
            List orgCourseStorageList = this.storageDao.getByIds((Collection)orgCourseStorageIds, new String[0]);
            ConcurrentMap orgCourseStorageMap2 = Maps.newConcurrentMap();
            for (Storage storage : orgCourseStorageList) {
                orgCourseStorageMap2.put(storage.getId().intValue(), storage);
            }
            for (OrgCourse orgCourse : orgCourses) {
                OrgRecommendCourseList dto = this.getHotOrgCourses(orgCourseStorageMap2, (OrgCourse)map.get(orgCourse.getId()), imgServer, monkeySite);
                if (dto == null) continue;
                courses.add(dto);
            }
        }
        return courses;
    }

    private OrgRecommendCourseList getHotOrgCourse(OrgCourse orgCourse, String imgServer, String monkeySite) {
        OrgRecommendCourseList dto = null;
        if (orgCourse != null && orgCourse.getStatus().intValue() == OrgCourseStatus.IN_PROGRESS.getCode()) {
            dto = new OrgRecommendCourseList();
            dto.setCourseType(CourseType.ORG_COURSE.getCode());
            dto.setName(orgCourse.getName());
            dto.setNumber(orgCourse.getNumber());
            dto.setPrice(orgCourse.getPrice().toString());
            dto.setCourseId(orgCourse.getId());
            Integer cover = orgCourse.getCover();
            if (cover != null) {
                Storage storage = this.getStorage(cover.longValue());
                String url = this.constructUrl(storage, imgServer);
                dto.setPreface(url);
            }
            dto.setLink("{host}/course/detail/{number}".replace("{host}", monkeySite).replace("{number}", orgCourse.getNumber().toString()));
        }
        return dto;
    }

    private OrgRecommendCourseList getHotOrgCourses(Map<Integer, Storage> orgCourseStorageMap, OrgCourse orgCourse, String imgServer, String monkeySite) {
        OrgRecommendCourseList dto = null;
        if (orgCourse != null && orgCourse.getStatus().intValue() == OrgCourseStatus.IN_PROGRESS.getCode()) {
            dto = new OrgRecommendCourseList();
            dto.setCourseType(CourseType.ORG_COURSE.getCode());
            dto.setName(orgCourse.getName());
            dto.setNumber(orgCourse.getNumber());
            dto.setPrice(orgCourse.getPrice().toString());
            dto.setCourseId(orgCourse.getId());
            Integer cover = orgCourse.getCover();
            if (cover != null) {
                Storage storage = orgCourseStorageMap.get(cover);
                logger.debug("---------------cover={},storage={}", (Object)cover, (Object)storage);
                String url = this.constructUrl(storage, imgServer);
                dto.setPreface(url);
            }
            dto.setLink("{host}/course/detail/{number}".replace("{host}", monkeySite).replace("{number}", orgCourse.getNumber().toString()));
        }
        return dto;
    }

    private OrgRecommendCourseList getHotClassCourse(TeacherClassCourse classCourse, String imgServer, String monkeySite) {
        OrgRecommendCourseList dto = null;
        if (classCourse != null && classCourse.getStatus().intValue() == ClassCourseStatus.ENROLLING.getState() && classCourse.getBeginTime().getTime() > System.currentTimeMillis()) {
            dto = new OrgRecommendCourseList();
            dto.setCourseType(CourseType.CLASS.getCode());
            dto.setName(classCourse.getName());
            dto.setNumber(classCourse.getNumber());
            dto.setPrice(classCourse.getPrice().toString());
            dto.setCourseId(classCourse.getId());
            Long cover = classCourse.getCover();
            if (cover != null) {
                Storage storage = this.getClassCourseStorage(cover);
                String url = this.constructUrl(storage, imgServer);
                dto.setPreface(url);
            }
            dto.setLink("{host1}/teacher/classCourseDetail/{number}".replace("{host}", monkeySite).replace("{number}", classCourse.getNumber().toString()));
        }
        return dto;
    }

    private OrgRecommendCourseList getHotClassCourses(Map<Long, Storage> classStorageMap, TeacherClassCourse classCourse, String imgServer, String monkeySite) {
        OrgRecommendCourseList dto = null;
        if (classCourse != null && classCourse.getStatus().intValue() == ClassCourseStatus.ENROLLING.getState() && classCourse.getBeginTime().getTime() > System.currentTimeMillis()) {
            dto = new OrgRecommendCourseList();
            dto.setCourseType(CourseType.CLASS.getCode());
            dto.setName(classCourse.getName());
            dto.setNumber(classCourse.getNumber());
            dto.setPrice(classCourse.getPrice().toString());
            dto.setCourseId(classCourse.getId());
            Long cover = classCourse.getCover();
            if (cover != null) {
                Storage storage = classStorageMap.get((long)cover);
                logger.debug("---------------cover={},storage={}", (Object)cover, (Object)storage);
                String url = this.constructUrl(storage, imgServer);
                dto.setPreface(url);
            }
            dto.setLink("{host1}/teacher/classCourseDetail/{number}".replace("{host}", monkeySite).replace("{number}", classCourse.getNumber().toString()));
        }
        return dto;
    }

    private List<OrgRecommendCourseList> getHotBCourse(Map<Long, Storage> classStorageMap, List<TeacherClassCourse> t, String imgServer, String monkeySite) {
        ArrayList result = Lists.newArrayList();
        if (t != null && !t.isEmpty()) {
            for (TeacherClassCourse course : t) {
                OrgRecommendCourseList ret = this.getHotClassCourses(classStorageMap, course, imgServer, monkeySite);
                if (ret == null) continue;
                result.add(ret);
            }
        }
        return result;
    }

    private List<OrgRecommendCourseList> getHotXXCourse(Map<Integer, Storage> orgCourseStorageMap, List<OrgCourse> c, String imgServer, String monkeySite) {
        ArrayList result = Lists.newArrayList();
        if (c != null && !c.isEmpty()) {
            for (OrgCourse course : c) {
                OrgRecommendCourseList ret = this.getHotOrgCourses(orgCourseStorageMap, course, imgServer, monkeySite);
                if (ret == null) continue;
                result.add(ret);
            }
        }
        return result;
    }

    private List<OrgCourseGroupRelate> getOrgCustomGroupCourse(Integer orgId, PageDto pageDto) {
        return this.orgCourseGroupRelateDao.getOrgCourseGroup(orgId, pageDto);
    }

    private List<TeacherClassCourse> getOrgTeacherClassCourseList(Integer orgNumber, Collection<Long> excludeIds, PageDto pageDto) {
        return this.teacherClassCourseDao.getOrgCourseList(orgNumber, excludeIds, pageDto);
    }

    private List<OrgCourse> getOrgCourseList(Integer orgNumber, Collection<Long> excludeIds, PageDto pageDto) {
        return this.orgCourseDao.getAndFilterOrgCourse(orgNumber, excludeIds, CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null, pageDto);
    }

    public List<DefaultTemplateDataList> getCourseSubjects(List<String> subjects, int limit, OrgBaseInfoModel model, OptionalParams params) {
        ArrayList data = Lists.newArrayList();
        DefaultTemplateDataList item = null;
        String courseUrl = "{host}/course/{number}".replace("{host}", params.getMonkeySiteHost()).replace("{number}", model.getNumber().toString());
        if (subjects != null && !subjects.isEmpty()) {
            int index = 0;
            for (String name : subjects) {
                item = new DefaultTemplateDataList();
                item.setName(name);
                item.setLink(courseUrl);
                data.add(item);
                if (++index != limit) continue;
                break;
            }
        } else {
            int index = 1;
            for (String link : BizConf.PHOTO_LINKS) {
                item = new DefaultTemplateDataList();
                item.setLink(courseUrl);
                item.setName("\u5206\u7c7b" + index);
                data.add(item);
                ++index;
            }
        }
        return data;
    }

    private Set<String> getClassCourseAndOrgCourseSubjects(Integer number) {
        List<Integer> classCourseSubjectIds = this.getTeacherClassCourseSubjects(number);
        List<Integer> orgCourseSubjectIds = this.getOrgCourseSubjects(number);
        HashSet result = Sets.newHashSet();
        HashSet subjectIds = Sets.newHashSet();
        subjectIds.addAll(classCourseSubjectIds);
        subjectIds.addAll(orgCourseSubjectIds);
        if (subjectIds != null && !subjectIds.isEmpty()) {
            List subLists = this.subjectDao.getSubjectNames((Collection)subjectIds, "name");
            result.addAll(subLists);
        }
        return result;
    }

    private List<String> getOrgCustomClassfication(Integer orgId) {
        PageDto page = new PageDto();
        page.setPageSize(BizConf.MAX_SUBJECT_DISPLAY);
        return this.orgCourseGroupDao.getDistinctSubject(orgId, page);
    }

    private List<Integer> getOrgCourseSubjects(Integer number) {
        return this.orgCourseDao.getOrgCourseSubjectIds(number, null, null, null);
    }

    private List<Integer> getTeacherClassCourseSubjects(Integer number) {
        return this.teacherClassCourseDao.getOrgDistinctSubject(number);
    }

    Storage getClassCourseStorage(Long storageId) {
        ClassCoursePhoto cover = (ClassCoursePhoto)this.classCoursePhotoDao.getById((Serializable)storageId, new String[0]);
        return (Storage)this.storageDao.getById((Serializable)cover.getStorageId(), new String[0]);
    }

    Storage getStorage(Long storageId) {
        return (Storage)this.storageDao.getById((Serializable)storageId, new String[0]);
    }

    private JSONObject wrapperAbroadTemplate(Integer orgId, String content, OptionalParams params) {
        OrgBaseInfoModel model = this.getAndSetOrgInfoModel(orgId, params);
        JSONObject abroadJson = JSONObject.fromObject((Object)content);
        abroadJson.put((Object)"orgInfo", (Object)JSONObject.fromObject((Object)((Object)model)));
        return abroadJson;
    }

    private void getAndSetOrgNumber(Integer orgId, OrgBaseInfoModel model, String host) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        if (orgAccount == null) {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.USER_NOT_FOUND);
        }
        model.setNumber(orgAccount.getNumber());
        model.setDomain(host + "/i/" + model.getNumber());
        this.getAndSetOrgInfo(orgId, model);
        this.getAndSetOrgCourse(orgAccount.getNumber(), model);
    }

    private void getAndSetOrgInfo(Integer orgId, OrgBaseInfoModel model) {
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
        if (orgInfo != null) {
            String _400_phone = orgInfo.getExtension();
            if (StringUtils.isNotBlank((CharSequence)_400_phone)) {
                model.setExtension("4000122166," + orgInfo.getExtension());
            } else {
                model.setExtension("4000122166");
            }
        } else {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.USER_NOT_FOUND);
        }
        model.setId(orgId);
        model.setShortName(orgInfo.getShortName());
    }

    private void getAndSetSummary(Integer orgId, OrgBaseInfoModel model) {
        OrgTxtMsg summary = this.orgTxtMsgDao.getOrgTxtByIdAndType(orgId.intValue(), AuditColumType.SUMMARY.getValue());
        if (summary != null) {
            model.setBrief(summary.getValue());
        }
    }

    private void getAndSetAddress(Integer orgId, OrgBaseInfoModel model) {
        List branchs = this.orgBranchsDao.listBranchsByOrgId(orgId.intValue());
        if (branchs != null && !branchs.isEmpty()) {
            OrgBranchs branch = (OrgBranchs)branchs.get(0);
            if (branch != null) {
                branch.setProvince(branch.getProvince() == null ? "" : branch.getProvince());
                branch.setCounty(branch.getCounty() == null ? "" : branch.getCounty());
                branch.setDistrict(branch.getDistrict() == null ? "" : branch.getDistrict());
                branch.setAddress(branch.getAddress() == null ? "" : branch.getAddress());
                model.setAddress(branch.getProvince() + branch.getCounty() + branch.getDistrict() + branch.getAddress());
            } else {
                model.setAddress("");
            }
        } else {
            model.setAddress("");
        }
    }

    private void getAndSetTags(Integer orgId, OrgBaseInfoModel model) {
        String value;
        OrgTxtMsg tags = this.orgTxtMsgDao.getOrgTxtByIdAndType(orgId.intValue(), AuditColumType.TAGS.getValue());
        if (tags != null && StringUtils.isNotBlank((CharSequence)(value = tags.getValue()))) {
            model.setTags(value.split("\\s+"));
        }
    }

    private void getAndSetOrgLogo(Integer orgId, OrgBaseInfoModel model, String imgServer) {
        List imgs = this.orgPhotoDao.getByOrgIdAndCategory(orgId.intValue(), OrgImgType.ORG_LOGO.getValue());
        logger.info("getAndSetOrgLogo.orgId:{}, imgServer:{}, logogs:{}", new Object[]{orgId, imgServer, JSONArray.fromObject((Object)imgs).toString()});
        if (imgs != null && !imgs.isEmpty()) {
            OrgPhoto logo = (OrgPhoto)imgs.get(0);
            Integer storageId = logo.getOrgStorageId();
            OrgStorage storage = this.orgStorageDao.getById(storageId.intValue());
            if (storage != null) {
                model.setLogo(this.constructUrl(storage, imgServer));
            }
        } else {
            model.setLogo("https://imgs.genshuixue.com/13699255_id1fpdgb.jpg");
        }
    }

    private void getAndSetOrgCourse(Integer orgNumber, OrgBaseInfoModel model) {
        int classCourseCount = this.teacherClassCourseDao.getVliadClassCourseCount(orgNumber);
        int microCourseCount = this.orgCourseDao.getValidOrgCourseCount(orgNumber, CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null);
        model.setCourseCount(microCourseCount);
    }

    public String constructUrl(OrgStorage storage, String imgServer) {
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = MIMEType.values()[storage.getMimeType() - 1].getExtension();
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    public String constructUrl(Storage storage, String imgServer) {
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = "";
        if (storage == null) {
            return "";
        }
        if (StringUtils.isNotBlank((CharSequence)storage.getMimetype())) {
            surfix = storage.getMimetype().contains("/") ? storage.getMimetype().split("/")[1] : storage.getMimetype();
        }
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    private List<DefaultTemplateDataList> getAboutUsLinks(Integer number, String monkeySiteHost, String gsxSiteHost) {
        DefaultTemplateDataList[] list = new DefaultTemplateDataList[]{new DefaultTemplateDataList("\u5173\u4e8e\u6211\u4eec", this.getRealAddress("{host1}/org/intro/{number}", monkeySiteHost, gsxSiteHost, number.toString())), new DefaultTemplateDataList("\u6700\u65b0\u8bfe\u7a0b", this.getRealAddress("{host}/course/{number}", monkeySiteHost, gsxSiteHost, number.toString())), new DefaultTemplateDataList("\u8001\u5e08\u56e2\u961f", this.getRealAddress("{host}/teacher/{number}", monkeySiteHost, gsxSiteHost, number.toString())), new DefaultTemplateDataList("\u5728\u7ebf\u9884\u7ea6", "javascript:;"), new DefaultTemplateDataList("\u5b66\u5458\u4e4b\u58f0", this.getRealAddress("{host1}/org/comment/{number}", monkeySiteHost, gsxSiteHost, number.toString())), new DefaultTemplateDataList("\u4f18\u60e0\u6d3b\u52a8", this.getRealAddress("{host1}/org/couponList?number={number}", monkeySiteHost, gsxSiteHost, number.toString()))};
        return Arrays.asList(list);
    }

    private String getRealAddress(String source, String monkeySiteHost, String gsxSiteHost, String number) {
        if (source.contains("{host}")) {
            return source.replace("{host}", monkeySiteHost).replace("{number}", number);
        }
        return source.replace("{host1}", gsxSiteHost).replace("{number}", number);
    }

    @Override
    public OrgBaseInfoModel preview(Integer orgId, OptionalParams params) {
        return this.getAndSetOrgInfoModel(orgId, params);
    }

    private List<OrgRecommendCourseList> convertToKaixue(OptionalParams params, List<OrgTemplateCourse> list, boolean readonly) {
        String imgServer = params.getImgServer();
        String monkeySite = params.getMonkeySiteHost();
        ArrayList result = Lists.newArrayList();
        ArrayList courseIds = Lists.newArrayList();
        for (OrgTemplateCourse templateCourse : list) {
            courseIds.add(templateCourse.getCourseId().longValue());
        }
        List classList = this.teacherClassCourseDao.getByIds((Collection)courseIds, new String[0]);
        Map classCourseMap = CollectorUtil.collectMap((Collection)classList, (Function)new Function<TeacherClassCourse, Long>(){

            public Long apply(TeacherClassCourse teacherClassCourse) {
                return teacherClassCourse.getId();
            }
        });
        List orgCourseList = this.orgCourseDao.getByIds((Collection)courseIds, new String[0]);
        Map orgCourseCourseMap = CollectorUtil.collectMap((Collection)orgCourseList, (Function)new Function<OrgCourse, Long>(){

            public Long apply(OrgCourse o) {
                return o.getId();
            }
        });
        ArrayList orgCourseStorageIds = Lists.newArrayList();
        for (OrgCourse l : orgCourseList) {
            orgCourseStorageIds.add(l.getCover());
        }
        List orgCourseStorageList = this.storageDao.getByIds((Collection)orgCourseStorageIds, new String[0]);
        ConcurrentMap orgCourseStorageMap = Maps.newConcurrentMap();
        for (Object s : orgCourseStorageList) {
            orgCourseStorageMap.put(s.getId().intValue(), s);
        }
        ArrayList classStorageIds = Lists.newArrayList();
        for (TeacherClassCourse l : classList) {
            classStorageIds.add(l.getCover());
        }
        List covers = this.classCoursePhotoDao.getByIds((Collection)classStorageIds, new String[0]);
        Map coverMap = CollectorUtil.collectMap((Collection)covers, (Function)new Function<ClassCoursePhoto, Long>(){

            public Long apply(ClassCoursePhoto o) {
                return o.getStorageId();
            }
        });
        ArrayList storageIds = Lists.newArrayList();
        for (ClassCoursePhoto c : covers) {
            storageIds.add(c.getStorageId());
        }
        List classStorageList = this.storageDao.getByIds((Collection)storageIds, new String[0]);
        Map storageMap = CollectorUtil.collectMap((Collection)classStorageList, (Function)new Function<Storage, Long>(){

            public Long apply(Storage storage) {
                return storage.getId();
            }
        });
        ConcurrentMap classStorageMap = Maps.newConcurrentMap();
        for (Long l : coverMap.keySet()) {
            classStorageMap.put(l, storageMap.get(l));
        }
        for (OrgTemplateCourse templateCourse : list) {
            OrgRecommendCourseList dto;
            if (templateCourse.getCourseType().intValue() == CourseType.CLASS.getCode()) {
                dto = this.getHotClassCourses(classStorageMap, (TeacherClassCourse)classCourseMap.get(templateCourse.getCourseId()), imgServer, monkeySite);
                if (dto == null) continue;
                result.add(dto);
                continue;
            }
            if (templateCourse.getCourseType().intValue() != CourseType.ORG_COURSE.getCode() || (dto = this.getHotOrgCourses(orgCourseStorageMap, (OrgCourse)orgCourseCourseMap.get(templateCourse.getCourseId()), imgServer, monkeySite)) == null) continue;
            result.add(dto);
        }
        if (readonly && (result.size() == 1 || result.size() == 3)) {
            result.remove(result.size() - 1);
        }
        logger.info("convertToKaixue ==params={},result={}", (Object)params, (Object)result);
        return result;
    }
}

